/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.barcode.formplugin.info;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bd.barcode.formplugin.BarcodeCustomCtrlHelper;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.ext.form.control.CustomControl;
import kd.bos.form.IPageCache;
import kd.bos.form.control.AbstractGrid;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.id.ID;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import org.apache.commons.lang3.StringUtils;

public class PackingPlugin
extends AbstractFormPlugin {
    private static Log LOGGER = LogFactory.getLog(PackingPlugin.class);
    private static final String ENTRY = "entry";

    public void initialize() {
        super.initialize();
        this.addItemClickListeners(new String[]{"toolbarap"});
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String name = e.getProperty().getName();
        if ("bizobj".equals(name)) {
            DynamicObject bizobj = (DynamicObject)this.getModel().getValue("bizobj");
            this.getView().getPageCache().put("bizobj", bizobj.getString("id"));
        }
    }

    public void beforeItemClick(BeforeItemClickEvent beforeitemclickevent) {
        String itemkey = beforeitemclickevent.getItemKey();
        if (itemkey.equals("btnok")) {
            this.save();
        }
    }

    public void customEvent(CustomEventArgs e) {
        super.customEvent(e);
        IPageCache pageCache = this.getView().getPageCache();
        if ("barcode".equals(e.getEventName())) {
            String key = e.getKey();
            String value = e.getEventArgs();
            if (key.equals("pkgbarcode")) {
                this.cleanData(null);
                QFilter[] qfArr = new QFilter[]{new QFilter("barcode", "=", (Object)value), new QFilter("barcodetype", "=", (Object)"P")};
                DynamicObject data = BusinessDataServiceHelper.loadSingleFromCache((String)"barcode_info", (String)"id,barcode,barcoderule,bizobj", (QFilter[])qfArr);
                if (data == null) {
                    this.getView().showErrorNotification(ResManager.loadResFormat((String)"\u6761\u7801\u4e3b\u6863\u6ca1\u6709\u6b64\u5305\u88c5\u6761\u7801\u503c", (String)"PackingCheckPlugin_2", (String)"bd-barcode-formplugin", (Object[])new Object[0]));
                    return;
                }
                DynamicObject barcoderule = (DynamicObject)data.get("barcoderule");
                pageCache.put("pkgbarcode", String.valueOf(data.get("barcode")));
                pageCache.put("pkgbarcodeId", String.valueOf(data.get("id")));
                pageCache.put("barcoderuleId", String.valueOf(barcoderule.get("id")));
                pageCache.put("packagecount", String.valueOf(barcoderule.get("packagecount")));
                pageCache.put("bizobj", ((DynamicObject)data.get("bizobj")).getString("id"));
                Iterator packageBarcode = BusinessDataServiceHelper.loadSingleFromCache((String)"package_barcode", (String)"entry.id,entry.seq,entry.isleaf,entry.ebarcode,entry.ebarcode.barcode,entry.isleaf", (QFilter[])new QFilter[]{new QFilter("barcode", "=", data.get("id"))});
                if (packageBarcode != null) {
                    this.getModel().getDataEntity(true);
                    DynamicObjectCollection entries = packageBarcode.getDynamicObjectCollection(ENTRY);
                    int[] rowIndex = this.getModel().batchCreateNewEntryRow(ENTRY, entries.size());
                    AbstractGrid grid = (AbstractGrid)this.getView().getControl(ENTRY);
                    grid.selectRows(rowIndex, rowIndex[0]);
                    for (int i = 0; i < rowIndex.length; ++i) {
                        DynamicObject pkgEntry = (DynamicObject)entries.get(i);
                        if (pkgEntry.getDynamicObject("ebarcode") == null) continue;
                        this.getModel().setValue("barcode", (Object)pkgEntry.getDynamicObject("ebarcode").getString("barcode"), rowIndex[i]);
                        this.getModel().setValue("ispkg", (Object)(!pkgEntry.getBoolean("isleaf") ? 1 : 0), rowIndex[i]);
                        this.getModel().setValue("id", pkgEntry.get("id"), rowIndex[i]);
                    }
                }
                this.getView().showTipNotification(ResManager.loadResFormat((String)"\u627e\u5230\u8be5\u5305\u88c5\u6761\u7801\u503c", (String)"PackingCheckPlugin_3", (String)"bd-barcode-formplugin", (Object[])new Object[0]));
            }
            if (key.equals("detail")) {
                String pkgbarcodeId = pageCache.get("pkgbarcodeId");
                if (StringUtils.isEmpty((CharSequence)pkgbarcodeId)) {
                    this.getView().showErrorNotification(ResManager.loadResFormat((String)"\u8bf7\u8f93\u5165\u5305\u88c5\u6761\u7801\u503c", (String)"PackingCheckPlugin_3", (String)"bd-barcode-formplugin", (Object[])new Object[0]));
                    BarcodeCustomCtrlHelper.focusControl(this.getView(), "pkgbarcode");
                    return;
                }
                if (StringUtils.equals((CharSequence)value, (CharSequence)pageCache.get("pkgbarcode"))) {
                    this.getView().showErrorNotification(ResManager.loadResFormat((String)"\u6761\u7801\u660e\u7ec6\u4e0d\u80fd\u4e0e\u5305\u88c5\u6761\u7801\u503c\u76f8\u540c", (String)"PackingCheckPlugin_5", (String)"bd-barcode-formplugin", (Object[])new Object[0]));
                    return;
                }
                String bizobj = pageCache.get("bizobj");
                DynamicObject data = BusinessDataServiceHelper.loadSingleFromCache((String)"barcode_info", (QFilter[])new QFilter[]{new QFilter("barcode", "=", (Object)value), new QFilter("bizobj", "=", (Object)bizobj)});
                if (data == null) {
                    this.getView().showErrorNotification(ResManager.loadResFormat((String)"\u8be5\u4e1a\u52a1\u5bf9\u8c61\u7684\u6761\u7801\u4e3b\u6863\u6ca1\u6709\u6b64\u6761\u7801\u503c", (String)"PackingCheckPlugin_4", (String)"bd-barcode-formplugin", (Object[])new Object[0]));
                    return;
                }
                for (DynamicObject bd : this.getModel().getEntryEntity(ENTRY)) {
                    if (!bd.getString("barcode").equals(value)) continue;
                    this.getView().showErrorNotification(ResManager.loadResFormat((String)"\u8be5\u6761\u7801\u503c\u5728\u5df2\u88c5\u7bb1\u76ee\u5f55\u4e2d\u5df2\u5b58\u5728", (String)"PackingCheckPlugin_7", (String)"bd-barcode-formplugin", (Object[])new Object[0]));
                    return;
                }
                this.checkBarcodeBizobj(Long.valueOf(pkgbarcodeId), data.getLong("id"));
                this.checkIsSupPkg(Long.valueOf(pkgbarcodeId), data.getLong("id"));
                this.checkUpper(Long.valueOf(pkgbarcodeId), data.getLong("id"));
                int count = this.checkSupPkgCount(Long.valueOf(pkgbarcodeId));
                int rowIndex = this.getModel().createNewEntryRow(ENTRY);
                boolean isPkg = "P".equals(data.get("barcodetype"));
                this.getModel().setValue("id", data.get("id"), rowIndex);
                this.getModel().setValue("barcode", (Object)value, rowIndex);
                this.getModel().setValue("ispkg", (Object)isPkg, rowIndex);
                if (isPkg) {
                    DynamicObject pkg = BusinessDataServiceHelper.loadSingleFromCache((String)"package_barcode", (String)"pkgcount", (QFilter[])new QFilter[]{new QFilter("barcode", "=", (Object)data.getLong("id"))});
                    if (pkg != null) {
                        count += pkg.getInt("pkgcount");
                    }
                } else {
                    ++count;
                }
                int packagecount = Integer.parseInt(pageCache.get("packagecount"));
                if (packagecount != 0 && count >= packagecount) {
                    this.save();
                }
            }
        }
    }

    private void checkBarcodeBizobj(Long pkgBarcodeId, Long barcodeId) throws KDBizException {
        QFilter[] filters = new QFilter[]{new QFilter("id", "=", (Object)pkgBarcodeId)};
        DynamicObject pkgBarcode = BusinessDataServiceHelper.loadSingleFromCache((String)"barcode_info", (QFilter[])filters);
        DynamicObject bizobj = (DynamicObject)pkgBarcode.get("bizobj");
        String bizobjNumber = bizobj.getString("number");
        QFilter[] qfArr = new QFilter[]{new QFilter("id", "=", (Object)barcodeId)};
        DynamicObject ebarcode = BusinessDataServiceHelper.loadSingleFromCache((String)"barcode_info", (QFilter[])qfArr);
        DynamicObject barcodeBizobj = (DynamicObject)ebarcode.get("bizobj");
        if (!bizobjNumber.equals(barcodeBizobj.getString("number"))) {
            String msg = ResManager.loadResFormat((String)"\u88c5\u7bb1\u4e2d\u6761\u7801\u4e0e\u5305\u88c5\u6761\u7801\u503c\u4e1a\u52a1\u5bf9\u8c61\u4e0d\u540c(%1)", (String)"PackageBarcodeCheckPlugin_3", (String)"bd-barcode-formplugin", (Object[])new Object[]{barcodeId});
            throw new KDBizException(msg);
        }
    }

    private void checkIsSupPkg(Long pkgBarcodeId, Long barcodeId) {
        DynamicObject pkgBarcode = BusinessDataServiceHelper.loadSingleFromCache((String)"barcode_info", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)pkgBarcodeId)});
        DynamicObject pkg = BusinessDataServiceHelper.loadSingleFromCache((String)"package_barcode", (QFilter[])new QFilter[]{new QFilter("barcode", "=", (Object)barcodeId)});
        if (pkg != null) {
            String barcode = pkg.getDynamicObject("barcode").getString("barcode");
            this.isSupPkg(barcode, pkg, pkgBarcode.getString("barcode"));
        }
    }

    private void isSupPkg(String barcode, DynamicObject pkg, String pkgBarcode) {
        DynamicObjectCollection entry = pkg.getDynamicObjectCollection(ENTRY);
        for (DynamicObject ebarcode : entry) {
            if (pkgBarcode.equals(ebarcode.getDynamicObject("ebarcode").getString("barcode"))) {
                String msg = ResManager.loadResFormat((String)"\u6761\u7801\u503c:%1\u4e3a\u4e0a\u7ea7\u5305\u88c5\u6761\u7801,\u4e0d\u80fd\u88c5\u7bb1", (String)"PackageBarcodeCheckPlugin_5", (String)"bd-barcode-formplugin", (Object[])new Object[]{barcode});
                throw new KDBizException(msg);
            }
            if (ebarcode.getBoolean("isleaf") || (pkg = BusinessDataServiceHelper.loadSingleFromCache((String)"package_barcode", (QFilter[])new QFilter[]{new QFilter("barcode", "=", (Object)ebarcode.getLong("id"))})) == null) continue;
            this.isSupPkg(barcode, pkg, pkgBarcode);
        }
    }

    private int checkSupPkgCount(Long pkgBarcodeId) {
        int count = 0;
        for (DynamicObject bd : this.getModel().getEntryEntity(ENTRY)) {
            if (bd.getBoolean("ispkg")) {
                DynamicObject pkg = BusinessDataServiceHelper.loadSingleFromCache((String)"package_barcode", (String)"pkgcount", (QFilter[])new QFilter[]{new QFilter("barcode", "=", (Object)bd.getLong("id"))});
                if (pkg == null) continue;
                count += pkg.getInt("pkgcount");
                continue;
            }
            ++count;
        }
        DynamicObject pkg = BusinessDataServiceHelper.loadSingleFromCache((String)"package_barcode", (QFilter[])new QFilter[]{new QFilter("entry.ebarcode", "in", (Object)pkgBarcodeId)});
        if (pkg != null) {
            DynamicObject barcoderule = pkg.getDynamicObject("barcoderule");
            barcoderule = BusinessDataServiceHelper.loadSingleFromCache((Object)barcoderule.getPkValue(), (String)"barcode_rule");
            int rulePkgCount = barcoderule.getInt("packagecount");
            int pkgcount = pkg.getInt("pkgcount");
            if (rulePkgCount != 0 && pkgcount + count >= rulePkgCount) {
                String msg = ResManager.loadResFormat((String)"\u5df2\u8fbe\u5230\u4e0a\u7ea7\u5305\u88c5\u6761\u7801\u88c5\u7bb1\u6570\u91cf,\u4e0d\u80fd\u518d\u6b21\u88c5\u7bb1", (String)"PackageBarcodeCheckPlugin_5", (String)"bd-barcode-formplugin", (Object[])new Object[0]);
                throw new KDBizException(msg);
            }
        }
        return count;
    }

    private void checkUpper(Long id, Long barcodeId) {
        QFilter[] filters = new QFilter[]{new QFilter("entry.ebarcode", "=", (Object)barcodeId), new QFilter("id", "!=", (Object)id)};
        boolean fExists = QueryServiceHelper.exists((String)"package_barcode", (QFilter[])filters);
        if (fExists) {
            QFilter[] bFilters = new QFilter[]{new QFilter("id", "=", (Object)barcodeId)};
            DynamicObject barocde = BusinessDataServiceHelper.loadSingleFromCache((String)"barcode_info", (QFilter[])bFilters);
            String msg = ResManager.loadResFormat((String)"\u6761\u7801\u503c:%1\u5df2\u88ab\u88c5\u7bb1,\u4e0d\u80fd\u518d\u6b21\u88c5\u7bb1", (String)"PackageBarcodeCheckPlugin_4", (String)"bd-barcode-formplugin", (Object[])new Object[]{barocde.getString("barcode")});
            throw new KDBizException(msg);
        }
    }

    private void save() {
        Throwable throwable;
        TXHandle txHandle;
        block26: {
            block27: {
                block28: {
                    DynamicObjectCollection collection;
                    IPageCache pageCache = this.getView().getPageCache();
                    DynamicObject bizObjectType = BusinessDataServiceHelper.loadSingleFromCache((String)"bos_objecttype", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)pageCache.get("bizobj"))});
                    if (bizObjectType == null) {
                        this.getView().showErrorNotification(ResManager.loadResFormat((String)"\u8bf7\u8f93\u5165\u5305\u88c5\u6761\u7801\u503c", (String)"PackingCheckPlugin_3", (String)"bd-barcode-formplugin", (Object[])new Object[0]));
                        return;
                    }
                    String pkgbarcodeId = pageCache.get("pkgbarcodeId");
                    DynamicObject pkgbarcode = null;
                    if (StringUtils.isNotEmpty((CharSequence)pkgbarcodeId)) {
                        pkgbarcode = BusinessDataServiceHelper.loadSingleFromCache((String)"package_barcode", (String)"billno,barcode,entry.id,entry.seq,entry.isleaf,entry.ebarcode,entry.ebarcode.barcode,pkgcount", (QFilter[])new QFilter[]{new QFilter("barcode", "=", (Object)pkgbarcodeId)});
                    }
                    if ((collection = this.getModel().getDataEntity(true).getDynamicObjectCollection(ENTRY)).size() == 0) {
                        this.getView().showErrorNotification(ResManager.loadResFormat((String)"\u5df2\u88c5\u7bb1\u6761\u7801\u503c\u4e0d\u80fd\u4e3a\u7a7a", (String)"PackingCheckPlugin_6", (String)"bd-barcode-formplugin", (Object[])new Object[0]));
                        return;
                    }
                    if (pkgbarcode == null) {
                        pkgbarcode = BusinessDataServiceHelper.newDynamicObject((String)"package_barcode");
                        long genLongId = ID.genLongId();
                        pkgbarcode.set("id", (Object)genLongId);
                        pkgbarcode.set("createtime", (Object)ID.getCreateTime((long)genLongId));
                        pkgbarcode.set("org", (Object)RequestContext.get().getOrgId());
                        pkgbarcode.set("billstatus", (Object)"C");
                        pkgbarcode.set("bizobj", bizObjectType.getPkValue());
                        pkgbarcode.set("barcode", (Object)Long.valueOf(pageCache.get("pkgbarcodeId")));
                        pkgbarcode.set("barcoderule", (Object)Long.valueOf(pageCache.get("barcoderuleId")));
                        DynamicObjectCollection entries = pkgbarcode.getDynamicObjectCollection(ENTRY);
                        int i = 0;
                        for (DynamicObject pageEntry : collection) {
                            DynamicObject entry = entries.addNew();
                            entry.set("id", (Object)ID.genLongId());
                            entry.set("seq", (Object)i++);
                            entry.set("ebarcode", pageEntry.get("id"));
                            entry.set("isleaf", (Object)(!pageEntry.getBoolean("ispkg") ? 1 : 0));
                        }
                    } else {
                        DynamicObjectCollection entries = pkgbarcode.getDynamicObjectCollection(ENTRY);
                        HashSet set = Sets.newHashSet();
                        entries.forEach(e -> set.add(e.getDynamicObject("ebarcode").getString("barcode")));
                        int i = set.size();
                        for (DynamicObject pageEntry : collection) {
                            if (set.contains(pageEntry.getString("barcode"))) continue;
                            DynamicObject entry = entries.addNew();
                            entry.set("id", (Object)ID.genLongId());
                            entry.set("seq", (Object)i++);
                            entry.set("ebarcode", pageEntry.get("id"));
                            entry.set("isleaf", (Object)(!pageEntry.getBoolean("ispkg") ? 1 : 0));
                        }
                    }
                    int count = 0;
                    for (DynamicObject entry : pkgbarcode.getDynamicObjectCollection(ENTRY)) {
                        if (entry.getBoolean("isleaf")) {
                            ++count;
                            continue;
                        }
                        DynamicObject pkg = BusinessDataServiceHelper.loadSingleFromCache((String)"package_barcode", (String)"pkgcount", (QFilter[])new QFilter[]{new QFilter("barcode", "=", (Object)entry.getLong("id"))});
                        if (pkg == null) continue;
                        count += pkg.getInt("pkgcount");
                    }
                    pkgbarcode.set("pkgcount", (Object)count);
                    OperateOption saveOption = OperateOption.create();
                    saveOption.setVariableValue("ignorewarn", String.valueOf(true));
                    saveOption.setVariableValue("ignoreinteraction", String.valueOf(true));
                    saveOption.setVariableValue("strictvalidation", String.valueOf(true));
                    txHandle = TX.required((String)"package_barcode_save");
                    throwable = null;
                    OperationResult saveResult = SaveServiceHelper.saveOperate((String)"save", (String)"package_barcode", (DynamicObject[])new DynamicObject[]{pkgbarcode}, (OperateOption)saveOption);
                    if (saveResult.isSuccess()) break block26;
                    String errMessage = saveResult.getMessage();
                    this.getView().showErrorNotification(errMessage);
                    if (txHandle == null) break block27;
                    if (throwable == null) break block28;
                    try {
                        txHandle.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    break block27;
                }
                txHandle.close();
            }
            return;
        }
        try {
            try {
                this.getView().showSuccessNotification(ResManager.loadResFormat((String)"\u4fdd\u5b58\u6210\u529f", (String)"PACKING_SAVE_SUCCESS", (String)"bd-barcode-formplugin", (Object[])new Object[0]));
            }
            catch (Exception e2) {
                txHandle.markRollback();
                LOGGER.error("barcode save error: " + e2);
                this.getView().showErrorNotification(e2.getMessage());
            }
        }
        catch (Throwable throwable3) {
            throwable = throwable3;
            throw throwable3;
        }
        catch (Throwable throwable4) {
            throw throwable4;
        }
        finally {
            if (txHandle != null) {
                if (throwable != null) {
                    try {
                        txHandle.close();
                    }
                    catch (Throwable throwable5) {
                        throwable.addSuppressed(throwable5);
                    }
                } else {
                    txHandle.close();
                }
            }
        }
        this.cleanData("save");
    }

    private <T> List<T> getList(IPageCache pageCache, String name, Class clz) {
        List lst = JSON.parseArray((String)pageCache.get(name), (Class)clz);
        if (lst == null) {
            lst = Lists.newArrayList();
        }
        return lst;
    }

    private void cleanData(String type) {
        this.getModel().deleteEntryData(ENTRY);
        Map<String, Object> ctrlData = BarcodeCustomCtrlHelper.buildCtrlData("setvalue", "");
        ((CustomControl)this.getView().getControl("detail")).setData(ctrlData);
        if ("save".equals(type)) {
            ((CustomControl)this.getView().getControl("pkgbarcode")).setData(ctrlData);
        }
        this.getView().getPageCache().put("pkgbarcode", "");
        this.getView().getPageCache().put("pkgbarcodeId", "");
        this.getView().getPageCache().put("pkgIds", JSON.toJSON((Object)Lists.newArrayList()).toString());
        this.getView().getPageCache().put("detailIds", JSON.toJSON((Object)Lists.newArrayList()).toString());
    }
}

