/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.barcode.formplugin.operation;

import com.alibaba.fastjson.JSONObject;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bd.barcode.common.BarcodeParsedValJsonHelper;
import kd.bd.barcode.common.enums.BarcodeReturnMsgEnum;
import kd.bd.barcode.common.form.FormShowParameterBuilder;
import kd.bd.barcode.formplugin.BarcodeDataLoader;
import kd.bd.barcode.mservice.BarcodeGenerateBillHelper;
import kd.bd.barcode.servicehelper.BarcodeServiceHelper;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.botp.runtime.ConvertOperationResult;
import kd.bos.entity.datamodel.IBillModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.IListView;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.user.UserConfigServiceHelper;

public class BarcodeParserPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    private static final String KEY_ORG_ID = "orgID";
    private static final String KEY_ENTITY = "entityKey";
    private static final Log LOGGER = LogFactory.getLog(BarcodeParserPlugin.class);

    public void preOpenForm(PreOpenFormEventArgs e) {
        super.preOpenForm(e);
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit scanConfigEdit = (BasedataEdit)this.getView().getControl("scanconfig");
        if (scanConfigEdit != null) {
            scanConfigEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    public void customEvent(CustomEventArgs e) {
        super.customEvent(e);
        String event = e.getEventName();
        if ("barcode".equals(event)) {
            String barcode = e.getEventArgs();
            if (StringUtils.isEmpty((CharSequence)barcode)) {
                return;
            }
            DynamicObject scanConfig = this.getModel().getDataEntity().getDynamicObject("scanconfig");
            DynamicObject botpRule = scanConfig == null ? null : scanConfig.getDynamicObject("botp");
            IPageCache parentPageCache = this.getView().getParentView().getPageCache();
            String hasGeneratedBill = StringUtils.trimToEmpty((String)parentPageCache.get("hasGeneratedBill"));
            IFormView prsView = this.getView();
            IFormView billView = prsView.getViewNoPlugin(prsView.getFormShowParameter().getParentPageId());
            boolean isSavedBill = billView.getModel().getDataEntity().getDataEntityState().getFromDatabase();
            if (billView instanceof IListView || botpRule == null || "true".equals(hasGeneratedBill) || isSavedBill) {
                this.execParse(barcode);
            } else {
                DynamicObject targetBill = this.generatedBill(barcode, scanConfig, botpRule);
                this.writeDynObj2ParentView(targetBill, prsView, billView);
            }
        }
    }

    public void afterCreateNewData(EventObject e) {
        long userId = RequestContext.get().getCurrUserId();
        String settingJsonStr = UserConfigServiceHelper.getSetting((long)userId, (String)"user_scanconfig_setting");
        JSONObject setting = settingJsonStr == null ? null : JSONObject.parseObject((String)settingJsonStr);
        long lastScanConfigId = setting == null ? 0L : setting.getLong("lastScanConfigId");
        this.getModel().setValue("scanconfig", (Object)lastScanConfigId);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String fieldKey = e.getProperty().getName();
        Object newVal = e.getChangeSet()[0].getNewValue();
        if ("scanconfig".equals(fieldKey)) {
            long userId = RequestContext.get().getCurrUserId();
            JSONObject setting = new JSONObject();
            long lastScanConfigId = newVal instanceof DynamicObject ? ((DynamicObject)newVal).getLong("id") : 0L;
            setting.put("lastScanConfigId", (Object)lastScanConfigId);
            UserConfigServiceHelper.setSetting((long)userId, (String)"user_scanconfig_setting", (String)setting.toJSONString());
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        String fieldKey = e.getProperty().getName();
        ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
        ListFilterParameter filterParameter = showParameter.getListFilterParameter();
        List f7QFilters = filterParameter.getQFilters();
        if ("scanconfig".equals(fieldKey)) {
            Map<String, Object> customParams = this.getFormShowCustParams();
            String entityKey = customParams != null ? (String)customParams.get(KEY_ENTITY) : "";
            f7QFilters.add(new QFilter("targetbill", "=", (Object)entityKey));
        }
    }

    private Map<String, Object> getFormShowCustParams() {
        return this.getView().getFormShowParameter().getCustomParams();
    }

    private void execParse(String barcode) {
        LOGGER.info("barcode parsing: " + barcode);
        IFormView prsView = this.getView();
        IFormView billView = prsView.getViewNoPlugin(prsView.getFormShowParameter().getParentPageId());
        DynamicObjectCollection bizInfos = null;
        bizInfos = this.getCachedOrParse(barcode, billView);
        if (bizInfos == null || bizInfos.isEmpty()) {
            LOGGER.error("execParse, bizInfos is empty");
            return;
        }
        this.cacheParsedBarcode(barcode, billView, bizInfos);
        BarcodeDataLoader.checkException(prsView, bizInfos);
        if (billView instanceof IListView) {
            this.showSrcBillForm(bizInfos, prsView, billView);
        } else {
            BarcodeDataLoader.loadBarcodesInfos(prsView, billView, bizInfos);
        }
    }

    private DynamicObject generatedBill(String barcode, DynamicObject scanConfig, DynamicObject botpRule) {
        LOGGER.info("generatedBill: " + barcode);
        List targetBillList = null;
        DynamicObject botpDynObj = BusinessDataServiceHelper.loadSingleFromCache((Object)botpRule.getPkValue(), (String)"botp_crlist", (String)"id,number,sourceentitynumber,targetentitynumber");
        scanConfig.set("botp", (Object)botpDynObj);
        Map srcBillInfo = BarcodeGenerateBillHelper.convertBarcode2SrcBillInfo((String)barcode, (DynamicObject)scanConfig);
        Object srcBillId = srcBillInfo.get("srcBillId");
        if (srcBillId == null || srcBillId.equals(0L)) {
            throw new KDBizException(BarcodeReturnMsgEnum.SRC_BILL_NOT_FOUND.getDescription());
        }
        ConvertOperationResult convertBillResult = BarcodeGenerateBillHelper.invokeBOTPGenerateBill((DynamicObject)scanConfig, (Map)srcBillInfo, (boolean)false);
        if (!convertBillResult.isSuccess()) {
            List srcBillReport = convertBillResult.getBillReports();
            String pushFailedMsg = srcBillReport.isEmpty() ? convertBillResult.getMessage() : srcBillReport.toString();
            String generateFailedMsg = BarcodeReturnMsgEnum.GENERATE_FAILED.getDescription() + pushFailedMsg;
            throw new KDBizException(generateFailedMsg);
        }
        targetBillList = BarcodeGenerateBillHelper.getBOTPTargetBill((ConvertOperationResult)convertBillResult);
        if (targetBillList == null || targetBillList.isEmpty()) {
            throw new KDBizException(BarcodeReturnMsgEnum.GENERATED_BILL_ISEMPTY.getDescription());
        }
        if (targetBillList.size() > 1) {
            throw new KDBizException(BarcodeReturnMsgEnum.GENERATED_MULTI_BILL.getDescription());
        }
        return (DynamicObject)targetBillList.get(0);
    }

    private void writeDynObj2ParentView(DynamicObject targetBill, IFormView view, IFormView parentView) {
        if (targetBill == null) {
            return;
        }
        IPageCache parentPageCache = parentView.getPageCache();
        parentPageCache.put("hasGeneratedBill", "true");
        ((IBillModel)parentView.getModel()).push((Object)targetBill);
        parentView.updateView();
        view.sendFormAction(parentView);
    }

    private void showSrcBillForm(DynamicObjectCollection bizInfos, IFormView prsView, IFormView billView) {
        String pkId = null;
        for (DynamicObject bInfo : bizInfos) {
            IDataEntityProperty srcIdProp = (IDataEntityProperty)bInfo.getDataEntityType().getProperties().get((Object)"srcbillid");
            if (srcIdProp == null) continue;
            pkId = bInfo.getString("srcbillid");
            break;
        }
        if (StringUtils.isNotEmpty(pkId)) {
            Map<String, Object> customParams = this.getFormShowCustParams();
            String entityId = (String)customParams.get("entityId");
            String viewBillFormId = (String)customParams.get("viewBillFormId");
            String permissionEntityId = (String)customParams.get("permissionEntityId");
            FormShowParameter parameter = FormShowParameterBuilder.getFormShowParameter((String)entityId, (String)viewBillFormId, (String)permissionEntityId, (OperationStatus)OperationStatus.VIEW, (String)pkId, (IFormView)billView);
            billView.showForm(parameter);
            prsView.sendFormAction(billView);
        } else {
            String msg = ResManager.loadKDString((String)"\u6761\u7801\u672a\u5173\u8054\u4e1a\u52a1\u5bf9\u8c61", (String)"BARCODE_NO_SRC", (String)"bd-barcode-formplugin", (Object[])new Object[0]);
            billView.showMessage(msg);
        }
    }

    private DynamicObjectCollection getCachedOrParse(String barcode, IFormView billView) {
        boolean fHasCache;
        DynamicObjectCollection bizInfos = null;
        String jsonStr = billView.getPageCache().get("barcode_" + barcode);
        boolean bl = fHasCache = !StringUtils.isEmpty((CharSequence)jsonStr);
        if (fHasCache) {
            bizInfos = BarcodeParsedValJsonHelper.getCachedBarcodeBizInfos((String)jsonStr);
            LOGGER.info("getCachedOrParse, get barcode cached json: " + bizInfos);
        } else {
            String entityKey = null;
            Long orgID = null;
            Map<String, Object> customParams = this.getFormShowCustParams();
            if (customParams != null) {
                entityKey = (String)customParams.get(KEY_ENTITY);
                Object orgVal = customParams.get(KEY_ORG_ID);
                orgID = orgVal != null ? Long.valueOf(orgVal.toString()) : null;
                bizInfos = BarcodeServiceHelper.parseBarcode((String)barcode, (String)entityKey, (Long)orgID);
            }
        }
        return bizInfos;
    }

    private void cacheParsedBarcode(String barcode, IFormView billView, DynamicObjectCollection bizInfos) {
        boolean fNoCache = StringUtils.isEmpty((CharSequence)billView.getPageCache().get("barcode_" + barcode));
        try {
            if (fNoCache) {
                String cachedJsonStr = BarcodeParsedValJsonHelper.getBarcodeBizInfosJsonString((DynamicObjectCollection)bizInfos);
                billView.getPageCache().put("barcode_" + barcode, cachedJsonStr);
                LOGGER.info("page has not barcode cache, cache json: " + cachedJsonStr);
            }
        }
        catch (Exception ex) {
            LOGGER.error("failed to cache parsed barcode", (Throwable)ex);
        }
    }
}

