/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.barcode.formplugin.rule;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import kd.bd.barcode.common.BarcodeMetadataHelper;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.designer.botp.BillTreeBuildParameter;
import kd.bos.designer.botp.EntityParseHelper;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.TextEdit;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;

public class BarcodePropMappingPlugin
extends AbstractFormPlugin {
    private static final Log LOGGER = LogFactory.getLog(BarcodePropMappingPlugin.class);
    private static final int MAX_OBJ_CT = 15;
    private static final String KEY_POP_MODALBOX = "barcoderule_prop_pop";
    private static final String KEY_OK = "btnok";
    private static final String KEY_CANCEL = "btncancel";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        for (int i = 1; i <= 15; ++i) {
            TextEdit textEdit = (TextEdit)this.getView().getControl("textfield" + i);
            textEdit.addClickListener((ClickListener)this);
            this.addClickListeners(new String[]{KEY_OK, KEY_CANCEL});
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control source = (Control)evt.getSource();
        ArrayList list = Lists.newArrayListWithCapacity((int)15);
        for (int i = 1; i <= 15; ++i) {
            list.add("textfield" + i);
        }
        String col = source.getKey();
        if (list.contains(col)) {
            this.showModalBox(col);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String name = e.getProperty().getName();
        if ("bizobj".equals(name)) {
            Map<String, String> map;
            this.showTextField(false);
            DynamicObjectCollection bizobj = (DynamicObjectCollection)this.getModel().getValue("bizobj");
            int size = bizobj.size();
            if (size < 2) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u81f3\u5c11\u9009\u62e9\u4fe9\u4e2a\u4e1a\u52a1\u5bf9\u8c61", (String)"FIELD_MAPPING_BIZ", (String)"bd-barcode-formplugin", (Object[])new Object[0]));
                return;
            }
            this.getView().setEnable(Boolean.TRUE, new String[]{"addrow"});
            this.getView().setEnable(Boolean.TRUE, new String[]{"delrow"});
            this.getModel().deleteEntryData("showentity");
            this.getModel().deleteEntryData("entryentity");
            ArrayList list = Lists.newArrayListWithCapacity((int)size);
            ArrayList keyList = Lists.newArrayListWithCapacity((int)size);
            for (int i = 0; i < size; ++i) {
                this.getView().setVisible(Boolean.TRUE, new String[]{"textfield" + (i + 1)});
                DynamicObject dynamicObject = ((DynamicObject)bizobj.get(i)).getDynamicObject("fbasedataid");
                TextEdit field = (TextEdit)this.getView().getControl("textfield" + (i + 1));
                field.setCaption(new LocaleString(dynamicObject.getString("name")));
                MainEntityType dt = EntityMetadataCache.getDataEntityType((String)dynamicObject.getString("number"));
                BillTreeBuildParameter billTreeBuildParameter = new BillTreeBuildParameter(dt);
                TreeNode treeNodes = EntityParseHelper.buildBillTreeNodes((BillTreeBuildParameter)billTreeBuildParameter);
                map = Maps.newHashMap();
                map = this.fillMap(map, treeNodes.getChildren(), dt);
                list.add(map);
                keyList.add(map.keySet());
            }
            Set coin = keyList.stream().flatMap(Collection::stream).filter(this.predicate()).collect(Collectors.toSet());
            if (coin.size() == 0) {
                return;
            }
            int[] entryRow = this.getModel().batchCreateNewEntryRow("showentity", coin.size());
            int i = 0;
            for (String key : coin) {
                for (int j = 0; j < list.size() && j < bizobj.size(); ++j) {
                    map = (Map<String, String>)list.get(j);
                    String value = "";
                    if (StringUtils.isNotBlank((CharSequence)((CharSequence)map.get(key)))) {
                        value = (String)map.get(key);
                    }
                    this.getModel().setValue("key" + (j + 1), (Object)value, entryRow[i]);
                    MainEntityType dt = EntityMetadataCache.getDataEntityType((String)((DynamicObject)bizobj.get(j)).getDynamicObject("fbasedataid").getString("number"));
                    String pname = "";
                    if (StringUtils.isNotBlank((CharSequence)value)) {
                        pname = BarcodeMetadataHelper.getPropName((String)value);
                        DynamicProperty meta = BarcodeMetadataHelper.getPropertyMeta((String)pname, (DynamicObjectType)dt);
                        pname = meta.getDisplayName().toString();
                    }
                    this.getModel().setValue("textfield" + (j + 1), (Object)pname, entryRow[i]);
                }
                ++i;
            }
        }
    }

    private Predicate<String> predicate() {
        HashSet set = Sets.newHashSet();
        return i -> !set.add(i);
    }

    private Map<String, String> fillMap(Map<String, String> map, List<TreeNode> children, MainEntityType dt) {
        for (TreeNode node : children) {
            List nodes = node.getChildren();
            if (CollectionUtils.isEmpty((Collection)nodes)) {
                String id = node.getId();
                String[] split = id.split("\\.");
                if ((split.length <= 1 || !"number".equals(split[1])) && split.length != 1) continue;
                String text = BarcodeMetadataHelper.getPropName((String)id);
                DynamicProperty meta = BarcodeMetadataHelper.getPropertyMeta((String)text, (DynamicObjectType)dt);
                text = meta.getDisplayName().toString();
                map.put(text + meta.getClass(), id);
                continue;
            }
            this.fillMap(map, nodes, dt);
        }
        return map;
    }

    public void afterBindData(EventObject e) {
        super.beforeBindData(e);
        this.showData();
    }

    private void showData() {
        this.getModel().deleteEntryData("showentity");
        this.showTextField(false);
        this.getView().setEnable(Boolean.FALSE, new String[]{"addrow"});
        this.getView().setEnable(Boolean.FALSE, new String[]{"delrow"});
        long id = (Long)this.getModel().getValue("id");
        if (id != 0L) {
            DynamicObjectCollection bizobjs = (DynamicObjectCollection)this.getModel().getValue("bizobj");
            int bizobjSize = bizobjs.size();
            ArrayList bizNumbers = Lists.newArrayListWithExpectedSize((int)bizobjSize);
            for (int i = 0; i < bizobjSize; ++i) {
                this.getView().setVisible(Boolean.TRUE, new String[]{"textfield" + (i + 1)});
                DynamicObject dynamicObject = ((DynamicObject)bizobjs.get(i)).getDynamicObject("fbasedataid");
                TextEdit field = (TextEdit)this.getView().getControl("textfield" + (i + 1));
                field.setCaption(new LocaleString(dynamicObject.getString("name")));
                bizNumbers.add(dynamicObject.getString("number"));
            }
            DynamicObjectCollection entryentity = (DynamicObjectCollection)this.getModel().getValue("entryentity");
            if (CollectionUtils.isNotEmpty((Collection)entryentity) && CollectionUtils.isNotEmpty((Collection)bizobjs)) {
                this.getView().setEnable(Boolean.TRUE, new String[]{"addrow"});
                this.getView().setEnable(Boolean.TRUE, new String[]{"delrow"});
                HashMap data = Maps.newHashMapWithExpectedSize((int)entryentity.size());
                for (int i = 0; i < entryentity.size(); ++i) {
                    int j;
                    DynamicObject entry = (DynamicObject)entryentity.get(i);
                    String lnumber = entry.getDynamicObject("lbizobj").getString("number");
                    String rnumber = entry.getDynamicObject("rbizobj").getString("number");
                    String lobjpropname = entry.getString("lobjpropname");
                    String robjpropname = entry.getString("robjpropname");
                    int row = entry.getInt("seq");
                    List rowData = (List)data.get(row);
                    if (rowData == null) {
                        rowData = Lists.newArrayListWithExpectedSize((int)bizobjSize);
                        for (j = 0; j < bizobjSize; ++j) {
                            rowData.add("");
                        }
                    }
                    for (j = 0; j < bizNumbers.size(); ++j) {
                        if (((String)bizNumbers.get(j)).equals(lnumber)) {
                            rowData.set(j, lobjpropname);
                        }
                        if (!((String)bizNumbers.get(j)).equals(rnumber)) continue;
                        rowData.set(j, robjpropname);
                    }
                    data.put(row, rowData);
                }
                int[] entryRow = this.getModel().batchCreateNewEntryRow("showentity", data.size());
                for (int i = 0; i < data.size(); ++i) {
                    List list = (List)data.get(i + 1);
                    for (int j = 0; j < list.size() && j < bizobjSize; ++j) {
                        this.getModel().setValue("key" + (j + 1), list.get(j), entryRow[i]);
                        MainEntityType dt = EntityMetadataCache.getDataEntityType((String)((DynamicObject)bizobjs.get(j)).getDynamicObject("fbasedataid").getString("number"));
                        String pname = "";
                        String value = (String)list.get(j);
                        if (StringUtils.isNotBlank((CharSequence)value)) {
                            value = value.split("\\.")[0];
                            for (Map.Entry dtEntry : dt.getAllFields().entrySet()) {
                                if (!((String)dtEntry.getKey()).equals(value)) continue;
                                pname = ((IDataEntityProperty)dtEntry.getValue()).getDisplayName().toString();
                                break;
                            }
                        }
                        this.getModel().setValue("textfield" + (j + 1), (Object)pname, entryRow[i]);
                    }
                }
            }
        }
        this.getModel().setDataChanged(false);
    }

    private void showTextField(boolean show) {
        for (int i = 1; i <= 15; ++i) {
            this.getView().setVisible(Boolean.valueOf(show), new String[]{"textfield" + i});
        }
    }

    private void showModalBox(String itemkey) {
        int objIndex = -1;
        try {
            objIndex = Integer.parseInt(itemkey.replace("textfield", "")) - 1;
        }
        catch (NumberFormatException e) {
            LOGGER.error("cannot locate column", (Throwable)e);
        }
        DynamicObjectCollection bizobjs = (DynamicObjectCollection)this.getModel().getValue("bizobj");
        if (objIndex == -1 || objIndex > bizobjs.size()) {
            return;
        }
        DynamicObject bizobj = ((DynamicObject)bizobjs.get(objIndex)).getDynamicObject("fbasedataid");
        String number = bizobj.getString("number");
        String name = bizobj.getString("name");
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId(KEY_POP_MODALBOX);
        showParameter.setCaption(name);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, itemkey));
        this.getPageCache().put("bizobj", number);
        String prop = (String)this.getModel().getValue(itemkey.replace("textfield", "key"));
        this.getPageCache().put("objprop", prop);
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(showParameter);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        if (closedCallBackEvent.getReturnData() != null) {
            Map returnData = (Map)closedCallBackEvent.getReturnData();
            String actionId = closedCallBackEvent.getActionId();
            String key = actionId.replace("textfield", "key");
            this.getModel().setValue(actionId, (Object)"");
            this.getModel().setValue(key, (Object)"");
            if (MapUtils.isNotEmpty((Map)returnData)) {
                for (Map.Entry entry : returnData.entrySet()) {
                    String sign = (String)entry.getKey();
                    String name = (String)entry.getValue();
                    this.getModel().setValue(actionId, (Object)name);
                    this.getModel().setValue(key, (Object)sign);
                }
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate source = (FormOperate)args.getSource();
        String operateKey = source.getOperateKey();
        if ("save".equals(operateKey) || "submit".equals(operateKey)) {
            if ("submit".equals(operateKey)) {
                this.getModel().setValue("status", (Object)"C");
            }
            DynamicObject dataEntity = this.getModel().getDataEntity(true);
            DynamicObjectCollection showentity = dataEntity.getDynamicObjectCollection("showentity");
            DynamicObjectCollection entryentity = dataEntity.getDynamicObjectCollection("entryentity");
            entryentity.clear();
            DynamicObjectCollection bizobj = (DynamicObjectCollection)this.getModel().getValue("bizobj");
            int size = bizobj.size();
            if (size < 2) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u81f3\u5c11\u9009\u62e9\u4fe9\u4e2a\u4e1a\u52a1\u5bf9\u8c61", (String)"FIELD_MAPPING_BIZ", (String)"bd-barcode-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            Long id = (Long)this.getModel().getValue("id");
            QFilter idFilter = null;
            if (id != null && !id.equals(0L)) {
                idFilter = new QFilter("id", "!=", (Object)id);
            }
            for (int i = 0; i < bizobj.size() - 1; ++i) {
                DynamicObject left = ((DynamicObject)bizobj.get(i)).getDynamicObject("fbasedataid");
                QFilter lFilter = new QFilter("bizobj.fbasedataid", "=", (Object)left.getString("id"));
                for (int j = i + 1; j < bizobj.size(); ++j) {
                    DynamicObject right = ((DynamicObject)bizobj.get(j)).getDynamicObject("fbasedataid");
                    QFilter rFilter = new QFilter("bizobj.fbasedataid", "=", (Object)right.getString("id"));
                    DynamicObjectCollection lquery = QueryServiceHelper.query((String)"barcode_prop_mapping", (String)"id", (QFilter[])new QFilter[]{lFilter, idFilter});
                    DynamicObjectCollection rquery = QueryServiceHelper.query((String)"barcode_prop_mapping", (String)"id", (QFilter[])new QFilter[]{rFilter, idFilter});
                    for (DynamicObject l : lquery) {
                        for (DynamicObject r : rquery) {
                            if (!StringUtils.equals((CharSequence)l.getString("id"), (CharSequence)r.getString("id"))) continue;
                            this.getView().showTipNotification(ResManager.loadResFormat((String)"\u4e1a\u52a1\u5bf9\u8c61:%1\u548c\u4e1a\u52a1\u5bf9\u8c61:%2\u5bf9\u7167\u5173\u7cfb\u5728\u5176\u4ed6\u6761\u7801\u5b57\u6bb5\u5bf9\u7167\u8bbe\u7f6e\u4e2d\u5df2\u5b58\u5728", (String)"FIELD_MAPPING_BIZ_EXIST", (String)"bd-barcode-formplugin", (Object[])new Object[]{left.getString("name"), right.getString("name")}));
                            args.setCancel(true);
                            return;
                        }
                    }
                }
            }
            int row = 1;
            for (DynamicObject entry : showentity) {
                boolean validator = false;
                for (int i = 1; i < size; ++i) {
                    String lkey = entry.getString("key" + i);
                    if (StringUtils.isBlank((CharSequence)lkey)) continue;
                    for (int r = i + 1; r <= size; ++r) {
                        DynamicProperty rmeta;
                        DynamicProperty lmeta;
                        String rkey = entry.getString("key" + r);
                        if (StringUtils.isBlank((CharSequence)rkey)) continue;
                        if (!validator) {
                            validator = true;
                        }
                        DynamicObject lbizobj = ((DynamicObject)bizobj.get(i - 1)).getDynamicObject("fbasedataid");
                        DynamicObject rbizobj = ((DynamicObject)bizobj.get(r - 1)).getDynamicObject("fbasedataid");
                        String lmetaName = null;
                        String rmetaName = null;
                        Class<?> lclass = null;
                        Class<?> rclass = null;
                        MainEntityType ldt = EntityMetadataCache.getDataEntityType((String)lbizobj.getString("number"));
                        String lpname = BarcodeMetadataHelper.getPropName((String)lkey);
                        if (StringUtils.isNotBlank((CharSequence)lpname) && (lmeta = BarcodeMetadataHelper.getPropertyMeta((String)lpname, (DynamicObjectType)ldt)) != null) {
                            lmetaName = lmeta.getDisplayName().toString();
                            lclass = lmeta.getClass();
                        }
                        MainEntityType rdt = EntityMetadataCache.getDataEntityType((String)rbizobj.getString("number"));
                        String rpname = BarcodeMetadataHelper.getPropName((String)rkey);
                        if (StringUtils.isNotBlank((CharSequence)rpname) && (rmeta = BarcodeMetadataHelper.getPropertyMeta((String)rpname, (DynamicObjectType)rdt)) != null) {
                            rmetaName = rmeta.getDisplayName().toString();
                            rclass = rmeta.getClass();
                        }
                        if (!StringUtils.equals((CharSequence)lmetaName, rmetaName) && lclass != null && rclass != null && !lclass.equals(rclass)) {
                            this.getView().showErrorNotification(ResManager.loadResFormat((String)"\u7b2c%1\u884c:\u8bf7\u9009\u62e9\u7c7b\u578b\u548c\u540d\u79f0\u4e00\u81f4\u7684\u5c5e\u6027!", (String)"FIELD_MAPPING_FIT", (String)"bd-barcode-formplugin", (Object[])new Object[]{row}));
                            args.setCancel(true);
                            return;
                        }
                        DynamicObject addNew = entryentity.addNew();
                        addNew.set("lbizobj", (Object)lbizobj);
                        addNew.set("lobjpropname", (Object)lkey);
                        addNew.set("rbizobj", (Object)rbizobj);
                        addNew.set("robjpropname", (Object)rkey);
                        addNew.set("seq", (Object)row);
                    }
                }
                if (!validator) {
                    this.getView().showErrorNotification(ResManager.loadResFormat((String)"\u7b2c%1\u884c:\u81f3\u5c11\u9009\u62e9\u4fe9\u4e2a\u5c5e\u6027!", (String)"FIELD_MAPPING_EMPTY", (String)"bd-barcode-formplugin", (Object[])new Object[]{row}));
                    args.setCancel(true);
                    return;
                }
                ++row;
            }
            if (row == 1) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u81f3\u5c11\u6dfb\u52a0\u4e00\u884c\u6761\u7801\u5b57\u6bb5\u5bf9\u7167\u5c5e\u6027\u5206\u5f55", (String)"FIELD_MAPPING_NUM", (String)"bd-barcode-formplugin", (Object[])new Object[]{row}));
                args.setCancel(true);
                return;
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        String key = args.getOperateKey();
        if ("save".equals(key)) {
            this.showData();
        }
    }
}

