/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.barcode.formplugin.rule;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import kd.bd.barcode.common.BarcodeMetadataHelper;
import kd.bd.barcode.formplugin.rule.BarcodeRuleFillData;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.StepperEdit;
import kd.bos.form.field.TextEdit;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;

public class BarcodeRuleEditPlugin
extends AbstractFormPlugin {
    public void initialize() {
        super.initialize();
        this.addItemClickListeners(new String[]{"tbmain", "entrytbmain"});
        this.addClickListeners(new String[]{"tbmain", "entrytbmain"});
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String name = e.getProperty().getName();
        ArrayList button = Lists.newArrayListWithCapacity((int)12);
        button.add("segmenttype");
        button.add("valuetype");
        button.add("ruletype");
        button.add("parsemethod");
        button.add("seperator");
        button.add("fieldlength");
        button.add("format");
        button.add("barcodetype");
        button.add("iscode");
        button.add("startval");
        button.add("objpropname");
        button.add("isperitem");
        if (button.contains(name)) {
            ChangeData[] changeSet = e.getChangeSet();
            int rowIndex = changeSet[0].getRowIndex();
            String newValue = "";
            if (!name.equals("fieldlength") && !name.equals("iscode") && !name.equals("startval") & !name.equals("isperitem")) {
                newValue = (String)changeSet[0].getNewValue();
            }
            IDataModel model = this.getModel();
            IFormView view = this.getView();
            String parsemethod = (String)model.getValue("parsemethod");
            ComboEdit methodEdit = (ComboEdit)view.getControl("parsemethod");
            ComboEdit seperatorEdit = (ComboEdit)view.getControl("seperator");
            TextEdit lengthEedit = (TextEdit)view.getControl("fieldlength");
            TextEdit startvalEdit = (TextEdit)view.getControl("startval");
            TextEdit priorityEdit = (TextEdit)view.getControl("priority");
            StepperEdit steppervalEdit = (StepperEdit)view.getControl("stepperval");
            switch (name) {
                case "segmenttype": {
                    Boolean meteEnable = Boolean.FALSE;
                    if ("M".equals(newValue)) {
                        meteEnable = Boolean.TRUE;
                        priorityEdit.setMustInput(false);
                        model.setValue("startval", (Object)0);
                        model.setValue("stepperval", (Object)1);
                        view.setEnable(Boolean.FALSE, rowIndex, new String[]{"startval"});
                        view.setEnable(Boolean.FALSE, rowIndex, new String[]{"stepperval"});
                        model.setValue("valuetype", null);
                    } else {
                        model.setValue("objprop", null);
                        model.setValue("objpropname", null);
                        view.setEnable(Boolean.TRUE, rowIndex, new String[]{"valuetype"});
                    }
                    view.setEnable(meteEnable, rowIndex, new String[]{"objprop"});
                    view.setEnable(meteEnable, rowIndex, new String[]{"objpropname"});
                    boolean seqMust = false;
                    Boolean steppervalEnable = Boolean.FALSE;
                    if ("S".equals(newValue)) {
                        seqMust = true;
                        steppervalEnable = Boolean.TRUE;
                        model.setValue("valuetype", (Object)"Q");
                        view.setEnable(Boolean.TRUE, rowIndex, new String[]{"stepperval"});
                    }
                    startvalEdit.setMustInput(seqMust);
                    steppervalEdit.setMustInput(seqMust);
                    view.setEnable(steppervalEnable, rowIndex, new String[]{"startval"});
                    Boolean fixvalueEnable = Boolean.FALSE;
                    Object fixvalue = null;
                    if ("F".equals(newValue)) {
                        fixvalueEnable = Boolean.TRUE;
                        model.setValue("valuetype", (Object)"S");
                    }
                    view.setEnable(fixvalueEnable, rowIndex, new String[]{"fixvalue"});
                    model.setValue("fixvalue", fixvalue);
                    BarcodeRuleFillData.fill(model);
                    break;
                }
                case "valuetype": {
                    Boolean formatEnable = Boolean.FALSE;
                    if ("D".equals(newValue) || "T".equals(newValue)) {
                        formatEnable = Boolean.TRUE;
                        this.fillFormatSelect();
                    } else {
                        model.setValue("format", null);
                    }
                    view.setEnable(formatEnable, rowIndex, new String[]{"format"});
                    Boolean dotposEnable = Boolean.FALSE;
                    Boolean isQtyEnable = Boolean.FALSE;
                    if ("M".equals(model.getValue("segmenttype")) && ("A".equals(newValue) || "Q".equals(newValue))) {
                        dotposEnable = Boolean.TRUE;
                        isQtyEnable = Boolean.TRUE;
                        if (!"S".equals(parsemethod)) {
                            model.setValue("align", (Object)"R");
                        }
                        view.setEnable(Boolean.FALSE, rowIndex, new String[]{"startval"});
                    } else if (!"S".equals(parsemethod)) {
                        model.setValue("align", (Object)"L");
                    }
                    model.setValue("dotposition", null);
                    model.setValue("isqtyprop", (Object)Boolean.FALSE);
                    view.setEnable(isQtyEnable, rowIndex, new String[]{"isqtyprop"});
                    view.setEnable(dotposEnable, rowIndex, new String[]{"dotposition"});
                    break;
                }
                case "ruletype": {
                    boolean must = false;
                    Boolean separatorEnable = Boolean.FALSE;
                    String parseSepartor = null;
                    if ("D".equals(newValue)) {
                        must = true;
                        separatorEnable = Boolean.TRUE;
                        parseSepartor = "@";
                    } else {
                        this.getModel().setValue("barcodelength", (Object)0);
                    }
                    methodEdit.setMustInput(must);
                    lengthEedit.setMustInput(must);
                    seperatorEdit.setMustInput(must);
                    view.setEnable(separatorEnable, new String[]{"seperator"});
                    this.getModel().setValue("priority", (Object)"1");
                    this.getModel().setValue("seperator", (Object)parseSepartor);
                    this.getModel().setValue("isperitem", (Object)Boolean.FALSE);
                    this.getModel().setValue("isautogenerate", (Object)Boolean.FALSE);
                    BarcodeRuleFillData.fill(model);
                    break;
                }
                case "parsemethod": {
                    boolean lengthMust = false;
                    boolean seperatorMust = false;
                    if ("S".equals(newValue)) {
                        this.getModel().setValue("seperator", (Object)"@");
                        seperatorMust = true;
                    } else {
                        lengthMust = true;
                    }
                    lengthEedit.setMustInput(lengthMust);
                    seperatorEdit.setMustInput(seperatorMust);
                    this.getModel().setValue("priority", (Object)"1");
                    BarcodeRuleFillData.fill(model);
                    break;
                }
                case "seperator": {
                    this.fillFormatSelect();
                    BarcodeRuleFillData.fill(model);
                    break;
                }
                case "barcodetype": {
                    this.fillBarcodeTypeEdit(false);
                    break;
                }
                case "fieldlength": {
                    BarcodeRuleFillData.fill(model);
                    break;
                }
                case "iscode": {
                    BarcodeRuleFillData.fill(model);
                    break;
                }
                case "format": {
                    BarcodeRuleFillData.fill(model);
                    break;
                }
                case "startval": {
                    BarcodeRuleFillData.fill(model);
                    break;
                }
                case "objpropname": {
                    if (!StringUtils.isBlank((CharSequence)newValue)) break;
                    model.setValue("objprop", null);
                    model.setValue("valuetype", null);
                    model.setValue("fieldlength", null);
                    model.setValue("format", null);
                    model.setValue("format", null);
                    model.setValue("startval", (Object)0);
                    model.setValue("stepperval", (Object)1);
                    model.setValue("padding", (Object)0);
                    model.setValue("align", null);
                    model.setValue("fixvalue", null);
                    break;
                }
                case "isperitem": {
                    model.setValue("isqtyprop", (Object)Boolean.FALSE);
                }
            }
        }
    }

    public void itemClick(ItemClickEvent evt) {
        ArrayList button = Lists.newArrayList();
        button.add("delrow");
        button.add("uprow");
        button.add("downrow");
        if (button.contains(evt.getItemKey())) {
            BarcodeRuleFillData.fill(this.getModel());
        }
        if ("addrow".equals(evt.getItemKey())) {
            this.initEnable(this.getModel().getEntryEntity("entry").size() - 1);
        }
    }

    public void afterCreateNewData(EventObject e) {
        IDataModel model = this.getModel();
        IFormView parentView = this.getView().getParentView();
        if (parentView == null) {
            return;
        }
        IPageCache page = (IPageCache)parentView.getService(IPageCache.class);
        String id = page.get("id");
        String objId = page.get("objId");
        if (StringUtils.isEmpty((CharSequence)id) && StringUtils.isNotEmpty((CharSequence)objId)) {
            QFilter[] qfArr = new QFilter[]{new QFilter("number", "=", (Object)objId)};
            DynamicObject bizObjectType = BusinessDataServiceHelper.loadSingle((String)"bos_objecttype", (String)"id", (QFilter[])qfArr);
            if (bizObjectType == null) {
                String message = ResManager.loadKDString((String)"\u627e\u4e0d\u5230\u5143\u6570\u636e\uff08%1\uff09", (String)"META_NUM_INVAL", (String)"bd-barcode-formplugin", (Object[])new Object[]{objId});
                throw new KDBizException(message);
            }
            model.setValue("bizobj", bizObjectType.getPkValue());
            long userid = UserServiceHelper.getCurrentUserId();
            model.setValue("creator", (Object)userid);
            model.setValue("createdorg", (Object)RequestContext.get().getOrgId());
        }
        ComboEdit methodEdit = (ComboEdit)this.getView().getControl("parsemethod");
        ComboEdit seperatorEdit = (ComboEdit)this.getView().getControl("seperator");
        methodEdit.setMustInput(true);
        seperatorEdit.setMustInput(true);
        this.initEnable(0);
    }

    public void afterBindData(EventObject e) {
        IFormView view = this.getView();
        TextEdit priority = (TextEdit)view.getControl("priority");
        priority.setMustInput(true);
        DynamicObject bizobj = (DynamicObject)this.getModel().getValue("bizobj");
        if (bizobj == null) {
            return;
        }
        MainEntityType dt = EntityMetadataCache.getDataEntityType((String)((String)bizobj.get("number")));
        DynamicObjectCollection entry = (DynamicObjectCollection)this.getModel().getValue("entry");
        int i = 0;
        for (DynamicObject data : entry) {
            String segmenttype = (String)data.get("segmenttype");
            String objprop = (String)data.get("objprop");
            String valType = data.getString("valuetype");
            if ("A".equals(valType) || "Q".equals(valType)) {
                view.setEnable(Boolean.TRUE, i, new String[]{"dotposition"});
                view.setEnable(Boolean.FALSE, i, new String[]{"startval"});
            } else {
                view.setEnable(Boolean.FALSE, i, new String[]{"dotposition"});
            }
            if (segmenttype.equals("S")) {
                view.setEnable(Boolean.TRUE, i, new String[]{"startval"});
                view.setEnable(Boolean.TRUE, i, new String[]{"stepperval"});
                view.setEnable(Boolean.FALSE, i, new String[]{"objpropname"});
                view.setEnable(Boolean.FALSE, i, new String[]{"format"});
                view.setEnable(Boolean.FALSE, i, new String[]{"fixvalue"});
            }
            if (segmenttype.equals("F")) {
                view.setEnable(Boolean.TRUE, i, new String[]{"startval"});
                view.setEnable(Boolean.TRUE, i, new String[]{"stepperval"});
                view.setEnable(Boolean.FALSE, i, new String[]{"objpropname"});
                view.setEnable(Boolean.FALSE, i, new String[]{"format"});
                view.setEnable(Boolean.TRUE, i, new String[]{"fixvalue"});
            }
            if (segmenttype.equals("M") && StringUtils.isNotEmpty((CharSequence)objprop)) {
                boolean fFormat;
                view.setEnable(Boolean.FALSE, i, new String[]{"startval"});
                view.setEnable(Boolean.FALSE, i, new String[]{"stepperval"});
                view.setEnable(Boolean.FALSE, i, new String[]{"fixvalue"});
                String pname = BarcodeMetadataHelper.getPropName((String)objprop);
                DynamicProperty meta = BarcodeMetadataHelper.getPropertyMeta((String)pname, (DynamicObjectType)dt);
                this.getModel().setValue("objpropname", (Object)meta.getDisplayName(), i);
                boolean bl = fFormat = "D".equals(valType) || "T".equals(valType);
                if (!fFormat) {
                    view.setEnable(Boolean.FALSE, i, new String[]{"format"});
                }
            }
            ++i;
        }
        this.fillBarcodeTypeEdit(true);
        if (entry.size() > 0) {
            this.getModel().setDataChanged(false);
        }
    }

    private ComboEdit fillFormatSelect() {
        String seperator = (String)this.getModel().getValue("seperator");
        ArrayList<ComboItem> data = new ArrayList<ComboItem>();
        data.add(new ComboItem(new LocaleString("yyyyMMdd"), "yyyyMMdd"));
        data.add(new ComboItem(new LocaleString("yyyyMMdd HH:mm:ss"), "yyyyMMdd HH:mm:ss"));
        data.add(new ComboItem(new LocaleString("yyyy/MM/dd"), "yyyy/MM/dd"));
        data.add(new ComboItem(new LocaleString("yyyy/MM/dd HH:mm:ss"), "yyyy/MM/dd HH:mm:ss"));
        if (!"-".equals(seperator)) {
            data.add(new ComboItem(new LocaleString("yyyy-MM-dd"), "yyyy-MM-dd"));
            data.add(new ComboItem(new LocaleString("yyyy-MM-dd HH:mm:ss"), "yyyy-MM-dd HH:mm:ss"));
        }
        data.add(new ComboItem(new LocaleString("HH:mm:ss"), "HH:mm:ss"));
        data.add(new ComboItem(new LocaleString("HH:mm"), "HH:mm"));
        ComboEdit format = (ComboEdit)this.getView().getControl("format");
        format.setComboItems(data);
        return format;
    }

    private void initEnable(int row) {
        this.getView().setEnable(Boolean.FALSE, row, new String[]{"format"});
        this.getView().setEnable(Boolean.FALSE, row, new String[]{"startval"});
        this.getView().setEnable(Boolean.FALSE, row, new String[]{"stepperval"});
        this.getView().setEnable(Boolean.FALSE, row, new String[]{"dotposition"});
        this.getView().setEnable(Boolean.FALSE, row, new String[]{"fixvalue"});
        this.getView().setEnable(Boolean.FALSE, row, new String[]{"isqtyprop"});
    }

    private void fillBarcodeTypeEdit(boolean isInit) {
        String barcodeType = (String)this.getModel().getValue("barcodetype");
        boolean must = false;
        ArrayList data = Lists.newArrayList();
        data.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u4e3b\u6863\u5bf9\u7167", (String)"PROP_TYPE_COMBOITEM_M", (String)"bd-barcode-formplugin", (Object[])new Object[0])), "M"));
        if ("N".equals(barcodeType)) {
            data.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u52a8\u6001\u89e3\u6790", (String)"PROP_TYPE_COMBOITEM_D", (String)"bd-barcode-formplugin", (Object[])new Object[0])), "D"));
        } else {
            must = true;
            this.getModel().setValue("ruletype", (Object)"M");
        }
        TextEdit packagecount = (TextEdit)this.getView().getControl("packagecount");
        packagecount.setMustInput(must);
        ComboEdit ruletypeEdit = (ComboEdit)this.getView().getControl("ruletype");
        ruletypeEdit.setComboItems((List)data);
        if ("M".equals((String)this.getModel().getValue("ruletype"))) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"seperator"});
        }
        if (!isInit && "N".equals(barcodeType)) {
            this.getModel().setValue("ruletype", (Object)"D");
            this.getModel().setValue("seperator", (Object)"@");
            this.getModel().setValue("priority", (Object)"1");
            BarcodeRuleFillData.fill(this.getModel());
        }
    }
}

