/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.barcode.formplugin.rule;

import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.designer.botp.BillTreeBuildParameter;
import kd.bos.designer.botp.EntityParseHelper;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.IPageCache;
import kd.bos.form.control.Control;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.TreeNodeCheckEvent;
import kd.bos.form.control.events.TreeNodeCheckListener;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;

public class BarcodeRuleEntityPropPlugin
extends AbstractFormPlugin
implements TreeNodeClickListener,
TreeNodeCheckListener {
    public static final String KEY_OK = "btnok";
    public static final String KEY_CANCEL = "btncancel";
    public static final String KEY_TREEVIEW_MODAL = "treeviewmodal";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{KEY_OK, KEY_CANCEL});
        TreeView treeView = (TreeView)this.getView().getControl(KEY_TREEVIEW_MODAL);
        treeView.addTreeNodeCheckListener((TreeNodeCheckListener)this);
    }

    public void beforeBindData(EventObject e) {
        TreeNode treeNode;
        super.beforeBindData(e);
        TreeView treeView = (TreeView)this.getView().getControl(KEY_TREEVIEW_MODAL);
        treeView.setMulti(true);
        IPageCache page = (IPageCache)this.getView().getParentView().getService(IPageCache.class);
        String bizobj = page.get("bizobj");
        MainEntityType dt = new MainEntityType();
        dt = EntityMetadataCache.getDataEntityType((String)bizobj);
        String entityName = dt.getDisplayName().toString();
        BillTreeBuildParameter billTreeBuildParameter = new BillTreeBuildParameter(dt);
        TreeNode treeNodes = EntityParseHelper.buildBillTreeNodes((BillTreeBuildParameter)billTreeBuildParameter);
        treeNodes.setIsOpened(false);
        String nodeId = treeNodes.getId();
        TreeNode rootNode = new TreeNode("", nodeId, entityName);
        treeView.addNode(rootNode);
        List children = treeNodes.getChildren();
        for (TreeNode node1 : children) {
            List children1 = node1.getChildren();
            if (children1 == null) continue;
            node1.setIsOpened(false);
            for (TreeNode node2 : children1) {
                List children2 = node2.getChildren();
                if (children2 == null) continue;
                node2.setIsOpened(false);
                for (TreeNode node3 : children2) {
                    node3.setIsOpened(false);
                    node3.setChildren(null);
                }
            }
        }
        rootNode.setChildren(children);
        treeView.setRootVisible(true);
        String objprop = page.get("objprop");
        if (StringUtils.isNotBlank((CharSequence)objprop) && (treeNode = treeNodes.getTreeNode(objprop, 10)) != null) {
            treeView.checkNode(treeNode);
        }
        treeView.showNode(objprop);
    }

    public void treeNodeCheck(TreeNodeCheckEvent event) {
        IPageCache page = (IPageCache)this.getView().getParentView().getService(IPageCache.class);
        String bizobj = page.get("bizobj");
        MainEntityType dt = new MainEntityType();
        dt = EntityMetadataCache.getDataEntityType((String)bizobj);
        BillTreeBuildParameter billTreeBuildParameter = new BillTreeBuildParameter(dt);
        TreeNode treeNodes = EntityParseHelper.buildBillTreeNodes((BillTreeBuildParameter)billTreeBuildParameter);
        if (!event.getChecked().booleanValue()) {
            String nodeId = (String)event.getNodeId();
            this.getPageCache().remove(nodeId);
            this.getChildren(this.getPageCache(), treeNodes, nodeId);
        } else {
            HashMap<String, String> checkedNodesMap = new HashMap<String, String>();
            TreeView treeView = (TreeView)this.getView().getControl(KEY_TREEVIEW_MODAL);
            TreeView.TreeState treeState = treeView.getTreeState();
            List checkedNodes = treeState.getCheckedNodes();
            for (Map node : checkedNodes) {
                boolean isParent = (Boolean)node.get("isParent");
                if (isParent) continue;
                String id = (String)node.get("id");
                String text = (String)node.get("text");
                String parentId = (String)node.get("parentid");
                TreeNode treeNode = treeNodes.getTreeNode(parentId, 5);
                String parentName = treeNode.getText();
                checkedNodesMap.put(id, parentName + "." + text);
            }
            if (!checkedNodesMap.isEmpty()) {
                this.getPageCache().put(checkedNodesMap);
            }
        }
    }

    private void deleteNodeId(IPageCache pageCache, TreeNode treeNode) {
        this.getPageCache().remove(treeNode.getId());
        List children = treeNode.getChildren();
        if (CollectionUtils.isNotEmpty((Collection)children)) {
            for (TreeNode node : children) {
                pageCache.remove(node.getId());
                this.deleteNodeId(pageCache, node);
            }
        }
    }

    private void getChildren(IPageCache pageCache, TreeNode treeNodes, String nodeId) {
        List children = treeNodes.getChildren();
        for (TreeNode node : children) {
            String parentid = node.getParentid();
            if (parentid.equals(nodeId)) {
                this.getPageCache().remove(parentid);
                this.deleteNodeId(this.getPageCache(), node);
                continue;
            }
            List nextChildren = node.getChildren();
            if (!CollectionUtils.isNotEmpty((Collection)nextChildren)) continue;
            this.getChildren(pageCache, node, nodeId);
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control btn = (Control)evt.getSource();
        if (StringUtils.equals((CharSequence)btn.getKey(), (CharSequence)KEY_OK)) {
            Map checkNodeMap = this.getPageCache().getAll();
            if (MapUtils.isNotEmpty((Map)checkNodeMap)) {
                Iterator iter = checkNodeMap.keySet().iterator();
                while (iter.hasNext()) {
                    String key = (String)iter.next();
                    if (!"FormShowParameter".equals(key) && !"controlstates".equals(key) && !"_csrftoken_".equals(key)) continue;
                    iter.remove();
                }
                this.getView().returnDataToParent((Object)checkNodeMap);
            } else {
                this.getView().returnDataToParent((Object)"");
            }
            this.getView().close();
        } else if (KEY_CANCEL.equals(btn.getKey())) {
            this.getView().close();
        }
    }
}

