/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.barcode.formplugin.rule;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bd.barcode.common.BarcodeMetadataHelper;
import kd.bd.barcode.formplugin.rule.BarcodeRuleFillData;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.TimeProp;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.TextEdit;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;

public class BarcodeRuleEntryPlugin
extends AbstractFormPlugin
implements ClickListener {
    private static final String KEY_POP_MODALBOX = "barcoderule_prop_pop";
    private static final String KEY_OK = "btnok";
    private static final String KEY_CANCEL = "btncancel";
    private static final String KEY_SUB_ENTRYENTITY = "entry";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        TextEdit textEdit = (TextEdit)this.getView().getControl("objpropname");
        textEdit.addClickListener((ClickListener)this);
        this.addClickListeners(new String[]{KEY_OK, KEY_CANCEL});
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control source = (Control)evt.getSource();
        DynamicObject businessobj = (DynamicObject)this.getModel().getValue("bizobj");
        OrmLocaleValue name = (OrmLocaleValue)businessobj.get("name");
        if (StringUtils.equals((CharSequence)"objpropname", (CharSequence)source.getKey())) {
            this.showModalBox(name.toString());
        }
    }

    private void showModalBox(String attributeName) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId(KEY_POP_MODALBOX);
        showParameter.setCaption(attributeName);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "objpropname"));
        DynamicObject bizobj = (DynamicObject)this.getModel().getValue("bizobj");
        String number = (String)bizobj.get("number");
        this.getPageCache().put("bizobj", number);
        this.getPageCache().put("objprop", (String)this.getModel().getValue("objprop"));
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        DynamicObjectCollection entry = dataEntity.getDynamicObjectCollection(KEY_SUB_ENTRYENTITY);
        if (entry.size() != 0) {
            ArrayList list = Lists.newArrayList();
            for (DynamicObject obj : entry) {
                String objprop = obj.getString("objprop");
                if (!StringUtils.isNotBlank((CharSequence)objprop)) continue;
                list.add(objprop);
            }
            if (list.size() != 0) {
                this.getPageCache().put(KEY_SUB_ENTRYENTITY, JSON.toJSON((Object)list).toString());
            }
        }
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(showParameter);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        if (StringUtils.equals((CharSequence)closedCallBackEvent.getActionId(), (CharSequence)"objpropname") && null != closedCallBackEvent.getReturnData()) {
            String entryprop = this.getPageCache().get(KEY_SUB_ENTRYENTITY);
            this.getPageCache().put(KEY_SUB_ENTRYENTITY, "");
            MainEntityType dt = EntityMetadataCache.getDataEntityType((String)this.getPageCache().get("bizobj"));
            Map returnData = (Map)closedCallBackEvent.getReturnData();
            if (MapUtils.isNotEmpty((Map)returnData)) {
                List props = null;
                if (StringUtils.isNotBlank((CharSequence)entryprop)) {
                    props = JSON.parseArray((String)entryprop, String.class);
                }
                Set entrySet = returnData.entrySet();
                Set<Object> returnSet = Sets.newHashSet();
                if (props != null && !props.isEmpty()) {
                    for (Map.Entry entry : entrySet) {
                        String string = (String)entry.getKey();
                        if (props.contains(string)) continue;
                        returnSet.add(entry);
                    }
                } else {
                    returnSet = entrySet;
                }
                if (returnSet.size() == 0) {
                    return;
                }
                int count = 1;
                for (Map.Entry entry : returnSet) {
                    String pname;
                    DynamicProperty propertyMeta;
                    String sign = (String)entry.getKey();
                    String name = (String)entry.getValue();
                    Class propertyType = null;
                    String[] split = sign.split("\\.");
                    String compare = split[0];
                    for (Map.Entry dtEntry : dt.getAllFields().entrySet()) {
                        IDataEntityProperty ev = (IDataEntityProperty)dtEntry.getValue();
                        String key = (String)dtEntry.getKey();
                        if (!key.equals(compare)) continue;
                        propertyType = ev.getPropertyType();
                    }
                    String valuetype = "S";
                    if (propertyType == BigDecimal.class) {
                        valuetype = "A";
                        if (sign.indexOf("qty") > -1) {
                            valuetype = "Q";
                        }
                    }
                    if (propertyType == Date.class) {
                        valuetype = "D";
                    }
                    if (propertyType == DynamicObject.class) {
                        valuetype = "B";
                    }
                    if ((propertyMeta = BarcodeMetadataHelper.getPropertyMeta((String)(pname = BarcodeMetadataHelper.getPropName((String)sign)), (DynamicObjectType)dt)) instanceof TimeProp) {
                        valuetype = "T";
                    }
                    if (count == 1) {
                        String prop = (String)this.getModel().getValue("objprop");
                        if (StringUtils.isNotBlank((CharSequence)prop)) {
                            int[] rowIndex = this.getModel().batchCreateNewEntryRow(KEY_SUB_ENTRYENTITY, 1);
                            this.fillEntryData(rowIndex[0], name, sign, valuetype);
                        } else {
                            this.fillEntryData(name, sign, valuetype);
                        }
                    } else {
                        int[] rowIndex = this.getModel().batchCreateNewEntryRow(KEY_SUB_ENTRYENTITY, --count);
                        for (int i = 0; i < count; ++i) {
                            this.fillEntryData(rowIndex[i], name, sign, valuetype);
                        }
                    }
                    ++count;
                }
            } else {
                this.getModel().setValue("objpropname", (Object)"");
                this.getModel().setValue("objprop", (Object)"");
            }
            BarcodeRuleFillData.fill(this.getModel());
        }
    }

    private void fillEntryData(String name, String sign, String valuetype) {
        this.getView().setEnable(Boolean.FALSE, new String[]{"valuetype"});
        this.getView().setEnable(Boolean.FALSE, new String[]{"startval"});
        this.getView().setEnable(Boolean.FALSE, new String[]{"stepperval"});
        this.getView().setEnable(Boolean.FALSE, new String[]{"fixvalue"});
        this.getModel().setValue("objpropname", (Object)name);
        this.getModel().setValue("objprop", (Object)sign);
        this.getModel().setValue("segmenttype", (Object)"M");
        this.getModel().setValue("valuetype", (Object)valuetype);
        if ("D".equals(valuetype) || "T".equals(valuetype)) {
            this.getView().setEnable(Boolean.TRUE, new String[]{"format"});
        } else {
            this.getModel().setValue("format", null);
            this.getView().setEnable(Boolean.FALSE, new String[]{"format"});
        }
        if ("A".equals(valuetype) || "Q".equals(valuetype)) {
            if (!"S".equals(this.getModel().getValue("parsemethod"))) {
                this.getModel().setValue("align", (Object)"R");
            }
            this.getModel().setValue("dotposition", null);
            this.getView().setEnable(Boolean.TRUE, new String[]{"dotposition"});
        } else {
            if (!"S".equals(this.getModel().getValue("parsemethod"))) {
                this.getModel().setValue("align", (Object)"L");
            }
            this.getModel().setValue("dotposition", null);
            this.getView().setEnable(Boolean.FALSE, new String[]{"dotposition"});
        }
    }

    private void fillEntryData(int row, String name, String sign, String valuetype) {
        this.getView().setEnable(Boolean.FALSE, row, new String[]{"valuetype"});
        this.getView().setEnable(Boolean.FALSE, row, new String[]{"startval"});
        this.getView().setEnable(Boolean.FALSE, row, new String[]{"stepperval"});
        this.getView().setEnable(Boolean.FALSE, row, new String[]{"fixvalue"});
        this.getModel().setValue("objpropname", (Object)name, row);
        this.getModel().setValue("objprop", (Object)sign, row);
        this.getModel().setValue("segmenttype", (Object)"M", row);
        this.getModel().setValue("valuetype", (Object)valuetype, row);
        if ("D".equals(valuetype) || "T".equals(valuetype)) {
            this.getView().setEnable(Boolean.TRUE, row, new String[]{"format"});
        } else {
            this.getModel().setValue("format", null);
            this.getView().setEnable(Boolean.FALSE, row, new String[]{"format"});
        }
        if ("A".equals(valuetype) || "Q".equals(valuetype)) {
            if (!"S".equals(this.getModel().getValue("parsemethod"))) {
                this.getModel().setValue("align", (Object)"R", row);
            }
            this.getModel().setValue("dotposition", null);
            this.getView().setEnable(Boolean.TRUE, row, new String[]{"dotposition"});
        } else {
            if (!"S".equals(this.getModel().getValue("parsemethod"))) {
                this.getModel().setValue("align", (Object)"L", row);
            }
            this.getModel().setValue("dotposition", null, row);
            this.getView().setEnable(Boolean.FALSE, row, new String[]{"dotposition"});
        }
    }
}

