/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.barcode.formplugin.rule;

import kd.bd.barcode.common.vo.BarcodeSegment;
import kd.bd.barcode.mservice.generator.ISegmentGenerator;
import kd.bd.barcode.mservice.generator.SegmentGeneratorFactory;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.StringUtils;
import org.apache.commons.lang3.RandomStringUtils;

public class BarcodeRuleFillData {
    private static final Log LOGGER = LogFactory.getLog(BarcodeRuleFillData.class);

    public static void fill(IDataModel model) {
        DynamicObject dataEntity = model.getDataEntity(true);
        DynamicObjectCollection collection = dataEntity.getDynamicObjectCollection("entry");
        StringBuilder example = new StringBuilder();
        String seperator = "";
        if (model.getValue("seperator") != null) {
            seperator = (String)model.getValue("seperator");
        }
        if ("M".equals(model.getValue("ruletype"))) {
            seperator = "";
        }
        boolean fByLength = "L".equals(model.getValue("parsemethod")) && "D".equals(model.getValue("ruletype"));
        int barcodelength = 0;
        int index = 1;
        int ruleEntryCount = collection.size();
        String segType = (String)model.getValue("segmenttype");
        String valueType = (String)model.getValue("valuetype");
        for (DynamicObject ruleEntry : collection) {
            boolean fIscode = ruleEntry.getBoolean("iscode");
            if (fIscode) {
                String seg = null;
                if (StringUtils.isNotEmpty((String)segType) && StringUtils.isNotEmpty((String)valueType)) {
                    try {
                        ISegmentGenerator iSegGen = SegmentGeneratorFactory.getInstance((DynamicObject)ruleEntry);
                        BarcodeSegment segInfo = iSegGen.toSampleSegmentInfo(ruleEntry);
                        seg = segInfo.getSegment();
                    }
                    catch (Exception e) {
                        LOGGER.error("barcode rule edit: cannot find segment generator");
                    }
                }
                if (StringUtils.isEmpty(seg)) {
                    seg = RandomStringUtils.randomAlphanumeric((int)5);
                }
                example.append(seg);
                example.append(index < ruleEntryCount ? seperator : "");
            }
            if (fByLength) {
                int length = ruleEntry.getInt("fieldlength");
                barcodelength += length;
            }
            ++index;
        }
        if (fByLength) {
            model.setValue("barcodelength", (Object)barcodelength);
        }
        String result = example.toString();
        model.setValue("example", (Object)result);
    }
}

