/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.barcode.formplugin.rule;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kd.bd.barcode.business.helper.BarcodeRuleTreeListHelper;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.bill.BillShowParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.plugin.TreeListBizAppsPlugin;
import kd.bos.list.BillList;
import kd.bos.list.events.BeforeShowBillFormEvent;
import kd.bos.list.events.BuildTreeListFilterEvent;
import kd.bos.list.events.ListRowClickEvent;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.devportal.BizAppServiceHelp;

public class BarcodeRuleTreeListPlugin
extends TreeListBizAppsPlugin {
    public void listRowDoubleClick(ListRowClickEvent evt) {
        evt.setCancel(true);
        this.getView().invokeOperation("view");
    }

    public void initialize() {
        super.initialize();
        this.getView().setVisible(Boolean.FALSE, new String[]{"btnnew", "btnedit", "btndel"});
    }

    public void beforeItemClick(BeforeItemClickEvent beforeitemclickevent) {
        String itemkey = beforeitemclickevent.getItemKey();
        BillList billList = (BillList)this.getView().getControl("billlistap");
        ListSelectedRowCollection rows = billList.getSelectedRows();
        if (!("tblnew".equals(itemkey) || "btn_reflesh".equals(itemkey) || "importandexport".equals(itemkey) || rows.size() != 0)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e", (String)"BarcodeRuleTreeListPlugin_0", (String)"bd-barcode-formplugin", (Object[])new Object[0]));
            return;
        }
        if ("btn_view".equals(itemkey) && rows.size() > 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u80fd\u9009\u62e9\u4e00\u6761\u6761\u7801\u89c4\u5219", (String)"BarcodeRuleTreeListPlugin_1", (String)"bd-barcode-formplugin", (Object[])new Object[0]));
            return;
        }
        String[] ids = new String[rows.size()];
        int i = 0;
        for (ListSelectedRow row : rows) {
            ids[i++] = String.valueOf(row.getPrimaryKeyValue());
        }
        Object id = billList.getFocusRowPkId();
        switch (itemkey.toLowerCase(Locale.ENGLISH)) {
            case "tblnew": {
                TreeView systeTtree = (TreeView)this.getControl("treeview");
                Map map = systeTtree.getTreeState().getFocusNode();
                String objId = this.getPageCache().get("objId");
                Object isParent = map.get("isParent");
                if (isParent != null && !((Boolean)isParent).booleanValue()) {
                    objId = (String)map.get("id");
                }
                if (StringUtils.isBlank((CharSequence)objId)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u4ece\u5de6\u4fa7\u4e1a\u52a1\u5bf9\u8c61\u6811\u4e2d\u9009\u62e9\u4e00\u4e2a\u4e1a\u52a1\u5bf9\u8c61", (String)"BarcodeRuleTreeListPlugin_2", (String)"bd-barcode-formplugin", (Object[])new Object[0]));
                    beforeitemclickevent.setCancel(true);
                }
                this.getPageCache().put("objId", objId);
                break;
            }
            case "btn_modify": {
                DynamicObject barcode = BusinessDataServiceHelper.loadSingleFromCache((Object)id, (String)"barcode_rule");
                String status = (String)barcode.get("status");
                if (!"C".equals(status)) break;
                String number = (String)barcode.get("number");
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u7f16\u7801\u89c4\u5219:%1\u4e3a\u5df2\u5ba1\u6838\u72b6\u6001\uff0c\u4e0d\u80fd\u4fee\u6539!", (String)"BarcodeRuleTreeListPlugin_3", (String)"bd-barcode-formplugin", (Object[])new Object[]{number}));
                beforeitemclickevent.setCancel(true);
                break;
            }
            case "tblaudit": {
                Object[] dot;
                this.getPageCache().put("id", String.valueOf(id));
                DynamicObject barcode = BusinessDataServiceHelper.loadSingleFromCache((Object)id, (String)"barcode_rule");
                String ruletype = (String)barcode.get("ruletype");
                if (!"D".equals(ruletype)) break;
                DynamicObject businessobj = (DynamicObject)barcode.get("bizobj");
                String objNumber = (String)businessobj.get("number");
                Integer priority = (Integer)barcode.get("priority");
                QFilter[] orgFilter = new QFilter[]{new QFilter("priority", "=", (Object)priority), new QFilter("bizobj", "=", (Object)objNumber), new QFilter("parsemethod", "=", (Object)"D"), null};
                if (StringUtils.isNotBlank((Object)id)) {
                    orgFilter[3] = new QFilter("id", "!=", id);
                }
                if (!ArrayUtils.isNotEmpty((Object[])(dot = BusinessDataServiceHelper.load((String)"barcode_rule", (String)"id", (QFilter[])orgFilter)))) break;
                this.getView().showMessage(ResManager.loadKDString((String)"\u540c\u4e00\u4e1a\u52a1\u5bf9\u8c61\u5df2\u5b58\u5728\u76f8\u540c\u7684\u4f18\u5148\u7ea7\uff0c\u4e0d\u80fd\u8fdb\u884c\u5ba1\u6838!", (String)"BarcodeRuleTreeListPlugin_4", (String)"bd-barcode-formplugin", (Object[])new Object[0]));
                break;
            }
        }
    }

    public void setFilter(SetFilterEvent e) {
        super.setFilter(e);
        e.addCustomQFilter(new QFilter("bizobj", "in", this.getBillNumbers()));
    }

    public void buildTreeListFilter(BuildTreeListFilterEvent e) {
        String nodeId = e.getNodeId().toString();
        TreeNode root = this.getTreeModel().getRoot();
        TreeNode node = root.getTreeNode(nodeId, 20);
        QFilter filter = this.getFilter(node);
        e.addQFilter(filter);
        e.setCancel(true);
    }

    private QFilter getFilter(TreeNode node) {
        String nodeId = node.getId();
        if (this.isTopNode(nodeId)) {
            return null;
        }
        switch ((String)node.getData()) {
            case "cloud": {
                return new QFilter("bizobj", "in", (Object)this.getBillIdInCloud(nodeId));
            }
            case "app": {
                return new QFilter("bizobj", "in", (Object)this.getBillIdInApp(nodeId));
            }
        }
        return new QFilter("bizobj", "=", (Object)nodeId);
    }

    public void beforeShowBill(BeforeShowBillFormEvent e) {
        super.beforeShowBill(e);
        BillShowParameter param = e.getParameter();
        String currentNodeId = this.getTreeModel().getCurrentNodeId().toString();
        String rootId = this.getTreeModel().getRoot().getId();
        if (currentNodeId.contains("cloud_") || currentNodeId.contains("app_") || rootId.equals(currentNodeId)) {
            return;
        }
        param.setCustomParam("tree_parent_id", null);
        param.setCustomParam("bizobj", (Object)currentNodeId);
    }

    public void treeNodeClick(TreeNodeEvent treenodeevent) {
        this.getTreeModel().setNodeClickExpand(false);
        String nodeId = treenodeevent.getNodeId().toString();
        this.getPageCache().put("nodeId", nodeId);
        TreeNode node = this.getTreeModel().getRoot().getTreeNode(nodeId, 10);
        String nodeData = (String)node.getData();
        if (node.getChildren() != null || "app".equals(nodeData) || "cloud".equals(nodeData)) {
            nodeData = null;
        }
        super.treeNodeClick(treenodeevent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> getBillNumbers() {
        String fields = "number";
        String orderby = "bizappid asc";
        QFilter modelTypeFilter = new QFilter("modeltype", "in", Arrays.asList("BaseFormModel", "BillFormModel"));
        QFilter isTemplateFilter = new QFilter("istemplate", "=", (Object)Boolean.FALSE);
        QFilter enableImport = new QFilter("enableimport", "=", (Object)Boolean.TRUE);
        QFilter[] filters = new QFilter[]{modelTypeFilter, isTemplateFilter, enableImport};
        ArrayList<String> billNumbers = new ArrayList<String>();
        try (DataSet ds = ORM.create().queryDataSet("bos_entityobject", "bos_entityobject", fields, filters, orderby);){
            for (Row row : ds) {
                billNumbers.add(row.getString("number"));
            }
        }
        return billNumbers;
    }

    protected List<TreeNode> getAppNodesBy(String cloudNodeId) {
        TreeNode root = (TreeNode)BizAppServiceHelp.getSubsysTree((String[])new String[]{cloudNodeId}, null, null, (String)"app", (boolean)true, (boolean)false, (boolean)true);
        List clouds = null;
        if (root != null) {
            clouds = root.getChildren();
        }
        if (clouds == null || clouds.isEmpty()) {
            return new ArrayList<TreeNode>();
        }
        List apps = ((TreeNode)clouds.get(0)).getChildren();
        if (apps == null || apps.isEmpty()) {
            return new ArrayList<TreeNode>();
        }
        for (TreeNode app : apps) {
            if (app == null) continue;
            app.setChildren(new ArrayList(0));
        }
        return apps;
    }

    protected Map<String, String> searchApp(String searchText) {
        List billApps = BarcodeRuleTreeListHelper.searchBillApp((String)searchText);
        String likeExp = String.format("%%%s%%", searchText);
        List objs = BarcodeRuleTreeListHelper.getApps((QFilter[])new QFilter[]{new QFilter("name", "like", (Object)likeExp).or("number", "like", (Object)likeExp).or("id", "in", (Object)billApps)}, (String)"sequence asc", (boolean)true, (boolean)false);
        HashMap<String, String> apps = new HashMap<String, String>(objs.size());
        for (DynamicObject obj : objs) {
            apps.put(obj.getString("id"), obj.getString("bizcloud_id"));
        }
        return apps;
    }
}

