/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.barcode.opplugin.barcode;

import java.util.ArrayList;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;

public class BarcodeSaveValidator
extends AbstractValidator {
    public void validate() {
        ExtendedDataEntity[] dataEntities = this.getDataEntities();
        ArrayList<String> barcodes = new ArrayList<String>(dataEntities.length);
        for (ExtendedDataEntity data : dataEntities) {
            QFilter[] filters;
            DynamicObject barcodeinfo;
            String barcode = (String)data.getValue("barcode");
            if (barcodes.contains(barcode)) {
                this.addErrorMessage(data, ResManager.loadResFormat((String)"\u6761\u7801\u503c:%1\u91cd\u590d", (String)"BarcodeCheckPlugin_2", (String)"bd-barcode-opplugin", (Object[])new Object[]{barcode}));
                this.getValidateResult().setSuccess(false);
            }
            if ((barcodeinfo = BusinessDataServiceHelper.loadSingleFromCache((String)"barcode_info", (QFilter[])(filters = new QFilter[]{new QFilter("barcode", "=", (Object)barcode)}))) != null) {
                this.addErrorMessage(data, ResManager.loadResFormat((String)"\u6761\u7801\u503c:%1\u5df2\u5b58\u5728", (String)"BarcodeCheckPlugin_1", (String)"bd-barcode-opplugin", (Object[])new Object[]{barcode}));
                this.getValidateResult().setSuccess(false);
            }
            barcodes.add(barcode);
        }
    }
}

