/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.barcode.opplugin.pkgbarcode;

import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;

public class PackageBarcodeSaveValidator
extends AbstractValidator {
    private static final String MODULE = "bd-barcode-opplugin";

    public void validate() {
        ExtendedDataEntity[] dataEntities;
        for (ExtendedDataEntity entity : dataEntities = this.getDataEntities()) {
            Long barcodeId = null;
            if (entity.getValue("barcode") instanceof DynamicObject) {
                DynamicObject barcode = (DynamicObject)entity.getValue("barcode");
                barcodeId = barcode.getLong("id");
            } else {
                barcodeId = (Long)entity.getValue("barcode");
            }
            DynamicObject dataEntity = entity.getDataEntity();
            DynamicObjectCollection collection = dataEntity.getDynamicObjectCollection("entry");
            ArrayList<Long> ids = new ArrayList<Long>();
            collection.forEach(e -> {
                if (e.get("ebarcode") instanceof DynamicObject) {
                    DynamicObject ebarcode = (DynamicObject)e.get("ebarcode");
                    ids.add(ebarcode.getLong("id"));
                } else {
                    ids.add((Long)e.get("ebarcode"));
                }
            });
            this.checkBarcodeBizobj(barcodeId, ids);
            this.checkPackageLevel(barcodeId);
            this.checkUpper((Long)entity.getValue("id"), ids);
            this.checkIsSupPkg(barcodeId, ids);
        }
    }

    protected void checkChildLevel(Long pkgBarcodeId, short sLevel) {
        if (sLevel > 5) {
            String msg = ResManager.loadResFormat((String)"\u8d85\u8fc7\u6700\u5927\u5305\u88c5\u5c42\u6570%1", (String)"PackageBarcodeCheckPlugin_1", (String)MODULE, (Object[])new Object[]{(short)5});
            throw new KDBizException(msg);
        }
        QFilter[] filters = new QFilter[]{new QFilter("barcode", "=", (Object)pkgBarcodeId)};
        DynamicObject pkgInfo = BusinessDataServiceHelper.loadSingleFromCache((String)"package_barcode", (QFilter[])filters);
        if (pkgInfo == null) {
            return;
        }
        ArrayList<Long> subPkgIds = new ArrayList<Long>();
        boolean fSubPkg = false;
        DynamicObjectCollection pEntries = pkgInfo.getDynamicObjectCollection("entry");
        for (DynamicObject pEntry : pEntries) {
            if (pEntry.getBoolean("isleaf")) continue;
            subPkgIds.add(pEntry.getLong("ebarcode_id"));
        }
        boolean bl = fSubPkg = subPkgIds.size() > 0;
        if (fSubPkg) {
            for (Long subpId : subPkgIds) {
                this.checkChildLevel(subpId, (short)(sLevel + 1));
            }
        }
    }

    protected void checkReferenceLevel(Long pkgBarcodeId, short sLevel) {
        if (sLevel > 5) {
            String msg = ResManager.loadResFormat((String)"\u8d85\u8fc7\u6700\u5927\u5305\u88c5\u5c42\u6570%1", (String)"PackageBarcodeCheckPlugin_1", (String)MODULE, (Object[])new Object[]{(short)5});
            throw new KDBizException(msg);
        }
        String fields = "id, barcode, barcode.barcodetype";
        QFilter[] filters = new QFilter[]{new QFilter("entry.ebarcode", "=", (Object)pkgBarcodeId)};
        DynamicObject pkgInfo = BusinessDataServiceHelper.loadSingleFromCache((String)"package_barcode", (String)fields, (QFilter[])filters);
        if (pkgInfo == null) {
            return;
        }
        String barcodeType = pkgInfo.getString("barcode.barcodetype");
        if ("P".equals(barcodeType)) {
            Long parentPkgBarcodeId = pkgInfo.getLong("barcode.id");
            this.checkReferenceLevel(parentPkgBarcodeId, (short)(sLevel + 1));
        }
    }

    protected void checkPackageLevel(Long pkgBarcodeId) throws KDBizException {
        short level = 1;
        short rLevel = 1;
        this.checkChildLevel(pkgBarcodeId, level);
        this.checkReferenceLevel(pkgBarcodeId, rLevel);
    }

    protected void checkBarcodeBizobj(Long pkgBarcodeId, List<Long> barcodeIds) throws KDBizException {
        QFilter[] filters = new QFilter[]{new QFilter("id", "=", (Object)pkgBarcodeId)};
        DynamicObject pkgBarcode = BusinessDataServiceHelper.loadSingleFromCache((String)"barcode_info", (QFilter[])filters);
        DynamicObject bizobj = (DynamicObject)pkgBarcode.get("bizobj");
        String bizobjNumber = bizobj.getString("number");
        for (Long id : barcodeIds) {
            QFilter[] qfArr = new QFilter[]{new QFilter("id", "=", (Object)id)};
            DynamicObject ebarcode = BusinessDataServiceHelper.loadSingleFromCache((String)"barcode_info", (QFilter[])qfArr);
            DynamicObject barcodeBizobj = (DynamicObject)ebarcode.get("bizobj");
            if (bizobjNumber.equals(barcodeBizobj.getString("number"))) continue;
            String msg = ResManager.loadResFormat((String)"\u88c5\u7bb1\u4e2d\u6761\u7801\u4e0e\u5305\u88c5\u6761\u7801\u503c\u4e1a\u52a1\u5bf9\u8c61\u4e0d\u540c(%1)", (String)"PackageBarcodeCheckPlugin_3", (String)MODULE, (Object[])new Object[]{id});
            throw new KDBizException(msg);
        }
    }

    protected void checkUpper(Long id, List<Long> barcodeIds) {
        for (Long barcodeId : barcodeIds) {
            QFilter[] filters = new QFilter[]{new QFilter("entry.ebarcode", "=", (Object)barcodeId), new QFilter("id", "!=", (Object)id)};
            boolean fExists = QueryServiceHelper.exists((String)"package_barcode", (QFilter[])filters);
            if (!fExists) continue;
            QFilter[] bFilters = new QFilter[]{new QFilter("id", "=", (Object)barcodeId)};
            DynamicObject barocde = BusinessDataServiceHelper.loadSingleFromCache((String)"barcode_info", (QFilter[])bFilters);
            String msg = ResManager.loadResFormat((String)"\u6761\u7801\u503c:%1\u5df2\u88ab\u88c5\u7bb1,\u4e0d\u80fd\u518d\u6b21\u88c5\u7bb1", (String)"PackageBarcodeCheckPlugin_4", (String)MODULE, (Object[])new Object[]{barocde.getString("barcode")});
            throw new KDBizException(msg);
        }
    }

    protected void checkIsSupPkg(Long pkgBarcodeId, List<Long> barcodeIds) {
        QFilter[] filters = new QFilter[]{new QFilter("id", "=", (Object)pkgBarcodeId)};
        DynamicObject pkgBarcode = BusinessDataServiceHelper.loadSingleFromCache((String)"barcode_info", (QFilter[])filters);
        for (Long id : barcodeIds) {
            DynamicObject pkg = BusinessDataServiceHelper.loadSingleFromCache((String)"package_barcode", (QFilter[])new QFilter[]{new QFilter("barcode", "=", (Object)id)});
            if (pkg == null) continue;
            String barcode = pkg.getDynamicObject("barcode").getString("barcode");
            this.isSupPkg(barcode, pkg, pkgBarcode.getString("barcode"));
        }
    }

    private void isSupPkg(String barcode, DynamicObject pkg, String pkgBarcode) {
        DynamicObjectCollection entry = pkg.getDynamicObjectCollection("entry");
        for (DynamicObject ebarcode : entry) {
            if (pkgBarcode.equals(ebarcode.getDynamicObject("ebarcode").getString("barcode"))) {
                String msg = ResManager.loadResFormat((String)"\u6761\u7801\u503c:%1\u4e3a\u4e0a\u7ea7\u5305\u88c5\u6761\u7801,\u4e0d\u80fd\u88c5\u7bb1", (String)"PackageBarcodeCheckPlugin_5", (String)MODULE, (Object[])new Object[]{barcode});
                throw new KDBizException(msg);
            }
            if (ebarcode.getBoolean("isleaf") || (pkg = BusinessDataServiceHelper.loadSingleFromCache((String)"package_barcode", (QFilter[])new QFilter[]{new QFilter("barcode", "=", (Object)ebarcode.getLong("id"))})) == null) continue;
            this.isSupPkg(barcode, pkg, pkgBarcode);
        }
    }
}

