/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.barcode.opplugin.rule;

import java.util.ArrayList;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.ArrayUtils;

public class BarcodeRuleSaveValidator
extends AbstractValidator {
    public void validate() {
        ExtendedDataEntity[] dataEntities = this.getDataEntities();
        ArrayList<String> dateList = new ArrayList<String>();
        dateList.add("yyyyMMdd");
        dateList.add("yyyyMMdd HH:mm:ss");
        dateList.add("yyyy/MM/dd");
        dateList.add("yyyy/MM/dd HH:mm:ss");
        dateList.add("yyyy-MM-dd");
        dateList.add("yyyy-MM-dd HH:mm:ss");
        ArrayList<String> timeList = new ArrayList<String>();
        timeList.add("HH:mm:ss");
        timeList.add("HH:mm");
        for (ExtendedDataEntity entity : dataEntities) {
            DynamicObject dataEntity;
            DynamicObjectCollection collection;
            QFilter[] autoFilter;
            boolean exists;
            Long id = (Long)entity.getValue("id");
            DynamicObject barcoderule = BusinessDataServiceHelper.loadSingleFromCache((Object)id, (String)"barcode_rule");
            String itemkey = this.getOperateKey();
            if (!StringUtils.equals((String)"save", (String)itemkey) && !StringUtils.equals((String)"submit", (String)itemkey)) continue;
            OrmLocaleValue nameLocaleValue = (OrmLocaleValue)entity.getValue("name");
            String name = nameLocaleValue.toString();
            String number = (String)entity.getValue("number");
            QFilter[] nameFilter = new QFilter[]{new QFilter("name", "=", (Object)name), null};
            QFilter[] numberFilter = new QFilter[]{new QFilter("number", "=", (Object)number), null};
            if (barcoderule != null) {
                QFilter qFilter;
                nameFilter[1] = qFilter = new QFilter("id", "!=", (Object)id);
                numberFilter[1] = qFilter;
            }
            if (exists = QueryServiceHelper.exists((String)"barcode_rule", (QFilter[])nameFilter)) {
                this.addErrorMessage(entity, ResManager.loadKDString((String)"\u89c4\u5219\u540d\u79f0\u4e0d\u80fd\u91cd\u590d", (String)"BarcodeRuleEditCheckPlugin_4", (String)"bd-barcode-opplugin", (Object[])new Object[0]));
            }
            if (exists = QueryServiceHelper.exists((String)"barcode_rule", (QFilter[])numberFilter)) {
                this.addErrorMessage(entity, ResManager.loadKDString((String)"\u89c4\u5219\u7f16\u7801\u4e0d\u80fd\u91cd\u590d", (String)"BarcodeRuleEditCheckPlugin_1", (String)"bd-barcode-opplugin", (Object[])new Object[0]));
            }
            DynamicObject businessobj = (DynamicObject)entity.getValue("bizobj");
            String objNumber = (String)businessobj.get("number");
            if (((Boolean)entity.getValue("isautogenerate")).booleanValue() && (exists = QueryServiceHelper.exists((String)"barcode_rule", (QFilter[])(autoFilter = new QFilter[]{new QFilter("isautogenerate", "=", (Object)true), new QFilter("bizobj", "=", (Object)objNumber)})))) {
                this.addErrorMessage(entity, ResManager.loadKDString((String)"\u8be5\u4e1a\u52a1\u5bf9\u8c61\u5df2\u6709\u81ea\u52a8\u751f\u6210\u7684\u6761\u7801\u89c4\u5219", (String)"BarcodeRuleEditCheckPlugin_18", (String)"bd-barcode-opplugin", (Object[])new Object[0]));
            }
            String parsemethod = (String)entity.getValue("parsemethod");
            String seperator = (String)entity.getValue("seperator");
            String ruletype = (String)entity.getValue("ruletype");
            int length = (Integer)entity.getValue("barcodelength");
            if ("D".equals(ruletype)) {
                Object[] dot;
                Integer priority = (Integer)entity.getValue("priority");
                QFilter[] orgFilter = new QFilter[]{new QFilter("priority", "=", (Object)priority), new QFilter("bizobj", "=", (Object)objNumber), new QFilter("ruletype", "=", (Object)"D"), null, null, null};
                if (id != null && id != 0L) {
                    orgFilter[3] = new QFilter("id", "!=", (Object)id);
                }
                if (parsemethod.equals("S")) {
                    orgFilter[4] = new QFilter("seperator", "=", (Object)seperator);
                    orgFilter[5] = new QFilter("parsemethod", "=", (Object)"S");
                }
                if (parsemethod.equals("L")) {
                    orgFilter[4] = new QFilter("barcodelength", "=", (Object)length);
                    orgFilter[5] = new QFilter("parsemethod", "=", (Object)"L");
                }
                if (ArrayUtils.isNotEmpty((Object[])(dot = BusinessDataServiceHelper.load((String)"barcode_rule", (String)"id,name", (QFilter[])orgFilter)))) {
                    String info = null;
                    if (parsemethod.equals("S")) {
                        info = ResManager.loadKDString((String)"\u540c\u4e00\u4e1a\u52a1\u5bf9\u8c61\u76f8\u540c\u5206\u9694\u7b26\u5df2\u5b58\u5728\u76f8\u540c\u7684\u4f18\u5148\u7ea7", (String)"BarcodeRuleEditCheckPlugin_2", (String)"bd-barcode-opplugin", (Object[])new Object[0]);
                    }
                    if (parsemethod.equals("L")) {
                        info = ResManager.loadKDString((String)"\u540c\u4e00\u4e1a\u52a1\u5bf9\u8c61\u76f8\u540c\u957f\u5ea6\u5df2\u5b58\u5728\u76f8\u540c\u7684\u4f18\u5148\u7ea7", (String)"BarcodeRuleEditCheckPlugin_14", (String)"bd-barcode-opplugin", (Object[])new Object[0]);
                    }
                    this.addErrorMessage(entity, info);
                }
            }
            boolean isPeritem = false;
            if ("M".equals(ruletype) && ((Boolean)entity.getValue("isperitem")).booleanValue()) {
                isPeritem = true;
            }
            if ((collection = (dataEntity = entity.getDataEntity()).getDynamicObjectCollection("entry")).size() < 1) {
                this.addErrorMessage(entity, ResManager.loadKDString((String)"\u89c4\u5219\u5185\u5bb9\u81f3\u5c11\u8981\u6709\u4e00\u884c\u6570\u636e", (String)"BarcodeRuleEditCheckPlugin_7", (String)"bd-barcode-opplugin", (Object[])new Object[0]));
            }
            if (collection.size() > 20) {
                this.addErrorMessage(entity, ResManager.loadKDString((String)"\u89c4\u5219\u5185\u5bb9\u6700\u591a\u4e8c\u5341\u884c\u6570\u636e", (String)"BarcodeRuleEditCheckPlugin_12", (String)"bd-barcode-opplugin", (Object[])new Object[0]));
            }
            int i = 1;
            int qtyprop = 0;
            boolean hasSerial = false;
            for (DynamicObject de : collection) {
                Integer fieldlength;
                String valuetype = (String)de.get("valuetype");
                String format = (String)de.get("format");
                String segmenttype = (String)de.get("segmenttype");
                if (isPeritem && de.getBoolean("isqtyprop")) {
                    ++qtyprop;
                }
                if ("S".equals(segmenttype)) {
                    hasSerial = true;
                }
                if ("F".equals(segmenttype) && StringUtils.isBlank((String)de.getString("fixvalue"))) {
                    this.addErrorMessage(entity, ResManager.loadResFormat((String)"\u7b2c%1\u884c\u56fa\u5b9a\u503c\u4e0d\u80fd\u4e3a\u7a7a", (String)"BarcodeRuleEditCheckPlugin_15", (String)"bd-barcode-opplugin", (Object[])new Object[]{i}));
                }
                if ("T".equals(valuetype) && !timeList.contains(format)) {
                    this.addErrorMessage(entity, ResManager.loadResFormat((String)"\u7b2c%1\u884c\u65f6\u95f4\u503c\u7c7b\u578b\u5bf9\u5e94\u7684\u683c\u5f0f\u4e0d\u6b63\u786e", (String)"BarcodeRuleEditCheckPlugin_5", (String)"bd-barcode-opplugin", (Object[])new Object[]{i}));
                }
                if ("D".equals(valuetype) && !dateList.contains(format)) {
                    this.addErrorMessage(entity, ResManager.loadResFormat((String)"\u7b2c%1\u884c\u65e5\u671f\u503c\u7c7b\u578b\u5bf9\u5e94\u7684\u683c\u5f0f\u4e0d\u6b63\u786e", (String)"BarcodeRuleEditCheckPlugin_6", (String)"bd-barcode-opplugin", (Object[])new Object[]{i}));
                }
                if (ruletype.equals("D") && parsemethod.equals("S") && StringUtils.equals((String)seperator, (String)"-") && (StringUtils.equals((String)format, (String)"yyyy-MM-dd") || StringUtils.equals((String)format, (String)"yyyy-MM-dd HH:mm:ss"))) {
                    this.addErrorMessage(entity, ResManager.loadResFormat((String)"\u7b2c%1\u884c\u683c\u5f0f\u4e0e\u5206\u9694\u7b26\u5b58\u5728\u51b2\u7a81,\u8bf7\u66f4\u6362\u5206\u9694\u7b26\u6216\u683c\u5f0f", (String)"BarcodeRuleEditCheckPlugin_9", (String)"bd-barcode-opplugin", (Object[])new Object[]{i}));
                }
                if (ruletype.equals("D") && parsemethod.equals("L") && ((fieldlength = (Integer)de.get("fieldlength")) == null || fieldlength < 1)) {
                    this.addErrorMessage(entity, ResManager.loadResFormat((String)"\u7b2c%1\u884c\u503c\u957f\u5ea6\u8981\u5927\u4e8e\u7b49\u4e8e1", (String)"BarcodeRuleEditCheckPlugin_11", (String)"bd-barcode-opplugin", (Object[])new Object[]{i}));
                }
                ++i;
            }
            if (isPeritem && qtyprop != 1) {
                this.addErrorMessage(entity, ResManager.loadKDString((String)"\u6761\u7801\u6570\u91cf\u53ea\u80fd\u9009\u62e9\u4e00\u4e2a\u6570\u503c\u7c7b\u578b\u7684\u5b57\u6bb5", (String)"BarcodeRuleEditCheckPlugin_16", (String)"bd-barcode-opplugin", (Object[])new Object[0]));
            }
            if (!isPeritem || hasSerial) continue;
            this.addErrorMessage(entity, ResManager.loadKDString((String)"\u4e00\u7269\u4e00\u7801\u5fc5\u987b\u8981\u6709\u4e00\u884c\u662f\u6d41\u6c34\u53f7", (String)"BarcodeRuleEditCheckPlugin_17", (String)"bd-barcode-opplugin", (Object[])new Object[0]));
        }
    }
}

