/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.barcode.business.helper;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.AppInfo;
import kd.bos.entity.AppMetadataCache;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.runmode.RunModeServiceHelper;

public class BarcodeRuleTreeListHelper {
    private static final Log logger = LogFactory.getLog(BarcodeRuleTreeListHelper.class);

    public static List<String> searchBillApp(String searchText) {
        QFilter modelTypeFilter = new QFilter("modeltype", "in", Arrays.asList("BaseFormModel", "BillFormModel", "QueryListModel"));
        QFilter isTemplateFilter = new QFilter("istemplate", "=", (Object)Boolean.FALSE);
        QFilter enableImportFilter = new QFilter("enableimport", "=", (Object)Boolean.TRUE);
        String s = "%%%s%%";
        QFilter likeFilter = new QFilter("number", "like", (Object)String.format(s, searchText)).or("name", "like", (Object)String.format(s, searchText));
        QFilter[] filters = new QFilter[]{modelTypeFilter, isTemplateFilter, enableImportFilter, likeFilter};
        filters = RunModeServiceHelper.getEntityIdBlacklistFilters((QFilter[])filters, (String)"dentityid");
        DynamicObject[] objects = BusinessDataServiceHelper.load((String)"bos_entityobject", (String)"bizappid", (QFilter[])filters);
        HashSet<String> apps = new HashSet<String>(objects.length);
        for (DynamicObject object : objects) {
            apps.add(object.getString("bizappid_id"));
        }
        return new ArrayList<String>(apps);
    }

    public static List<DynamicObject> getApps(QFilter[] filters, String orderBy, boolean isRuntime, boolean onlyVisible) {
        QFilter mstEmpty;
        QFilter mstNotNUll;
        QFilter[] mstfilters;
        Map appExtends;
        filters = RunModeServiceHelper.getAppAndCloudBlacklistFilters((QFilter[])filters, (String)"id", (String)"bizcloud");
        Map appsMap = BusinessDataServiceHelper.loadFromCache((String)"bos_devportal_bizapp", (String)"id,name,number,type,industry,bizcloud,sequence,visible", (QFilter[])filters, (String)orderBy);
        HashSet<String> extendedAppIds = new HashSet<String>();
        if (isRuntime && onlyVisible && (appExtends = BusinessDataServiceHelper.loadFromCache((String)"bos_devportal_bizapp", (String)"masterid,visible", (QFilter[])(mstfilters = new QFilter[]{mstNotNUll = new QFilter("masterid", "is not null", (Object)Boolean.TRUE), mstEmpty = new QFilter("masterid", "!=", (Object)" ")}))).size() > 0) {
            for (DynamicObject obj : appExtends.values()) {
                extendedAppIds.add(obj.getString("masterid"));
            }
        }
        ArrayList<DynamicObject> apps = new ArrayList<DynamicObject>();
        if (appsMap != null) {
            for (DynamicObject obj : appsMap.values()) {
                String appId = obj.getString("id");
                String appNum = obj.getString("number");
                if (isRuntime && onlyVisible) {
                    if ("portal".equals(appNum)) continue;
                    if (extendedAppIds.contains(appId)) {
                        AppInfo appInfo = AppMetadataCache.getAppInfo((String)appNum);
                        if (!appInfo.isRealRuntime()) continue;
                        obj.set("name", (Object)appInfo.getName());
                    } else {
                        boolean visible = obj.getBoolean("visible");
                        if (!visible) continue;
                    }
                }
                apps.add(obj);
            }
        }
        final Map<Object, DynamicObject> cloudsMap = BarcodeRuleTreeListHelper.getClouds(null);
        try {
            Collections.sort(apps, new Comparator<DynamicObject>(){

                @Override
                public int compare(DynamicObject o1, DynamicObject o2) {
                    if (o1.getString("bizcloud_id").equals(o2.getString("bizcloud_id"))) {
                        return 0;
                    }
                    DynamicObject obj1 = (DynamicObject)cloudsMap.get(o1.getString("bizcloud_id"));
                    DynamicObject obj2 = (DynamicObject)cloudsMap.get(o2.getString("bizcloud_id"));
                    if (obj1 != null && obj2 != null && StringUtils.isNotBlank((Object)obj1.getInt("sequence")) && StringUtils.isNotBlank((Object)obj2.getInt("sequence"))) {
                        return obj1.getInt("sequence") - obj2.getInt("sequence");
                    }
                    return 0;
                }
            });
        }
        catch (Exception exception) {
            logger.error(exception.getMessage());
        }
        return apps;
    }

    private static Map<Object, DynamicObject> getClouds(QFilter[] filters) {
        String fields = "id,name,number,sequence";
        filters = RunModeServiceHelper.getCloudIdBlacklistFilters((QFilter[])filters, (String)"id");
        Map cloudsMap = BusinessDataServiceHelper.loadFromCache((String)"bos_devportal_bizcloud", (String)fields, (QFilter[])filters, (String)"sequence asc");
        return cloudsMap;
    }
}

