/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.barcode.mservice;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bd.barcode.common.enums.BarcodeReturnMsgEnum;
import kd.bd.barcode.common.enums.EnableEnum;
import kd.bd.barcode.mservice.api.IExecutePlugin;
import kd.bos.data.BusinessDataReader;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.runtime.ConvertOperationResult;
import kd.bos.entity.botp.runtime.PushArgs;
import kd.bos.entity.datamodel.IRefrencedataProvider;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.botp.ConvertServiceHelper;
import kd.bos.trace.TraceSpan;
import kd.bos.trace.Tracer;

public class BarcodeGenerateBillHelper {
    private static final Log log = LogFactory.getLog(BarcodeGenerateBillHelper.class);
    private static final String LINE_BREAK = "\r\n";

    public static DynamicObject loadScanConfig(String srcBillEntityId, String targetBillEntityId) {
        QFilter srcBillFilter = new QFilter("srcbill", "=", (Object)srcBillEntityId);
        QFilter targetBillFilter = new QFilter("targetbill", "=", (Object)targetBillEntityId);
        QFilter statusFilter = new QFilter("status", "=", (Object)"C");
        QFilter enableFilter = new QFilter("enable", "=", (Object)EnableEnum.ENABLE.getCode());
        Map scanConfigMap = BusinessDataServiceHelper.loadFromCache((String)"barcode_scanconfig", (String)"id,number,targetbill,srcbill,botp,plugin", (QFilter[])new QFilter[]{srcBillFilter, targetBillFilter, statusFilter, enableFilter});
        if (scanConfigMap.isEmpty()) {
            return null;
        }
        return (DynamicObject)scanConfigMap.values().iterator().next();
    }

    public static Map<String, Object> convertBarcode2SrcBillInfo(String barcode, DynamicObject scanConfig) {
        String pluginClassName = scanConfig.getString("plugin");
        Map<String, Object> srcBillInfo = null;
        try (TraceSpan span = Tracer.create((String)"BarcodeGenerateBillHelper", (String)"getSrcBillInfo");){
            srcBillInfo = BarcodeGenerateBillHelper.getSrcBillInfo(barcode, pluginClassName);
        }
        catch (Exception e) {
            log.error("call getSrcBillInfo exception", (Throwable)e);
        }
        if (srcBillInfo == null || srcBillInfo.isEmpty()) {
            log.info("call getSrcBillInfo failed, return srcBillInfo is empty");
            return Collections.emptyMap();
        }
        Object srcBillNo = srcBillInfo.get("srcBillNo");
        if (StringUtils.isBlank((Object)srcBillNo)) {
            log.info("call getSrcBillInfo failed, return srcBillNo is empty");
            return srcBillInfo;
        }
        Object srcBillId = srcBillInfo.get("srcBillId");
        if (srcBillId != null && !srcBillId.equals(0L)) {
            return srcBillInfo;
        }
        DynamicObject botpRule = scanConfig.getDynamicObject("botp");
        DynamicObject srcEntityField = botpRule.getDynamicObject("sourceentitynumber");
        String srcEntityNum = srcEntityField.getString("number");
        log.info("convertBarcode2SrcBillId, srcEntityNum=" + srcEntityNum + " barcode=" + barcode + " srcBillInfo=" + srcBillInfo);
        MainEntityType srcEntityType = EntityMetadataCache.getDataEntityType((String)srcEntityNum);
        if (srcEntityType == null) {
            log.error("convertBarcode2SrcBillId, can't found " + srcEntityNum + " entity");
            return srcBillInfo;
        }
        IDataEntityProperty billNoField = srcEntityType.findProperty("billno");
        if (billNoField == null) {
            log.error("convertBarcode2SrcBillId, can't found 'billno' property for the " + srcEntityNum);
            return srcBillInfo;
        }
        DynamicObject srcBill = QueryServiceHelper.queryOne((String)srcEntityNum, (String)"id", (QFilter[])new QFilter[]{new QFilter("billno", "=", srcBillNo)});
        if (srcBill != null) {
            srcBillInfo.put("srcBillId", srcBill.getLong("id"));
        }
        return srcBillInfo;
    }

    private static Map<String, Object> getSrcBillInfo(String barcode, String pluginClassName) throws Exception {
        HashMap<String, Object> emptyResult = new HashMap<String, Object>(16);
        emptyResult.put("srcBillNo", barcode);
        emptyResult.put("srcBillId", 0L);
        emptyResult.put("srcBillEntryKey", "");
        emptyResult.put("srcBillEntryIds", null);
        if (StringUtils.isBlank((CharSequence)pluginClassName)) {
            return emptyResult;
        }
        Class<?> executePluginClass = Class.forName(pluginClassName);
        IExecutePlugin executePlugin = (IExecutePlugin)executePluginClass.newInstance();
        return executePlugin.getSrcBillInfo(barcode);
    }

    public static ConvertOperationResult invokeBOTPGenerateBill(DynamicObject scanConfig, Map<String, Object> srcBillInfo, boolean autoSave) {
        DynamicObject botpRule = scanConfig.getDynamicObject("botp");
        String botpRuleId = botpRule.getString("id");
        String srcEntityNum = botpRule.getDynamicObject("sourceentitynumber").getString("number");
        String tarEntityNum = botpRule.getDynamicObject("targetentitynumber").getString("number");
        Object srcBillId = srcBillInfo.get("srcBillId");
        Object srcBillEntryKey = srcBillInfo.get("srcBillEntryKey");
        Object srcBillEntryIds = srcBillInfo.get("srcBillEntryIds");
        log.info("invokeBOTPGenerateBill, botpRuleId=" + botpRuleId + ",srcEntityNum=" + srcEntityNum + ",tarEntityNum=" + tarEntityNum + ",srcBillId=" + srcBillId + ",srcBillEntryKey=" + srcBillEntryKey + ",srcBillEntryIds=" + srcBillEntryIds);
        PushArgs pushArgs = new PushArgs();
        pushArgs.setSourceEntityNumber(srcEntityNum);
        pushArgs.setTargetEntityNumber(tarEntityNum);
        pushArgs.setRuleId(botpRuleId);
        ArrayList<ListSelectedRow> selectedRows = new ArrayList<ListSelectedRow>(10);
        if (StringUtils.isBlank((Object)srcBillEntryKey)) {
            ListSelectedRow srcBill = new ListSelectedRow(srcBillId);
            selectedRows.add(srcBill);
        } else if (srcBillEntryIds instanceof List) {
            List srcBillEntryIdList = (List)srcBillEntryIds;
            for (Long srcBillEntryId : srcBillEntryIdList) {
                ListSelectedRow srcBill = new ListSelectedRow(srcBillId);
                srcBill.setEntryEntityKey(srcBillEntryKey.toString());
                srcBill.setEntryPrimaryKeyValue((Object)srcBillEntryId);
                selectedRows.add(srcBill);
            }
        }
        pushArgs.setSelectedRows(selectedRows);
        TraceSpan span = Tracer.create((String)"BarcodeGenerateBillHelper", (String)"ConvertServiceHelper.push");
        Object object = null;
        try {
            ConvertOperationResult pushResult = null;
            pushResult = autoSave ? ConvertServiceHelper.pushAndSave((PushArgs)pushArgs) : ConvertServiceHelper.push((PushArgs)pushArgs);
            if (!pushResult.isSuccess()) {
                List srcBillReport = pushResult.getBillReports();
                String pushFailedMsg = srcBillReport.isEmpty() ? pushResult.getMessage() : srcBillReport.toString();
                log.info("invokeBOTPGenerateBill, pushFailedMsg=" + pushFailedMsg);
            }
            ConvertOperationResult convertOperationResult = pushResult;
            return convertOperationResult;
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            if (span != null) {
                if (object != null) {
                    try {
                        span.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)object).addSuppressed(throwable);
                    }
                } else {
                    span.close();
                }
            }
        }
    }

    public static Map<String, Object> buildResultMap(boolean isSuccess, Object outBillId, BarcodeReturnMsgEnum returnMsgEnum, String appendMsg) {
        HashMap<String, Object> result = new HashMap<String, Object>(16);
        result.put("isSuccess", isSuccess);
        result.put("outBillId", outBillId);
        result.put("code", returnMsgEnum.getCode());
        String msg = StringUtils.isEmpty((CharSequence)appendMsg) ? returnMsgEnum.getDescription() : returnMsgEnum.getDescription() + appendMsg;
        result.put("message", msg);
        return result;
    }

    public static Map<String, Object> buildErrResultMap(BarcodeReturnMsgEnum returnMsgEnum) {
        return BarcodeGenerateBillHelper.buildErrResultMap(returnMsgEnum, "");
    }

    public static Map<String, Object> buildErrResultMap(BarcodeReturnMsgEnum returnMsgEnum, String appendMsg) {
        return BarcodeGenerateBillHelper.buildResultMap(false, 0L, returnMsgEnum, appendMsg);
    }

    public static Map<String, Object> buildSuccessResultMap(Object outBillId, BarcodeReturnMsgEnum returnMsgEnum) {
        return BarcodeGenerateBillHelper.buildResultMap(true, outBillId, returnMsgEnum, "");
    }

    public static List<DynamicObject> getBOTPTargetBill(ConvertOperationResult botpResult) {
        if (!botpResult.isSuccess()) {
            return Collections.emptyList();
        }
        MainEntityType mainType = EntityMetadataCache.getDataEntityType((String)botpResult.getTargetEntityNumber());
        return botpResult.loadTargetDataObjects(new IRefrencedataProvider(){

            public void fillReferenceData(Object[] dataEntitys, IDataEntityType type) {
                BusinessDataReader.loadRefence((Object[])dataEntitys, (IDataEntityType)type);
            }
        }, mainType);
    }

    public static String getOperateErrMsg(OperationResult opResult) {
        StringBuilder errMsgBuilder = new StringBuilder();
        List allErrorOrValidateInfo = opResult.getAllErrorOrValidateInfo();
        if (allErrorOrValidateInfo.isEmpty()) {
            errMsgBuilder.append(opResult.getMessage()).append(LINE_BREAK);
        } else {
            for (IOperateInfo operInfo : allErrorOrValidateInfo) {
                errMsgBuilder.append(operInfo.getMessage()).append(LINE_BREAK);
            }
        }
        return errMsgBuilder.toString();
    }
}

