/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.barcode.mservice;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import kd.bd.barcode.common.BarcodeMetadataHelper;
import kd.bd.barcode.common.vo.Barcode;
import kd.bd.barcode.common.vo.BarcodeBillEntryData;
import kd.bd.barcode.common.vo.BarcodeGenerateOption;
import kd.bd.barcode.common.vo.BarcodeGenerated;
import kd.bd.barcode.common.vo.BarcodeSegment;
import kd.bd.barcode.mservice.BarcodeParamsHelper;
import kd.bd.barcode.mservice.BarcodePermHelper;
import kd.bd.barcode.mservice.BarcodeRuleHelper;
import kd.bd.barcode.mservice.api.IBarcodeGenerateService;
import kd.bd.barcode.mservice.generator.ISegmentGenerator;
import kd.bd.barcode.mservice.generator.SegmentGeneratorFactory;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.property.ItemClassProp;
import kd.bos.entity.validate.ValidateResult;
import kd.bos.entity.validate.ValidateResultCollection;
import kd.bos.exception.KDBizException;
import kd.bos.id.ID;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.bos.util.StringUtils;

public class BarcodeGenerateServiceImpl
implements IBarcodeGenerateService {
    private static final String PROP_ID = "id";
    private static final String RULE_ENTRY = "entry";
    private static final Log LOGGER = LogFactory.getLog(BarcodeGenerateServiceImpl.class);
    private static final String MODULE = "bd-barcode-mservice";
    private static final int BATCH_CT = 100;
    private static final int MAX_LENGTH = 200;

    protected void checkParams(Long barcodeRuleId, List<BarcodeGenerateOption> options) throws KDBizException {
        BarcodeParamsHelper.checkRule(barcodeRuleId);
        this.checkParams(options, false);
    }

    protected void checkParams(List<BarcodeGenerateOption> options, boolean fOptionRule) throws KDBizException {
        if (options == null || options.isEmpty()) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6761\u7801\u751f\u6210\u65f6\uff0c\u8bf7\u6307\u5b9a\u4e1a\u52a1\u5bf9\u8c61\u6570\u636e\u53ca\u4e00\u7269\u4e00\u7801\u9009\u9879\uff01", (String)"GEN_OPTIONS_NULL", (String)MODULE, (Object[])new Object[0]));
        }
        for (BarcodeGenerateOption option : options) {
            Long ruleId = option.getRuleId();
            if (fOptionRule && ruleId == null) {
                throw new KDBizException(ResManager.loadKDString((String)"\u6761\u7801\u89c4\u5219\u4e0d\u80fd\u4e3a\u7a7a\uff01", (String)"RULE_NULL", (String)MODULE, (Object[])new Object[0]));
            }
            Long pk = option.getBillId();
            if (pk == null) {
                throw new KDBizException(ResManager.loadKDString((String)"\u6761\u7801\u751f\u6210\u65f6\uff0c\u8bf7\u6307\u5b9a\u4e1a\u52a1\u5bf9\u8c61\u6570\u636e\uff01", (String)"GEN_OPTIONS_OBJNULL", (String)MODULE, (Object[])new Object[0]));
            }
            List opEntries = option.getEntryNameIds();
            if (opEntries == null || opEntries.isEmpty()) continue;
            this.checkOptionEntries(opEntries);
        }
    }

    private void checkOptionEntries(List<BarcodeBillEntryData> opEntries) {
        for (BarcodeBillEntryData op : opEntries) {
            if (op.getEntryId() != null && !StringUtils.isEmpty((String)op.getEntryName())) continue;
            throw new KDBizException(ResManager.loadKDString((String)"\u6761\u7801\u751f\u6210\u65f6\uff0c\u6307\u5b9a\u4e1a\u52a1\u5bf9\u8c61\u5206\u5f55\u65f6\u8bf7\u6307\u5b9a\u5206\u5f55\u540d\u79f0\u53ca\u5185\u7801\uff01", (String)"GEN_OPTIONS_ENTRYNULL", (String)MODULE, (Object[])new Object[0]));
        }
    }

    protected String getBillSelectFields(DynamicObject rule, DynamicObjectType objType) {
        DynamicObjectCollection entries = rule.getDynamicObjectCollection(RULE_ENTRY);
        HashSet<String> props = new HashSet<String>();
        String itemClsTypeProp = null;
        int n = entries.size();
        for (int i = 0; i < n; ++i) {
            DynamicObject entry = (DynamicObject)entries.get(i);
            String prop = entry.getString("objprop");
            if (StringUtils.isEmpty((String)prop)) continue;
            String rawProp = BarcodeMetadataHelper.getPropName((String)prop);
            itemClsTypeProp = null;
            DynamicProperty pMeta = BarcodeMetadataHelper.getPropertyMeta((String)rawProp, (DynamicObjectType)objType);
            if (pMeta instanceof ItemClassProp) {
                itemClsTypeProp = BarcodeMetadataHelper.getItemClassTypeProp((DynamicObjectType)objType, (ItemClassProp)((ItemClassProp)pMeta));
            }
            props.add(prop);
            if (itemClsTypeProp == null) continue;
            props.add(itemClsTypeProp);
        }
        if (objType instanceof BillEntityType) {
            String numProp = ((BillEntityType)objType).getBillNo();
            props.add(numProp);
        }
        return String.join((CharSequence)",", props);
    }

    protected DynamicObject getBillInfo(Object pk, String entityKey, Long orgId, String billFields, DynamicObjectType objType) {
        QFilter dataF = BarcodePermHelper.getPermissionFilter(entityKey, orgId);
        QFilter idF = new QFilter(PROP_ID, "=", pk);
        QFilter[] filters = null;
        filters = dataF != null ? new QFilter[]{dataF, idF} : new QFilter[]{idF};
        DynamicObject bill = BusinessDataServiceHelper.loadSingleFromCache((String)entityKey, (String)billFields, (QFilter[])filters);
        if (bill == null) {
            String msg = null;
            msg = dataF != null ? ResManager.loadResFormat((String)"\u5f53\u524d\u7528\u6237\u4e0d\u80fd\u67e5\u770b\u8be5\u6570\u636e", (String)"NO_BILL_PERM", (String)MODULE, (Object[])new Object[0]) : ResManager.loadResFormat((String)"%1\uff08%2\uff09\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u4e1a\u52a1\u5bf9\u8c61\u503c", (String)"BILL_NO_VALUE", (String)MODULE, (Object[])new Object[]{objType.getDisplayName(), entityKey});
            throw new KDBizException(msg);
        }
        return bill;
    }

    protected Map<Object, DynamicObject> getBillsInfo(List<BarcodeGenerateOption> options, int currIndex, String entityKey, Long orgId, String billFields) {
        List<Long> ids = this.getBatchBillIds(options, 100, currIndex);
        QFilter dataF = BarcodePermHelper.getPermissionFilter(entityKey, orgId);
        QFilter idF = new QFilter(PROP_ID, "in", ids);
        QFilter[] filters = null;
        filters = dataF != null ? new QFilter[]{dataF, idF} : new QFilter[]{idF};
        return BusinessDataServiceHelper.loadFromCache((String)entityKey, (String)billFields, (QFilter[])filters);
    }

    protected Barcode generateBarcodeInfo(DynamicObject rule, Long orgId, BarcodeGenerateOption billOption, DynamicObject bill) {
        ArrayList<BarcodeSegment> segs = new ArrayList<BarcodeSegment>();
        String barcode = this.buildBarcodeStringSegs(rule, billOption, bill, segs);
        Long ruleId = rule.getLong(PROP_ID);
        String entityKey = rule.getString("bizobj_id");
        Object srcId = bill.get(PROP_ID);
        String sSrcId = srcId == null ? null : srcId.toString();
        Barcode barcodeInfo = new Barcode();
        barcodeInfo.setBarcodeString(barcode);
        barcodeInfo.setEntityKey(entityKey);
        barcodeInfo.setRuleId(ruleId);
        barcodeInfo.setOrgId(orgId);
        barcodeInfo.setSrcBillId(sSrcId);
        barcodeInfo.setSegments(segs);
        String barcodeType = rule.getString("barcodetype");
        if ("P".equals(barcodeType)) {
            barcodeInfo.setPackageBarcode(true);
        }
        this.setBarcodeSrcNumber(bill, barcodeInfo);
        return barcodeInfo;
    }

    private String buildBarcodeStringSegs(DynamicObject rule, BarcodeGenerateOption billOption, DynamicObject bill, List<BarcodeSegment> segs) {
        boolean fPerItem = rule.getBoolean("isperitem");
        String qtyProp = null;
        DynamicObjectCollection entries = rule.getDynamicObjectCollection(RULE_ENTRY);
        for (Object ruleEntry : entries) {
            if (!ruleEntry.getBoolean("isqtyprop")) continue;
            qtyProp = ruleEntry.getString("objprop");
            break;
        }
        if (fPerItem && LOGGER.isInfoEnabled()) {
            LOGGER.info(String.format("barcode per item, quantityProp: %s", qtyProp));
        }
        StringBuilder segBuilder = new StringBuilder();
        for (DynamicObject ruleEntry : entries) {
            boolean fIsCode = ruleEntry.getBoolean("iscode");
            String segment = null;
            ISegmentGenerator iSegGen = SegmentGeneratorFactory.getInstance(ruleEntry);
            BarcodeSegment segInfo = iSegGen.toSegmentInfo(ruleEntry, bill, billOption, fPerItem, qtyProp);
            segs.add(segInfo);
            segment = segInfo.getSegment();
            if (!fIsCode) continue;
            segBuilder.append(segment);
        }
        String barcode = segBuilder.toString();
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info(String.format("barcode : %s", barcode));
        }
        if (barcode.length() > 200) {
            String msg = ResManager.loadResFormat((String)"\u751f\u6210\u7684\u6761\u7801\u957f\u5ea6\uff08%1\uff09\u8d85\u8fc7\u5141\u8bb8\u7684\u6700\u5927\u957f\u5ea6\uff08%2\uff09", (String)"BARCODE_GT_LENGTH", (String)MODULE, (Object[])new Object[]{barcode.length(), 200});
            throw new KDBizException(msg);
        }
        return barcode;
    }

    private void setBarcodeSrcNumber(DynamicObject bill, Barcode barcodeInfo) {
        String srcBillNum;
        DynamicProperty billNoProp;
        String numProp = null;
        DynamicObjectType objType = bill.getDynamicObjectType();
        if (objType instanceof BillEntityType) {
            numProp = ((BillEntityType)objType).getBillNo();
        } else if (objType instanceof MainEntityType) {
            numProp = "number";
        }
        if (StringUtils.isNotEmpty((String)numProp) && (billNoProp = BarcodeMetadataHelper.getPropertyMeta((String)numProp, (DynamicObjectType)objType)) != null && StringUtils.isNotEmpty((String)(srcBillNum = bill.getString(numProp)))) {
            barcodeInfo.setSrcBillNum(srcBillNum);
        }
    }

    public BarcodeGenerated generateBarcode(BarcodeGenerateOption option) throws KDBizException {
        if (BarcodeParamsHelper.isISV()) {
            return (BarcodeGenerated)DispatchServiceHelper.invokeBizService((String)"bd", (String)"word_barcode", (String)"BarcodeGenerateService", (String)"generateBarcode", (Object[])new Object[]{option});
        }
        throw new KDBizException(ResManager.loadKDString((String)"\u672a\u8d2d\u4e70\u6761\u7801\u670d\u52a1\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"BarcodeMservice_1", (String)MODULE, (Object[])new Object[0]));
    }

    public List<BarcodeGenerated> generateBarcodes(List<BarcodeGenerateOption> options) throws KDBizException {
        if (BarcodeParamsHelper.isISV()) {
            return (List)DispatchServiceHelper.invokeBizService((String)"bd", (String)"word_barcode", (String)"BarcodeGenerateService", (String)"generateBarcodes", (Object[])new Object[]{options});
        }
        throw new KDBizException(ResManager.loadKDString((String)"\u672a\u8d2d\u4e70\u6761\u7801\u670d\u52a1\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"BarcodeMservice_1", (String)MODULE, (Object[])new Object[0]));
    }

    private void generateBarcodesWithRulesMap(List<BarcodeGenerated> barcodes, List<BarcodeGenerateOption> options, Map<Long, DynamicObject> rules, Map<Long, String> fieldsMap, Map<Long, String> entityKeyMap) {
        boolean fAllInvalid;
        boolean bl = fAllInvalid = options.size() == barcodes.size();
        if (fAllInvalid) {
            return;
        }
        int currIndex = 0;
        DynamicObject bill = null;
        Map<Object, DynamicObject> bills = null;
        for (BarcodeGenerateOption option : options) {
            Long ruleId = option.getRuleId();
            Long orgId = option.getOrgId();
            DynamicObject rule = rules.get(ruleId);
            if (rule != null) {
                String entityKey = entityKeyMap.get(ruleId);
                String billFields = fieldsMap.get(ruleId);
                if (currIndex == 0 || currIndex % 100 == 0) {
                    bills = this.getBillsInfo(options, currIndex, entityKey, orgId, billFields);
                }
                if (bills != null && !bills.isEmpty()) {
                    bill = bills.get(option.getBillId());
                }
                try {
                    List<BarcodeGenerated> barcodeGen = this.generateBarcodeGeneratedVO(orgId, rule, bill, option);
                    if (barcodeGen != null && !barcodeGen.isEmpty()) {
                        barcodes.addAll(barcodeGen);
                    }
                }
                catch (Exception e) {
                    this.appendErrInfo(barcodes, option, orgId, e.getMessage());
                    LOGGER.error("failed to generate barcodes", (Throwable)e);
                }
            }
            ++currIndex;
        }
    }

    private void appendErrInfo(List<BarcodeGenerated> barcodes, BarcodeGenerateOption option, Long orgId, String msg) {
        Long pk = option.getBillId();
        BarcodeGenerated err = new BarcodeGenerated();
        err.setBillId(pk);
        if (orgId != null) {
            err.setOrgId(orgId);
        } else {
            err.setOrgId(option.getOrgId());
        }
        err.setEntryNameIds(option.getEntryNameIds());
        err.setExceptionMsg(msg);
        barcodes.add(err);
    }

    private List<Long> getBatchBillIds(List<BarcodeGenerateOption> options, int batchCt, int currIndex) {
        ArrayList<Long> ids = new ArrayList<Long>();
        int index = 0;
        int ct = 0;
        for (BarcodeGenerateOption option : options) {
            if (index >= currIndex && ct < batchCt) {
                ids.add(option.getBillId());
                ++ct;
            }
            ++index;
        }
        return ids;
    }

    private void checkOptionEntryNames(DynamicObjectType objType, BarcodeGenerateOption option) {
        List entryNameIds = option.getEntryNameIds();
        if (entryNameIds != null && !entryNameIds.isEmpty()) {
            for (BarcodeBillEntryData entryData : entryNameIds) {
                String entryName = entryData.getEntryName();
                BarcodeMetadataHelper.checkPropValid((DynamicObjectType)objType, (String)entryName);
            }
        }
    }

    private List<BarcodeGenerated> generateBarcodeGeneratedVO(Long orgId, DynamicObject rule, DynamicObject bill, BarcodeGenerateOption option) {
        Long pk = option.getBillId();
        ArrayList<BarcodeGenerated> barcodeGenerateds = null;
        if (bill == null) {
            barcodeGenerateds = new ArrayList<BarcodeGenerated>(1);
            String msg = ResManager.loadResFormat((String)"\u5f53\u524d\u7528\u6237\u4e0d\u80fd\u67e5\u770b\u8be5\u6570\u636e\uff0c\u6216\u6ca1\u6709\u5bf9\u5e94\u6570\u636e\u3002", (String)"NO_BILL_PERM", (String)MODULE, (Object[])new Object[0]);
            this.appendErrInfo(barcodeGenerateds, option, orgId, msg);
        } else {
            int iQty = this.getQuantity(rule, option);
            barcodeGenerateds = new ArrayList(iQty);
            for (int i = 0; i < iQty; ++i) {
                BarcodeGenerated barcodeGen = new BarcodeGenerated();
                barcodeGen.setBillId(pk);
                if (orgId != null) {
                    barcodeGen.setOrgId(orgId);
                } else {
                    barcodeGen.setOrgId(option.getOrgId());
                }
                barcodeGen.setEntryNameIds(option.getEntryNameIds());
                try {
                    Barcode barocdeInfo = this.generateBarcodeInfo(rule, orgId, option, bill);
                    barcodeGen.setBarcode(barocdeInfo);
                }
                catch (KDBizException e) {
                    barcodeGen.setExceptionMsg(e.getMessage());
                }
                barcodeGenerateds.add(barcodeGen);
            }
        }
        return barcodeGenerateds;
    }

    private int getQuantity(DynamicObject rule, BarcodeGenerateOption option) {
        int iQty = 1;
        if (rule.getBoolean("isperitem")) {
            if (!BarcodeRuleHelper.isApplyBarcodePerItem(rule)) {
                String msg = ResManager.loadKDString((String)"\u6761\u7801\u89c4\u5219\u4e2d\u6ca1\u6709\u6d41\u6c34\u53f7\u548c\u6570\u91cf\u5206\u6bb5\uff0c\u4e0d\u80fd\u9002\u7528\u4e8e\u4e00\u7269\u4e00\u7801\uff01", (String)"RULE_NO_SEQ_QTY", (String)MODULE, (Object[])new Object[0]);
                throw new KDBizException(msg);
            }
            iQty = option.getCount();
            iQty = iQty > 0 ? iQty : 1;
        }
        return iQty;
    }

    public List<BarcodeGenerated> generateBarcodes(Long ruleId, Long orgId, List<BarcodeGenerateOption> options) throws KDBizException {
        if (BarcodeParamsHelper.isISV()) {
            return (List)DispatchServiceHelper.invokeBizService((String)"bd", (String)"word_barcode", (String)"BarcodeGenerateService", (String)"generateBarcodes", (Object[])new Object[]{ruleId, orgId, options});
        }
        throw new KDBizException(ResManager.loadKDString((String)"\u672a\u8d2d\u4e70\u6761\u7801\u670d\u52a1\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"BarcodeMservice_1", (String)MODULE, (Object[])new Object[0]));
    }

    protected void checkBarcodes(List<Barcode> barcodes) {
        if (barcodes == null || barcodes.isEmpty()) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u6307\u5b9a\u6761\u7801\u6570\u636e\uff01", (String)"BARCODES_NULL", (String)MODULE, (Object[])new Object[0]));
        }
        ListIterator<Barcode> it = barcodes.listIterator();
        while (it.hasNext()) {
            Barcode b = it.next();
            if (Collections.frequency(barcodes, b) <= 1) continue;
            it.remove();
        }
    }

    public List<BarcodeGenerated> generateSaveBarcodes(List<BarcodeGenerateOption> options) throws KDBizException {
        if (BarcodeParamsHelper.isISV()) {
            return (List)DispatchServiceHelper.invokeBizService((String)"bd", (String)"word_barcode", (String)"BarcodeGenerateService", (String)"generateSaveBarcodes", (Object[])new Object[]{options});
        }
        throw new KDBizException(ResManager.loadKDString((String)"\u672a\u8d2d\u4e70\u6761\u7801\u670d\u52a1\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"BarcodeMservice_1", (String)MODULE, (Object[])new Object[0]));
    }

    public List<BarcodeGenerated> generateSaveBarcodes(Long ruleId, Long orgId, List<BarcodeGenerateOption> options) throws KDBizException {
        if (BarcodeParamsHelper.isISV()) {
            return (List)DispatchServiceHelper.invokeBizService((String)"bd", (String)"word_barcode", (String)"BarcodeGenerateService", (String)"generateSaveBarcodes", (Object[])new Object[]{ruleId, orgId, options});
        }
        throw new KDBizException(ResManager.loadKDString((String)"\u672a\u8d2d\u4e70\u6761\u7801\u670d\u52a1\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"BarcodeMservice_1", (String)MODULE, (Object[])new Object[0]));
    }

    public List<BarcodeGenerated> generateSaveBarcodes(Long ruleId, Long orgId, String options) throws KDBizException {
        if (BarcodeParamsHelper.isISV()) {
            return (List)DispatchServiceHelper.invokeBizService((String)"bd", (String)"word_barcode", (String)"BarcodeGenerateService", (String)"generateSaveBarcodes", (Object[])new Object[]{ruleId, orgId, options});
        }
        throw new KDBizException(ResManager.loadKDString((String)"\u672a\u8d2d\u4e70\u6761\u7801\u670d\u52a1\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"BarcodeMservice_1", (String)MODULE, (Object[])new Object[0]));
    }

    private OperationResult saveGenerated(Long orgId, List<BarcodeGenerated> barcodeGens) {
        String validateErr;
        ArrayList<Barcode> barcodes = new ArrayList<Barcode>();
        for (BarcodeGenerated bGenerated : barcodeGens) {
            if (!StringUtils.isEmpty((String)bGenerated.getExceptionMsg())) continue;
            barcodes.add(bGenerated.getBarcode());
        }
        OperationResult opResult = null;
        if (barcodes.isEmpty()) {
            String msg = ResManager.loadKDString((String)"\u6761\u7801\u751f\u6210\u5931\u8d25\uff0c\u672a\u6210\u529f\u751f\u6210\u4efb\u4f55\u6761\u7801\u3002", (String)"GEN_FAIL_NO_DATA", (String)MODULE, (Object[])new Object[0]);
            throw new KDBizException(msg);
        }
        opResult = this.saveBarcodes(orgId, barcodes);
        if (opResult != null && opResult.getValidateResult() != null && StringUtils.isNotEmpty((String)(validateErr = this.getValidateError(opResult, barcodeGens, barcodes)))) {
            LOGGER.error("generateSaveBarcodes, " + validateErr);
        }
        return opResult;
    }

    private String getValidateError(OperationResult opResult, List<BarcodeGenerated> barcodeGens, List<Barcode> barcodes) {
        String msg = null;
        StringBuilder validateErr = new StringBuilder();
        ValidateResultCollection validateResults = opResult.getValidateResult();
        List lstValidateResult = validateResults.getValidateErrors();
        if (lstValidateResult == null || lstValidateResult.isEmpty()) {
            return msg;
        }
        HashSet errorDataIndexs = validateResults.getErrorDataIndexs();
        for (ValidateResult result : lstValidateResult) {
            List errorInfos = result.getAllErrorInfo();
            if (errorInfos == null || errorInfos.isEmpty()) continue;
            for (Integer oIndex : errorDataIndexs) {
                int index = oIndex;
                OperateErrorInfo errorInfo = (OperateErrorInfo)errorInfos.get(index);
                String errMsg = errorInfo.getMessage();
                validateErr.append(errMsg);
                Barcode barcode = barcodes.get(index);
                int bgIndex = this.locateBarcodeIndex(barcodeGens, barcode);
                if (bgIndex < 0) continue;
                BarcodeGenerated failBc = barcodeGens.get(bgIndex);
                failBc.setExceptionMsg(errMsg);
            }
        }
        msg = validateErr.toString();
        return msg;
    }

    private int locateBarcodeIndex(List<BarcodeGenerated> barcodeGens, Barcode barcode) {
        int i = -1;
        int c = 0;
        String chkBcStr = barcode.getBarcodeString();
        for (BarcodeGenerated bg : barcodeGens) {
            String barcodeString = bg.getBarcode().getBarcodeString();
            if (StringUtils.isNotEmpty((String)chkBcStr) && StringUtils.isNotEmpty((String)barcodeString) && chkBcStr.equals(barcodeString)) {
                i = c;
                break;
            }
            ++c;
        }
        return i;
    }

    public OperationResult saveBarcodes(Long orgId, List<Barcode> barcodes) throws KDBizException {
        if (BarcodeParamsHelper.isISV()) {
            return (OperationResult)DispatchServiceHelper.invokeBizService((String)"bd", (String)"word_barcode", (String)"BarcodeGenerateService", (String)"saveBarcodes", (Object[])new Object[]{orgId, barcodes});
        }
        throw new KDBizException(ResManager.loadKDString((String)"\u672a\u8d2d\u4e70\u6761\u7801\u670d\u52a1\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"BarcodeMservice_1", (String)MODULE, (Object[])new Object[0]));
    }

    protected DynamicObject createBarcode(Long orgId, Barcode barcode) {
        DynamicObject barcodeDyn = BusinessDataServiceHelper.newDynamicObject((String)"barcode_info");
        long barcodeId = ID.genLongId();
        Date createTime = ID.getCreateTime((long)barcodeId);
        Long ruleId = barcode.getRuleId();
        DynamicObject rule = BusinessDataServiceHelper.loadSingleFromCache((Object)ruleId, (String)"barcode_rule");
        DynamicObject bizObj = (DynamicObject)rule.get("bizobj");
        DynamicObject user = UserServiceHelper.getCurrentUser((String)"number");
        barcodeDyn.set(PROP_ID, (Object)barcodeId);
        barcodeDyn.set("barcode", (Object)barcode.getBarcodeString());
        barcodeDyn.set("barcoderule", (Object)rule);
        barcodeDyn.set("bizobj", (Object)bizObj);
        barcodeDyn.set("barcodetype", (Object)(barcode.isPackageBarcode() ? "P" : "N"));
        barcodeDyn.set("sourcetype", (Object)"I");
        barcodeDyn.set("barcodestatus", (Object)"E");
        barcodeDyn.set("srcbillid", (Object)barcode.getSrcBillId());
        barcodeDyn.set("srcbillnumber", (Object)barcode.getSrcBillNum());
        barcodeDyn.set("billstatus", (Object)"C");
        barcodeDyn.set("createtime", (Object)createTime);
        barcodeDyn.set("creator", (Object)user);
        Long bcOrgId = barcode.getOrgId();
        if (orgId != null) {
            bcOrgId = orgId;
        }
        if (bcOrgId != null) {
            DynamicObject org = BusinessDataServiceHelper.loadSingleFromCache((Object)bcOrgId, (String)"bos_org");
            barcodeDyn.set("org", (Object)org);
        }
        DynamicObjectCollection entries = barcodeDyn.getDynamicObjectCollection(RULE_ENTRY);
        this.createBarcodeEntries(barcode, entries);
        return barcodeDyn;
    }

    protected void createBarcodeEntries(Barcode barcode, DynamicObjectCollection entries) {
        List segments = barcode.getSegments();
        int i = 0;
        for (BarcodeSegment seg : segments) {
            DynamicObject entry = entries.addNew();
            long entryId = ID.genLongId();
            entry.set("seq", (Object)i++);
            entry.set(PROP_ID, (Object)entryId);
            entry.set("objprop", (Object)seg.getProp());
            entry.set("valuetype", (Object)seg.getValueType());
            entry.set("segmentval", (Object)seg.getSegment());
            entry.set("dataid", seg.getInfoId());
            entry.set("numval", (Object)seg.getNumVal());
            entry.set("textval", (Object)seg.getTextVal());
            entry.set("timeval", (Object)seg.getTimeVal());
            entry.set("dateval", (Object)seg.getDateVal());
        }
    }
}

