/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.barcode.mservice;

import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public class BarcodeParamsHelper {
    private static final String MODULE = "bd-barcode-mservice";
    private static final Log LOGGER = LogFactory.getLog(BarcodeParamsHelper.class);

    public static void checkOrg(Long orgID) {
        if (orgID == null) {
            if (LOGGER.isErrorEnabled()) {
                LOGGER.error("BarcodeServiceHelper, no main org");
            }
            throw new KDBizException(ResManager.loadKDString((String)"\u4e1a\u52a1\u7ec4\u7ec7\u4e0d\u80fd\u4e3a\u7a7a\uff01", (String)"ORG_NULL", (String)MODULE, (Object[])new Object[0]));
        }
    }

    public static void checkRule(Long ruleID) {
        if (ruleID == null) {
            LOGGER.error("BarcodeParamsHelper.checkRule, no ruleID");
            throw new KDBizException(ResManager.loadKDString((String)"\u6761\u7801\u89c4\u5219\u4e0d\u80fd\u4e3a\u7a7a\uff01", (String)"RULE_NULL", (String)MODULE, (Object[])new Object[0]));
        }
    }

    public static void checkEntityType(DynamicObjectType objType, String entityKey) {
        if (objType == null) {
            if (LOGGER.isErrorEnabled()) {
                LOGGER.error("barcode, cannot find metadata with id: " + entityKey);
            }
            String msg = ResManager.loadResFormat((String)"\u627e\u4e0d\u5230\u5185\u90e8\u540d\u79f0\u662f%1\u7684\u5143\u6570\u636e", (String)"NO_ENTITYKEY", (String)MODULE, (Object[])new Object[]{entityKey});
            throw new KDBizException(msg);
        }
    }

    public static boolean isISV() {
        boolean result = false;
        String sql = "SELECT fvalue FROM T_IM_INVDBPARAM WHERE FKEY = 'isbarcode'";
        try (DataSet data = DB.queryDataSet((String)BarcodeParamsHelper.class.getName(), (DBRoute)DBRoute.of((String)"im"), (String)sql);){
            if (data.hasNext()) {
                Row row = data.next();
                result = "1".equals(row.getString("fvalue"));
            }
        }
        LOGGER.info("isISV=" + result);
        return result;
    }
}

