/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.barcode.mservice;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bd.barcode.common.BarcodeMetadataHelper;
import kd.bd.barcode.mservice.BarcodeParamsHelper;
import kd.bd.barcode.mservice.BarcodePermHelper;
import kd.bd.barcode.mservice.BarcodeRuleHelper;
import kd.bd.barcode.mservice.api.IBarcodeParseService;
import kd.bd.barcode.mservice.cache.BarcodeCache;
import kd.bd.barcode.mservice.parser.ISegmentParser;
import kd.bd.barcode.mservice.parser.SegmentParserFactory;
import kd.bd.barcode.mservice.splitter.BarcodeSplitterFactory;
import kd.bd.barcode.mservice.splitter.IBarcodeSplitter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.ItemClassProp;
import kd.bos.entity.property.ItemClassTypeProp;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;

public class BarcodeParseServiceImpl
implements IBarcodeParseService {
    private static final String MODULE = "bd-barcode-mservice";
    private static final Log LOGGER = LogFactory.getLog(BarcodeParseServiceImpl.class);
    private static final String[] BARCODE_PROPS = new String[]{"barcode", "srcbillid", "objvalues", "exception"};
    private static final String[] SEG_PROPS = new String[]{"segment", "prop", "propvalue", "exception", "valuetype", "parsecls"};

    private DynamicObjectType getEntityType(String entityKey) {
        MainEntityType objType = null;
        try {
            objType = EntityMetadataCache.getDataEntityType((String)entityKey);
        }
        catch (Exception e) {
            LOGGER.error("invalid entityKey, " + entityKey, (Throwable)e);
            throw new KDBizException(e.getMessage());
        }
        return objType;
    }

    public boolean hasBarcodeRule(String entityKey, Long orgID) {
        if (BarcodeParamsHelper.isISV()) {
            return (Boolean)DispatchServiceHelper.invokeBizService((String)"bd", (String)"word_barcode", (String)"BarcodeParseService", (String)"hasBarcodeRule", (Object[])new Object[]{entityKey, orgID});
        }
        throw new KDBizException(ResManager.loadKDString((String)"\u672a\u8d2d\u4e70\u6761\u7801\u670d\u52a1\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"BarcodeMservice_1", (String)MODULE, (Object[])new Object[0]));
    }

    private Set<String> getMappingEntities(String entityKey) {
        Set<String> keys = null;
        String fName = "bizobj.fbasedataid";
        QFilter mFilter = new QFilter(fName, "=", (Object)entityKey);
        QFilter[] filters = mFilter.toArray();
        DynamicObject[] mappings = BusinessDataServiceHelper.load((String)"barcode_prop_mapping", (String)("id, " + fName), (QFilter[])filters);
        if (mappings == null || mappings.length == 0) {
            LOGGER.info("getMappingEntities\uff1a mappings not found.entityKey=" + entityKey);
            return keys;
        }
        keys = this.buildMappingKeys(entityKey, mappings);
        if (keys.isEmpty()) {
            LOGGER.info("getMappingEntities.buildMappingKeys:result is empty");
        }
        return keys;
    }

    private Set<String> buildMappingKeys(String entityKey, DynamicObject[] mappings) {
        HashSet<String> keys = new HashSet<String>(16);
        for (DynamicObject mapping : mappings) {
            DynamicObjectCollection mappingObjs = mapping.getDynamicObjectCollection("bizobj");
            if (mappingObjs == null || mappingObjs.isEmpty()) continue;
            for (DynamicObject rowObj : mappingObjs) {
                DynamicObject obj = rowObj.getDynamicObject("fbasedataid");
                String otherEntity = obj.getString("id");
                keys.add(otherEntity);
            }
        }
        keys.remove(entityKey);
        return keys;
    }

    private String getParseError(DynamicObjectCollection bizObjs) {
        StringBuilder expMsg = new StringBuilder();
        for (DynamicObject rtnObj : bizObjs) {
            String errMsg = rtnObj.getString("exception");
            if (!StringUtils.isNotEmpty((String)errMsg)) continue;
            expMsg.append(errMsg);
            expMsg.append(System.lineSeparator());
        }
        return expMsg.toString();
    }

    private void logExceptions(DynamicObjectCollection parseResultCollection) {
        String errMsg = this.getParseError(parseResultCollection);
        LOGGER.error("failed to parse barcodes, msg:" + errMsg);
    }

    public DynamicObjectCollection parseBarcodes(List<String> barcodes, String entityKey, Long orgID) throws KDBizException {
        if (BarcodeParamsHelper.isISV()) {
            return (DynamicObjectCollection)DispatchServiceHelper.invokeBizService((String)"bd", (String)"word_barcode", (String)"BarcodeParseService", (String)"parseBarcodes", (Object[])new Object[]{barcodes, entityKey, orgID});
        }
        throw new KDBizException(ResManager.loadKDString((String)"\u672a\u8d2d\u4e70\u6761\u7801\u670d\u52a1\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"BarcodeMservice_1", (String)MODULE, (Object[])new Object[0]));
    }

    protected DynamicObjectCollection parseBarcodeByRules(String barcode, DynamicObjectCollection rules, DynamicObjectType objType, Long orgID) throws KDBizException {
        String entityKey = objType.getName();
        boolean fSuccess = false;
        DynamicObjectCollection bizObjs = null;
        boolean fHasInfoRule = this.hasInfoRule(rules);
        DynamicObject barcodeInfo = null;
        if (fHasInfoRule) {
            barcodeInfo = this.getBarcodeInfoByEntity(barcode, entityKey, orgID, false);
        }
        ArrayList<DynamicObjectCollection> failObjs = new ArrayList<DynamicObjectCollection>(10);
        String errMsg = null;
        for (DynamicObject rule : rules) {
            bizObjs = this.parseBarcodeByRule(barcode, rule, objType, orgID, barcodeInfo);
            if (bizObjs == null || bizObjs.isEmpty()) continue;
            errMsg = this.getParseError(bizObjs);
            if (StringUtils.isEmpty((String)errMsg)) {
                LOGGER.info("parseBarcodeByRules:match ruleId=" + rule.getPkValue());
                fSuccess = true;
                break;
            }
            failObjs.add(bizObjs);
        }
        if (!fSuccess && failObjs.isEmpty()) {
            LOGGER.error("No applicable barcode rule for metadata: " + objType.getDisplayName() + ", key:" + entityKey + ", barcode: " + barcode);
            errMsg = ResManager.loadResFormat((String)"%1\uff08%2\uff09\u6ca1\u6709\u9002\u7528\u4e8e%3\u7684\u6761\u7801\u89c4\u5219", (String)"ENTITY_NO_APPLICABLE_RULE", (String)MODULE, (Object[])new Object[]{objType.getDisplayName(), entityKey, barcode});
            bizObjs = this.createBusiInfoWithErr(barcode, errMsg);
            BarcodeCache.addBarcodeErrRule(entityKey, barcode, null);
        } else if (!(fSuccess || failObjs.isEmpty() || bizObjs != null && !bizObjs.isEmpty())) {
            bizObjs = (DynamicObjectCollection)failObjs.get(0);
        }
        return bizObjs;
    }

    private boolean hasInfoRule(DynamicObjectCollection rules) {
        boolean fInfo = false;
        for (DynamicObject rule : rules) {
            if (!BarcodeRuleHelper.isInfoRule(rule)) continue;
            fInfo = true;
            break;
        }
        return fInfo;
    }

    private DynamicObject getBarcodeInfoByEntity(String barcode, String entityKey, Long orgID, boolean fPkg) {
        Set<String> mappingEntities;
        QFilter[] filters = this.getEntityBarcodeInfoFilter(barcode, entityKey, orgID, fPkg);
        DynamicObject barcodeInfo = BusinessDataServiceHelper.loadSingleFromCache((String)"barcode_info", (QFilter[])filters);
        if (barcodeInfo == null && (mappingEntities = this.getMappingEntities(entityKey)) != null && !mappingEntities.isEmpty()) {
            filters = this.getMappingBarcodeInfoFilter(barcode, mappingEntities, orgID, fPkg);
            barcodeInfo = BusinessDataServiceHelper.loadSingleFromCache((String)"barcode_info", (QFilter[])filters);
        }
        return barcodeInfo;
    }

    public DynamicObjectCollection parseBarcode(String barcode, String entityKey, Long orgID) throws KDBizException {
        if (BarcodeParamsHelper.isISV()) {
            return (DynamicObjectCollection)DispatchServiceHelper.invokeBizService((String)"bd", (String)"word_barcode", (String)"BarcodeParseService", (String)"parseBarcode", (Object[])new Object[]{barcode, entityKey, orgID});
        }
        throw new KDBizException(ResManager.loadKDString((String)"\u672a\u8d2d\u4e70\u6761\u7801\u670d\u52a1\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"BarcodeMservice_1", (String)MODULE, (Object[])new Object[0]));
    }

    protected void checkBarcode(String barcode) {
        if (StringUtils.isEmpty((String)barcode)) {
            LOGGER.error("BarcodeParseService, barcode is null");
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u6307\u5b9a\u6761\u7801\uff01", (String)"BARCODE_NULL", (String)MODULE, (Object[])new Object[0]));
        }
    }

    protected void checkBarcodes(List<String> barcodes) {
        if (barcodes == null || barcodes.size() == 0) {
            LOGGER.error("checkBarcodes\uff1a barcodes are null");
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u6307\u5b9a\u6761\u7801\uff01", (String)"BARCODE_NULL", (String)MODULE, (Object[])new Object[0]));
        }
        boolean allBarcodeIsEmpty = barcodes.stream().allMatch(StringUtils::isEmpty);
        if (allBarcodeIsEmpty) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u6307\u5b9a\u6761\u7801\uff01", (String)"BARCODE_NULL", (String)MODULE, (Object[])new Object[0]));
        }
    }

    protected void checkEntity(String entityKey) {
        if (StringUtils.isEmpty((String)entityKey)) {
            LOGGER.error("checkEntity\uff1a no entityKey");
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u6307\u5b9a\u5143\u6570\u636e\u540d\u79f0\u3002", (String)"ENTITYKEY_NULL", (String)MODULE, (Object[])new Object[0]));
        }
    }

    protected DynamicObjectCollection parseBarcodeByRule(String barcode, DynamicObject rule, DynamicObjectType objType, Long orgID, DynamicObject barcodeInfo) throws KDBizException {
        DynamicObjectCollection bizObjs = null;
        String ruleType = rule.getString("ruletype");
        if (barcodeInfo != null && "M".equals(ruleType)) {
            Object barcodeRuleId = barcodeInfo.getDynamicObject("barcoderule").get("id");
            if (barcodeRuleId.equals(rule.get("id"))) {
                String barcodeType = rule.getString("barcodetype");
                bizObjs = this.getParseResultByBarcodeInfo(objType, orgID, barcodeInfo, barcodeType);
            }
        } else if ("D".equals(ruleType) && BarcodeRuleHelper.isApplicable(barcode, rule)) {
            bizObjs = this.parseBarcode(barcode, rule, objType, orgID);
        }
        if (bizObjs != null && !bizObjs.isEmpty()) {
            Long ruleID = rule.getLong("id");
            String entityKey = objType.getName();
            BarcodeCache.addBarcodeParsedRule(entityKey, barcode, ruleID);
        }
        return bizObjs;
    }

    protected DynamicObjectCollection getParseResultByBarcodeInfo(DynamicObjectType objType, Long orgID, DynamicObject barcodeInfo, String barcodeType) {
        Map<Object, Object> barcodeInfos = null;
        DynamicObject bizObjEntity = barcodeInfo.getDynamicObject("bizobj");
        String bizObjEntityKey = bizObjEntity.getString("id");
        if ("P".equals(barcodeType)) {
            List<Long> barcodeInfoIds;
            short sLevel;
            Long pkgBarcodeId = barcodeInfo.getLong("id");
            Map<String, List<Long>> ids = this.getSubPackageIds(pkgBarcodeId, sLevel = 1);
            List<Long> list = barcodeInfoIds = ids != null ? ids.get("leaf") : null;
            if (barcodeInfoIds == null || barcodeInfoIds.isEmpty()) {
                LOGGER.error("the package barcode does NOT has leaf barcodes!");
            } else {
                LOGGER.info("getParseResultByBarcodeInfo:barcodeInfoIds=" + barcodeInfoIds);
                Object[] pkArray = barcodeInfoIds.toArray();
                barcodeInfos = BusinessDataServiceHelper.loadFromCache((Object[])pkArray, (String)"barcode_info");
            }
        }
        if (barcodeInfos == null) {
            barcodeInfos = new HashMap<Object, DynamicObject>(16);
            Long id = barcodeInfo.getLong("id");
            barcodeInfos.put(id, barcodeInfo);
        }
        return this.convertCollection(bizObjEntityKey, barcodeInfos, objType, orgID);
    }

    private void checkDataAccess(DynamicObject barcodeInfo, Long orgID) {
        String srcBillId = barcodeInfo.getString("srcbillid");
        if (StringUtils.isEmpty((String)srcBillId)) {
            return;
        }
        String propEntityKey = barcodeInfo.getString("bizobj_id");
        boolean fExist = QueryServiceHelper.exists((String)propEntityKey, (Object)srcBillId);
        if (!fExist) {
            String barcode = barcodeInfo.getString("barcode");
            String msg = ResManager.loadResFormat((String)"\u8be5\u6761\u7801\uff08%1\uff09\u7684\u6765\u6e90\u4e1a\u52a1\u5bf9\u8c61id\u4e0d\u5b58\u5728\u5bf9\u5e94\u6570\u636e", (String)"INVL_SRCBILL", (String)MODULE, (Object[])new Object[]{barcode});
            throw new KDBizException(msg);
        }
        String barcode = barcodeInfo.getString("barcode");
        this.checkSrcBillAccess(propEntityKey, orgID, barcode, srcBillId);
    }

    protected void checkPackageLevel(short sLevel) {
        if (sLevel > 5) {
            String msg = ResManager.loadResFormat((String)"\u8d85\u8fc7\u6700\u5927\u5305\u88c5\u5c42\u6570%1", (String)"GT_MAX_PKG_LEVEL", (String)MODULE, (Object[])new Object[]{(short)5});
            LOGGER.error("MAX_PKG_LEVEL: 5, sLevel : " + sLevel);
            throw new KDBizException(msg);
        }
    }

    protected Map<String, List<Long>> getSubPackageIds(Long pkgBarcodeId, short sLevel) {
        this.checkPackageLevel(sLevel);
        String bc = "barcode";
        QFilter bIdFilter = new QFilter(bc, "=", (Object)pkgBarcodeId);
        QFilter[] pFilters = new QFilter[]{bIdFilter};
        DynamicObject pkgInfo = BusinessDataServiceHelper.loadSingleFromCache((String)"package_barcode", (QFilter[])pFilters);
        if (pkgInfo == null) {
            return null;
        }
        ArrayList<Long> barcodeIds = new ArrayList<Long>();
        ArrayList<Long> subPkgIds = new ArrayList<Long>();
        boolean fHasSubPkg = false;
        DynamicObjectCollection pEntries = pkgInfo.getDynamicObjectCollection("entry");
        for (DynamicObject pEntry : pEntries) {
            if (pEntry.getBoolean("isleaf")) {
                barcodeIds.add(pEntry.getLong("ebarcode_id"));
                continue;
            }
            subPkgIds.add(pEntry.getLong("ebarcode_id"));
        }
        boolean bl = fHasSubPkg = !subPkgIds.isEmpty();
        if (fHasSubPkg) {
            ArrayList subSubPIds = new ArrayList();
            for (Long subpId : subPkgIds) {
                Map<String, List<Long>> subIds = this.getSubPackageIds(subpId, (short)(sLevel + 1));
                subSubPIds.addAll(subIds.get("pkg"));
                barcodeIds.addAll((Collection)subIds.get("leaf"));
            }
            subPkgIds.addAll(subSubPIds);
        }
        HashMap<String, List<Long>> rtnMap = new HashMap<String, List<Long>>(16);
        rtnMap.put("leaf", barcodeIds);
        rtnMap.put("pkg", subPkgIds);
        return rtnMap;
    }

    protected DynamicObjectCollection parseBarcode(String barcode, DynamicObject rule, DynamicObjectType objType, Long orgID) {
        LOGGER.info("parseBarcode:barcode=" + barcode);
        if (!BarcodeRuleHelper.isItemClassTypeMatch(rule, objType)) {
            String msg = ResManager.loadKDString((String)"\u6761\u7801\u89c4\u5219\u4e2d\u9700\u540c\u65f6\u6307\u5b9a\u591a\u7c7b\u522b\u57fa\u7840\u8d44\u6599\u5c5e\u6027\u53ca\u5bf9\u5e94\u7684\u591a\u7c7b\u522b\u57fa\u7840\u8d44\u6599\u7c7b\u578b\u5c5e\u6027\u3002", (String)"ITEM_ClS_TYPE_MATCH", (String)MODULE, (Object[])new Object[0]);
            LOGGER.error("parseBarcode\uff1aitem rule must have itemClassProp and corresponding itemClassTypeProp!");
            throw new KDBizException(msg);
        }
        DynamicObject parseObj = BarcodeMetadataHelper.createDynamicObject((String)"bcprs_vals", (String[])BARCODE_PROPS);
        parseObj.set("barcode", (Object)barcode);
        String parseMethod = rule.getString("parsemethod");
        IBarcodeSplitter spliter = BarcodeSplitterFactory.getInstance(parseMethod);
        String[] segments = spliter.splitBarcodeSegments(barcode, rule);
        LOGGER.info("parseBarcode:segments=" + segments);
        Map<String, String> itemClsTypeMap = BarcodeRuleHelper.getRuleItemClassTypeMap(rule, objType);
        DynamicObjectCollection segObjCollection = new DynamicObjectCollection();
        boolean isParseByLength = "L".equals(parseMethod);
        Long ruleId = rule.getLong("id");
        HashMap<String, String> typeValMap = new HashMap<String, String>();
        DynamicObjectCollection ruleEntry = (DynamicObjectCollection)rule.get("entry");
        int len = ruleEntry.size();
        for (int i = 0; i < len; ++i) {
            DynamicObject segObj;
            String rawProp;
            DynamicProperty pMeta;
            DynamicObject ruleEntryRow = (DynamicObject)ruleEntry.get(i);
            String prop = ruleEntryRow.getString("objprop");
            String typeVal = null;
            if (StringUtils.isEmpty((String)prop)) continue;
            String segment = segments[i];
            if (isParseByLength) {
                segment = BarcodeRuleHelper.removePadding(segment, ruleEntryRow);
            }
            if ((pMeta = BarcodeMetadataHelper.getPropertyMeta((String)(rawProp = BarcodeMetadataHelper.getPropName((String)prop)), (DynamicObjectType)objType)) instanceof ItemClassProp) {
                String typeProp = itemClsTypeMap.get(rawProp);
                typeVal = (String)typeValMap.get(typeProp);
            }
            if ((segObj = this.parseSegment(ruleId, segment, ruleEntryRow, objType, orgID, typeVal)) == null) continue;
            String errMsg = segObj.getString("exception");
            if (!StringUtils.isEmpty((String)errMsg)) {
                String currErr = parseObj.getString("exception");
                currErr = currErr != null ? currErr + System.lineSeparator() + errMsg : errMsg;
                parseObj.set("exception", (Object)currErr);
            } else if (pMeta instanceof ItemClassTypeProp) {
                typeValMap.put(rawProp, segObj.getString("propvalue"));
            }
            segObjCollection.add((Object)segObj);
        }
        parseObj.set("objvalues", (Object)segObjCollection);
        DynamicObjectCollection parseObjCollection = new DynamicObjectCollection();
        parseObjCollection.add((Object)parseObj);
        return parseObjCollection;
    }

    private DynamicObject parseSegment(Long ruleId, String segment, DynamicObject ruleEntryRow, DynamicObjectType objType, Long orgID, String typeVal) {
        String prop = ruleEntryRow.getString("objprop");
        String valueType = ruleEntryRow.getString("valuetype");
        LOGGER.info("parseSegment:ruleId=" + ruleId + ",segment=" + segment + ",prop=" + prop + ",valueType=" + valueType);
        String custCls = null;
        DynamicObject segObj = BarcodeMetadataHelper.createDynamicObject((String)"bcprs_val", (String[])SEG_PROPS);
        segObj.set("segment", (Object)segment);
        segObj.set("prop", (Object)prop);
        Object prsVal = BarcodeCache.getSegmentParsedCache(ruleId, prop, segment);
        String errMsg = BarcodeCache.getSegmentParsedErrCache(ruleId, prop, segment);
        boolean fNotCached = prsVal == null && errMsg == null;
        try {
            ISegmentParser parser = SegmentParserFactory.getInstance(ruleEntryRow);
            if (fNotCached) {
                prsVal = parser.parse(segment, ruleEntryRow, objType, orgID, typeVal);
            } else {
                parser.checkViewPermission(prop, segment, objType, orgID, prsVal, typeVal);
            }
            LOGGER.info("parseSegment:prsVal=" + prsVal);
        }
        catch (Exception ex) {
            errMsg = ex.getMessage();
            LOGGER.error("barcode, failed to parse the segment, " + segment, (Throwable)ex);
        }
        if (prsVal != null) {
            segObj.set("propvalue", prsVal);
            segObj.set("valuetype", (Object)valueType);
            BarcodeCache.putSegmentParsed(ruleId, prop, segment, prsVal, valueType, errMsg, custCls);
        } else if (!StringUtils.isEmpty((String)errMsg)) {
            segObj.set("exception", (Object)errMsg);
            BarcodeCache.putSegmentParseErr(ruleId, prop, segment, errMsg);
        }
        return segObj;
    }

    private DynamicObjectCollection convertCollection(String bizObjEntityKey, Map<Object, DynamicObject> barcodeInfos, DynamicObjectType objType, Long orgID) {
        LOGGER.info("convertCollection:bizObjEntityKey=" + bizObjEntityKey + ",objType=" + objType + ",orgID=" + orgID);
        DynamicObject parseObj = null;
        DynamicObjectCollection parseObjCollection = new DynamicObjectCollection();
        String entityKey = objType.getName();
        DynamicObjectCollection mappingProps = this.getMappingProps(bizObjEntityKey, entityKey);
        Set<Map.Entry<Object, DynamicObject>> entries = barcodeInfos.entrySet();
        for (Map.Entry<Object, DynamicObject> entry : entries) {
            DynamicObject barcodeInfo = entry.getValue();
            parseObj = BarcodeMetadataHelper.createDynamicObject((String)"bcprs_vals", (String[])BARCODE_PROPS);
            parseObj.set("barcode", barcodeInfo.get("barcode"));
            parseObj.set("srcbillid", barcodeInfo.get("srcbillid"));
            this.convertSegments(mappingProps, barcodeInfo, parseObj, objType, orgID);
            parseObjCollection.add((Object)parseObj);
        }
        return parseObjCollection;
    }

    private DynamicObjectCollection getMappingProps(String bizObjEntityKey, String entityKey) {
        String oql;
        QFilter filter;
        String selectors;
        DynamicObject mappingInfo;
        boolean fMappingEntity = !bizObjEntityKey.equals(entityKey);
        DynamicObjectCollection mappingProps = null;
        if (fMappingEntity && (mappingInfo = BusinessDataServiceHelper.loadSingleFromCache((String)"barcode_prop_mapping", (String)(selectors = "id, entryentity.lbizobj, entryentity.rbizobj, entryentity.lobjpropname, entryentity.robjpropname"), (QFilter[])(filter = QFilter.of((String)(oql = "(entryentity.lbizobj = ? and entryentity.rbizobj = ?) or (entryentity.lbizobj = ? and entryentity.rbizobj = ?)"), (Object[])new Object[]{bizObjEntityKey, entityKey, entityKey, bizObjEntityKey})).toArray())) != null) {
            mappingProps = mappingInfo.getDynamicObjectCollection("entryentity");
        }
        return mappingProps;
    }

    private void convertSegments(DynamicObjectCollection mappingProps, DynamicObject barcodeInfo, DynamicObject parseObj, DynamicObjectType objType, Long orgID) {
        boolean fHasMapping = false;
        if (mappingProps != null && !mappingProps.isEmpty()) {
            fHasMapping = true;
        }
        DynamicObjectCollection segObjs = new DynamicObjectCollection();
        try {
            this.checkDataAccess(barcodeInfo, orgID);
            DynamicObjectCollection segs = barcodeInfo.getDynamicObjectCollection("entry");
            for (DynamicObject seg : segs) {
                this.convertSegment(mappingProps, objType, fHasMapping, segObjs, seg);
            }
        }
        catch (KDBizException e) {
            LOGGER.error("barcode parse, failed to check user data access");
            parseObj.set("exception", (Object)e.getMessage());
        }
        parseObj.set("objvalues", (Object)segObjs);
    }

    private void convertSegment(DynamicObjectCollection mappingProps, DynamicObjectType objType, boolean fHasMapping, DynamicObjectCollection targetSegObjs, DynamicObject srcSegObj) {
        boolean propIsNotEmpty;
        String segment = srcSegObj.getString("segmentval");
        String prop = srcSegObj.getString("objprop");
        if (StringUtils.isEmpty((String)prop)) {
            LOGGER.info("do NOT return the value if the segment does not has prop (seq, fixedvalue)");
            return;
        }
        DynamicObject segObj = BarcodeMetadataHelper.createDynamicObject((String)"bcprs_val", (String[])SEG_PROPS);
        this.setValTypeSegValue(objType, segObj, srcSegObj, prop);
        segObj.set("segment", (Object)segment);
        if (fHasMapping) {
            prop = this.getMappingProp(mappingProps, prop);
        }
        if (propIsNotEmpty = StringUtils.isNotEmpty((String)prop)) {
            segObj.set("prop", (Object)prop);
        }
        LOGGER.info("convertSegment:fHasMapping=" + fHasMapping + ", mappingPropIsNotEmpty=" + propIsNotEmpty);
        if (!fHasMapping || fHasMapping && propIsNotEmpty) {
            targetSegObjs.add((Object)segObj);
        }
    }

    protected void setValTypeSegValue(DynamicObjectType objType, DynamicObject targetSegObj, DynamicObject srcSegObj, String prop) {
        boolean fNotRead;
        String vType = srcSegObj.getString("valuetype");
        Object prsVal = null;
        String propField = prop;
        if ("B".equals(vType)) {
            propField = BarcodeMetadataHelper.getPropName((String)prop);
        }
        if (!(fNotRead = BarcodePermHelper.isPropNotRead(objType, propField))) {
            if ("B".equals(vType)) {
                DynamicObject bill = new DynamicObject(objType);
                bill.set("id", srcSegObj.get("dataid"));
                prsVal = bill;
            } else if ("A".equals(vType) || "Q".equals(vType)) {
                prsVal = srcSegObj.get("numval");
            } else if ("D".equals(vType)) {
                prsVal = srcSegObj.get("dateval");
            } else if ("T".equals(vType)) {
                prsVal = srcSegObj.get("timeval");
            } else if ("S".equals(vType)) {
                prsVal = srcSegObj.get("textval");
            }
            targetSegObj.set("propvalue", prsVal);
            targetSegObj.set("valuetype", (Object)vType);
        }
    }

    private String getMappingProp(DynamicObjectCollection mappingProps, String prop) {
        String mProp = null;
        if (prop == null) {
            return mProp;
        }
        for (DynamicObject entry : mappingProps) {
            String elProp = entry.getString("lobjpropname");
            String erProp = entry.getString("robjpropname");
            if (prop.equals(elProp)) {
                mProp = erProp;
                continue;
            }
            if (!prop.equals(erProp)) continue;
            mProp = elProp;
        }
        return mProp;
    }

    public DynamicObjectCollection parseBarcodesByRule(List<String> barcodes, Long ruleID, Long orgID) throws KDBizException {
        if (BarcodeParamsHelper.isISV()) {
            return (DynamicObjectCollection)DispatchServiceHelper.invokeBizService((String)"bd", (String)"word_barcode", (String)"BarcodeParseService", (String)"parseBarcodesByRule", (Object[])new Object[]{barcodes, ruleID, orgID});
        }
        throw new KDBizException(ResManager.loadKDString((String)"\u672a\u8d2d\u4e70\u6761\u7801\u670d\u52a1\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"BarcodeMservice_1", (String)MODULE, (Object[])new Object[0]));
    }

    private DynamicObjectCollection createBusiInfoWithErr(String barcode, String errMsg) {
        DynamicObjectCollection propObjs = new DynamicObjectCollection();
        DynamicObject rtnObj = BarcodeMetadataHelper.createDynamicObject((String)"bcprs_vals", (String[])BARCODE_PROPS);
        rtnObj.set("barcode", (Object)barcode);
        rtnObj.set("exception", (Object)errMsg);
        propObjs.add((Object)rtnObj);
        return propObjs;
    }

    private QFilter[] getEntityBarcodeInfoFilter(String barcode, String entityKey, Long orgID, boolean fPkg) {
        return this.getBarcodeInfoFilter(barcode, null, entityKey, null, orgID, fPkg);
    }

    private QFilter[] getMappingBarcodeInfoFilter(String barcode, Set<String> entityKeys, Long orgID, boolean fPkg) {
        return this.getBarcodeInfoFilter(barcode, null, null, entityKeys, orgID, fPkg);
    }

    private QFilter[] getPkgBarcodesInfoFilter(List<String> barcodes, String entityKey, Long orgID) {
        return this.getBarcodeInfoFilter(null, barcodes, entityKey, null, orgID, true);
    }

    private QFilter[] getBarcodeInfoFilter(String barcode, List<String> barcodes, String entityKey, Set<String> entityKeys, Long orgID, boolean fPkg) {
        QFilter eFilter = new QFilter("barcodestatus", "=", (Object)"E");
        QFilter pFilter = BarcodePermHelper.getPermissionFilter("barcode_info", orgID);
        QFilter bFilter = null;
        bFilter = barcodes != null ? new QFilter("barcode", "in", barcodes) : new QFilter("barcode", "=", (Object)barcode);
        QFilter bTFilter = null;
        bTFilter = entityKeys != null ? new QFilter("bizobj", "in", entityKeys) : new QFilter("bizobj", "=", (Object)entityKey);
        QFilter[] filters = null;
        if (fPkg) {
            QFilter tFilter = new QFilter("barcodetype", "=", (Object)"P");
            filters = new QFilter[]{bFilter, bTFilter, eFilter, tFilter, pFilter};
        } else {
            filters = new QFilter[]{bFilter, bTFilter, eFilter, pFilter};
        }
        return filters;
    }

    public DynamicObject getBarcodeInfo(String barcode, String entityKey, Long orgID, boolean fPkg) throws KDBizException {
        if (BarcodeParamsHelper.isISV()) {
            return (DynamicObject)DispatchServiceHelper.invokeBizService((String)"bd", (String)"word_barcode", (String)"BarcodeParseService", (String)"getBarcodeInfo", (Object[])new Object[]{barcode, entityKey, orgID, fPkg});
        }
        throw new KDBizException(ResManager.loadKDString((String)"\u672a\u8d2d\u4e70\u6761\u7801\u670d\u52a1\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"BarcodeMservice_1", (String)MODULE, (Object[])new Object[0]));
    }

    public DynamicObjectCollection getPackageBarcodeDetail(String packageBarcode, String entityKey, Long orgID) throws KDBizException {
        if (BarcodeParamsHelper.isISV()) {
            return (DynamicObjectCollection)DispatchServiceHelper.invokeBizService((String)"bd", (String)"word_barcode", (String)"BarcodeParseService", (String)"getPackageBarcodeDetail", (Object[])new Object[]{packageBarcode, entityKey, orgID});
        }
        throw new KDBizException(ResManager.loadKDString((String)"\u672a\u8d2d\u4e70\u6761\u7801\u670d\u52a1\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"BarcodeMservice_1", (String)MODULE, (Object[])new Object[0]));
    }

    public DynamicObjectCollection getPackageBarcodesDetail(List<String> packageBarcodes, String entityKey, Long orgID) throws KDBizException {
        if (BarcodeParamsHelper.isISV()) {
            return (DynamicObjectCollection)DispatchServiceHelper.invokeBizService((String)"bd", (String)"word_barcode", (String)"BarcodeParseService", (String)"getPackageBarcodesDetail", (Object[])new Object[]{packageBarcodes, entityKey, orgID});
        }
        throw new KDBizException(ResManager.loadKDString((String)"\u672a\u8d2d\u4e70\u6761\u7801\u670d\u52a1\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"BarcodeMservice_1", (String)MODULE, (Object[])new Object[0]));
    }

    protected DynamicObjectCollection getPackageBarcodeInfo(Long pkgBarcodeId, Long orgID, short sLevel) throws KDBizException {
        this.checkPackageLevel(sLevel);
        DynamicObjectCollection barcodes = new DynamicObjectCollection();
        QFilter bIdFilter = new QFilter("barcode", "=", (Object)pkgBarcodeId);
        QFilter[] pFilters = null;
        if (orgID != null) {
            QFilter oFilter = new QFilter("org", "=", (Object)orgID);
            pFilters = new QFilter[]{bIdFilter, oFilter};
        } else {
            pFilters = new QFilter[]{bIdFilter};
        }
        String selectors = "status, createtime, modifytime, isleaf, barcoderule.barcodetype, barcode.id, ebarcode.id";
        DynamicObject pkgInfo = BusinessDataServiceHelper.loadSingleFromCache((String)"package_barcode", (String)selectors, (QFilter[])pFilters);
        if (pkgInfo == null) {
            LOGGER.error("NOT defined package that barcode, id: " + pkgBarcodeId);
            String msg = ResManager.loadResFormat((String)"\u672a\u5b9a\u4e49\u6761\u7801\u503c\u4e3a%1\u7684\u5305\u88c5\u6761\u7801", (String)"NOT_DEFINED_PKG_BARCODE", (String)MODULE, (Object[])new Object[]{pkgBarcodeId});
            throw new KDBizException(msg);
        }
        barcodes.add((Object)pkgInfo);
        DynamicObjectCollection pEntries = pkgInfo.getDynamicObjectCollection("entry");
        for (DynamicObject pEntry : pEntries) {
            DynamicObjectCollection subBarcodes;
            Long subId = pEntry.getLong("ebarcode_id");
            if (pEntry.getBoolean("isleaf") || (subBarcodes = this.getPackageBarcodeInfo(subId, orgID, (short)(sLevel + 1))).isEmpty()) continue;
            barcodes.addAll((Collection)subBarcodes);
        }
        return barcodes;
    }

    protected void setBarcodeInfo(DynamicObjectCollection pkgbarcodes) {
        HashSet<Long> ids = new HashSet<Long>(pkgbarcodes.size());
        String bc = "barcode";
        String ebc = "ebarcode";
        for (DynamicObject pkgBarcode : pkgbarcodes) {
            Long id = pkgBarcode.getDynamicObject(bc).getLong("id");
            ids.add(id);
            DynamicObjectCollection pkgEntries = pkgBarcode.getDynamicObjectCollection("entry");
            for (DynamicObject pEntry : pkgEntries) {
                id = pEntry.getDynamicObject(ebc).getLong("id");
                ids.add(id);
            }
        }
        String selectors = "barcode, barcodetype, sourcetype, barcodestatus, bizobj, srcbillnumber, srcbillid, segmentval, objprop, valuetype, textval, dateval, timeval, numval, dataid";
        QFilter idsFilter = new QFilter("id", "in", ids);
        Map barcodeMap = BusinessDataServiceHelper.loadFromCache((String)"barcode_info", (String)selectors, (QFilter[])new QFilter[]{idsFilter});
        Collection barcodes = barcodeMap.values();
        for (DynamicObject barcode : barcodes) {
            Long id = barcode.getLong("id");
            for (DynamicObject pkgBarcode : pkgbarcodes) {
                Long bId = pkgBarcode.getDynamicObject(bc).getLong("id");
                if (id.compareTo(bId) == 0) {
                    pkgBarcode.set(bc, (Object)barcode);
                }
                DynamicObjectCollection pkgEntries = pkgBarcode.getDynamicObjectCollection("entry");
                for (DynamicObject pEntry : pkgEntries) {
                    Long eId = pEntry.getDynamicObject(ebc).getLong("id");
                    if (id.compareTo(eId) != 0) continue;
                    pEntry.set(ebc, (Object)barcode);
                }
            }
        }
    }

    protected void checkCacheResultDataPerm(DynamicObjectType objType, String entityKey, Long orgID, String barcode, DynamicObjectCollection bizObjs) {
        for (DynamicObject info : bizObjs) {
            DynamicObjectCollection segs;
            String srcBillId = info.getString("srcbillid");
            if (StringUtils.isNotEmpty((String)srcBillId)) {
                try {
                    this.checkSrcBillAccess(entityKey, orgID, barcode, srcBillId);
                }
                catch (Exception e) {
                    info.set("objvalues", null);
                    info.set("exception", (Object)e.getMessage());
                }
            }
            if ((segs = info.getDynamicObjectCollection("objvalues")) == null || segs.isEmpty()) continue;
            this.checkCacheSegDataPerm(objType, orgID, segs);
        }
    }

    protected void checkCacheSegDataPerm(DynamicObjectType objType, Long orgID, DynamicObjectCollection segs) {
        HashMap<String, String> typeValMap = new HashMap<String, String>();
        Map<String, String> itemClsTypeMap = BarcodeRuleHelper.getItemClassTypeMap(objType);
        for (DynamicObject segInfo : segs) {
            String type;
            String valType = segInfo.getString("valuetype");
            if (StringUtils.isEmpty((String)valType)) continue;
            String prop = segInfo.getString("prop");
            String segment = segInfo.getString("segment");
            String custCls = segInfo.getString("parsecls");
            String rawProp = BarcodeMetadataHelper.getPropName((String)prop);
            String typeVal = null;
            Object prsVal = segInfo.get("propvalue");
            if (itemClsTypeMap.containsKey(rawProp) && (type = itemClsTypeMap.get(prop)) != null) {
                typeVal = (String)typeValMap.get(type);
            }
            try {
                ISegmentParser parser = SegmentParserFactory.getInstance(valType, custCls);
                parser.checkViewPermission(prop, segment, objType, orgID, prsVal, typeVal);
                if (!itemClsTypeMap.containsValue(rawProp) || prsVal == null) continue;
                typeValMap.put(rawProp, prsVal.toString());
            }
            catch (Exception ex) {
                LOGGER.error("failed to create parser instance, or check permission");
                segInfo.set("propvalue", null);
                segInfo.set("exception", (Object)ex.getMessage());
            }
        }
    }

    protected void checkSrcBillAccess(String entityKey, Long orgID, String barcode, String srcBillId) {
        QFilter dataF = BarcodePermHelper.getPermissionFilter(entityKey, orgID);
        QFilter[] filters = null;
        if (dataF != null) {
            QFilter idF = new QFilter("id", "=", (Object)srcBillId);
            filters = new QFilter[]{dataF, idF};
            boolean fAccess = QueryServiceHelper.exists((String)entityKey, (QFilter[])filters);
            if (!fAccess) {
                String msg = ResManager.loadResFormat((String)"\u5f53\u524d\u7528\u6237\u4e0d\u80fd\u67e5\u770b\u8be5\u6761\u7801\uff08%1\uff09\u5bf9\u5e94\u7684\u4e1a\u52a1\u5bf9\u8c61", (String)"NO_ACCESS_SRCBILL", (String)MODULE, (Object[])new Object[]{barcode});
                throw new KDBizException(msg);
            }
        }
    }

    private DynamicObjectCollection getApprovedBarcodeRules(DynamicObjectType objType) {
        boolean fNotNullmRules;
        QFilter[] filters;
        String entityKey = objType.getName();
        String ruleFields = BarcodeRuleHelper.getRuleFields();
        Map<Object, DynamicObject> rulesMap = BusinessDataServiceHelper.loadFromCache((String)"barcode_rule", (String)ruleFields, (QFilter[])(filters = BarcodeRuleHelper.getRuleApprvFilter(entityKey)), (String)"priority asc");
        int rulesMapSize = rulesMap == null ? 0 : rulesMap.size();
        LOGGER.info("getApprovedBarcodeRules: rulesMapSize=" + rulesMapSize);
        Map<Object, DynamicObject> mRulesMap = this.getMappingApprovedRules(entityKey);
        int mRulesMapSize = mRulesMap == null ? 0 : mRulesMap.size();
        LOGGER.info("getApprovedBarcodeRules: mRulesMapSize=" + mRulesMapSize);
        boolean fNotNullRules = rulesMap != null && !rulesMap.isEmpty();
        boolean bl = fNotNullmRules = mRulesMap != null && !mRulesMap.isEmpty();
        if (fNotNullRules && fNotNullmRules) {
            rulesMap.putAll(mRulesMap);
        } else if (!fNotNullRules && fNotNullmRules) {
            rulesMap = mRulesMap;
        }
        DynamicObjectCollection rules = BarcodeRuleHelper.convertoDynCollection(rulesMap);
        int ruleSize = rules == null ? 0 : rules.size();
        LOGGER.info("getApprovedBarcodeRules: ruleSize=" + ruleSize);
        if (rules == null || rules.isEmpty()) {
            String msg = ResManager.loadResFormat((String)"%1\uff08%2\uff09\u6ca1\u6709\u542f\u7528\u7684\u6761\u7801\u89c4\u5219", (String)"NO_ENABLED_BARCODERULE", (String)MODULE, (Object[])new Object[]{objType.getDisplayName(), entityKey});
            throw new KDBizException(msg);
        }
        return rules;
    }

    private Map<Object, DynamicObject> getMappingApprovedRules(String entityKey) {
        Set<String> keys = this.getMappingEntities(entityKey);
        if (keys == null || keys.isEmpty()) {
            return Collections.emptyMap();
        }
        String ruleFields = BarcodeRuleHelper.getRuleFields();
        QFilter[] filters = BarcodeRuleHelper.getMappingMasterRuleApprvFilter(keys);
        return BusinessDataServiceHelper.loadFromCache((String)"barcode_rule", (String)ruleFields, (QFilter[])filters);
    }
}

