/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.barcode.mservice;

import java.util.ArrayList;
import java.util.Set;
import kd.bd.barcode.common.BarcodeMetadataHelper;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.FieldControlRule;
import kd.bos.servicehelper.devportal.BizAppServiceHelp;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;

public class BarcodePermHelper {
    public static boolean isPropNotRead(DynamicObjectType propObjType, String pField) {
        long userId = UserServiceHelper.getCurrentUserId();
        String propEntityKey = propObjType.getName();
        String appId = BizAppServiceHelp.getAppIdByFormNum((String)propEntityKey);
        return BarcodePermHelper.isPropNotRead(userId, appId, propEntityKey, pField);
    }

    public static boolean isPropNotRead(long userId, String appId, String propEntityKey, String pField) {
        Set<String> bdNotReads = BarcodePermHelper.getCannotReadFields(userId, appId, propEntityKey);
        return bdNotReads != null && !bdNotReads.isEmpty() && bdNotReads.contains(pField);
    }

    public static Set<String> getCannotReadFields(String entityKey) {
        long userId = UserServiceHelper.getCurrentUserId();
        String appId = BizAppServiceHelp.getAppIdByFormNum((String)entityKey);
        return BarcodePermHelper.getCannotReadFields(userId, appId, entityKey);
    }

    public static Set<String> getCannotReadFields(long userId, String appId, String entityKey) {
        FieldControlRule fieldCtrlRule = PermissionServiceHelper.getFieldRulesSum((Long)userId, (String)appId, (String)entityKey);
        Set bdNotReads = null;
        if (fieldCtrlRule != null) {
            bdNotReads = fieldCtrlRule.getCanNotReadFields();
        }
        return bdNotReads;
    }

    public static void checkPropAccess(DynamicObjectType propObjType, String pField) {
        long userId = UserServiceHelper.getCurrentUserId();
        String propEntityKey = propObjType.getName();
        String appId = BizAppServiceHelp.getAppIdByFormNum((String)propEntityKey);
        BarcodePermHelper.checkPropAccess(userId, appId, propEntityKey, propObjType, pField);
    }

    public static void checkPropAccess(long userId, String appId, String propEntityKey, DynamicObjectType propObjType, String pField) {
        boolean fNotRead = BarcodePermHelper.isPropNotRead(userId, appId, propEntityKey, pField);
        if (fNotRead) {
            DynamicProperty pProp = BarcodeMetadataHelper.getPropertyMeta((String)pField, (DynamicObjectType)propObjType);
            String fldName = pField;
            if (pProp != null) {
                fldName = pProp.getDisplayName().toString();
            }
            String msg = ResManager.loadResFormat((String)"\u5f53\u524d\u7528\u6237\u4e0d\u80fd\u8bfb\u53d6%1\u7684\u5c5e\u6027%2\u3002", (String)"PROP_NO_READ", (String)"bd-barcode-mserivce", (Object[])new Object[]{propObjType.getName(), fldName});
            throw new KDBizException(msg);
        }
    }

    public static QFilter getPermissionFilter(String propEntityKey, Long orgID) {
        long userId = UserServiceHelper.getCurrentUserId();
        String appId = BizAppServiceHelp.getAppIdByFormNum((String)propEntityKey);
        QFilter filter = null;
        ArrayList<Long> orgIds = new ArrayList<Long>();
        if (orgID != null) {
            orgIds.add(orgID);
            filter = PermissionServiceHelper.getDataPermission((long)userId, (String)appId, (String)propEntityKey, orgIds);
        } else {
            filter = PermissionServiceHelper.getDataPermWithOrg((long)userId, (String)appId, (String)propEntityKey);
        }
        return filter;
    }
}

