/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.barcode.mservice;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bd.barcode.common.BarcodeMetadataHelper;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.property.ItemClassProp;
import kd.bos.entity.property.ItemClassTypeProp;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.util.StringUtils;

public class BarcodeRuleHelper {
    private static final String MODULE = "bd-barcode-mservice";
    private static final Log LOGGER = LogFactory.getLog(BarcodeRuleHelper.class);
    public static final QFilter APPRV_FILTER = new QFilter("status", "=", (Object)"C");

    public static boolean isApplicable(String barcode, DynamicObject rule) {
        boolean result = false;
        String ruleType = rule.getString("ruletype");
        if (!"D".equals(ruleType)) {
            return true;
        }
        String parseMethod = rule.getString("parsemethod");
        DynamicObjectCollection ruleEntry = rule.getDynamicObjectCollection("entry");
        int ruleEntrySize = ruleEntry != null ? ruleEntry.size() : 0;
        boolean fHasEntries = ruleEntrySize > 0;
        int expectedLength = rule.getInt("barcodelength");
        String seperator = rule.getString("seperator");
        LOGGER.info("isApplicable:barcode=" + barcode + ",parseMethod=" + parseMethod + ",expectedLength=" + expectedLength + ",seperator=" + seperator + ",ruleEntrySize=" + ruleEntrySize);
        if ("L".equals(parseMethod)) {
            if (barcode.length() == expectedLength && fHasEntries) {
                result = true;
            }
        } else if ("S".equals(parseMethod) && !StringUtils.isEmpty((String)seperator)) {
            int barcodeSegmentCount = barcode.split(seperator).length;
            result = ruleEntrySize == barcodeSegmentCount;
        }
        return result;
    }

    public static boolean isRegularChar(String padding) {
        return "$".equals(padding) || "\\".equals(padding) || "^".equals(padding) || "*".equals(padding) || "?".equals(padding) || "+".equals(padding);
    }

    public static String removePadding(String segment, DynamicObject ruleEntryRow) {
        String align = ruleEntryRow.getString("align");
        String padding = ruleEntryRow.getString("padding");
        String rawStr = segment;
        if (StringUtils.isEmpty((String)align) || StringUtils.isEmpty((String)padding)) {
            return rawStr;
        }
        String pattern = null;
        if (BarcodeRuleHelper.isRegularChar(padding)) {
            padding = "\\" + padding;
        }
        pattern = "L".equals(align) ? padding + "+$" : "^" + padding + "+";
        rawStr = segment.replaceAll(pattern, "");
        return rawStr;
    }

    public static String getRuleFields() {
        return "name, number, status, barcodetype, ruletype, priority, parsemethod, barcodelength, seperator, bizobj, isautogenerate, isperitem, entry.objprop, entry.segmenttype, entry.valuetype, entry.fieldlength, entry.padding, entry.align, entry.dotposition, entry.format, entry.startval, entry.stepperval, entry.currval, entry.iscode, entry.fixvalue, entry.isqtyprop";
    }

    public static QFilter[] getRuleApprvFilter(String entityKey) {
        QFilter objFilter = new QFilter("bizobj", "=", (Object)entityKey);
        return new QFilter[]{objFilter, APPRV_FILTER};
    }

    public static QFilter[] getMappingMasterRuleApprvFilter(Set<String> keys) {
        QFilter kFilter = new QFilter("bizobj", "in", keys);
        QFilter mFilter = new QFilter("ruletype", "=", (Object)"M");
        return new QFilter[]{kFilter, mFilter, APPRV_FILTER};
    }

    public static DynamicObject getBarcodeRule(Long barcodeRuleId, boolean fChkBarcodeInfo) {
        QFilter idFilter;
        QFilter[] filters;
        String ruleFields = BarcodeRuleHelper.getRuleFields();
        DynamicObject rule = BusinessDataServiceHelper.loadSingle((String)"barcode_rule", (String)ruleFields, (QFilter[])(filters = new QFilter[]{idFilter = new QFilter("id", "=", (Object)barcodeRuleId), APPRV_FILTER}));
        if (rule == null) {
            String msg = ResManager.loadResFormat((String)"\u6307\u5b9a\u7684\u6761\u7801\u89c4\u5219\u4e0d\u5b58\u5728\u6216\u6ca1\u6709\u542f\u7528\uff08%1\uff09\u3002", (String)"NO_ID_BARCODERULE", (String)MODULE, (Object[])new Object[]{barcodeRuleId});
            throw new KDBizException(msg);
        }
        if (fChkBarcodeInfo && !BarcodeRuleHelper.isInfoRule(rule)) {
            String msg = ResManager.loadResFormat((String)"\u8bf7\u6307\u5b9a\u6761\u7801\u4e3b\u6863\u7c7b\u578b\u7684\u6761\u7801\u89c4\u5219\u3002", (String)"NOT_INFO_BARCODERULE", (String)MODULE, (Object[])new Object[]{barcodeRuleId});
            throw new KDBizException(msg);
        }
        return rule;
    }

    public static boolean isInfoRule(DynamicObject rule) {
        return "M".equals(rule.getString("ruletype"));
    }

    public static DynamicObjectCollection convertoDynCollection(Map<Object, DynamicObject> dynMap) {
        DynamicObjectCollection infos = null;
        if (dynMap == null || dynMap.isEmpty()) {
            return infos;
        }
        infos = new DynamicObjectCollection();
        for (DynamicObject ruleInfo : dynMap.values()) {
            infos.add((Object)ruleInfo);
        }
        return infos;
    }

    public static boolean isApplyBarcodePerItem(DynamicObject rule) {
        boolean fSeq = false;
        boolean fQty = false;
        DynamicObjectCollection entries = rule.getDynamicObjectCollection("entry");
        for (DynamicObject entry : entries) {
            boolean isQtyprop;
            String segType = entry.getString("segmenttype");
            if ("S".equals(segType)) {
                fSeq = true;
                continue;
            }
            if (!"M".equals(segType) || !(isQtyprop = entry.getBoolean("isqtyprop"))) continue;
            fQty = true;
        }
        return fSeq && fQty;
    }

    public static List<String> getRuleQtyProp(DynamicObject rule) {
        ArrayList<String> props = new ArrayList<String>();
        DynamicObjectCollection entries = rule.getDynamicObjectCollection("entry");
        for (DynamicObject entry : entries) {
            String valType;
            String segType = entry.getString("segmenttype");
            if (!"M".equals(segType) || !"Q".equals(valType = entry.getString("valuetype"))) continue;
            String prop = entry.getString("objprop");
            props.add(prop);
        }
        return props;
    }

    public static boolean hasSequenceEntry(DynamicObject rule) {
        boolean fSeq = false;
        DynamicObjectCollection entries = rule.getDynamicObjectCollection("entry");
        for (DynamicObject entry : entries) {
            String segType = entry.getString("segmenttype");
            if (!"S".equals(segType)) continue;
            fSeq = true;
            break;
        }
        return fSeq;
    }

    public static Map<String, String> getItemClassTypeMap(DynamicObjectType objType) {
        HashMap<String, String> clsTypeMap = new HashMap<String, String>();
        DataEntityPropertyCollection props = objType.getProperties();
        for (IDataEntityProperty prop : props) {
            String rawProp = prop.getName();
            BarcodeRuleHelper.addToMap(objType, rawProp, clsTypeMap);
        }
        return clsTypeMap;
    }

    private static void addToMap(DynamicObjectType objType, String rawProp, Map<String, String> clsTypeMap) {
        String itemClsTypeProp;
        DynamicProperty pMeta = BarcodeMetadataHelper.getPropertyMeta((String)rawProp, (DynamicObjectType)objType);
        if (pMeta instanceof ItemClassProp && StringUtils.isNotEmpty((String)(itemClsTypeProp = BarcodeMetadataHelper.getItemClassTypeProp((DynamicObjectType)objType, (ItemClassProp)((ItemClassProp)pMeta))))) {
            clsTypeMap.put(rawProp, itemClsTypeProp);
        }
    }

    public static Map<String, String> getRuleItemClassTypeMap(DynamicObject rule, DynamicObjectType objType) {
        HashMap<String, String> clsTypeMap = new HashMap<String, String>();
        DynamicObjectCollection entries = (DynamicObjectCollection)rule.get("entry");
        for (DynamicObject entry : entries) {
            String prop = entry.getString("objprop");
            if (StringUtils.isEmpty((String)prop)) continue;
            String rawProp = BarcodeMetadataHelper.getPropName((String)prop);
            BarcodeRuleHelper.addToMap(objType, rawProp, clsTypeMap);
        }
        return clsTypeMap;
    }

    public static boolean isItemClassTypeMatch(DynamicObject rule, DynamicObjectType objType) {
        boolean fMatch = true;
        HashSet<String> clsProps = new HashSet<String>();
        HashSet<String> clsTypeProps = new HashSet<String>();
        HashMap<String, String> clsTypeMap = new HashMap<String, String>();
        DynamicObjectCollection entries = (DynamicObjectCollection)rule.get("entry");
        for (DynamicObject entry : entries) {
            String prop = entry.getString("objprop");
            if (StringUtils.isEmpty((String)prop)) continue;
            String rawProp = BarcodeMetadataHelper.getPropName((String)prop);
            DynamicProperty pMeta = BarcodeMetadataHelper.getPropertyMeta((String)rawProp, (DynamicObjectType)objType);
            if (pMeta instanceof ItemClassProp) {
                clsProps.add(rawProp);
                String itemClsTypeProp = BarcodeMetadataHelper.getItemClassTypeProp((DynamicObjectType)objType, (ItemClassProp)((ItemClassProp)pMeta));
                if (!StringUtils.isNotEmpty((String)itemClsTypeProp)) continue;
                clsTypeMap.put(rawProp, itemClsTypeProp);
                continue;
            }
            if (!(pMeta instanceof ItemClassTypeProp)) continue;
            clsTypeProps.add(rawProp);
        }
        if (clsProps.isEmpty()) {
            return fMatch;
        }
        for (String p : clsProps) {
            String tProp = (String)clsTypeMap.get(p);
            if (clsTypeProps.contains(tProp)) continue;
            fMatch = false;
            break;
        }
        return fMatch;
    }
}

