/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.barcode.mservice.cache;

import java.util.Arrays;
import kd.bd.barcode.common.BarcodeParsedValJsonHelper;
import kd.bd.barcode.mservice.cache.BarcodeCacheMgr;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.bos.util.StringUtils;

public class BarcodeCache {
    private static final Log LOGGER = LogFactory.getLog(BarcodeCache.class);
    private static final int TIMEOUT = 600;

    public static int getTimeout() {
        return 600;
    }

    public static DynamicObjectCollection getBarcodeParsed(String entityKey, String barcode) {
        if (StringUtils.isEmpty((String)entityKey) || StringUtils.isEmpty((String)barcode)) {
            return null;
        }
        String cacheType = BarcodeCacheMgr.getBarcodeEntityMapType(entityKey);
        long userId = UserServiceHelper.getCurrentUserId();
        String key = BarcodeCache.getKey(barcode, userId);
        String json = BarcodeCacheMgr.get(cacheType, key);
        DynamicObjectCollection bizInfos = BarcodeParsedValJsonHelper.getCachedBarcodeBizInfos((String)json);
        LOGGER.info("getBarcodeParsed, cacheType=" + cacheType + ",entityKey=" + entityKey + ",barcode=" + barcode);
        return bizInfos;
    }

    private static String getKey(String barcode, long userId) {
        return userId + "_" + barcode;
    }

    public static void putBarcodeParsed(String entityKey, String barcode, DynamicObjectCollection bizInfos) {
        if (StringUtils.isEmpty((String)entityKey) || StringUtils.isEmpty((String)barcode) || bizInfos == null || bizInfos.isEmpty()) {
            return;
        }
        String cacheType = BarcodeCacheMgr.getBarcodeEntityMapType(entityKey);
        String json = BarcodeParsedValJsonHelper.getBarcodeBizInfosJsonString((DynamicObjectCollection)bizInfos);
        long userId = UserServiceHelper.getCurrentUserId();
        String key = BarcodeCache.getKey(barcode, userId);
        BarcodeCacheMgr.put(cacheType, key, json, BarcodeCache.getTimeout());
        LOGGER.info("putBarcodeParsed, cacheType:" + cacheType + ", key:" + key + ", json:" + json);
    }

    public static String getBarcodeParseRule(String entityKey, String barcode) {
        if (StringUtils.isEmpty((String)entityKey) || StringUtils.isEmpty((String)barcode)) {
            return null;
        }
        String cacheType = BarcodeCacheMgr.getBarcodeEntityMapType(entityKey);
        String rule = BarcodeCacheMgr.get(cacheType, barcode + "_rule");
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("get parsed rule, cacheType:" + cacheType + ", rule:" + rule);
        }
        return rule;
    }

    protected static String getSegmentKey(String prop, String segment) {
        long userId = UserServiceHelper.getCurrentUserId();
        return userId + "_" + prop + "_" + segment;
    }

    protected static String getSegmentErrKey(String prop, String segment) {
        long userId = UserServiceHelper.getCurrentUserId();
        return userId + "_" + prop + "_" + segment + "_err";
    }

    public static Object getSegmentParsedCache(Long ruleId, String prop, String segment) {
        if (ruleId == null || StringUtils.isEmpty((String)prop) || StringUtils.isEmpty((String)segment)) {
            return null;
        }
        String cacheType = BarcodeCacheMgr.getBarcodeRuleSegType(ruleId);
        String key = BarcodeCache.getSegmentKey(prop, segment);
        String json = BarcodeCacheMgr.get(cacheType, key);
        Object val = BarcodeParsedValJsonHelper.getPropVal((String)json);
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("get segment cache, cacheType:" + cacheType + ", key:" + key + ", val:" + val);
        }
        return val;
    }

    public static void putSegmentParsed(Long ruleId, String prop, String segment, Object val, String valType, String errMsg, String custCls) {
        if (ruleId == null || StringUtils.isEmpty((String)prop) || StringUtils.isEmpty((String)segment)) {
            return;
        }
        String cacheType = BarcodeCacheMgr.getBarcodeRuleSegType(ruleId);
        String key = BarcodeCache.getSegmentKey(prop, segment);
        String json = BarcodeParsedValJsonHelper.getSegmentJsonStr((String)prop, (String)segment, (Object)val, (String)valType, (String)errMsg, (String)custCls);
        BarcodeCacheMgr.put(cacheType, key, json, BarcodeCache.getTimeout());
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("put segment parsed, cacheType:" + cacheType + ", key:" + key + ", json:" + json);
        }
    }

    public static void addBarcodeParsedRule(String entityKey, String barcode, Long ruleId) {
        if (StringUtils.isEmpty((String)entityKey) || StringUtils.isEmpty((String)barcode) || ruleId == null) {
            return;
        }
        String cacheType = BarcodeCacheMgr.getBarcodeEntitySuccSetType(entityKey);
        BarcodeCacheMgr.addToSet(cacheType, ruleId.toString(), BarcodeCache.getTimeout());
        BarcodeCache.addParsedBarcode(ruleId, barcode);
    }

    public static String getBarcodeParseRule(String entityKey, Long ruleId) {
        if (StringUtils.isEmpty((String)entityKey) || ruleId == null) {
            return null;
        }
        String cacheType = BarcodeCacheMgr.getBarcodeEntitySuccSetType(entityKey);
        String key = ruleId.toString();
        String rule = BarcodeCacheMgr.get(cacheType, key);
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("get parsed rule, cacheType:" + cacheType + ", rule:" + rule);
        }
        return rule;
    }

    public static void addBarcodeErrRule(String entityKey, String barcode, Long ruleId) {
        if (StringUtils.isEmpty((String)entityKey) || StringUtils.isEmpty((String)barcode)) {
            return;
        }
        if (ruleId != null) {
            String cacheType = BarcodeCacheMgr.getBarcodeEntityErrRuleSetType(entityKey);
            BarcodeCacheMgr.addToSet(cacheType, ruleId.toString(), BarcodeCache.getTimeout());
            String setType = BarcodeCacheMgr.getBarcodeRuleErrSetType(ruleId);
            long userId = UserServiceHelper.getCurrentUserId();
            String key = BarcodeCache.getKey(barcode, userId);
            BarcodeCacheMgr.addToSet(setType, key, BarcodeCache.getTimeout());
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("add barcode err rule, cacheType:" + cacheType + ", ruleId: " + ruleId + ", key:" + key);
            }
        }
        BarcodeCache.addErrBarcode(entityKey, barcode);
    }

    public static void addParsedBarcode(Long ruleId, String barcode) {
        if (ruleId == null || StringUtils.isEmpty((String)barcode)) {
            return;
        }
        String cacheType = BarcodeCacheMgr.getBarcodeRuleSetType(ruleId);
        long userId = UserServiceHelper.getCurrentUserId();
        String key = BarcodeCache.getKey(barcode, userId);
        BarcodeCacheMgr.addToSet(cacheType, key, BarcodeCache.getTimeout());
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("add barcode parsed, cacheType:" + cacheType + ", key:" + key);
        }
    }

    public static void addErrBarcode(String entityKey, String barcode) {
        if (StringUtils.isEmpty((String)barcode)) {
            return;
        }
        long userId = UserServiceHelper.getCurrentUserId();
        String cacheType = BarcodeCacheMgr.getBarcodeEntityErrSetType(entityKey);
        String key = BarcodeCache.getKey(barcode, userId);
        BarcodeCacheMgr.addToSet(cacheType, key, BarcodeCache.getTimeout());
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("add barcode err, cacheType:" + cacheType + ", key:" + key);
        }
    }

    public static String getSegmentParsedErrCache(Long ruleId, String prop, String segment) {
        if (ruleId == null || StringUtils.isEmpty((String)prop) || StringUtils.isEmpty((String)segment)) {
            return null;
        }
        String cacheType = BarcodeCacheMgr.getBarcodeRuleErrSetType(ruleId);
        String key = BarcodeCache.getSegmentErrKey(prop, segment);
        String errMsg = BarcodeCacheMgr.get(cacheType, key);
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("get segment err cache, cacheType:" + cacheType + ", key:" + key + ", errMsg:" + errMsg);
        }
        return errMsg;
    }

    public static void putSegmentParseErr(Long ruleId, String prop, String segment, String errMsg) {
        if (ruleId == null || StringUtils.isEmpty((String)prop) || StringUtils.isEmpty((String)segment) || StringUtils.isEmpty((String)errMsg)) {
            return;
        }
        String cacheType = BarcodeCacheMgr.getBarcodeRuleSegErrType(ruleId);
        String key = BarcodeCache.getSegmentErrKey(prop, segment);
        BarcodeCacheMgr.put(cacheType, key, errMsg, BarcodeCache.getTimeout());
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("put segment err, cacheType:" + cacheType + ", key:" + key + ", errMsg:" + errMsg);
        }
    }

    public static void clear(String entityKey, Long ruleId, boolean fAudit) {
        if (ruleId == null || StringUtils.isEmpty((String)entityKey)) {
            return;
        }
        if (fAudit) {
            BarcodeCache.clearEntityFailedCache(entityKey);
        } else {
            BarcodeCache.clearUsedRuleCache(entityKey, ruleId);
        }
    }

    public static void clearEntityFailedCache(String entityKey) {
        String[] uidBarcodes;
        String entityMapName = BarcodeCacheMgr.getBarcodeEntityMapType(entityKey);
        String errRuleSetName = BarcodeCacheMgr.getBarcodeEntityErrRuleSetType(entityKey);
        String entityErrSetName = BarcodeCacheMgr.getBarcodeEntityErrSetType(entityKey);
        for (String key : uidBarcodes = BarcodeCacheMgr.getSetValues(entityErrSetName)) {
            BarcodeCacheMgr.clear(entityMapName, key);
        }
        BarcodeCacheMgr.clear(errRuleSetName);
        BarcodeCacheMgr.clear(entityErrSetName);
    }

    protected static void clearUsedRuleCache(String entityKey, Long ruleId) {
        String ruleErrSetType;
        boolean fRuleUsed;
        String entityMapName = BarcodeCacheMgr.getBarcodeEntityMapType(entityKey);
        String entitySetType = BarcodeCacheMgr.getBarcodeEntitySuccSetType(entityKey);
        String sRuleId = ruleId.toString();
        Object[] rules = BarcodeCacheMgr.getSetValues(entitySetType);
        boolean bl = fRuleUsed = Arrays.binarySearch(rules, sRuleId) > -1;
        if (fRuleUsed) {
            String[] uidBarcodes;
            String ruleSetType = BarcodeCacheMgr.getBarcodeRuleSetType(ruleId);
            for (String key : uidBarcodes = BarcodeCacheMgr.getSetValues(ruleSetType)) {
                BarcodeCacheMgr.clear(entityMapName, key);
            }
            BarcodeCacheMgr.clear(ruleSetType);
            BarcodeCacheMgr.removeSetValue(entitySetType, new String[]{sRuleId});
            String segMapType = BarcodeCacheMgr.getBarcodeRuleSegType(ruleId);
            BarcodeCacheMgr.clear(segMapType);
        }
        boolean bl2 = fRuleUsed = Arrays.binarySearch(rules = BarcodeCacheMgr.getSetValues(ruleErrSetType = BarcodeCacheMgr.getBarcodeEntityErrRuleSetType(entityKey)), sRuleId) > -1;
        if (fRuleUsed) {
            String[] failedUidBcs;
            String ruleFSetType = BarcodeCacheMgr.getBarcodeRuleErrSetType(ruleId);
            String entityErrSetType = BarcodeCacheMgr.getBarcodeEntityErrSetType(entityKey);
            for (String key : failedUidBcs = BarcodeCacheMgr.getSetValues(ruleFSetType)) {
                BarcodeCacheMgr.clear(entityMapName, key);
                BarcodeCacheMgr.clear(entityErrSetType, key);
            }
            BarcodeCacheMgr.clear(ruleFSetType);
            BarcodeCacheMgr.removeSetValue(ruleErrSetType, new String[]{sRuleId});
            String segErrType = BarcodeCacheMgr.getBarcodeRuleSegErrType(ruleId);
            BarcodeCacheMgr.clear(segErrType);
        }
    }

    public static void clear(Long ruleId) {
        String cacheType = BarcodeCacheMgr.getBarcodeRuleSetType(ruleId);
        BarcodeCacheMgr.clear(cacheType);
    }

    public static void clear(String entityKey, String barcode) {
        String cacheType = BarcodeCacheMgr.getBarcodeEntityMapType(entityKey);
        BarcodeCacheMgr.clear(cacheType, barcode);
    }
}

