/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.barcode.mservice.cache;

import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.cache.CacheKeyUtil;

public class BarcodeCacheMgr {
    private static DistributeSessionlessCache cache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("bd_barcode");

    public static String getAcctId() {
        String acctId = CacheKeyUtil.getAcctId();
        if (acctId == null || acctId.length() == 0) {
            throw new RuntimeException(ResManager.loadKDString((String)"\u5f53\u524d\u6570\u636e\u4e2d\u5fc3\u4e3a\u7a7a\u3002", (String)"CacheMgr_0", (String)"bd-barcode-mservice", (Object[])new Object[0]));
        }
        return acctId;
    }

    public static void clear(String type) {
        cache.removeType(type);
    }

    public static void clear(String type, String key) {
        cache.remove(type, key);
    }

    public static void removeSetValue(String type, String[] vals) {
        cache.removeSetValues(type, vals);
    }

    public static void put(String type, String key, String val) {
        cache.put(type, key, val, 3600);
    }

    public static void put(String type, String key, String val, int timeoutseconds) {
        cache.put(type, key, val, timeoutseconds);
    }

    public static void addToSet(String type, String val) {
        cache.addToSet(type, new String[]{val});
    }

    public static void addToSet(String type, String val, int timeoutseconds) {
        cache.addToSet(type, new String[]{val}, timeoutseconds);
    }

    public static String get(String type, String key) {
        return (String)cache.get(type, key);
    }

    public static String[] getSetValues(String type) {
        return cache.getSetValues(type);
    }

    public static String getBarcodeEntityMapType(String entityKey) {
        return "Barcode_" + entityKey + "_" + BarcodeCacheMgr.getAcctId();
    }

    public static String getBarcodeEntitySuccSetType(String entityKey) {
        return "Barcode_" + entityKey + "_RULE_" + BarcodeCacheMgr.getAcctId();
    }

    public static String getBarcodeEntityErrSetType(String entityKey) {
        return "Barcode_" + entityKey + "_ERR_" + BarcodeCacheMgr.getAcctId();
    }

    public static String getBarcodeEntityErrRuleSetType(String entityKey) {
        return "Barcode_" + entityKey + "_ERR_R_" + BarcodeCacheMgr.getAcctId();
    }

    public static String getBarcodeRuleSetType(Long ruleId) {
        return "Barcode_" + ruleId.toString() + "_" + BarcodeCacheMgr.getAcctId();
    }

    public static String getBarcodeRuleErrSetType(Long ruleId) {
        return "Barcode_" + ruleId.toString() + "_ERR_" + BarcodeCacheMgr.getAcctId();
    }

    public static String getBarcodeRuleSegType(Long ruleId) {
        return "Barcode_" + ruleId.toString() + "_SEG_" + BarcodeCacheMgr.getAcctId();
    }

    public static String getBarcodeRuleSegErrType(Long ruleId) {
        return "Barcode_" + ruleId.toString() + "_SEGERR_" + BarcodeCacheMgr.getAcctId();
    }
}

