/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.barcode.mservice.generator;

import kd.bd.barcode.common.BarcodeMetadataHelper;
import kd.bd.barcode.common.vo.BarcodeGenerateOption;
import kd.bd.barcode.common.vo.BarcodeSegment;
import kd.bd.barcode.mservice.BarcodePermHelper;
import kd.bd.barcode.mservice.generator.ISegmentGenerator;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.property.SubEntryProp;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.StringUtils;
import org.apache.commons.lang3.RandomStringUtils;

public abstract class AbstractSegmentGenerator
implements ISegmentGenerator {
    private static final Log LOGGER = LogFactory.getLog(AbstractSegmentGenerator.class);
    protected static final String PROP_ID = "id";
    protected static final String MODULE = "bd-barcode-mservice";

    protected Object getPropRawValue(DynamicObject bill, BarcodeGenerateOption option, String prop, boolean fPerItem, String qtyProp) {
        DynamicObjectType objType = bill.getDynamicObjectType();
        BarcodePermHelper.checkPropAccess(objType, prop);
        Object val = null;
        String entryName = null;
        if (!StringUtils.isEmpty((String)prop)) {
            String pname = BarcodeMetadataHelper.getPropName((String)prop);
            entryName = BarcodeMetadataHelper.getEntryName((String)pname, (DynamicObjectType)objType);
            Long entryId = option.getEntryId(entryName);
            val = entryName != null && entryId != null ? this.getEntrySubEntryVal(bill, objType, entryName, pname, entryId) : bill.get(pname);
        }
        return val;
    }

    private Object getEntrySubEntryVal(DynamicObject bill, DynamicObjectType objType, String entryName, String pname, Long entryId) {
        Object val = null;
        DynamicProperty pType = BarcodeMetadataHelper.getPropertyMeta((String)entryName, (DynamicObjectType)objType);
        if (pType instanceof SubEntryProp) {
            String subEntryName = entryName;
            String eName = BarcodeMetadataHelper.getEntryName((String)entryName, (DynamicObjectType)objType);
            DynamicObjectCollection bEntries = bill.getDynamicObjectCollection(eName);
            for (DynamicObject entry : bEntries) {
                DynamicObjectCollection sbEntries = entry.getDynamicObjectCollection(subEntryName);
                for (DynamicObject sentry : sbEntries) {
                    Object idVal = sentry.get(PROP_ID);
                    if (idVal == null || !entryId.equals(idVal)) continue;
                    return sentry.get(pname);
                }
            }
        } else {
            DynamicObjectCollection bEntries = bill.getDynamicObjectCollection(entryName);
            for (DynamicObject entry : bEntries) {
                Object idVal = entry.get(PROP_ID);
                if (idVal == null || !entryId.equals(idVal)) continue;
                val = entry.get(pname);
            }
        }
        return val;
    }

    protected Object getPropVal(Object val, String prop) {
        return val;
    }

    protected String strVal(int i) {
        return i > 9 ? String.valueOf(i) : "0" + i;
    }

    protected void checkSegmentValNull(Object val, String prop, DynamicObject bill) {
        if (val == null) {
            String pname = BarcodeMetadataHelper.getPropName((String)prop);
            IDataEntityType billEntityType = bill.getDataEntityType();
            DynamicProperty pProp = BarcodeMetadataHelper.getPropertyMeta((String)pname, (DynamicObjectType)((DynamicObjectType)billEntityType));
            String propDisplayName = prop;
            if (pProp.getDisplayName() != null && StringUtils.isEmpty((String)(propDisplayName = pProp.getDisplayName().toString()))) {
                propDisplayName = prop;
            }
            String msg = ResManager.loadResFormat((String)"%1\u5c5e\u6027\u503c\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u751f\u6210\u5206\u6bb5\u6587\u672c ", (String)"SEG_NULL_VALUE", (String)MODULE, (Object[])new Object[]{propDisplayName});
            throw new KDBizException(msg);
        }
    }

    private void checkSegmentLength(String segment) {
        int SEG_COL_MAX = 50;
        if (segment != null && segment.length() > SEG_COL_MAX) {
            String msg = ResManager.loadResFormat((String)"\u8d85\u8fc7\u5206\u6bb5\u6587\u672c\u6700\u5927\u957f\u5ea6%1", (String)"SEG_MAX", (String)MODULE, (Object[])new Object[]{SEG_COL_MAX});
            throw new KDBizException(msg);
        }
    }

    @Override
    public BarcodeSegment toSegmentInfo(DynamicObject ruleEntry, DynamicObject bill, BarcodeGenerateOption option, boolean fPerItem, String qtyProp) {
        Object val;
        String valType = ruleEntry.getString("valuetype");
        String prop = ruleEntry.getString("objprop");
        String format = ruleEntry.getString("format");
        String segType = ruleEntry.getString("segmenttype");
        boolean fIsCode = ruleEntry.getBoolean("iscode");
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("valtype:" + valType + ", prop: " + prop + ", format:" + (format == null ? "NULL" : format) + ", fIscode: " + String.valueOf(fIsCode));
        }
        String segment = null;
        Object rawVal = this.getPropRawValue(bill, option, prop, fPerItem, qtyProp);
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("rawVal: " + rawVal);
        }
        Object object = val = rawVal == null ? null : this.getPropVal(rawVal, prop);
        if (fIsCode) {
            this.checkSegmentValNull(val, prop, bill);
        }
        if (val != null) {
            segment = this.convertToStr(val, format);
        }
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("segment: " + (segment == null ? "NULL" : segment));
        }
        this.checkSegmentLength(segment);
        BarcodeSegment segInfo = this.createBarcodeSeg(prop, valType, segment);
        if (rawVal != null) {
            this.setBarcodeSegVal(segInfo, rawVal);
        }
        return segInfo;
    }

    protected abstract String convertToStr(Object var1, String var2);

    protected abstract void setBarcodeSegVal(BarcodeSegment var1, Object var2);

    protected Object getSampleValue(int fldLength) {
        int sampleLength = fldLength > 0 ? fldLength : 5;
        return RandomStringUtils.randomAlphanumeric((int)sampleLength);
    }

    protected String appendPadding(DynamicObject ruleEntry, String segment) {
        StringBuilder s = new StringBuilder();
        int fldLength = ruleEntry.getInt("fieldlength");
        if (fldLength > 0 && segment.length() < fldLength) {
            String padding = ruleEntry.getString("padding");
            if (StringUtils.isNotEmpty((String)padding)) {
                String align = ruleEntry.getString("align");
                int ct = fldLength - segment.length();
                StringBuilder pads = new StringBuilder();
                for (int i = 0; i < ct; ++i) {
                    pads.append(padding);
                }
                if ("L".equals(align)) {
                    s.append(segment);
                    s.append((CharSequence)pads);
                } else {
                    s.append((CharSequence)pads);
                    s.append(segment);
                }
            }
        } else {
            s.append(segment);
        }
        return s.toString();
    }

    @Override
    public BarcodeSegment toSampleSegmentInfo(DynamicObject ruleEntry) {
        String valType = ruleEntry.getString("valuetype");
        String prop = ruleEntry.getString("objprop");
        String format = ruleEntry.getString("format");
        int fldLength = ruleEntry.getInt("fieldlength");
        BarcodeSegment segInfo = null;
        Object sampleVal = this.getSampleValue(fldLength);
        String segment = this.convertToStr(sampleVal, format);
        segment = this.appendPadding(ruleEntry, segment);
        segInfo = this.createBarcodeSeg(prop, valType, segment);
        return segInfo;
    }
}

