/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.barcode.mservice.generator;

import java.math.BigDecimal;
import kd.bd.barcode.common.vo.BarcodeGenerateOption;
import kd.bd.barcode.common.vo.BarcodeSegment;
import kd.bd.barcode.mservice.generator.AbstractSegmentGenerator;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.util.StringUtils;
import org.apache.commons.lang3.RandomStringUtils;

public class SegmentAmountGenerator
extends AbstractSegmentGenerator {
    @Override
    protected Object getPropRawValue(DynamicObject bill, BarcodeGenerateOption option, String prop, boolean fPerItem, String qtyProp) {
        Object rawVal = super.getPropRawValue(bill, option, prop, fPerItem, qtyProp);
        if (fPerItem && StringUtils.isNotEmpty((String)prop) && StringUtils.isNotEmpty((String)qtyProp)) {
            int idx = qtyProp.indexOf(46);
            String string = qtyProp = idx > -1 ? qtyProp.split("\\.")[1] : qtyProp;
            if (prop.equals(qtyProp)) {
                rawVal = BigDecimal.ONE;
            }
        }
        return rawVal;
    }

    @Override
    protected String convertToStr(Object val, String format) {
        String segment = null;
        if (!(val instanceof BigDecimal)) {
            String msg = ResManager.loadResFormat((String)"\u5206\u6bb5\u5bf9\u5e94\u5c5e\u6027\u503c\u4e0d\u662f\u6570\u503c\uff08%1\uff09\u3002 ", (String)"NOT_NUM", (String)"bd-barcode-mservice", (Object[])new Object[]{val});
            throw new KDBizException(msg);
        }
        BigDecimal numVal = (BigDecimal)val;
        segment = numVal.stripTrailingZeros().toPlainString();
        return segment;
    }

    @Override
    protected void setBarcodeSegVal(BarcodeSegment segInfo, Object rawVal) {
        segInfo.setNumVal((BigDecimal)rawVal);
    }

    @Override
    protected Object getSampleValue(int fldLength) {
        int sampleLength = fldLength > 0 ? fldLength : 1;
        String amtStr = RandomStringUtils.randomNumeric((int)sampleLength);
        BigDecimal amt = new BigDecimal(amtStr);
        return amt;
    }
}

