/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.barcode.mservice.generator;

import java.util.HashMap;
import java.util.Map;
import kd.bd.barcode.mservice.generator.ISegmentGenerator;
import kd.bos.dataentity.TypesContainer;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.StringUtils;

public class SegmentGeneratorFactory {
    private static final Log LOGGER = LogFactory.getLog(SegmentGeneratorFactory.class);
    private static Map<String, String> map = new HashMap<String, String>();

    public static ISegmentGenerator getInstance(DynamicObject ruleEntry) {
        String valType = ruleEntry.getString("valuetype");
        String segType = ruleEntry.getString("segmenttype");
        String customG = null;
        if ("C".equals(segType)) {
            customG = "kd.bd.barcode.mservice.generator.SegmentCustomGenerator";
        }
        return SegmentGeneratorFactory.getInstance(segType, valType, customG);
    }

    public static ISegmentGenerator getInstance(String segType, String valueType, String customCls) {
        String clsName = null;
        String msg = null;
        if ("M".equals(segType)) {
            clsName = map.get(valueType);
        } else if ("S".equals(segType)) {
            clsName = "kd.bd.barcode.mservice.generator.SegmentSeqGenerator";
        } else if ("F".equals(segType)) {
            clsName = "kd.bd.barcode.mservice.generator.SegmentFixedValGenerator";
        } else {
            clsName = customCls;
            LOGGER.error("no custom generator is specified");
            msg = ResManager.loadResFormat((String)"\u672a\u6307\u5b9a\u81ea\u5b9a\u4e49\u751f\u6210\u5668\u5b9e\u73b0", (String)"NO_GENERATOR_CUST", (String)"bd-barcode-mserivce", (Object[])new Object[0]);
            throw new KDBizException(msg);
        }
        if (StringUtils.isEmpty((String)clsName)) {
            LOGGER.error("cannot find segment generator with (segType, valueType): " + segType + ", " + valueType);
            msg = ResManager.loadResFormat((String)"\u672a\u627e\u5230\u5bf9\u5e94\u7684\u751f\u6210\u5668\u5b9e\u73b0", (String)"NO_GENERATOR", (String)"bd-barcode-mserivce", (Object[])new Object[0]);
            throw new KDBizException(msg);
        }
        return (ISegmentGenerator)TypesContainer.getOrRegisterSingletonInstance((String)clsName);
    }

    static {
        map.put("B", "kd.bd.barcode.mservice.generator.SegmentBizObjGenerator");
        map.put("A", "kd.bd.barcode.mservice.generator.SegmentAmountGenerator");
        map.put("Q", "kd.bd.barcode.mservice.generator.SegmentAmountGenerator");
        map.put("D", "kd.bd.barcode.mservice.generator.SegmentDateGenerator");
        map.put("T", "kd.bd.barcode.mservice.generator.SegmentTimeGenerator");
        map.put("S", "kd.bd.barcode.mservice.generator.SegmentTextGenerator");
    }
}

