/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.barcode.mservice.generator;

import java.time.LocalDateTime;
import kd.bd.barcode.common.vo.BarcodeSegment;
import kd.bd.barcode.mservice.generator.AbstractSegmentGenerator;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.util.StringUtils;

public class SegmentTimeGenerator
extends AbstractSegmentGenerator {
    @Override
    protected String convertToStr(Object val, String format) {
        String fmt;
        String segment = null;
        if (!(val instanceof Integer)) {
            String msg = ResManager.loadResFormat((String)"\u5206\u6bb5\u5bf9\u5e94\u5c5e\u6027\u503c\u4e0d\u662f\u65f6\u95f4\u503c\uff08%1\uff09 \u3002", (String)"NOT_TIME", (String)"bd-barcode-mservice", (Object[])new Object[]{val});
            throw new KDBizException(msg);
        }
        Integer timeVal = (Integer)val;
        int timeIntVal = timeVal;
        if (timeIntVal < 0) {
            String msg = ResManager.loadResFormat((String)"\u65f6\u95f4\u503c\u5c0f\u4e8e0\uff08%1\uff09 ", (String)"INVALID_TIME", (String)"bd-barcode-mservice", (Object[])new Object[]{timeIntVal});
            throw new KDBizException(msg);
        }
        int h = timeIntVal > 3600 ? timeIntVal / 3600 : 0;
        int m = (timeIntVal - h * 3600) / 60;
        segment = this.strVal(h) + ":" + this.strVal(m);
        String string = fmt = StringUtils.isEmpty((String)format) ? "HH:mm:ss" : format;
        if ("HH:mm:ss".equals(fmt)) {
            int s = timeIntVal - h * 3600 - m * 60;
            segment = segment + ":" + this.strVal(s);
        }
        return segment;
    }

    @Override
    protected void setBarcodeSegVal(BarcodeSegment segInfo, Object rawVal) {
        segInfo.setTimeVal((Integer)rawVal);
    }

    @Override
    protected Object getSampleValue(int fldLength) {
        LocalDateTime now = LocalDateTime.now();
        int h = now.getHour();
        int m = now.getMinute();
        int s = now.getSecond();
        int val = h * 3600 + m * 60 + s;
        return val;
    }
}

