/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.barcode.mservice.parser;

import java.math.BigDecimal;
import kd.bd.barcode.common.BarcodeMetadataHelper;
import kd.bd.barcode.mservice.BarcodePermHelper;
import kd.bd.barcode.mservice.parser.ISegmentParser;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;

public class SegmentAmountParser
implements ISegmentParser<BigDecimal> {
    @Override
    public BigDecimal parse(String segment, DynamicObject ruleEntry, DynamicObjectType objType, Long orgID, String typeVal) throws KDBizException {
        String pname = ruleEntry.getString("objprop");
        BarcodeMetadataHelper.checkPropValid((DynamicObjectType)objType, (String)pname);
        BarcodePermHelper.checkPropAccess(objType, pname);
        String rawStr = segment;
        int dotPos = ruleEntry.getInt("dotposition");
        int n = dotPos = dotPos < 0 ? 0 : dotPos;
        if (dotPos >= segment.length()) {
            String invalidDotPosMsg = ResManager.loadResFormat((String)"\u6570\u503c\u89e3\u6790\u5931\u8d25\uff0c\u6761\u7801\u5206\u6bb5\u503c%1\uff0c\u8c03\u6574\u89e3\u6790\u7cbe\u5ea6\u503c%2\u7b49\u4e8e\u6216\u8d85\u8fc7\u6587\u672c\u957f\u5ea6\u3002", (String)"SEG_NUM_DOTPOS", (String)"bd-barcode-mserivce", (Object[])new Object[]{segment, dotPos});
            throw new KDBizException(invalidDotPosMsg);
        }
        if (dotPos > 0) {
            rawStr = this.setRawWithDot(rawStr, dotPos);
        } else {
            int index = rawStr.indexOf(46);
            if (index > 0 && index + 1 < rawStr.length()) {
                dotPos = rawStr.length() - (index + 1);
            }
        }
        BigDecimal numVal = null;
        try {
            numVal = new BigDecimal(rawStr).setScale(dotPos, 2);
        }
        catch (NumberFormatException e) {
            String msg = ResManager.loadResFormat((String)"\u6570\u503c\u89e3\u6790\u5931\u8d25\uff0c\u6761\u7801\u5206\u6bb5\u503c%1\u3002", (String)"SEG_NUM_PARSE_ERR", (String)"bd-barcode-mserivce", (Object[])new Object[]{segment, rawStr});
            throw new KDBizException(msg);
        }
        return numVal;
    }

    public String setRawWithDot(String rawStr, int dotPos) {
        int index = rawStr.length() - dotPos;
        rawStr = rawStr.substring(0, index) + "." + rawStr.substring(index);
        return rawStr;
    }
}

