/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.barcode.mservice.parser;

import java.util.ArrayList;
import java.util.List;
import kd.bd.barcode.common.BarcodeMetadataHelper;
import kd.bd.barcode.common.BarcodeProp;
import kd.bd.barcode.mservice.BarcodePermHelper;
import kd.bd.barcode.mservice.parser.ISegmentParser;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.FlexProp;
import kd.bos.entity.property.ItemClassProp;
import kd.bos.entity.property.MaterielProp;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.devportal.BizAppServiceHelp;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.bos.util.StringUtils;

public class SegmentBizObjParser
implements ISegmentParser<Object> {
    private static final String MODULE = "bd-barcode-mserivce";
    private static final Log LOGGER = LogFactory.getLog(SegmentBizObjParser.class);
    private static final String APPROVE = "C";
    private static final String PROP_STATUS = "status";
    private static final String PROP_ENABLE = "enable";
    private static final String PROP_BILLSTATUS = "billstatus";

    @Override
    public Object parse(String segment, DynamicObject ruleEntry, DynamicObjectType objType, Long orgID, String typeVal) throws KDBizException {
        DynamicObject bizInfo = null;
        String prop = ruleEntry.getString("objprop");
        String pname = null;
        String pField = null;
        BarcodeProp barcodeProp = BarcodeMetadataHelper.getPropNameField((String)prop);
        pname = barcodeProp.getName();
        pField = barcodeProp.getField();
        BarcodeMetadataHelper.checkPropValid((DynamicObjectType)objType, (String)pname);
        BarcodePermHelper.checkPropAccess(objType, pname);
        DynamicProperty propMeta = BarcodeMetadataHelper.getPropertyMeta((String)pname, (DynamicObjectType)objType);
        if (propMeta instanceof ItemClassProp && typeVal == null) {
            String msg = ResManager.loadKDString((String)"\u6761\u7801\u5206\u6bb5\u4e3a\u591a\u7c7b\u522b\u57fa\u7840\u8d44\u6599\uff0c\u8bf7\u5148\u6307\u5b9a\u6b63\u786e\u7684\u591a\u7c7b\u522b\u57fa\u7840\u8d44\u6599\u7c7b\u578b\u503c\u3002", (String)"SEG_VAL_INVALID", (String)MODULE, (Object[])new Object[0]);
            throw new KDBizException(msg);
        }
        String qryField = this.getQueryField(pField, propMeta);
        String propEntityKey = this.getPropEntityKey(propMeta, barcodeProp, typeVal);
        if (StringUtils.isEmpty((String)propEntityKey)) {
            return null;
        }
        this.checkBaseDataPropAccess(propEntityKey, pField);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("BarcodeParseService, propEntityKey: " + propEntityKey + ", prop: " + pname + ", field:" + pField + ", value:" + segment);
        }
        boolean fOnlyActive = true;
        if (propMeta instanceof BasedataProp) {
            BasedataProp propType = (BasedataProp)propMeta;
            fOnlyActive = propType.isShowUsed();
        }
        bizInfo = this.getBizInfo(propEntityKey, qryField, segment, orgID, fOnlyActive);
        return bizInfo;
    }

    private String getQueryField(String pField, DynamicProperty propMeta) {
        String qryField = pField;
        if (propMeta instanceof MulBasedataProp) {
            qryField = "fbasedataid." + pField;
        } else if (propMeta instanceof MaterielProp) {
            String baseEntityId;
            boolean fNumName;
            boolean bl = fNumName = "number".equals(pField) || "name".equals(pField);
            if (fNumName && !"bd_material".equals(baseEntityId = ((MaterielProp)propMeta).getBaseEntityId())) {
                qryField = "masterid." + pField;
            }
        }
        return qryField;
    }

    private DynamicObject getBizInfo(String propEntityKey, String pField, String segment, Long orgID, boolean fOnlyActive) {
        long userId = UserServiceHelper.getCurrentUserId();
        String appId = BizAppServiceHelp.getAppIdByFormNum((String)propEntityKey);
        MainEntityType propObjType = EntityMetadataCache.getDataEntityType((String)propEntityKey);
        BarcodePermHelper.checkPropAccess(userId, appId, propEntityKey, (DynamicObjectType)propObjType, pField);
        QFilter valF = new QFilter(pField, "=", (Object)segment);
        boolean fExist = QueryServiceHelper.exists((String)propEntityKey, (QFilter[])new QFilter[]{valF});
        if (!fExist) {
            String msg = ResManager.loadResFormat((String)"\u6761\u7801\u5206\u6bb5\u503c%1\uff08\u4e1a\u52a1\u5bf9\u8c61%2\uff09\u627e\u4e0d\u5230\u5bf9\u5e94\u6570\u636e", (String)"SEG_VAL_INVALID", (String)MODULE, (Object[])new Object[]{segment, propEntityKey});
            throw new KDBizException(msg);
        }
        ArrayList<QFilter> lstFilter = new ArrayList<QFilter>();
        lstFilter.add(valF);
        if (fOnlyActive) {
            this.addEnableFilter((DynamicObjectType)propObjType, lstFilter);
        }
        if (orgID != null) {
            QFilter dataF;
            QFilter basedF = BaseDataServiceHelper.getBaseDataFilter((String)propEntityKey, (Long)orgID);
            if (basedF != null) {
                lstFilter.add(basedF);
            }
            if ((dataF = BarcodePermHelper.getPermissionFilter(propEntityKey, orgID)) != null) {
                lstFilter.add(dataF);
            }
        }
        QFilter[] filters = new QFilter[lstFilter.size()];
        filters = lstFilter.toArray(filters);
        String selectFields = "id";
        DynamicObject bizInfo = BusinessDataServiceHelper.loadSingleFromCache((String)propEntityKey, (String)selectFields, (QFilter[])filters);
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("BarcodeParseService, " + (bizInfo != null ? "found, id:" + bizInfo.get("id") : "not found"));
        }
        if (bizInfo == null) {
            String msg = ResManager.loadResFormat((String)"\u5f53\u524d\u7528\u6237\u4e0d\u80fd\u8bbf\u95ee\u6761\u7801\u5206\u6bb5\u503c%1\uff08\u4e1a\u52a1\u5bf9\u8c61%2\uff09\u5bf9\u5e94\u6570\u636e\uff0c\u6216\u6570\u636e\u72b6\u6001\u4e3a\u672a\u542f\u7528\u3002", (String)"SEG_VAL_NOPRV_ACT", (String)MODULE, (Object[])new Object[]{segment, propEntityKey});
            LOGGER.info(msg);
            throw new KDBizException(msg);
        }
        return bizInfo;
    }

    private void addEnableFilter(DynamicObjectType propObjType, List<QFilter> lstFilter) {
        boolean fHasBillStatus;
        boolean fHasStatus = BarcodeMetadataHelper.getPropertyMeta((String)PROP_STATUS, (DynamicObjectType)propObjType) != null;
        boolean fHasEnable = BarcodeMetadataHelper.getPropertyMeta((String)PROP_ENABLE, (DynamicObjectType)propObjType) != null;
        boolean bl = fHasBillStatus = BarcodeMetadataHelper.getPropertyMeta((String)PROP_BILLSTATUS, (DynamicObjectType)propObjType) != null;
        if (fHasStatus) {
            lstFilter.add(new QFilter(PROP_STATUS, "=", (Object)APPROVE));
        }
        if (fHasEnable) {
            QFilter enFilter = new QFilter(PROP_ENABLE, "=", (Object)"1");
            QFilter euFilter = QFilter.isNull((String)PROP_ENABLE);
            QFilter enOrFilter = enFilter.or(euFilter);
            lstFilter.add(enOrFilter);
        }
        if (fHasBillStatus) {
            lstFilter.add(new QFilter(PROP_BILLSTATUS, "=", (Object)APPROVE));
        }
    }

    private String getPropEntityKey(DynamicProperty pType, BarcodeProp barcodeProp, String typeVal) {
        String propEntityKey = null;
        if (pType instanceof BasedataProp) {
            if (pType instanceof FlexProp) {
                String msg = ResManager.loadKDString((String)"\u6682\u672a\u652f\u6301\u5f39\u6027\u57df\u5c5e\u6027\u89e3\u6790\uff01", (String)"FLEXPROP_TODO", (String)MODULE, (Object[])new Object[0]);
                throw new KDBizException(msg);
            }
            propEntityKey = ((BasedataProp)pType).getBaseEntityId();
            if (pType instanceof ItemClassProp) {
                propEntityKey = typeVal;
            }
        } else {
            LOGGER.error("BarcodeParseService, prop " + barcodeProp.getName() + " PropertyType is not BasedataProp ( FlexProp ), cannot identify the entitykey");
        }
        return propEntityKey;
    }

    private void checkBaseDataPropAccess(String propEntityKey, String pField) {
        MainEntityType propObjType = null;
        try {
            propObjType = EntityMetadataCache.getDataEntityType((String)propEntityKey);
        }
        catch (Exception e) {
            LOGGER.error("invalid, propEntityKey: " + propEntityKey);
            throw new KDBizException(e.getMessage());
        }
        BarcodePermHelper.checkPropAccess((DynamicObjectType)propObjType, pField);
    }

    @Override
    public void checkViewPermission(String prop, String segment, DynamicObjectType objType, Long orgID, Object prsVal, String typeVal) {
        if (prsVal == null) {
            return;
        }
        boolean fAccess = true;
        BarcodeProp barcodeProp = BarcodeMetadataHelper.getPropNameField((String)prop);
        String pname = barcodeProp.getName();
        String pField = barcodeProp.getField();
        DynamicProperty propMeta = BarcodeMetadataHelper.getPropertyMeta((String)pname, (DynamicObjectType)objType);
        String propEntityKey = this.getPropEntityKey(propMeta, barcodeProp, typeVal);
        this.checkBaseDataPropAccess(propEntityKey, pField);
        QFilter dataF = BarcodePermHelper.getPermissionFilter(propEntityKey, orgID);
        if (dataF != null && prsVal instanceof DynamicObject) {
            Object id = ((DynamicObject)prsVal).get("id");
            if (id != null) {
                QFilter idF = new QFilter("id", "=", id);
                fAccess = QueryServiceHelper.exists((String)propEntityKey, (QFilter[])new QFilter[]{idF, dataF});
            }
            if (!fAccess) {
                String msg = ResManager.loadResFormat((String)"\u5f53\u524d\u7528\u6237\u4e0d\u80fd\u8bbf\u95ee\u6761\u7801\u5206\u6bb5\u503c%1\uff08\u5bf9\u5e94\u5355\u636e%2\uff09\u5bf9\u5e94\u6570\u636e\uff0c\u6216\u6570\u636e\u72b6\u6001\u4e3a\u672a\u542f\u7528\u3002", (String)"SEG_VAL_NOPRV_ACT", (String)MODULE, (Object[])new Object[]{segment, propEntityKey});
                throw new KDBizException(msg);
            }
        }
    }
}

