/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.barcode.mservice.parser;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import kd.bd.barcode.common.BarcodeMetadataHelper;
import kd.bd.barcode.mservice.BarcodePermHelper;
import kd.bd.barcode.mservice.parser.ISegmentParser;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;

public class SegmentDateParser
implements ISegmentParser<Date> {
    @Override
    public Date parse(String segment, DynamicObject ruleEntry, DynamicObjectType objType, Long orgID, String typeVal) throws KDBizException {
        String pname = ruleEntry.getString("objprop");
        BarcodeMetadataHelper.checkPropValid((DynamicObjectType)objType, (String)pname);
        BarcodePermHelper.checkPropAccess(objType, pname);
        String format = ruleEntry.getString("format");
        SimpleDateFormat formatter = new SimpleDateFormat(format);
        Date parseDate = null;
        try {
            parseDate = formatter.parse(segment);
        }
        catch (ParseException e) {
            throw new KDBizException(ResManager.loadResFormat((String)"\u65e5\u671f\u89e3\u6790\u5931\u8d25\uff0c\u6761\u7801\u5206\u6bb5\u503c%1\uff0c\u683c\u5f0f%2", (String)"SEG_DATE_PARSE_ERR", (String)"bd-barcode-mservice", (Object[])new Object[]{segment, format}));
        }
        return parseDate;
    }
}

