/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.barcode.mservice.parser;

import java.util.HashMap;
import java.util.Map;
import kd.bd.barcode.mservice.parser.ISegmentParser;
import kd.bos.dataentity.TypesContainer;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.StringUtils;

public class SegmentParserFactory {
    private static final Log LOGGER = LogFactory.getLog(SegmentParserFactory.class);
    private static Map<String, String> parserMap = new HashMap<String, String>();

    public static ISegmentParser getInstance(DynamicObject ruleEntry) {
        String valType = ruleEntry.getString("valuetype");
        String segType = ruleEntry.getString("segmenttype");
        String customP = null;
        if ("C".equals(segType)) {
            customP = "kd.bd.barcode.mservice.parser.SegmentCustomParser";
        }
        return SegmentParserFactory.getInstance(valType, customP);
    }

    public static ISegmentParser getInstance(String valueType, String customP) {
        String clsName;
        boolean fNoCustom = StringUtils.isEmpty((String)customP);
        String string = clsName = fNoCustom ? parserMap.get(valueType) : customP;
        if (StringUtils.isEmpty((String)clsName)) {
            LOGGER.error("no custom parser is specified, or cannot find segment parser with valueType: " + valueType);
            String msg = ResManager.loadResFormat((String)"\u672a\u627e\u5230\u503c\u7c7b\u578b\u5bf9\u5e94\u7684\u89e3\u6790\u5b9e\u73b0", (String)"NO_PARSER", (String)"bd-barcode-mserivce", (Object[])new Object[0]);
            if (!fNoCustom) {
                msg = ResManager.loadResFormat((String)"\u672a\u6307\u5b9a\u81ea\u5b9a\u4e49\u5206\u6bb5\u89e3\u6790\u5b9e\u73b0", (String)"NO_PARSER_CUST", (String)"bd-barcode-mserivce", (Object[])new Object[0]);
            }
            throw new KDBizException(msg);
        }
        return (ISegmentParser)TypesContainer.getOrRegisterSingletonInstance((String)clsName);
    }

    static {
        parserMap.put("B", "kd.bd.barcode.mservice.parser.SegmentBizObjParser");
        parserMap.put("A", "kd.bd.barcode.mservice.parser.SegmentAmountParser");
        parserMap.put("Q", "kd.bd.barcode.mservice.parser.SegmentAmountParser");
        parserMap.put("D", "kd.bd.barcode.mservice.parser.SegmentDateParser");
        parserMap.put("T", "kd.bd.barcode.mservice.parser.SegmentTimeParser");
        parserMap.put("S", "kd.bd.barcode.mservice.parser.SegmentTextParser");
    }
}

