/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.barcode.mservice.parser;

import java.util.List;
import kd.bd.barcode.common.BarcodeMetadataHelper;
import kd.bd.barcode.mservice.BarcodePermHelper;
import kd.bd.barcode.mservice.parser.ISegmentParser;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.property.ComboProp;
import kd.bos.exception.KDBizException;

public class SegmentTextParser
implements ISegmentParser<String> {
    @Override
    public String parse(String segment, DynamicObject ruleEntry, DynamicObjectType objType, Long orgID, String typeVal) throws KDBizException {
        String prop = ruleEntry.getString("objprop");
        String rtnVal = segment;
        BarcodeMetadataHelper.checkPropValid((DynamicObjectType)objType, (String)prop);
        BarcodePermHelper.checkPropAccess(objType, prop);
        String rawProp = BarcodeMetadataHelper.getPropName((String)prop);
        DynamicProperty pMeta = BarcodeMetadataHelper.getPropertyMeta((String)rawProp, (DynamicObjectType)objType);
        if (pMeta instanceof ComboProp) {
            rtnVal = this.getComboValue(segment, pMeta);
        }
        return rtnVal;
    }

    private String getComboValue(String segment, DynamicProperty pMeta) {
        String rtnVal = segment;
        boolean fMatch = false;
        ComboProp cProp = (ComboProp)pMeta;
        List items = cProp.getComboItems();
        for (ValueMapItem item : items) {
            if (item.getValue().equals(segment)) {
                fMatch = true;
                break;
            }
            if (!item.getName().getLocaleValue().equals(segment)) continue;
            fMatch = true;
            rtnVal = item.getValue();
            break;
        }
        if (!fMatch) {
            String msg = ResManager.loadResFormat((String)"\u6587\u672c\u89e3\u6790\u5931\u8d25\uff0c\u6761\u7801\u5206\u6bb5\u503c%1\u4e0d\u662f\u6709\u6548\u503c\u3002", (String)"SEG_COMBO_ERR", (String)"bd-barcode-mservice", (Object[])new Object[]{segment});
            throw new KDBizException(msg);
        }
        return rtnVal;
    }
}

