/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.barcode.mservice.parser;

import kd.bd.barcode.common.BarcodeMetadataHelper;
import kd.bd.barcode.mservice.BarcodePermHelper;
import kd.bd.barcode.mservice.parser.ISegmentParser;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public class SegmentTimeParser
implements ISegmentParser<Integer> {
    private static Log LOGGER = LogFactory.getLog(SegmentTimeParser.class);

    @Override
    public Integer parse(String segment, DynamicObject ruleEntry, DynamicObjectType objType, Long orgID, String typeVal) throws KDBizException {
        String pname = ruleEntry.getString("objprop");
        BarcodeMetadataHelper.checkPropValid((DynamicObjectType)objType, (String)pname);
        BarcodePermHelper.checkPropAccess(objType, pname);
        String format = ruleEntry.getString("format");
        String[] tArr = segment.split(":");
        if (tArr.length != 2 && "HH:mm".equals(format) || tArr.length != 3 && "HH:mm:ss".equals(format)) {
            LOGGER.error("barcode segment parse, time format is " + format + ", value does NOT has same fields joined with :");
            throw new KDBizException(ResManager.loadResFormat((String)"\u65f6\u95f4\u89e3\u6790\u5931\u8d25\uff0c\u6761\u7801\u5206\u6bb5\u503c%1\u548c\u683c\u5f0f%2\u4e0d\u5339\u914d\u3002", (String)"SEG_TIME_FORMAT_ERR", (String)"bd-barcode-mservice", (Object[])new Object[]{segment, format}));
        }
        int sum = 0;
        Integer timeVal = 0;
        try {
            for (int i = 0; i < tArr.length; ++i) {
                String s = tArr[i];
                int val = Integer.parseInt(s);
                if (i == 0) {
                    if (val > 23 || val < 0) {
                        throw new KDBizException(ResManager.loadResFormat((String)"\u65f6\u95f4\u89e3\u6790\u5931\u8d25\uff0c\u5c0f\u65f6\u503c\u5fc5\u987b\u57280-23\u4e4b\u95f4\uff0c\u6761\u7801\u5206\u6bb5\u503c%1\uff0c\u683c\u5f0f%2\u3002", (String)"SEG_TIME_HOUR_ERR", (String)"bd-barcode-mservice", (Object[])new Object[]{segment, format}));
                    }
                    val *= 3600;
                } else if (i == 1) {
                    if (val > 59 || val < 0) {
                        throw new KDBizException(ResManager.loadResFormat((String)"\u65f6\u95f4\u89e3\u6790\u5931\u8d25\uff0c\u5206\u949f\u503c\u5fc5\u987b\u57280-59\u4e4b\u95f4\uff0c\u6761\u7801\u5206\u6bb5\u503c%1\uff0c\u683c\u5f0f%2\u3002", (String)"SEG_TIME_MIN_ERR", (String)"bd-barcode-mservice", (Object[])new Object[]{segment, format}));
                    }
                    val *= 60;
                } else if (val > 59 || val < 0) {
                    throw new KDBizException(ResManager.loadResFormat((String)"\u65f6\u95f4\u89e3\u6790\u5931\u8d25\uff0c\u79d2\u503c\u5fc5\u987b\u57280-59\u4e4b\u95f4\uff0c\u6761\u7801\u5206\u6bb5\u503c%1\uff0c\u683c\u5f0f%2\u3002", (String)"SEG_TIME_SEC_ERR", (String)"bd-barcode-mservice", (Object[])new Object[]{segment, format}));
                }
                sum += val;
            }
            timeVal = sum;
        }
        catch (NumberFormatException e) {
            LOGGER.error("barcode segment parse, time segment parse exception", (Throwable)e);
            throw new KDBizException(ResManager.loadResFormat((String)"\u65f6\u95f4\u89e3\u6790\u5931\u8d25\uff0c\u6761\u7801\u5206\u6bb5\u503c%1\uff0c\u683c\u5f0f%2", (String)"SEG_TIME_PARSE_ERR", (String)"bd-barcode-mservice", (Object[])new Object[]{segment, format}));
        }
        return timeVal;
    }
}

