/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.barcode.mservice.splitter;

import kd.bd.barcode.mservice.splitter.AbstractBarcodeSplitter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public class BarcodeSegLengthSplitter
extends AbstractBarcodeSplitter {
    private static Log LOGGER = LogFactory.getLog(BarcodeSegLengthSplitter.class);

    @Override
    public String[] splitSegments(String barcode, DynamicObject rule) {
        DynamicObjectCollection ruleEntry = (DynamicObjectCollection)rule.get("entry");
        String[] segments = new String[ruleEntry.size()];
        int begin = 0;
        int end = 0;
        StringBuilder segJoin = new StringBuilder();
        int len = ruleEntry.size();
        for (int i = 0; i < len; ++i) {
            DynamicObject ruleEntryRow = (DynamicObject)ruleEntry.get(i);
            int fieldLength = ruleEntryRow.getInt("fieldlength");
            if (fieldLength < 1) {
                String msg = ResManager.loadKDString((String)"\u6761\u7801\u89c4\u5219\u5206\u6bb5\u957f\u5ea6\u503c\u4e0d\u80fd\u5c0f\u4e8e1\u3002", (String)"RULE_FIELDLENGTH_ZERO", (String)"bd-barcode-mservice", (Object[])new Object[0]);
                throw new KDBizException(msg);
            }
            end = begin + fieldLength;
            segments[i] = barcode.substring(begin, end).trim();
            segJoin.append(segments[i]);
            begin = end;
        }
        if (!barcode.trim().equals(segJoin.toString())) {
            LOGGER.error("barcode, [" + barcode + "], splitted join str: [" + segJoin + "]");
            String msg = ResManager.loadKDString((String)"\u6761\u7801\u6309\u957f\u5ea6\u89e3\u6790\u540e\u548c\u6761\u7801\u503c\u4e0d\u4e00\u81f4\u3002", (String)"RULE_ENTRY_VALS_DIFF", (String)"bd-barcode-mservice", (Object[])new Object[0]);
            throw new KDBizException(msg);
        }
        return segments;
    }
}

