/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.barcode.mservice.splitter;

import kd.bd.barcode.mservice.splitter.AbstractBarcodeSplitter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.StringUtils;

public class BarcodeSegSepaSplitter
extends AbstractBarcodeSplitter {
    private static Log LOGGER = LogFactory.getLog(BarcodeSegSepaSplitter.class);

    @Override
    public String[] splitSegments(String barcode, DynamicObject rule) {
        DynamicObjectCollection ruleEntry = (DynamicObjectCollection)rule.get("entry");
        String seperator = rule.getString("seperator");
        if (StringUtils.isEmpty((String)seperator)) {
            String msg = ResManager.loadKDString((String)"\u6761\u7801\u89c4\u5219\u5206\u6bb5\u6ca1\u6709\u6307\u5b9a\u5206\u9694\u7b26\u3002", (String)"NO_SEPARATOR", (String)"bd-barcode-mservice", (Object[])new Object[0]);
            throw new KDBizException(msg);
        }
        String[] segments = barcode.split(seperator);
        if (segments.length != ruleEntry.size()) {
            LOGGER.error("splitSegments:ruleEntrySize=" + ruleEntry.size() + ", segmentSize=" + segments.length);
            String msg = ResManager.loadKDString((String)"\u6761\u7801\u6309\u5206\u9694\u7b26\u89e3\u6790\u540e\u548c\u6761\u7801\u503c\u4e0d\u4e00\u81f4\u3002", (String)"RULE_SEP_ENTRY_VALS_DIFF", (String)"bd-barcode-mservice", (Object[])new Object[0]);
            throw new KDBizException(msg);
        }
        return segments;
    }
}

