/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.barcode.mservice.splitter;

import java.util.HashMap;
import java.util.Map;
import kd.bd.barcode.mservice.splitter.IBarcodeSplitter;
import kd.bos.dataentity.TypesContainer;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.StringUtils;

public class BarcodeSplitterFactory {
    private static final Log LOGGER = LogFactory.getLog(BarcodeSplitterFactory.class);
    private static Map<String, String> map = new HashMap<String, String>();

    public static IBarcodeSplitter getInstance(String parseMethod) {
        String clsName = map.get(parseMethod);
        if (StringUtils.isEmpty((String)clsName)) {
            LOGGER.error("cannot find barcode splitter with parse method, " + parseMethod);
            String msg = ResManager.loadResFormat((String)"\u672a\u627e\u5230%1\u5bf9\u5e94\u7684\u5206\u89e3\u5668\u5b9e\u73b0", (String)"NO_Splitter", (String)"bd-barcode-mserivce", (Object[])new Object[]{parseMethod});
            throw new KDBizException(msg);
        }
        return (IBarcodeSplitter)TypesContainer.getOrRegisterSingletonInstance((String)clsName);
    }

    static {
        map.put("L", "kd.bd.barcode.mservice.splitter.BarcodeSegLengthSplitter");
        map.put("S", "kd.bd.barcode.mservice.splitter.BarcodeSegSepaSplitter");
    }
}

