/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.barcode.webapi;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bd.barcode.common.vo.BarcodeGenerateOption;
import kd.bd.barcode.common.vo.BarcodeGenerated;
import kd.bd.barcode.servicehelper.BarcodeServiceHelper;
import kd.bd.barcode.webapi.AbstractBarcodeApiPlugin;
import kd.bd.barcode.webapi.BarcodeParseApiPlugin;
import kd.bos.entity.api.ApiResult;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.StringUtils;

public class BarcodeGenerateApiPlugin
extends AbstractBarcodeApiPlugin {
    private static final Log LOGGER = LogFactory.getLog(BarcodeParseApiPlugin.class);
    private static final String K_OPTIONS = "options";

    private List<BarcodeGenerateOption> getOptions(Map<String, Object> params) {
        JSONArray optionsJ;
        String optionsStr = JSON.toJSONString((Object)params.get(K_OPTIONS));
        ArrayList<BarcodeGenerateOption> options = null;
        if (!StringUtils.isEmpty((String)optionsStr) && (optionsJ = JSON.parseArray((String)optionsStr)) != null && !optionsJ.isEmpty()) {
            options = new ArrayList<BarcodeGenerateOption>(optionsJ.size());
            int n = optionsJ.size();
            for (int i = 0; i < n; ++i) {
                JSONObject optionJ = optionsJ.getJSONObject(i);
                BarcodeGenerateOption option = (BarcodeGenerateOption)optionJ.toJavaObject(BarcodeGenerateOption.class);
                options.add(option);
            }
        }
        return options;
    }

    private ApiResult checkParams(Long orgID, Long ruleID, List<BarcodeGenerateOption> options) {
        ApiResult result = null;
        if (options == null || options.isEmpty()) {
            result = ApiResult.fail((String)this.getNotNullMessage(K_OPTIONS));
        }
        return result;
    }

    private List<BarcodeGenerated> callService(Long orgID, Long ruleID, List<BarcodeGenerateOption> options) {
        List barcodes = null;
        barcodes = orgID != null && ruleID != null ? BarcodeServiceHelper.generateSaveBarcodes((Long)ruleID, (Long)orgID, options) : BarcodeServiceHelper.generateSaveBarcodes(options);
        return barcodes;
    }

    public ApiResult doCustomService(Map<String, Object> params) {
        List<BarcodeGenerateOption> options;
        Long ruleID;
        ApiResult result = null;
        Long orgID = this.getLong(params, "orgid");
        result = this.checkParams(orgID, ruleID = this.getLong(params, "ruleid"), options = this.getOptions(params));
        if (result != null) {
            return result;
        }
        try {
            List<BarcodeGenerated> barcodes = this.callService(orgID, ruleID, options);
            LOGGER.info("barcode api, generateSave");
            result = ApiResult.success(barcodes);
        }
        catch (KDBizException e) {
            LOGGER.error("barcode api, generate failed", (Throwable)e);
            result = ApiResult.ex((Throwable)e);
            result.setMessage(e.getStackTraceMessage());
        }
        return result;
    }
}

