/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.barcode.webapi;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bd.barcode.servicehelper.BarcodeServiceHelper;
import kd.bd.barcode.webapi.AbstractBarcodeApiPlugin;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.api.ApiResult;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.StringUtils;

public class BarcodeParseApiPlugin
extends AbstractBarcodeApiPlugin {
    private static final String K_BARCODES = "barcodes";
    private static final String K_FORMID = "formid";
    private static final String K_METHOD = "method";
    private static final Log LOGGER = LogFactory.getLog(BarcodeParseApiPlugin.class);
    private static final String PARSE_BY_RULE = "parseByRule";
    private static final String PARSE_BY_ENTITY = "parseByEntity";

    private ApiResult checkParams(String method, String entityKey, Long orgID, Long ruleID, List<String> barcodes) {
        ApiResult result = null;
        if (StringUtils.isEmpty((String)method)) {
            result = ApiResult.fail((String)this.getNotNullMessage(K_METHOD));
        } else {
            boolean fParseByEntity = PARSE_BY_ENTITY.equalsIgnoreCase(method);
            boolean fParseByRule = PARSE_BY_RULE.equalsIgnoreCase(method);
            if (barcodes == null || barcodes.isEmpty()) {
                result = ApiResult.fail((String)this.getNotNullMessage(K_BARCODES));
            } else if (fParseByEntity && StringUtils.isEmpty((String)entityKey)) {
                result = ApiResult.fail((String)this.getNotNullMessage(K_FORMID));
            } else if (fParseByRule && ruleID == null) {
                result = ApiResult.fail((String)this.getNotNullMessage("ruleid"));
            }
        }
        return result;
    }

    private List<String> getBarcodes(Map<String, Object> params) {
        JSONArray jArr;
        ArrayList<String> barcodes = new ArrayList<String>();
        String barcodesStr = JSON.toJSONString((Object)params.get(K_BARCODES));
        if (!StringUtils.isEmpty((String)barcodesStr) && (jArr = JSON.parseArray((String)barcodesStr)) != null && !jArr.isEmpty()) {
            for (Object b : jArr) {
                barcodes.add((String)b);
            }
        }
        return barcodes;
    }

    private DynamicObjectCollection callService(String method, Long orgID, Long ruleID, String entityKey, List<String> barcodes) {
        DynamicObjectCollection bizObjs = null;
        if (PARSE_BY_ENTITY.equalsIgnoreCase(method)) {
            bizObjs = BarcodeServiceHelper.parseBarcodes(barcodes, (String)entityKey, (Long)orgID);
        } else if (PARSE_BY_RULE.equalsIgnoreCase(method)) {
            bizObjs = BarcodeServiceHelper.parseBarcodesByRule(barcodes, (Long)ruleID, (Long)orgID);
        }
        return bizObjs;
    }

    public ApiResult doCustomService(Map<String, Object> params) {
        List<String> barcodes;
        Long ruleID;
        Long orgID;
        String entityKey;
        ApiResult result = null;
        String method = (String)params.get(K_METHOD);
        result = this.checkParams(method, entityKey = (String)params.get(K_FORMID), orgID = this.getLong(params, "orgid"), ruleID = this.getLong(params, "ruleid"), barcodes = this.getBarcodes(params));
        if (result != null) {
            return result;
        }
        try {
            DynamicObjectCollection bizObjs = this.callService(method, orgID, ruleID, entityKey, barcodes);
            result = ApiResult.success((Object)bizObjs);
        }
        catch (KDBizException e) {
            LOGGER.error("barcode api, parse failed", (Throwable)e);
            result = ApiResult.ex((Throwable)e);
            result.setMessage(e.getStackTraceMessage());
        }
        return result;
    }
}

