/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.mpdm.webapi;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.openapi.common.result.CustomApiResult;

public class MmcCommonOpenApiService
implements Serializable {
    public char validateLegalString(String content) {
        String illegal = "`~!#%^&*=+\\|{};:'\"<>/?\u25cb\u25cf\u2605\u2606\u2640\u2642\u203b\u00a4\u306e";
        char isLegalChar = 't';
        block0: for (int i = 0; i < content.length(); ++i) {
            for (int j = 0; j < illegal.length(); ++j) {
                if (content.charAt(i) != illegal.charAt(j)) continue;
                isLegalChar = content.charAt(i);
                break block0;
            }
        }
        return isLegalChar;
    }

    public Set<String> getFieldSet(String selectfields) {
        String[] fieldStr = selectfields.split(",");
        HashSet<String> dataSet = new HashSet<String>(fieldStr.length);
        Collections.addAll(dataSet, fieldStr);
        return dataSet;
    }

    public Set<Long> getIdSet(String orderids) {
        String[] idStr = orderids.split(",");
        HashSet<Long> idSet = new HashSet<Long>(idStr.length);
        for (String ids : idStr) {
            idSet.add(Long.valueOf(ids));
        }
        return idSet;
    }

    public OperateOption getOperateOption() {
        OperateOption option = OperateOption.create();
        option.setVariableValue("ishasright", "true");
        option.setVariableValue("ignorewarn", "true");
        option.setVariableValue("ignoreinteraction", "true");
        return option;
    }

    private String getErrorByOrderId(Object orderID, OperationResult operationResult) {
        StringBuilder errorString = new StringBuilder("error:");
        for (IOperateInfo errInfo : operationResult.getAllErrorOrValidateInfo()) {
            if (!errInfo.getPkValue().toString().equals(orderID.toString())) continue;
            errorString.append(" ");
            errorString.append(errInfo.getMessage());
        }
        return errorString.toString();
    }

    public Map<String, Object> genOperationReslt(OperationResult operationResult, Set<Long> idSet) {
        HashMap<Object, String> operationMap = new HashMap<Object, String>(1);
        HashSet operationSuccessIds = new HashSet(operationResult.getSuccessPkIds());
        int successfulCount = 0;
        int errorCount = 0;
        for (Long id : idSet) {
            if (!operationSuccessIds.contains(id)) {
                operationMap.put(id, this.getErrorByOrderId(id, operationResult));
                ++errorCount;
                continue;
            }
            operationMap.put(id, "successful");
            ++successfulCount;
        }
        operationMap.put("successfulCount", String.valueOf(successfulCount));
        operationMap.put("errorCount", String.valueOf(errorCount));
        HashMap<String, Object> returnMap = new HashMap<String, Object>(16);
        returnMap.put("returnString", SerializationUtils.toJsonString(operationMap));
        returnMap.put("errorCount", errorCount);
        returnMap.put("successfulCount", successfulCount);
        return returnMap;
    }

    public CustomApiResult<String> genCustomApiResult(Map<String, Object> messageMap) {
        String messages = messageMap.get("message") == null ? "" : messageMap.get("message").toString();
        boolean isSuccess = (Boolean)messageMap.get("success");
        CustomApiResult result = null;
        if (isSuccess) {
            result = CustomApiResult.success((Object)messages);
            result.setData((Object)messages);
        } else {
            result = CustomApiResult.fail((String)messageMap.get("errorcode").toString(), (String)messages);
        }
        return result;
    }
}

