/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.mpdm.report.tpl;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.report.IReportView;
import kd.bos.report.filter.ReportFilter;
import kd.bos.report.plugin.AbstractReportFormPlugin;
import kd.bos.servicehelper.QueryServiceHelper;
import org.apache.commons.lang3.StringUtils;

public class HistoryProjectHourRptPlugin
extends AbstractReportFormPlugin {
    private static final String PAGESEQ = "spageseq";
    private static final String PAGESUMHOURS = "pagesumhours";
    private static final String SALEHOURS = "salehours";
    private static final String CUSTOMESUMHOURS = "customesumhours";
    private static final String PAGEREMARK = "pageremark";
    private static final String PAGEMODIFIER = "pagemodifier";
    private static final String PAGEMODIFYDATE = "pagemodifydate";

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{PAGESEQ});
    }

    public void afterCreateNewData(EventObject e) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        List<Map<String, Object>> pageSeqMapList = this.queryWorkcardPageSeqInfo();
        this.getPageCache().put("pageSeqMapList", SerializationUtils.toJsonString(pageSeqMapList));
        if (customParams.containsKey("workcardpageseq")) {
            String workcardpageseq = customParams.get("workcardpageseq").toString();
            this.getModel().setValue(PAGESEQ, (Object)workcardpageseq);
            for (Map<String, Object> map : pageSeqMapList) {
                if (!workcardpageseq.equals(map.get(PAGESEQ).toString())) continue;
                this.setPageSeqInfo(map);
                break;
            }
        } else if (pageSeqMapList.size() > 0) {
            this.getModel().setValue(PAGESEQ, pageSeqMapList.get(0).get(PAGESEQ));
            this.setPageSeqInfo(pageSeqMapList.get(0));
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        ReportFilter filter = (ReportFilter)this.getControl("reportfilterap");
        filter.search();
    }

    public void beforeQuery(ReportQueryParam queryParam) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        if (!customParams.containsKey("workcardid")) {
            return;
        }
        String workcardid = customParams.get("workcardid").toString();
        queryParam.getCustomParam().put("workcardid", workcardid);
    }

    public boolean verifyQuery(ReportQueryParam queryParam) {
        IDataModel model = this.getModel();
        String pageseq = (String)model.getValue(PAGESEQ);
        if (StringUtils.isBlank((CharSequence)pageseq)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u9875\u7801\u4e0d\u5141\u8bb8\u4e3a\u7a7a\u3002", (String)"HistoryProjectHourRptPlugin_0", (String)"bd-mpdm-report", (Object[])new Object[0]));
            return false;
        }
        return super.verifyQuery(queryParam);
    }

    private List<Map<String, Object>> queryWorkcardPageSeqInfo() {
        ArrayList<Map<String, Object>> pageseqMapList = new ArrayList<Map<String, Object>>(10);
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        if (customParams.containsKey("workcardid")) {
            String workcardid = customParams.get("workcardid").toString();
            QFilter qFilter = new QFilter("id", "=", (Object)Long.parseLong(workcardid));
            qFilter.and(new QFilter("pageentity.pageseq", "is not null", null));
            try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"queryWorkcardPageSeq", (String)"mpdm_mrocardroute", (String)"pageentity.pageseq,pageentity.pagesumhours,pageentity.salehours,pageentity.customesumhours,pageentity.pageremark,pageentity.pagemodifier,pageentity.pagemodifydate", (QFilter[])new QFilter[]{qFilter}, (String)"pageentity.seq");){
                while (dataSet.hasNext()) {
                    Row row = dataSet.next();
                    HashMap<String, Object> map = new HashMap<String, Object>(5);
                    map.put(PAGESEQ, row.get("pageentity.pageseq"));
                    map.put(PAGESUMHOURS, row.get("pageentity.pagesumhours"));
                    map.put(SALEHOURS, row.get("pageentity.salehours"));
                    map.put(CUSTOMESUMHOURS, row.get("pageentity.customesumhours"));
                    map.put(PAGEREMARK, row.get("pageentity.pageremark"));
                    map.put(PAGEMODIFIER, row.get("pageentity.pagemodifier"));
                    map.put(PAGEMODIFYDATE, row.get("pageentity.pagemodifydate"));
                    pageseqMapList.add(map);
                }
            }
        }
        return pageseqMapList;
    }

    private void setPageSeqInfo(Map<String, Object> map) {
        this.getModel().setValue(PAGESUMHOURS, map.get(PAGESUMHOURS));
        this.getModel().setValue(SALEHOURS, map.get(SALEHOURS));
        this.getModel().setValue(CUSTOMESUMHOURS, map.get(CUSTOMESUMHOURS));
        this.getModel().setValue(PAGEREMARK, map.get(PAGEREMARK));
        this.getModel().setValue(PAGEMODIFIER, map.get(PAGEMODIFIER));
        this.getModel().setValue(PAGEMODIFYDATE, map.get(PAGEMODIFYDATE));
    }

    public void click(EventObject event) {
        super.click(event);
        if (event == null) {
            return;
        }
        Object srcObj = event.getSource();
        Control srcC = srcObj instanceof Control ? (Control)srcObj : null;
        String srcKey = srcC == null ? null : srcC.getKey();
        IReportView fv = this.getView();
        if (fv == null) {
            return;
        }
        if (kd.bos.util.StringUtils.isBlank((String)srcKey)) {
            return;
        }
        if (PAGESEQ.equalsIgnoreCase(srcKey) && StringUtils.isNotBlank((CharSequence)this.getPageCache().get("pageSeqMapList"))) {
            List pageseqMapList = (List)JSON.parse((String)this.getPageCache().get("pageSeqMapList"));
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("list", pageseqMapList);
            params.put("formId", "mpdm_workcardpageseq_f7");
            FormShowParameter showParameter = FormShowParameter.createFormShowParameter(params);
            showParameter.getOpenStyle().setShowType(ShowType.Modal);
            showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "workcardpageseqf7"));
            fv.showForm(showParameter);
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        Object returnData = closedCallBackEvent.getReturnData();
        if (returnData == null) {
            return;
        }
        switch (closedCallBackEvent.getActionId()) {
            case "workcardpageseqf7": {
                Map result = (Map)returnData;
                this.getModel().setValue(PAGESEQ, result.get("pageseq"));
                if (StringUtils.isNotBlank((CharSequence)this.getPageCache().get("pageSeqMapList"))) {
                    List pageseqMapList = (List)JSON.parse((String)this.getPageCache().get("pageSeqMapList"));
                    for (Map map : pageseqMapList) {
                        if (!result.get("pageseq").toString().equals(map.get(PAGESEQ).toString())) continue;
                        this.setPageSeqInfo(map);
                        break;
                    }
                }
                ReportFilter filter = (ReportFilter)this.getControl("reportfilterap");
                filter.search();
                break;
            }
        }
    }
}

