/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.mpdm.report.tpl;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bd.mpdm.common.mftorder.utils.MPDMMftGenStocksUtils;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataSetBuilder;
import kd.bos.algo.Field;
import kd.bos.algo.GroupbyDataSet;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.dataset.AbstractDataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.AbstractReportListDataPlugin;
import kd.bos.entity.report.ColumnStyle;
import kd.bos.entity.report.DecimalReportColumn;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportColumn;
import kd.bos.entity.report.ReportColumnGroup;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import org.apache.commons.lang3.StringUtils;

public class HistoryProjectHourRptQuery
extends AbstractReportListDataPlugin {
    private static final Log logger = LogFactory.getLog(HistoryProjectHourRptQuery.class);
    private Set<String> pnumberList = new HashSet<String>(16);

    public DataSet query(ReportQueryParam arg0, Object arg1) throws Throwable {
        DataSet projectHourDataSet;
        ArrayList<QFilter> qfList = new ArrayList<QFilter>(10);
        if (!arg0.getCustomParam().containsKey("workcardid")) {
            return Algo.create((String)HistoryProjectHourRptQuery.class.getName()).createDataSetBuilder(new RowMeta(new Field[0])).build();
        }
        String workcardid = arg0.getCustomParam().get("workcardid").toString();
        if (StringUtils.isNotBlank((CharSequence)workcardid)) {
            qfList.add(new QFilter("treeentryentity.workcard", "=", (Object)Long.parseLong(workcardid)));
        }
        FilterInfo filter = this.getQueryParam().getFilter();
        String pageseq = filter.getString("spageseq");
        qfList.add(new QFilter("treeentryentity.pageseq", "=", (Object)pageseq));
        int projectRange = filter.getInt("projectrange");
        DataSet cardDataSet = this.getCardDataSet(workcardid, pageseq);
        Set<Long> projectIdSet = this.getOrderProjectDataSet(qfList, projectRange);
        DataSet manftechDataSet = this.getManftechDataSet(workcardid, pageseq, projectIdSet);
        DataSet professionaDataSet = cardDataSet.select("professiona").union(manftechDataSet.select("oprprofessiona professiona")).distinct().select(pageseq + " as pageseq,professiona,10 unitid");
        if (null != professionaDataSet) {
            cardDataSet = professionaDataSet.leftJoin(cardDataSet).on("professiona", "professiona").select(cardDataSet.getRowMeta().getFieldNames()).finish();
            professionaDataSet.close();
        }
        if (null != (projectHourDataSet = this.getProjectHourDataSet(manftechDataSet))) {
            cardDataSet = cardDataSet.leftJoin(projectHourDataSet).on("professiona", "fprofessiona").select(cardDataSet.getRowMeta().getFieldNames(), projectHourDataSet.getRowMeta().getFieldNames()).finish();
            projectHourDataSet.close();
        }
        return cardDataSet;
    }

    public List<AbstractReportColumn> getColumns(List<AbstractReportColumn> columns) throws Throwable {
        List oldColumns = super.getColumns(columns);
        ArrayList<AbstractReportColumn> newColumns = new ArrayList<AbstractReportColumn>(oldColumns.size() + this.pnumberList.size());
        newColumns.addAll(oldColumns);
        if (this.pnumberList.size() == 1) {
            ReportColumn reportColumn = this.createColumnQty(this.pnumberList.iterator().next(), "unitid");
            newColumns.add((AbstractReportColumn)reportColumn);
        } else {
            ReportColumnGroup reportColumnGroup = this.createProjectGroup(ResManager.loadKDString((String)"\u5386\u53f2\u9879\u76ee\u8303\u56f4", (String)"HistoryProjectHourRptQuery_0", (String)"bd-mpdm-report", (Object[])new Object[0]), "project");
            newColumns.add((AbstractReportColumn)reportColumnGroup);
        }
        return newColumns;
    }

    private ReportColumnGroup createProjectGroup(String groupName, String number) {
        ReportColumnGroup reportColumnGroup = new ReportColumnGroup();
        reportColumnGroup.setCaption(new LocaleString(groupName));
        reportColumnGroup.setFieldKey(number);
        List recColumns = reportColumnGroup.getChildren();
        for (String pnumber : this.pnumberList) {
            recColumns.add(this.createColumnQty(pnumber, "unitid"));
        }
        return reportColumnGroup;
    }

    private ReportColumn createColumnQty(String projectInfo, String unitKey) {
        DecimalReportColumn column = new DecimalReportColumn();
        column.setFieldKey("F" + projectInfo.split("#")[0]);
        column.setCaption(new LocaleString(projectInfo.split("#")[1]));
        column.setFieldType("qty");
        column.setMeasureUnitField(unitKey);
        column.setSummary(1);
        ColumnStyle columnStyle = new ColumnStyle();
        columnStyle.setTextAlign("right");
        column.setStyle(columnStyle);
        return column;
    }

    private DataSet getCardDataSet(String workcardid, String pageseq) {
        QFilter qFilter = new QFilter("id", "=", (Object)Long.parseLong(workcardid));
        qFilter.and(new QFilter("processentry.pageseq1", "=", (Object)pageseq));
        DataSet cardDataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"mpdm_mrocardroute", (String)"processentry.professiona professiona,processentry.standardhours standardhours", (QFilter[])new QFilter[]{qFilter}, null);
        GroupbyDataSet groupBy = cardDataSet.groupBy(new String[]{"professiona"});
        cardDataSet = groupBy.sum("standardhours").finish();
        return cardDataSet.select(pageseq + " as pageseq,professiona,standardhours,10 unitid");
    }

    private Set<Long> getOrderProjectDataSet(List<QFilter> qfList, int projectRange) {
        qfList.add(new QFilter("treeentryentity.project.prjstate", "=", (Object)696208292405629952L));
        DataSet queryDataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"pom_mroorder", (String)"treeentryentity.project pid,treeentryentity.project.number pnumber,treeentryentity.project.devices.name dname", (QFilter[])qfList.toArray(new QFilter[0]), (String)"treeentryentity.endworktime desc");
        HashSet<Long> projectSet = new HashSet<Long>(16);
        for (Row row : queryDataSet) {
            if (projectSet.size() >= projectRange) break;
            String devicesInfo = null == row.getString("dname") ? " " : "/" + row.getString("dname");
            this.pnumberList.add(row.getString("pid") + "#" + row.getString("pnumber") + devicesInfo);
            projectSet.add(row.getLong("pid"));
        }
        return projectSet;
    }

    private DataSet getManftechDataSet(String workcardid, String pageseq, Set<Long> projectIdSet) {
        QFilter qFilter = new QFilter("workcard", "=", (Object)Long.parseLong(workcardid));
        qFilter.and(new QFilter("pageseq", "=", (Object)pageseq));
        qFilter.and(new QFilter("project", "in", projectIdSet));
        qFilter.and(new QFilter("oprentryentity.oprprofessiona", "!=", (Object)0));
        DataSet manftechDataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"sfc_mromanuftech", (String)"project,oprentryentity.oprprofessiona oprprofessiona,oprentryentity.opreffectivehours opreffectivehours", (QFilter[])new QFilter[]{qFilter}, null);
        return manftechDataSet;
    }

    private DataSet getProjectHourDataSet(DataSet manftechDataSet) {
        DataSet ds = null;
        GroupbyDataSet groupBy = manftechDataSet.groupBy(new String[]{"project", "oprprofessiona"});
        manftechDataSet = groupBy.sum("opreffectivehours").finish();
        try {
            List<Map<String, Object>> childList = this.parseToList(manftechDataSet);
            logger.info("\u68c0\u4fee\u5de5\u5e8f\u8ba1\u5212\u6839\u636e\u9879\u76ee\u53f7\u4e0e\u884c\u4e1a\u5206\u7ec4:" + childList.toString());
            if (!childList.isEmpty()) {
                HashMap returnMap = new HashMap(16);
                for (int i = 0; i < childList.size(); ++i) {
                    Map<String, Object> map = childList.get(i);
                    if (returnMap.containsKey(map.get("oprprofessiona").toString())) {
                        ((Map)returnMap.get(map.get("oprprofessiona").toString())).put(map.get("project").toString(), map.get("opreffectivehours"));
                        continue;
                    }
                    HashMap<String, Object> newMap = new HashMap<String, Object>(16);
                    newMap.put("professiona", map.get("oprprofessiona"));
                    newMap.put(map.get("project").toString(), map.get("opreffectivehours"));
                    returnMap.put(map.get("oprprofessiona").toString(), newMap);
                }
                ArrayList<Map<String, Object>> retList = new ArrayList<Map<String, Object>>(returnMap.values());
                this.getAvghours(retList);
                logger.info("\u9879\u76ee\u5386\u53f2\u8303\u56f4\u5e73\u5747\u503c:" + ((Object)retList).toString());
                DataSet globalDataSet = DB.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (DBRoute)DBRoute.of((String)"scm"), (String)this.getProjectSql());
                RowMeta rowMeta = globalDataSet.getRowMeta();
                ds = this.parseToDataSet((Object)this, retList, rowMeta);
            }
        }
        catch (Exception e) {
            logger.info("\u6839\u636e\u884c\u4e1a\u3001\u9879\u76ee\u53f7\u67e5\u8be2\u6709\u6548\u5de5\u65f6\u7ec4\u88c5\u6570\u636e\u51fa\u9519\uff1a" + e.getMessage());
            throw e;
        }
        finally {
            manftechDataSet.close();
        }
        return ds;
    }

    protected void getAvghours(List<Map<String, Object>> retList) {
        DynamicObject unit = BusinessDataServiceHelper.loadSingleFromCache((Object)10L, (String)"bd_measureunits");
        for (Map<String, Object> hmap : retList) {
            BigDecimal count = BigDecimal.ZERO;
            BigDecimal avghours = BigDecimal.ZERO;
            for (Map.Entry<String, Object> entry : hmap.entrySet()) {
                String key = entry.getKey();
                if (key.equalsIgnoreCase("professiona") || BigDecimal.ZERO.compareTo((BigDecimal)entry.getValue()) == 0) continue;
                avghours = avghours.add((BigDecimal)entry.getValue());
                count = count.add(BigDecimal.ONE);
            }
            if (avghours.compareTo(BigDecimal.ZERO) != 0) {
                int precision = unit.getInt("precision");
                avghours = avghours.divide(count, precision, MPDMMftGenStocksUtils.getRoundType((DynamicObject)unit));
            }
            hmap.put("avghours", avghours);
        }
    }

    protected String getProjectSql() {
        StringBuilder fields = new StringBuilder("select 1000000000000000000 as fprofessiona");
        for (String pnumber : this.pnumberList) {
            fields.append(",0.000000000 as f").append(pnumber.split("#")[0]);
        }
        fields.append(",0.000000000 as avghours from t_mpdm_mrocardroute where fid = -1");
        return fields.toString();
    }

    private DataSet parseToDataSet(Object plugin, List<Map<String, Object>> list, RowMeta rowMeta) {
        Algo algo = Algo.create((String)plugin.getClass().getName());
        DataSetBuilder builder = algo.createDataSetBuilder(rowMeta);
        String[] names = rowMeta.getFieldNames();
        for (int i = 0; i < list.size(); ++i) {
            Map<String, Object> map = list.get(i);
            Object[] objArray = new Object[names.length];
            for (int k = 0; k < names.length; ++k) {
                Object value;
                String fiedName = names[k];
                objArray[k] = "fprofessiona".equalsIgnoreCase(fiedName) ? (value = map.get("professiona")) : ("avghours".equalsIgnoreCase(fiedName) ? (value = map.get("avghours")) : (map.containsKey(fiedName.split("F")[1]) ? (value = map.get(fiedName.split("F")[1])) : Integer.valueOf(0)));
            }
            builder.append(objArray);
        }
        AbstractDataSet dateSet = (AbstractDataSet)builder.build();
        return dateSet;
    }

    private List<Map<String, Object>> parseToList(DataSet dateSet) {
        List<Map<String, Object>> list = Collections.synchronizedList(new ArrayList(10));
        if (dateSet == null) {
            return list;
        }
        String[] fieldNames = dateSet.getRowMeta().getFieldNames();
        while (dateSet.hasNext()) {
            Row row = dateSet.next();
            Map<String, Object> map = Collections.synchronizedMap(new HashMap(16));
            for (int i = 0; i < fieldNames.length; ++i) {
                String key = fieldNames[i];
                Object value = row.get(key);
                map.put(key, value);
            }
            if (map.isEmpty()) continue;
            list.add(map);
        }
        return list;
    }
}

