/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.mpdm.report.tpl;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.GroupbyDataSet;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.AbstractReportListDataPlugin;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportColumn;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;

public class MaterialDifferenceRptQuery
extends AbstractReportListDataPlugin {
    private final List<String> group_A = new ArrayList<String>(1){
        private static final long serialVersionUID = 1L;
        {
            this.add("transactiontypeid.transactiontype e_biztype");
        }
    };
    private final List<String> group_B = new ArrayList<String>(2){
        private static final long serialVersionUID = 1L;
        {
            this.add("transactiontypeid.transactiontype e_biztype");
            this.add("transactiontypeid e_transactproduct");
        }
    };
    private final List<String> group_C = new ArrayList<String>(1){
        private static final long serialVersionUID = 1L;
        {
            this.add("orderentryid.supplier e_supplier");
        }
    };
    private final List<String> group_D = new ArrayList<String>(1){
        private static final long serialVersionUID = 1L;
        {
            this.add("org e_org");
            this.add("orderentryid.producedept e_producedept");
        }
    };
    private final List<String> group_E = new ArrayList<String>(3){
        private static final long serialVersionUID = 1L;
        {
            this.add("orderentryid.material e_product");
            this.add("orderentryid.unit e_unit");
            this.add("orderentryid.baseunit e_baseunit");
        }
    };
    private final List<String> group_F = new ArrayList<String>(9){
        private static final long serialVersionUID = 1L;
        {
            this.add("stockentry.materialid e_material");
            this.add("stockentry.materialunitid e_materialbaseunit");
            this.add("bdproject e_bdproject");
            this.add("tracknumber e_tracknumber");
        }
    };
    private final List<String> group_I = new ArrayList<String>(1){
        private static final long serialVersionUID = 1L;
        {
            this.add("transactiontypeid.transactiontype e_biztype");
            this.add("transactiontypeid e_transactproduct");
            this.add("org e_org");
            this.add("orderentryid.producedept e_producedept");
            this.add("orderentryid.material e_product");
            this.add("orderentryid.unit e_unit");
            this.add("orderentryid.baseunit e_baseunit");
            this.add("orderentryid.headbillno e_order");
            this.add("orderentryid.entryseq e_orderrow");
        }
    };
    private final List<String> selectQtyList = new ArrayList<String>(1){
        private static final long serialVersionUID = 1L;
        {
            this.add("stockentry.standqty e_standqty");
            this.add("stockentry.demandqty e_demandqty");
            this.add("stockentry.actissueqty e_actissueqty");
            this.add("stockentry.rejectedqty e_rejectedqty");
            this.add("stockentry.feedingqty e_feedingqty");
            this.add("stockentry.unissueqty e_difference");
        }
    };
    private final Map<String, List<String>> groupFieldsMap = new HashMap<String, List<String>>(){
        private static final long serialVersionUID = 1L;
        {
            this.put("A", MaterialDifferenceRptQuery.this.group_A);
            this.put("B", MaterialDifferenceRptQuery.this.group_B);
            this.put("C", MaterialDifferenceRptQuery.this.group_C);
            this.put("D", MaterialDifferenceRptQuery.this.group_D);
            this.put("E", MaterialDifferenceRptQuery.this.group_E);
            this.put("F", MaterialDifferenceRptQuery.this.group_F);
            this.put("I", MaterialDifferenceRptQuery.this.group_I);
        }
    };
    private final List<String> type_A = new ArrayList<String>(1){
        private static final long serialVersionUID = 1L;
        {
            this.add("e_biztype");
        }
    };
    private final List<String> type_B = new ArrayList<String>(1){
        private static final long serialVersionUID = 1L;
        {
            this.add("e_biztype");
            this.add("e_transactproduct");
        }
    };
    private final List<String> type_C = new ArrayList<String>(1){
        private static final long serialVersionUID = 1L;
        {
            this.add("e_supplier");
            this.add("e_suppliername");
        }
    };
    private final List<String> type_D = new ArrayList<String>(1){
        private static final long serialVersionUID = 1L;
        {
            this.add("e_org");
            this.add("e_producedept");
        }
    };
    private final List<String> type_E = new ArrayList<String>(1){
        private static final long serialVersionUID = 1L;
        {
            this.add("e_product");
            this.add("e_productnumber");
            this.add("e_productname");
            this.add("e_productmodel");
            this.add("e_unit");
            this.add("e_baseunit");
        }
    };
    private final List<String> type_F = new ArrayList<String>(1){
        private static final long serialVersionUID = 1L;
        {
            this.add("e_material");
            this.add("e_materialnumber");
            this.add("e_materialname");
            this.add("e_materialmodel");
            this.add("e_materialbaseunit");
            this.add("e_bdproject");
            this.add("e_tracknumber");
        }
    };
    private final List<String> type_I = new ArrayList<String>(1){
        private static final long serialVersionUID = 1L;
        {
            this.add("e_org");
            this.add("e_producedept");
            this.add("e_product");
            this.add("e_productname");
            this.add("e_productmodel");
            this.add("e_unit");
            this.add("e_baseunit");
            this.add("e_order");
            this.add("e_orderrow");
            this.add("e_biztype");
            this.add("e_transactproduct");
        }
    };
    private final List<String> otherFields = new ArrayList<String>(1){
        private static final long serialVersionUID = 1L;
        {
            this.add("e_standqty");
            this.add("e_demandqty");
            this.add("e_actissueqty");
            this.add("e_rejectedqty");
            this.add("e_feedingqty");
            this.add("e_difference");
            this.add("e_differenceratio");
        }
    };
    private final Map<String, List<String>> fieldsMap = new HashMap<String, List<String>>(){
        private static final long serialVersionUID = 1L;
        {
            this.put("A", MaterialDifferenceRptQuery.this.type_A);
            this.put("B", MaterialDifferenceRptQuery.this.type_B);
            this.put("C", MaterialDifferenceRptQuery.this.type_C);
            this.put("D", MaterialDifferenceRptQuery.this.type_D);
            this.put("E", MaterialDifferenceRptQuery.this.type_E);
            this.put("F", MaterialDifferenceRptQuery.this.type_F);
            this.put("I", MaterialDifferenceRptQuery.this.type_I);
        }
    };

    public DataSet query(ReportQueryParam arg0, Object arg1) throws Throwable {
        List<QFilter> qfList = this.appendFilter();
        Set<String> groupFieldsSet = this.getGroupFields();
        String sql = this.getSelectFields(groupFieldsSet);
        DataSet queryDataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)arg0.getCustomParam().get("stock").toString(), (String)sql.substring(1), (QFilter[])qfList.toArray(new QFilter[0]), null);
        ArrayList<String> showFields = new ArrayList<String>(10);
        DataSet finish = this.getGroupDataSet(queryDataSet, groupFieldsSet, showFields);
        return this.getDataSet(finish, showFields);
    }

    private DataSet getDataSet(DataSet finish, List<String> showFields) {
        StringBuilder select = new StringBuilder();
        showFields.forEach(s -> select.append(',').append((String)s));
        String str = select.toString();
        if (str.length() > 1) {
            String substring = str.substring(1);
            String e_differenceratio = ",(case when e_demandqty=0 then 0 else e_difference/e_demandqty * 100 end) e_differenceratio";
            finish = finish.select(substring + e_differenceratio);
        }
        if (this.getQueryParam().getSortInfo() != null) {
            finish = finish.orderBy(new String[]{this.getQueryParam().getSortInfo()});
        }
        return finish;
    }

    private DataSet getGroupDataSet(DataSet queryDataSet, Set<String> groupFieldsSet, List<String> showFields) {
        LinkedHashSet set = new LinkedHashSet(10);
        groupFieldsSet.forEach(s -> {
            String substring = s.substring(s.indexOf("e_"), s.length());
            set.add(substring);
            showFields.add(substring);
        });
        GroupbyDataSet groupBy = queryDataSet.groupBy(set.toArray(new String[0]));
        this.selectQtyList.forEach(c -> {
            String substring = c.substring(c.indexOf("e_"), c.length());
            groupBy.sum(substring);
            showFields.add(substring);
        });
        return groupBy.finish();
    }

    private String getSelectFields(Set<String> groupFieldsSet) {
        LinkedHashSet<String> allFieldsSet = new LinkedHashSet<String>();
        allFieldsSet.addAll(groupFieldsSet);
        allFieldsSet.addAll(this.selectQtyList);
        StringBuilder sql = new StringBuilder();
        allFieldsSet.forEach(field -> sql.append(',').append((String)field));
        return sql.toString();
    }

    private List<QFilter> appendFilter() {
        FilterInfo filter = this.getQueryParam().getFilter();
        ArrayList<QFilter> qfList = new ArrayList<QFilter>();
        qfList.add(new QFilter("orderentryid.producttype", "=", (Object)"C"));
        this.appendOrgFilter(filter, qfList);
        this.appendBiztypeFilter(filter, qfList);
        this.appendProductTypeFilter(filter, qfList);
        this.appendStartTimeFilter(filter, qfList);
        this.appendFinishTimeFilter(filter, qfList);
        this.appendPorductDeptFilter(filter, qfList);
        this.appendOrderFilter(filter, qfList);
        this.appendSupplierFilter(filter, qfList);
        this.appendMaterialFilter(filter, qfList);
        this.appendBizStatusFilter(filter, qfList);
        this.appendPlanStatusFilter(filter, qfList);
        this.appendTaskStatusFilter(filter, qfList);
        this.appendBillStatusFilter(filter, qfList);
        this.appendPickStatusFilter(filter, qfList);
        this.appendStockFilter(filter, qfList);
        this.appendProjectFilter(filter, qfList);
        this.appendTrackNumberFilter(filter, qfList);
        return qfList;
    }

    private Set<String> getGroupFields() {
        String[] split = this.getQueryParam().getFilter().getString("grouptype").substring(1, this.getQueryParam().getFilter().getString("grouptype").length() - 1).split(",");
        LinkedHashSet<String> groupFieldsSet = new LinkedHashSet<String>();
        for (String s : split) {
            groupFieldsSet.addAll((Collection<String>)this.groupFieldsMap.get(s));
        }
        groupFieldsSet.addAll((Collection)this.groupFieldsMap.get("F"));
        return groupFieldsSet;
    }

    private void appendStockFilter(FilterInfo filter, List<QFilter> qfList) {
        if (filter.getDynamicObjectCollection("material") != null) {
            if (filter.getDynamicObjectCollection("material").size() == 1) {
                qfList.add(new QFilter("stockentry.materialid", ">=", ((DynamicObject)filter.getDynamicObjectCollection("material").get(0)).getPkValue()));
            } else {
                HashSet idSet = new HashSet(filter.getDynamicObjectCollection("material").size());
                filter.getDynamicObjectCollection("material").forEach(obj -> idSet.add(obj.getPkValue()));
                qfList.add(new QFilter("stockentry.materialid", "in", idSet));
            }
        }
        if (filter.getDynamicObject("materialto") != null) {
            qfList.add(new QFilter("stockentry.materialid", "<=", filter.getDynamicObject("materialto").getPkValue()));
        }
    }

    private void appendOrgFilter(FilterInfo filter, List<QFilter> qfList) {
        qfList.add(new QFilter("org", "=", filter.getDynamicObject("org").getPkValue()));
    }

    private void appendBiztypeFilter(FilterInfo filter, List<QFilter> qfList) {
        if (filter.getDynamicObjectCollection("biztype") != null) {
            HashSet idSet = new HashSet(filter.getDynamicObjectCollection("biztype").size());
            filter.getDynamicObjectCollection("biztype").forEach(obj -> idSet.add(obj.getPkValue()));
            qfList.add(new QFilter("transactiontypeid.transactiontype", "in", idSet));
        }
    }

    private void appendProductTypeFilter(FilterInfo filter, List<QFilter> qfList) {
        if (filter.getDynamicObjectCollection("transactproduct") != null) {
            HashSet idSet = new HashSet(filter.getDynamicObjectCollection("transactproduct").size());
            filter.getDynamicObjectCollection("transactproduct").forEach(obj -> idSet.add(obj.getPkValue()));
            qfList.add(new QFilter("transactiontypeid", "in", idSet));
        }
    }

    private void appendSupplierFilter(FilterInfo filter, List<QFilter> qfList) {
        if (filter.getDynamicObjectCollection("supplier") != null) {
            HashSet idSet = new HashSet(filter.getDynamicObjectCollection("supplier").size());
            filter.getDynamicObjectCollection("supplier").forEach(obj -> idSet.add(obj.getPkValue()));
            qfList.add(new QFilter("orderentryid.supplier", "in", idSet));
        }
    }

    private void appendOrderFilter(FilterInfo filter, List<QFilter> qfList) {
        if (filter.getString("order") != null && !"".equals(filter.getString("order"))) {
            qfList.add(new QFilter("orderentryid.headbillno", ">=", (Object)filter.getString("order")));
        }
        if (filter.getString("orderto") != null && !"".equals(filter.getString("orderto"))) {
            qfList.add(new QFilter("orderentryid.headbillno", "<=", (Object)filter.getString("orderto")));
        }
    }

    private void appendStartTimeFilter(FilterInfo filter, List<QFilter> qfList) {
        Date beginDate = filter.getDate("begintime");
        Date endDate = filter.getDate("endtime");
        Calendar cal = Calendar.getInstance();
        cal.setTime(beginDate);
        cal.set(10, 0);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        qfList.add(new QFilter("orderentryid.planbegintime", ">=", (Object)cal.getTime()));
        cal.setTime(endDate);
        cal.set(10, 0);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        cal.add(5, 1);
        qfList.add(new QFilter("orderentryid.planbegintime", "<", (Object)cal.getTime()));
    }

    private void appendFinishTimeFilter(FilterInfo filter, List<QFilter> qfList) {
        if (filter.getDate("finishbegin") != null && filter.getDate("finishend") != null) {
            Date beginDate = filter.getDate("finishbegin");
            Date endDate = filter.getDate("finishend");
            Calendar cal = Calendar.getInstance();
            cal.setTime(beginDate);
            cal.set(10, 0);
            cal.set(11, 0);
            cal.set(12, 0);
            cal.set(13, 0);
            cal.set(14, 0);
            qfList.add(new QFilter("orderentryid.planendtime", ">=", (Object)cal.getTime()));
            cal.setTime(endDate);
            cal.set(10, 0);
            cal.set(11, 0);
            cal.set(12, 0);
            cal.set(13, 0);
            cal.set(14, 0);
            cal.add(5, 1);
            qfList.add(new QFilter("orderentryid.planendtime", "<", (Object)cal.getTime()));
        }
    }

    private void appendPorductDeptFilter(FilterInfo filter, List<QFilter> qfList) {
        if (filter.getDynamicObject("producedept") != null) {
            qfList.add(new QFilter("orderentryid.producedept", "=", filter.getDynamicObject("producedept").getPkValue()));
        }
    }

    private void appendMaterialFilter(FilterInfo filter, List<QFilter> qfList) {
        if (filter.getDynamicObjectCollection("product") != null) {
            if (filter.getDynamicObjectCollection("product").size() == 1) {
                qfList.add(new QFilter("orderentryid.material", ">=", ((DynamicObject)filter.getDynamicObjectCollection("product").get(0)).getPkValue()));
            } else {
                HashSet idSet = new HashSet(filter.getDynamicObjectCollection("product").size());
                filter.getDynamicObjectCollection("product").forEach(obj -> idSet.add(obj.getPkValue()));
                qfList.add(new QFilter("orderentryid.material", "in", idSet));
            }
        }
        if (filter.getDynamicObject("productto") != null) {
            qfList.add(new QFilter("orderentryid.material", "<=", filter.getDynamicObject("productto").getPkValue()));
        }
    }

    private void appendBillStatusFilter(FilterInfo filter, List<QFilter> qfList) {
        qfList.add(new QFilter("billstatus", "in", (Object)filter.getString("billstatus").substring(1, filter.getString("billstatus").length() - 1).split(",")));
    }

    private void appendTaskStatusFilter(FilterInfo filter, List<QFilter> qfList) {
        qfList.add(new QFilter("orderentryid.taskstatus", "in", (Object)filter.getString("taskstatus").substring(1, filter.getString("taskstatus").length() - 1).split(",")));
    }

    private void appendPlanStatusFilter(FilterInfo filter, List<QFilter> qfList) {
        qfList.add(new QFilter("orderentryid.planstatus", "in", (Object)filter.getString("planstatus").substring(1, filter.getString("planstatus").length() - 1).split(",")));
    }

    private void appendBizStatusFilter(FilterInfo filter, List<QFilter> qfList) {
        qfList.add(new QFilter("orderentryid.bizstatus", "in", (Object)filter.getString("bizstatus").substring(1, filter.getString("bizstatus").length() - 1).split(",")));
    }

    private void appendPickStatusFilter(FilterInfo filter, List<QFilter> qfList) {
        qfList.add(new QFilter("orderentryid.pickstatus", "in", (Object)filter.getString("pickstatus").substring(1, filter.getString("pickstatus").length() - 1).split(",")));
    }

    private void appendProjectFilter(FilterInfo filter, List<QFilter> qfList) {
        DynamicObjectCollection projects = filter.getDynamicObjectCollection("bdproject");
        if (projects != null) {
            List ids = projects.stream().map(DataEntityBase::getPkValue).collect(Collectors.toList());
            qfList.add(new QFilter("bdproject", "in", ids));
        }
    }

    private void appendTrackNumberFilter(FilterInfo filter, List<QFilter> qfList) {
        DynamicObjectCollection trackNumber = filter.getDynamicObjectCollection("tracknumber");
        if (trackNumber != null) {
            List ids = trackNumber.stream().map(DataEntityBase::getPkValue).collect(Collectors.toList());
            qfList.add(new QFilter("tracknumber", "in", ids));
        }
    }

    public List<AbstractReportColumn> getColumns(List<AbstractReportColumn> columns) throws Throwable {
        String[] split = this.getQueryParam().getFilter().getString("grouptype").substring(1, this.getQueryParam().getFilter().getString("grouptype").length() - 1).split(",");
        HashSet<String> set = new HashSet<String>(10);
        for (String s : split) {
            set.addAll((Collection)this.fieldsMap.get(s));
        }
        set.addAll((Collection)this.fieldsMap.get("F"));
        set.addAll(this.otherFields);
        List columns2 = super.getColumns(columns);
        Iterator iterator = columns2.iterator();
        while (iterator.hasNext()) {
            ReportColumn next = (ReportColumn)iterator.next();
            if (!set.contains(next.getFieldKey())) {
                iterator.remove();
                continue;
            }
            if ("om_mftorder".equals(this.getQueryParam().getCustomParam().get("order")) && "e_order".equals(next.getFieldKey())) {
                next.setCaption(new LocaleString(ResManager.loadKDString((String)"\u59d4\u5916\u5de5\u5355", (String)"MaterialDifferenceRptQuery_0", (String)"bd-mpdm-report", (Object[])new Object[0])));
                continue;
            }
            if (!"om_mftorder".equals(this.getQueryParam().getCustomParam().get("order")) || !"e_orderrow".equals(next.getFieldKey())) continue;
            next.setCaption(new LocaleString(ResManager.loadKDString((String)"\u59d4\u5916\u5de5\u5355\u884c\u53f7", (String)"MaterialDifferenceRptQuery_1", (String)"bd-mpdm-report", (Object[])new Object[0])));
        }
        return columns2;
    }
}

