/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.mpdm.report.tpl;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataSetBuilder;
import kd.bos.algo.DataType;
import kd.bos.algo.JoinType;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.RowMetaFactory;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.report.AbstractReportListDataPlugin;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;

public class MftOrderRequireDetailRptACQuery
extends AbstractReportListDataPlugin {
    public static final String algoKey = MftOrderRequireDetailRptACQuery.class.getName();
    public static final String[] otherFields = new String[]{"entryid", "requirebillno", "requirebillseq"};
    public static final String[] groupFields = new String[]{"stock_materialmaster", "manuentryid", "billformid", "entrybaseunit"};
    public static final DataType[] otherTypes = new DataType[]{DataType.LongType, DataType.StringType, DataType.StringType};

    public DataSet query(ReportQueryParam reportQueryParam, Object o) throws Throwable {
        String selectedProperty = this.getSelectFields();
        List<QFilter> qFilterList = this.createHeadFilters();
        qFilterList.add(new QFilter("orderentryid.producttype", "=", (Object)"C"));
        qFilterList.add(new QFilter("orderentryid.baseqty", "!=", (Object)0));
        QFilter[] qFilters = qFilterList.toArray(new QFilter[0]);
        DataSet stockDataSet = QueryServiceHelper.queryDataSet((String)algoKey, (String)"pom_mftstock", (String)selectedProperty, (QFilter[])qFilters, null);
        HashSet<Long> entryIds = new HashSet<Long>();
        stockDataSet.copy().forEach(row -> entryIds.add(row.getLong("mftentryid")));
        DataSet otherDataSet = this.createOtherDataSet(entryIds);
        DataSet otherStockDataSet = QueryServiceHelper.queryDataSet((String)algoKey, (String)"pom_mftstock", (String)this.getSelectHeadFields(), (QFilter[])new QFilter[]{new QFilter("orderentryid", "in", entryIds)}, null);
        otherStockDataSet = otherStockDataSet.distinct();
        DataSet resultDataSet = stockDataSet.leftJoin(otherDataSet).on("mftentryid", "entryid").select(stockDataSet.getRowMeta().getFieldNames(), otherDataSet.getRowMeta().getFieldNames()).finish();
        DataSet mftOrderOtherDataSet = this.createMftOrderOtherDataSet(entryIds);
        resultDataSet = resultDataSet.leftJoin(mftOrderOtherDataSet).on("mftentryid", "treeentryentity.id").select(resultDataSet.getRowMeta().getFieldNames(), mftOrderOtherDataSet.getRowMeta().getFieldNames()).finish();
        resultDataSet = this.filterResult(resultDataSet);
        DataSet proorderDataSet = this.createProorderDataSet(entryIds);
        DataSet resultDataSet1 = resultDataSet.leftJoin(proorderDataSet).on("mftentryid", "manuentryid").on("stock_materialmaster1", "stock_materialmaster").select(resultDataSet.getRowMeta().getFieldNames(), proorderDataSet.getRowMeta().getFieldNames()).finish();
        DataSet resultDataSet2 = proorderDataSet.join(resultDataSet, JoinType.LEFT).on("manuentryid", "mftentryid").on("stock_materialmaster", "stock_materialmaster1").select(proorderDataSet.getRowMeta().getFieldNames(), resultDataSet.getRowMeta().getFieldNames()).finish();
        String[] fieldNames = resultDataSet.getRowMeta().getFieldNames();
        String[] fieldNames1 = proorderDataSet.getRowMeta().getFieldNames();
        StringBuilder sb = new StringBuilder();
        for (String fieldName : fieldNames) {
            sb.append(fieldName);
            sb.append(",");
        }
        for (String fieldName : fieldNames1) {
            sb.append(fieldName);
            sb.append(",");
        }
        String string = sb.toString();
        resultDataSet2 = resultDataSet2.select(string.substring(0, string.length() - 1));
        resultDataSet2 = resultDataSet2.where("stock_materialmaster1 is null and stock_materialmaster<>0");
        resultDataSet = resultDataSet1.union(resultDataSet2);
        resultDataSet = resultDataSet.updateField("stock_actissueqty1", "Case When stock_actissueqty1 is null then 0 else stock_actissueqty1 end");
        resultDataSet = resultDataSet.updateField("stock_feedingqty1", "Case When stock_feedingqty1 is null then 0 else stock_feedingqty1 end");
        resultDataSet = resultDataSet.updateField("stock_rejectedqty1", "Case When stock_rejectedqty1 is null then 0 else stock_rejectedqty1 end");
        resultDataSet = resultDataSet.updateField("stock_materialmaster", "Case When stock_materialmaster is null then stock_materialmaster1 else stock_materialmaster end");
        resultDataSet = resultDataSet.updateField("stock_baseunit", "Case When stock_baseunit is null then entrybaseunit else stock_baseunit end");
        resultDataSet = resultDataSet.updateField("mftentryid", "Case When mftentryid is null then manuentryid else mftentryid end");
        resultDataSet = resultDataSet.addField("Case When stock_demandqty<>0 then ((NullToZero(stock_actissueqty)+NullToZero(stock_feedingqty)-NullToZero(stock_rejectedqty))*100/stock_demandqty) end", "issuerate");
        resultDataSet = resultDataSet.addField("Case When (stock_demandqty<>0 and stock_demandqty is not null) then ((NullToZero(stock_actissueqty1)+NullToZero(stock_feedingqty1)-NullToZero(stock_rejectedqty1))*100/stock_demandqty) else 100 end", "issuerate1");
        resultDataSet = resultDataSet.addField("stock_actissueqty+stock_feedingqty-stock_rejectedqty", "stock_issuedstockqty");
        resultDataSet = resultDataSet.addField("NullToZero(stock_actissueqty1)+NullToZero(stock_feedingqty1)-NullToZero(stock_rejectedqty1)", "stock_issuedstockqty1");
        if (!reportQueryParam.getFilter().getBoolean("dispalycolcheck")) {
            resultDataSet = resultDataSet.where("stock_demandqty<>0 OR stock_actissueqty<>0 OR stock_rejectedqty<>0 OR stock_feedingqty<>0");
        }
        resultDataSet = resultDataSet.leftJoin(otherStockDataSet).on("mftentryid", "mftentryid").select(new String[]{"stockseq", "stock_material", " stock_materialnum", " stock_materialmaster1", " stock_baseunit", " stock_standqty", " stock_demandqty", " stock_actissueqty", " stock_rejectedqty", " stock_feedingqty", " stock_unissueqty", " stock_iscannegative", " stock_sourcetype", " entryid", " requirebillno", " requirebillseq", " stock_materialmaster", " manuentryid", " billformid", " entrybaseunit", " stock_actissueqty1", " stock_rejectedqty1", " stock_feedingqty1", " issuerate", " issuerate1", " stock_issuedstockqty", " stock_issuedstockqty1"}, otherStockDataSet.getRowMeta().getFieldNames()).finish();
        resultDataSet = resultDataSet.leftJoin(mftOrderOtherDataSet).on("mftentryid", "treeentryentity.id").select(resultDataSet.getRowMeta().getFieldNames(), mftOrderOtherDataSet.getRowMeta().getFieldNames()).finish();
        String sort = reportQueryParam.getSortInfo();
        if (StringUtils.isNotEmpty((CharSequence)sort)) {
            resultDataSet = resultDataSet.orderBy(new String[]{sort});
        }
        return resultDataSet;
    }

    private DataSet createProorderDataSet(Set<Long> entryIds) {
        String properties = "billentry.materialmasterid as stock_materialmaster,billentry.manuentryid as manuentryid,billentry.baseqty as baseqty,billtype.billformid as billformid,billentry.baseunit as entrybaseunit";
        QFilter[] qFilters = new QFilter[]{new QFilter("billentry.manuentryid", "in", entryIds), new QFilter("billstatus", "=", (Object)"C"), new QFilter("ischargeoff", "=", (Object)"0"), new QFilter("ischargeoffed", "=", (Object)"0")};
        DataSet proorderDataSet = QueryServiceHelper.queryDataSet((String)(algoKey + "_queryMftproorder"), (String)"im_mdc_mftproorder", (String)properties, (QFilter[])qFilters, null);
        DataSet actissueqtyDataSet = proorderDataSet.filter("billformid='im_mdc_mftproorder'").groupBy(groupFields).sum("baseqty", "stock_actissueqty1").finish();
        DataSet rejectedqtyDataSet = proorderDataSet.filter("billformid='im_mdc_mftreturnorder'").groupBy(groupFields).sum("baseqty", "stock_rejectedqty1").finish();
        DataSet feedingqtyDataSet = proorderDataSet.filter("billformid='im_mdc_mftfeedorder'").groupBy(groupFields).sum("baseqty", "stock_feedingqty1").finish();
        DataSet groupProOrderDataSet = proorderDataSet.groupBy(groupFields).finish();
        DataSet resultDataSet = groupProOrderDataSet.leftJoin(actissueqtyDataSet).on("stock_materialmaster", "stock_materialmaster").on("manuentryid", "manuentryid").select(groupProOrderDataSet.getRowMeta().getFieldNames(), new String[]{"stock_actissueqty1"}).finish();
        resultDataSet = resultDataSet.leftJoin(rejectedqtyDataSet).on("stock_materialmaster", "stock_materialmaster").on("manuentryid", "manuentryid").select(resultDataSet.getRowMeta().getFieldNames(), new String[]{"stock_rejectedqty1"}).finish();
        resultDataSet = resultDataSet.leftJoin(feedingqtyDataSet).on("stock_materialmaster", "stock_materialmaster").on("manuentryid", "manuentryid").select(resultDataSet.getRowMeta().getFieldNames(), new String[]{"stock_feedingqty1"}).finish();
        return resultDataSet;
    }

    protected DataSet filterResult(DataSet resultDataSet) {
        FilterInfo filter = this.getQueryParam().getFilter();
        String head_billstatus = filter.getString("head_billstatus");
        String[] billstatus_arr = head_billstatus.substring(1, head_billstatus.length() - 1).split(",");
        StringBuilder filter_exp = new StringBuilder("billstatus in (");
        for (String str : billstatus_arr) {
            filter_exp.append('\'').append(str).append('\'').append(',');
        }
        String exp = filter_exp.substring(0, filter_exp.length() - 1) + ")";
        return resultDataSet.filter(exp);
    }

    protected DataSet createMftOrderOtherDataSet(Set<Long> entryIds) {
        String properties = "treeentryentity.id,billstatus AS billstatus,treeentryentity.auxptyunit AS assistantunit,treeentryentity.auxptyqty AS assistantqty,treeentryentity.quainwaqty AS quainwaqty,treeentryentity.unquainwaqty AS unquainwaqty,treeentryentity.scrinwaqty AS scrinwaqty";
        QFilter qFilter = new QFilter("treeentryentity.id", "in", entryIds);
        return QueryServiceHelper.queryDataSet((String)(algoKey + "_createMftOrderOtherDataSet"), (String)"pom_mftorder", (String)properties, (QFilter[])new QFilter[]{qFilter}, null);
    }

    protected DataSet createOtherDataSet(Set<Long> entryIds) {
        DataSet mftOrderDataSet = this.queryMftOrder(entryIds);
        HashSet<String> planOrderNo = new HashSet<String>(16);
        mftOrderDataSet.copy().forEach(row -> {
            String sourceBillType = row.getString("treeentryentity.sourcebilltype");
            String sourceBillNumber = row.getString("treeentryentity.sourcebillnumber");
            if (StringUtils.equals((CharSequence)"mrp_planorder", (CharSequence)sourceBillType) && StringUtils.isNotBlank((CharSequence)sourceBillNumber)) {
                planOrderNo.add(sourceBillNumber);
            }
        });
        DataSet planOrderDataSet = this.queryPlanOrder(planOrderNo);
        DataSet resultDataSet = mftOrderDataSet.leftJoin(planOrderDataSet).on("treeentryentity.sourcebillnumber", "planorder").select(mftOrderDataSet.getRowMeta().getFieldNames(), planOrderDataSet.getRowMeta().getFieldNames()).finish();
        RowMeta rowMeta = RowMetaFactory.createRowMeta((String[])otherFields, (DataType[])otherTypes);
        DataSetBuilder dataSetBuilder = Algo.create((String)algoKey).createDataSetBuilder(rowMeta);
        resultDataSet.forEach(row -> dataSetBuilder.append(this.createNewRow((Row)row)));
        DataSet newDataSet = dataSetBuilder.build();
        return newDataSet;
    }

    protected Object[] createNewRow(Row row) {
        long entryId = row.getLong("treeentryentity.id");
        String sourceBillType = row.getString("treeentryentity.sourcebilltype");
        String sourceBillNumber = row.getString("treeentryentity.sourcebillnumber");
        String sourceEntrySeq = row.getString("treeentryentity.sourceentryseq");
        Object[] values = new Object[]{entryId, sourceBillNumber, sourceEntrySeq};
        if (StringUtils.equals((CharSequence)"mrp_planorder", (CharSequence)sourceBillType)) {
            values[1] = row.getString("demandbill");
            values[2] = row.getString("demandseq");
        }
        return values;
    }

    protected DataSet queryPlanOrder(Set<String> planOrderNo) {
        String properties = "billno AS planorder,demandbill,demandseq";
        QFilter[] qFilters = new QFilter[2];
        qFilters[0] = new QFilter("billno", "in", planOrderNo);
        return QueryServiceHelper.queryDataSet((String)(algoKey + "_queryPlanOrder"), (String)"mrp_planorder", (String)properties, (QFilter[])qFilters, null);
    }

    protected DataSet queryMftOrder(Set<Long> entryIds) {
        String properties = "treeentryentity.id,treeentryentity.sourcebilltype,treeentryentity.sourcebillnumber,treeentryentity.sourceentryseq";
        QFilter qFilter = new QFilter("treeentryentity.id", "in", entryIds);
        return QueryServiceHelper.queryDataSet((String)(algoKey + "_queryMftOrder"), (String)"pom_mftorder", (String)properties, (QFilter[])new QFilter[]{qFilter}, null);
    }

    protected String getSelectFields() {
        String property = "orderentryid.headbillno AS mftorder,orderentryid.id AS mftentryid,orderentryid.entryseq AS mftorderseq,orderentryid.bizstatus AS bizstatus,orderentryid.planstatus AS planstatus,orderentryid.taskstatus AS taskstatus,orderentryid.material.masterid AS material,orderentryid.auxproperty AS auxproperty,orderentryid.unit AS unit,orderentryid.qty AS qty,orderentryid.baseunit AS baseunit,orderentryid.baseqty AS baseqty,billno AS stockno,transactiontypeid AS transactiontype,stockentry.seq AS stockseq,stockentry.materialid AS stock_material,stockentry.materielmasterid.number AS stock_materialnum,stockentry.materielmasterid AS stock_materialmaster1,stockentry.materialunitid AS stock_baseunit,stockentry.standqty AS stock_standqty,stockentry.demandqty AS stock_demandqty,stockentry.actissueqty AS stock_actissueqty,stockentry.rejectedqty AS stock_rejectedqty,stockentry.feedingqty AS stock_feedingqty,stockentry.unissueqty AS stock_unissueqty,stockentry.iscannegative AS stock_iscannegative,stockentry.sourcetype AS stock_sourcetype,bdproject,tracknumber";
        return property;
    }

    protected String getSelectHeadFields() {
        String property = "orderentryid.headbillno AS mftorder,orderentryid.id AS mftentryid,orderentryid.entryseq AS mftorderseq,orderentryid.bizstatus AS bizstatus,orderentryid.planstatus AS planstatus,orderentryid.taskstatus AS taskstatus,orderentryid.material.masterid AS material,orderentryid.auxproperty AS auxproperty,orderentryid.unit AS unit,orderentryid.qty AS qty,orderentryid.baseunit AS baseunit,orderentryid.baseqty AS baseqty,billno AS stockno,transactiontypeid AS transactiontype,bdproject,tracknumber";
        return property;
    }

    protected List<QFilter> createHeadFilters() {
        FilterInfo filter = this.getQueryParam().getFilter();
        ArrayList<QFilter> qfList = new ArrayList<QFilter>();
        this.createOrgFilter(filter, qfList);
        this.createBiztypeFilter(filter, qfList);
        this.createProductTypeFilter(filter, qfList);
        this.createStartTimeFilter(filter, qfList);
        this.createFinishTimeFilter(filter, qfList);
        this.createPorductDeptFilter(filter, qfList);
        this.createOrderFilter(filter, qfList);
        this.createMaterialFilter(filter, qfList);
        this.createBizStatusFilter(filter, qfList);
        this.createPlanStatusFilter(filter, qfList);
        this.createTaskStatusFilter(filter, qfList);
        this.createPickStatusFilter(filter, qfList);
        this.createStockFilter(filter, qfList);
        this.createProjectFilter(filter, qfList);
        this.createTrackNumberFilter(filter, qfList);
        return qfList;
    }

    private void createStockFilter(FilterInfo filter, List<QFilter> qfList) {
        DynamicObject materialto;
        DynamicObjectCollection head_materialfrom = filter.getDynamicObjectCollection("head_materialfrom");
        if (head_materialfrom != null) {
            if (head_materialfrom.size() == 1) {
                qfList.add(new QFilter("stockentry.materialid", ">=", ((DynamicObject)head_materialfrom.get(0)).getPkValue()));
            } else {
                HashSet idSet = new HashSet(head_materialfrom.size());
                head_materialfrom.forEach(obj -> idSet.add(obj.getPkValue()));
                qfList.add(new QFilter("stockentry.materialid", "in", idSet));
            }
        }
        if ((materialto = filter.getDynamicObject("head_materialto")) != null) {
            qfList.add(new QFilter("stockentry.materialid", "<=", materialto.getPkValue()));
        }
    }

    private void createOrgFilter(FilterInfo filter, List<QFilter> qfList) {
        DynamicObject head_org = filter.getDynamicObject("head_org");
        if (head_org != null) {
            qfList.add(new QFilter("org", "=", head_org.getPkValue()));
        }
    }

    private void createBiztypeFilter(FilterInfo filter, List<QFilter> qfList) {
        DynamicObjectCollection head_biztype = filter.getDynamicObjectCollection("head_biztype");
        if (head_biztype != null) {
            HashSet idSet = new HashSet(head_biztype.size());
            head_biztype.forEach(obj -> idSet.add(obj.getPkValue()));
            qfList.add(new QFilter("transactiontypeid.transactiontype", "in", idSet));
        }
    }

    private void createProductTypeFilter(FilterInfo filter, List<QFilter> qfList) {
        DynamicObjectCollection head_transactproduct = filter.getDynamicObjectCollection("head_transactproduct");
        if (head_transactproduct != null) {
            HashSet idSet = new HashSet(head_transactproduct.size());
            head_transactproduct.forEach(obj -> idSet.add(obj.getPkValue()));
            qfList.add(new QFilter("transactiontypeid", "in", idSet));
        }
    }

    private void createOrderFilter(FilterInfo filter, List<QFilter> qfList) {
        String head_orderto;
        String head_orderfrom = filter.getString("head_orderfrom");
        if (StringUtils.isNotEmpty((CharSequence)head_orderfrom)) {
            qfList.add(new QFilter("orderentryid.headbillno", ">=", (Object)head_orderfrom));
        }
        if (StringUtils.isNotEmpty((CharSequence)(head_orderto = filter.getString("head_orderto")))) {
            qfList.add(new QFilter("orderentryid.headbillno", "<=", (Object)head_orderto));
        }
    }

    private void createStartTimeFilter(FilterInfo filter, List<QFilter> qfList) {
        Date beginDate = filter.getDate("begintime");
        Date endDate = filter.getDate("endtime");
        Calendar cal = Calendar.getInstance();
        if (beginDate != null) {
            cal.setTime(beginDate);
            cal.set(10, 0);
            cal.set(11, 0);
            cal.set(12, 0);
            cal.set(13, 0);
            cal.set(14, 0);
            qfList.add(new QFilter("orderentryid.planbegintime", ">=", (Object)cal.getTime()));
        }
        if (endDate != null) {
            cal.setTime(endDate);
            cal.set(10, 0);
            cal.set(11, 0);
            cal.set(12, 0);
            cal.set(13, 0);
            cal.set(14, 0);
            cal.add(5, 1);
            qfList.add(new QFilter("orderentryid.planbegintime", "<", (Object)cal.getTime()));
        }
    }

    private void createFinishTimeFilter(FilterInfo filter, List<QFilter> qfList) {
        if (filter.getDate("finishbegin") != null && filter.getDate("finishend") != null) {
            Date beginDate = filter.getDate("finishbegin");
            Date endDate = filter.getDate("finishend");
            Calendar cal = Calendar.getInstance();
            cal.setTime(beginDate);
            cal.set(10, 0);
            cal.set(11, 0);
            cal.set(12, 0);
            cal.set(13, 0);
            cal.set(14, 0);
            qfList.add(new QFilter("orderentryid.planendtime", ">=", (Object)cal.getTime()));
            cal.setTime(endDate);
            cal.set(10, 0);
            cal.set(11, 0);
            cal.set(12, 0);
            cal.set(13, 0);
            cal.set(14, 0);
            cal.add(5, 1);
            qfList.add(new QFilter("orderentryid.planendtime", "<", (Object)cal.getTime()));
        }
    }

    private void createPorductDeptFilter(FilterInfo filter, List<QFilter> qfList) {
        DynamicObject head_producedept = filter.getDynamicObject("head_producedept");
        if (head_producedept != null) {
            qfList.add(new QFilter("orderentryid.producedept", "=", head_producedept.getPkValue()));
        }
    }

    private void createMaterialFilter(FilterInfo filter, List<QFilter> qfList) {
        DynamicObject head_productto;
        DynamicObjectCollection head_productfrom = filter.getDynamicObjectCollection("head_productfrom");
        if (head_productfrom != null) {
            if (head_productfrom.size() == 1) {
                qfList.add(new QFilter("orderentryid.material", ">=", ((DynamicObject)head_productfrom.get(0)).getPkValue()));
            } else {
                HashSet idSet = new HashSet(head_productfrom.size());
                head_productfrom.forEach(obj -> idSet.add(obj.getPkValue()));
                qfList.add(new QFilter("orderentryid.material", "in", idSet));
            }
        }
        if ((head_productto = filter.getDynamicObject("head_productto")) != null) {
            qfList.add(new QFilter("orderentryid.material", "<=", head_productto.getPkValue()));
        }
    }

    private void createBillStatusFilter(FilterInfo filter, List<QFilter> qfList) {
        String head_billstatus = filter.getString("head_billstatus");
        qfList.add(new QFilter("billstatus", "in", (Object)head_billstatus.substring(1, head_billstatus.length() - 1).split(",")));
    }

    private void createTaskStatusFilter(FilterInfo filter, List<QFilter> qfList) {
        String head_taskstatus = filter.getString("head_taskstatus");
        qfList.add(new QFilter("orderentryid.taskstatus", "in", (Object)head_taskstatus.substring(1, head_taskstatus.length() - 1).split(",")));
    }

    private void createPlanStatusFilter(FilterInfo filter, List<QFilter> qfList) {
        String head_planstatus = filter.getString("head_planstatus");
        qfList.add(new QFilter("orderentryid.planstatus", "in", (Object)head_planstatus.substring(1, head_planstatus.length() - 1).split(",")));
    }

    private void createBizStatusFilter(FilterInfo filter, List<QFilter> qfList) {
        String head_bizstatus = filter.getString("head_bizstatus");
        qfList.add(new QFilter("orderentryid.bizstatus", "in", (Object)head_bizstatus.substring(1, head_bizstatus.length() - 1).split(",")));
    }

    private void createPickStatusFilter(FilterInfo filter, List<QFilter> qfList) {
        String head_pickstatus = filter.getString("head_pickstatus");
        qfList.add(new QFilter("orderentryid.pickstatus", "in", (Object)head_pickstatus.substring(1, head_pickstatus.length() - 1).split(",")));
    }

    private void createProjectFilter(FilterInfo filter, List<QFilter> qfList) {
        DynamicObjectCollection projects = filter.getDynamicObjectCollection("head_bdproject");
        if (projects != null) {
            List ids = projects.stream().map(DataEntityBase::getPkValue).collect(Collectors.toList());
            qfList.add(new QFilter("bdproject", "in", ids));
        }
    }

    private void createTrackNumberFilter(FilterInfo filter, List<QFilter> qfList) {
        DynamicObjectCollection trackNumber = filter.getDynamicObjectCollection("head_tracknumber");
        if (trackNumber != null) {
            List ids = trackNumber.stream().map(DataEntityBase::getPkValue).collect(Collectors.toList());
            qfList.add(new QFilter("tracknumber", "in", ids));
        }
    }
}

