/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.mpdm.report.tpl;

import com.google.common.collect.Sets;
import java.util.Calendar;
import java.util.Date;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageTypes;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.BeforeClickEvent;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.TextEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.report.events.CellStyleRule;
import kd.bos.report.events.SortAndFilterEvent;
import kd.bos.report.plugin.AbstractReportFormPlugin;
import kd.bos.servicehelper.permission.PermissionServiceHelper;

public class MftOrderRequireDetailRptPlugin
extends AbstractReportFormPlugin
implements BeforeF7SelectListener {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        TextEdit t = (TextEdit)this.getControl("head_orderfrom");
        t.addClickListener((ClickListener)this);
        t = (TextEdit)this.getControl("head_orderto");
        t.addClickListener((ClickListener)this);
        BasedataEdit edit = (BasedataEdit)this.getControl("head_org");
        edit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        RequestContext requestContext = RequestContext.get();
        long userID = requestContext.getCurrUserId();
        String appId = this.getView().getFormShowParameter().getAppId();
        HasPermOrgResult result = PermissionServiceHelper.getAllPermOrgs((Long)userID, (String)appId, (String)this.getModel().getDataEntityType().getName(), (String)"47150e89000000ac");
        if (result.hasAllOrgPerm()) {
            int hasPermissin = PermissionServiceHelper.checkPermission((Long)userID, (Long)requestContext.getOrgId(), (String)"04", (String)appId, (String)this.getModel().getDataEntityType().getName(), (String)"47150e89000000ac");
            if (hasPermissin == 1) {
                this.getModel().setValue("head_org", (Object)requestContext.getOrgId());
            } else {
                this.getModel().setValue("head_org", result.getHasPermOrgs() != null ? result.getHasPermOrgs().get(0) : Long.valueOf(0L));
            }
        } else {
            this.getModel().setValue("head_org", result.getHasPermOrgs() != null ? (result.getHasPermOrgs().size() > 0 ? result.getHasPermOrgs().get(0) : Long.valueOf(0L)) : Long.valueOf(0L));
        }
        Calendar cal = Calendar.getInstance();
        cal.add(2, 0);
        cal.set(5, 1);
        this.getModel().setValue("begintime", (Object)cal.getTime());
        this.getModel().setValue("endtime", (Object)new Date());
        this.getModel().setValue("finishbegin", (Object)cal.getTime());
        this.getModel().setValue("finishend", (Object)new Date());
    }

    public void setCellStyleRules(List<CellStyleRule> cellStyleRules) {
        HashSet needModifyCellStyleFields = Sets.newHashSet();
        needModifyCellStyleFields.add("stock_standqty");
        needModifyCellStyleFields.add("stock_demandqty");
        needModifyCellStyleFields.add("stock_actissueqty");
        for (String needModifyCellStyleField : needModifyCellStyleFields) {
            CellStyleRule cellStyleRule = new CellStyleRule();
            cellStyleRule.setFieldKey(needModifyCellStyleField);
            cellStyleRule.setForeColor("#FF0000");
            cellStyleRule.setDegree(100);
            cellStyleRule.setCondition("stock_iscannegative = true");
            cellStyleRules.add(cellStyleRule);
        }
    }

    public void beforeClick(BeforeClickEvent evt) {
        Control source = (Control)evt.getSource();
        String fieldKey = source.getKey();
        if ("head_orderfrom".equals(fieldKey) || "head_orderto".equals(fieldKey)) {
            DynamicObject org = (DynamicObject)this.getModel().getValue("head_org");
            if (org == null) {
                evt.setCancel(true);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u5f55\u5165\u201c\u751f\u4ea7\u7ec4\u7ec7\u201d\u3002", (String)"MftOrderRequireDetailRptPlugin_0", (String)"bd-mpdm-report", (Object[])new Object[0]));
                return;
            }
            ListShowParameter listShowParameter = ShowFormHelper.createShowListForm((String)"pom_mftorder", (boolean)false);
            listShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, fieldKey));
            List filters = listShowParameter.getListFilterParameter().getQFilters();
            filters.add(new QFilter("org", "=", org.getPkValue()));
            this.getView().showForm((FormShowParameter)listShowParameter);
        }
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        String actionId = evt.getActionId();
        Object returnData = evt.getReturnData();
        if (returnData == null) {
            return;
        }
        ListSelectedRowCollection list = (ListSelectedRowCollection)returnData;
        this.getModel().setValue(actionId, (Object)list.get(0).getBillNo());
    }

    public boolean verifyQuery(ReportQueryParam queryParam) {
        return this.verifyQueryImp(queryParam);
    }

    private boolean verifyQueryImp(ReportQueryParam queryParam) {
        FilterInfo filter = queryParam.getFilter();
        StringBuilder sb = new StringBuilder();
        if (filter.getValue("head_org") == null) {
            sb.append(ResManager.loadKDString((String)"\u201c\u751f\u4ea7\u7ec4\u7ec7\u201d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"MftOrderRequireDetailRptPlugin_1", (String)"bd-mpdm-report", (Object[])new Object[0]));
        }
        boolean flag = true;
        if (filter.getValue("begintime") == null || filter.getValue("endtime") == null) {
            sb.append(ResManager.loadKDString((String)"\u201c\u8ba1\u5212\u5f00\u5de5\u65e5\u671f\u201d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"MftOrderRequireDetailRptPlugin_2", (String)"bd-mpdm-report", (Object[])new Object[0]));
            flag = false;
        }
        if (flag) {
            Date begintime = filter.getDate("begintime");
            Date endtime = filter.getDate("endtime");
            if (filter.getValue("finishbegin") != null || filter.getValue("finishend") != null) {
                Date finishbegin = filter.getDate("finishbegin");
                Date finishend = filter.getDate("finishend");
                if (finishbegin.before(begintime)) {
                    sb.append(ResManager.loadKDString((String)"\u6700\u65e9\u8ba1\u5212\u5b8c\u5de5\u65e5\u671f\u5e94\u665a\u4e8e\u7b49\u4e8e\u6700\u65e9\u8ba1\u5212\u5f00\u5de5\u65e5\u671f\u3002", (String)"MftOrderRequireDetailRptPlugin_3", (String)"bd-mpdm-report", (Object[])new Object[0]));
                }
                if (finishend.before(endtime)) {
                    sb.append(ResManager.loadKDString((String)"\u6700\u665a\u8ba1\u5212\u5b8c\u5de5\u65e5\u671f\u5e94\u665a\u4e8e\u7b49\u4e8e\u6700\u665a\u8ba1\u5212\u5f00\u5de5\u65e5\u671f\u3002", (String)"MftOrderRequireDetailRptPlugin_4", (String)"bd-mpdm-report", (Object[])new Object[0]));
                }
            }
        }
        if (filter.getValue("head_bizstatus") == null) {
            sb.append(ResManager.loadKDString((String)"\u201c\u4e1a\u52a1\u72b6\u6001\u201d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"MftOrderRequireDetailRptPlugin_5", (String)"bd-mpdm-report", (Object[])new Object[0]));
        }
        if (filter.getValue("head_planstatus") == null) {
            sb.append(ResManager.loadKDString((String)"\u201c\u8ba1\u5212\u72b6\u6001\u201d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"MftOrderRequireDetailRptPlugin_6", (String)"bd-mpdm-report", (Object[])new Object[0]));
        }
        if (filter.getValue("head_taskstatus") == null) {
            sb.append(ResManager.loadKDString((String)"\u201c\u4efb\u52a1\u72b6\u6001\u201d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"MftOrderRequireDetailRptPlugin_7", (String)"bd-mpdm-report", (Object[])new Object[0]));
        }
        if (sb.length() != 0) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u5b8c\u6574\u7684\u67e5\u8be2\u6761\u4ef6\u3002", (String)"MftOrderRequireDetailRptPlugin_8", (String)"bd-mpdm-report", (Object[])new Object[0]), sb.toString(), MessageTypes.Default);
            return false;
        }
        return true;
    }

    public void setSortAndFilter(List<SortAndFilterEvent> allColumns) {
        HashSet<String> fieldSet = new HashSet<String>(16);
        fieldSet.add("materialname");
        fieldSet.add("model");
        fieldSet.add("stock_name");
        fieldSet.add("stock_model");
        fieldSet.add("biztype");
        for (SortAndFilterEvent sort : allColumns) {
            if (fieldSet.contains(sort.getColumnName())) continue;
            sort.setSort(true);
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        String fileName = evt.getProperty().getName();
        if ("head_org".equals(fileName)) {
            long userID = RequestContext.get().getCurrUserId();
            String appId = this.getView().getFormShowParameter().getAppId();
            HasPermOrgResult result = PermissionServiceHelper.getAllPermOrgs((Long)userID, (String)appId, (String)this.getModel().getDataEntityType().getName(), (String)"47150e89000000ac");
            if (!result.hasAllOrgPerm()) {
                ListShowParameter listShowParameter = (ListShowParameter)evt.getFormShowParameter();
                listShowParameter.getListFilterParameter().getQFilters().add(new QFilter("id", "in", (Object)result.getHasPermOrgs()));
                listShowParameter.setCustomParam("isIncludeAllSub", (Object)Boolean.TRUE);
            }
        }
    }
}

