/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.mpdm.report.tpl;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataSetBuilder;
import kd.bos.algo.DataType;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.RowMetaFactory;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.report.AbstractReportListDataPlugin;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;

public class MftOrderRequireDetailRptQuery
extends AbstractReportListDataPlugin {
    public static final String algoKey = MftOrderRequireDetailRptQuery.class.getName();
    public static final String[] otherFields = new String[]{"entryid", "requirebillno", "requirebillseq"};
    public static final DataType[] otherTypes = new DataType[]{DataType.LongType, DataType.StringType, DataType.StringType};

    public DataSet query(ReportQueryParam reportQueryParam, Object o) throws Throwable {
        String sort;
        String selectedProperty = this.getSelectFields();
        List<QFilter> qFilterList = this.createHeadFilters();
        qFilterList.add(new QFilter("orderentryid.producttype", "=", (Object)"C"));
        qFilterList.add(new QFilter("orderentryid.baseqty", "!=", (Object)0));
        QFilter[] qFilters = qFilterList.toArray(new QFilter[0]);
        DataSet stockDataSet = QueryServiceHelper.queryDataSet((String)algoKey, (String)"pom_mftstock", (String)selectedProperty, (QFilter[])qFilters, null);
        HashSet<Long> entryIds = new HashSet<Long>();
        stockDataSet.copy().forEach(row -> entryIds.add(row.getLong("mftentryid")));
        DataSet otherDataSet = this.createOtherDataSet(entryIds);
        DataSet resultDataSet = stockDataSet.leftJoin(otherDataSet).on("mftentryid", "entryid").select(stockDataSet.getRowMeta().getFieldNames(), otherDataSet.getRowMeta().getFieldNames()).finish();
        DataSet mftOrderOtherDataSet = this.createMftOrderOtherDataSet(entryIds);
        resultDataSet = resultDataSet.leftJoin(mftOrderOtherDataSet).on("mftentryid", "treeentryentity.id").select(resultDataSet.getRowMeta().getFieldNames(), mftOrderOtherDataSet.getRowMeta().getFieldNames()).finish();
        resultDataSet = resultDataSet.addField("quainwaqty+unquainwaqty+scrinwaqty", "inwarebaseqty");
        resultDataSet = resultDataSet.addField("ass_quainwaqty+ass_unquainwaqty+ass_scrinwaqty", "ass_inwarebaseqty");
        resultDataSet = resultDataSet.addField("baseqty-inwarebaseqty", "uninwarebaseqty");
        resultDataSet = resultDataSet.addField("assistantqty-ass_inwarebaseqty", "ass_uninwarebaseqty");
        resultDataSet = resultDataSet.addField("inwarebaseqty*100/baseqty", "completerate");
        resultDataSet = resultDataSet.addField("Case When stock_demandqty<>0 then ((stock_actissueqty+stock_feedingqty-stock_rejectedqty)*100/stock_demandqty) end", "issuerate");
        resultDataSet = resultDataSet.addField("stock_actissueqty+stock_feedingqty-stock_rejectedqty", "stock_issuedstockqty");
        resultDataSet = this.filterResult(resultDataSet);
        if (!reportQueryParam.getFilter().getBoolean("dispalycolcheck")) {
            resultDataSet = resultDataSet.where("stock_demandqty<>0 OR stock_actissueqty<>0 OR stock_rejectedqty<>0 OR stock_feedingqty<>0");
        }
        if (StringUtils.isNotEmpty((CharSequence)(sort = reportQueryParam.getSortInfo()))) {
            resultDataSet = resultDataSet.orderBy(new String[]{sort});
        }
        return resultDataSet;
    }

    protected DataSet filterResult(DataSet resultDataSet) {
        FilterInfo filter = this.getQueryParam().getFilter();
        String head_billstatus = filter.getString("head_billstatus");
        String[] billstatus_arr = head_billstatus.substring(1, head_billstatus.length() - 1).split(",");
        StringBuilder filter_exp = new StringBuilder("billstatus in (");
        for (String str : billstatus_arr) {
            filter_exp.append('\'').append(str).append('\'').append(',');
        }
        String exp = filter_exp.substring(0, filter_exp.length() - 1) + ")";
        return resultDataSet.filter(exp);
    }

    protected DataSet createMftOrderOtherDataSet(Set<Long> entryIds) {
        String properties = "treeentryentity.id,billstatus AS billstatus,treeentryentity.auxptyunit AS assistantunit,treeentryentity.auxptyqty AS assistantqty,treeentryentity.quainwaqty AS quainwaqty,treeentryentity.unquainwaqty AS unquainwaqty,treeentryentity.scrinwaqty AS scrinwaqty";
        QFilter qFilter = new QFilter("treeentryentity.id", "in", entryIds);
        return QueryServiceHelper.queryDataSet((String)(algoKey + "_createMftOrderOtherDataSet"), (String)"pom_mftorder", (String)properties, (QFilter[])new QFilter[]{qFilter}, null);
    }

    protected DataSet createOtherDataSet(Set<Long> entryIds) {
        DataSet mftOrderDataSet = this.queryMftOrder(entryIds);
        HashSet<String> planOrderNo = new HashSet<String>(16);
        mftOrderDataSet.copy().forEach(row -> {
            String sourceBillType = row.getString("treeentryentity.sourcebilltype");
            String sourceBillNumber = row.getString("treeentryentity.sourcebillnumber");
            if (StringUtils.equals((CharSequence)"mrp_planorder", (CharSequence)sourceBillType) && StringUtils.isNotBlank((CharSequence)sourceBillNumber)) {
                planOrderNo.add(sourceBillNumber);
            }
        });
        DataSet planOrderDataSet = this.queryPlanOrder(planOrderNo);
        DataSet resultDataSet = mftOrderDataSet.leftJoin(planOrderDataSet).on("treeentryentity.sourcebillnumber", "planorder").select(mftOrderDataSet.getRowMeta().getFieldNames(), planOrderDataSet.getRowMeta().getFieldNames()).finish();
        RowMeta rowMeta = RowMetaFactory.createRowMeta((String[])otherFields, (DataType[])otherTypes);
        DataSetBuilder dataSetBuilder = Algo.create((String)algoKey).createDataSetBuilder(rowMeta);
        resultDataSet.forEach(row -> dataSetBuilder.append(this.createNewRow((Row)row)));
        DataSet newDataSet = dataSetBuilder.build();
        DataSet manuInBillDataSet = this.queryManuInBill(entryIds);
        return newDataSet.leftJoin(manuInBillDataSet).on("entryid", "billentry.manuentryid").select(newDataSet.getRowMeta().getFieldNames(), manuInBillDataSet.getRowMeta().getFieldNames()).finish();
    }

    protected Object[] createNewRow(Row row) {
        long entryId = row.getLong("treeentryentity.id");
        String sourceBillType = row.getString("treeentryentity.sourcebilltype");
        String sourceBillNumber = row.getString("treeentryentity.sourcebillnumber");
        String sourceEntrySeq = row.getString("treeentryentity.sourceentryseq");
        Object[] values = new Object[]{entryId, sourceBillNumber, sourceEntrySeq};
        if (StringUtils.equals((CharSequence)"mrp_planorder", (CharSequence)sourceBillType)) {
            values[1] = row.getString("demandbill");
            values[2] = row.getString("demandseq");
        }
        return values;
    }

    protected DataSet queryPlanOrder(Set<String> planOrderNo) {
        String properties = "billno AS planorder,demandbill,demandseq";
        QFilter[] qFilters = new QFilter[2];
        qFilters[0] = new QFilter("billno", "in", planOrderNo);
        return QueryServiceHelper.queryDataSet((String)(algoKey + "_queryPlanOrder"), (String)"mrp_planorder", (String)properties, (QFilter[])qFilters, null);
    }

    protected DataSet queryManuInBill(Set<Long> entryIds) {
        String properties = "billentry.manuentryid,billentry.qualitystatus,billentry.qtyunit2nd";
        QFilter qFilter = new QFilter("billentry.manuentryid", "in", entryIds);
        DataSet manuInBillDataSet = QueryServiceHelper.queryDataSet((String)(algoKey + "_queryManuInBill"), (String)"im_mdc_mftmanuinbill", (String)properties, (QFilter[])new QFilter[]{qFilter}, null);
        String[] groupFields = new String[]{"billentry.manuentryid", "billentry.qualitystatus"};
        DataSet ass_quainwaqty = manuInBillDataSet.filter("billentry.qualitystatus = 'A'").groupBy(groupFields).sum("billentry.qtyunit2nd", "ass_quainwaqty").finish();
        DataSet ass_unquainwaqty = manuInBillDataSet.filter("billentry.qualitystatus = 'B'").groupBy(groupFields).sum("billentry.qtyunit2nd", "ass_unquainwaqty").finish();
        DataSet ass_scrinwaqty = manuInBillDataSet.filter("billentry.qualitystatus = 'D'").groupBy(groupFields).sum("billentry.qtyunit2nd", "ass_scrinwaqty").finish();
        DataSet groupManuInBillDataSet = manuInBillDataSet.groupBy(groupFields).finish();
        DataSet resultDataSet = groupManuInBillDataSet.leftJoin(ass_quainwaqty).on("billentry.manuentryid", "billentry.manuentryid").on("billentry.qualitystatus", "billentry.qualitystatus").select(groupManuInBillDataSet.getRowMeta().getFieldNames(), new String[]{"ass_quainwaqty"}).finish();
        resultDataSet = resultDataSet.leftJoin(ass_unquainwaqty).on("billentry.manuentryid", "billentry.manuentryid").on("billentry.qualitystatus", "billentry.qualitystatus").select(resultDataSet.getRowMeta().getFieldNames(), new String[]{"ass_unquainwaqty"}).finish();
        resultDataSet = resultDataSet.leftJoin(ass_scrinwaqty).on("billentry.manuentryid", "billentry.manuentryid").on("billentry.qualitystatus", "billentry.qualitystatus").select(resultDataSet.getRowMeta().getFieldNames(), new String[]{"ass_scrinwaqty"}).finish();
        resultDataSet = resultDataSet.groupBy(new String[]{"billentry.manuentryid"}).sum("ass_quainwaqty", "ass_quainwaqty").sum("ass_unquainwaqty", "ass_unquainwaqty").sum("ass_scrinwaqty", "ass_scrinwaqty").finish();
        return resultDataSet;
    }

    protected DataSet queryMftOrder(Set<Long> entryIds) {
        String properties = "treeentryentity.id,treeentryentity.sourcebilltype,treeentryentity.sourcebillnumber,treeentryentity.sourceentryseq";
        QFilter qFilter = new QFilter("treeentryentity.id", "in", entryIds);
        return QueryServiceHelper.queryDataSet((String)(algoKey + "_queryMftOrder"), (String)"pom_mftorder", (String)properties, (QFilter[])new QFilter[]{qFilter}, null);
    }

    protected String getSelectFields() {
        String property = "orderentryid.headbillno AS mftorder,orderentryid.id AS mftentryid,orderentryid.entryseq AS mftorderseq,orderentryid.bizstatus AS bizstatus,orderentryid.planstatus AS planstatus,orderentryid.taskstatus AS taskstatus,orderentryid.material.masterid AS material,orderentryid.auxproperty AS auxproperty,orderentryid.unit AS unit,orderentryid.qty AS qty,orderentryid.baseunit AS baseunit,orderentryid.baseqty AS baseqty,billno AS stockno,transactiontypeid AS transactiontype,stockentry.seq AS stockseq,stockentry.materialid AS stock_material,stockentry.materielmasterid.number AS stock_materialnum,stockentry.materialunitid AS stock_baseunit,stockentry.standqty AS stock_standqty,stockentry.demandqty AS stock_demandqty,stockentry.actissueqty AS stock_actissueqty,stockentry.rejectedqty AS stock_rejectedqty,stockentry.feedingqty AS stock_feedingqty,stockentry.unissueqty AS stock_unissueqty,stockentry.iscannegative AS stock_iscannegative,stockentry.sourcetype AS stock_sourcetype,bdproject,tracknumber";
        return property;
    }

    protected List<QFilter> createHeadFilters() {
        FilterInfo filter = this.getQueryParam().getFilter();
        ArrayList<QFilter> qfList = new ArrayList<QFilter>();
        this.createOrgFilter(filter, qfList);
        this.createBiztypeFilter(filter, qfList);
        this.createProductTypeFilter(filter, qfList);
        this.createStartTimeFilter(filter, qfList);
        this.createFinishTimeFilter(filter, qfList);
        this.createPorductDeptFilter(filter, qfList);
        this.createOrderFilter(filter, qfList);
        this.createMaterialFilter(filter, qfList);
        this.createBizStatusFilter(filter, qfList);
        this.createPlanStatusFilter(filter, qfList);
        this.createTaskStatusFilter(filter, qfList);
        this.createPickStatusFilter(filter, qfList);
        this.createStockFilter(filter, qfList);
        this.createProjectFilter(filter, qfList);
        this.createTrackNumberFilter(filter, qfList);
        return qfList;
    }

    private void createStockFilter(FilterInfo filter, List<QFilter> qfList) {
        DynamicObject materialto;
        DynamicObjectCollection head_materialfrom = filter.getDynamicObjectCollection("head_materialfrom");
        if (head_materialfrom != null) {
            if (head_materialfrom.size() == 1) {
                qfList.add(new QFilter("stockentry.materialid", ">=", ((DynamicObject)head_materialfrom.get(0)).getPkValue()));
            } else {
                HashSet idSet = new HashSet(head_materialfrom.size());
                head_materialfrom.forEach(obj -> idSet.add(obj.getPkValue()));
                qfList.add(new QFilter("stockentry.materialid", "in", idSet));
            }
        }
        if ((materialto = filter.getDynamicObject("head_materialto")) != null) {
            qfList.add(new QFilter("stockentry.materialid", "<=", materialto.getPkValue()));
        }
    }

    private void createOrgFilter(FilterInfo filter, List<QFilter> qfList) {
        DynamicObject head_org = filter.getDynamicObject("head_org");
        if (head_org != null) {
            qfList.add(new QFilter("org", "=", head_org.getPkValue()));
        }
    }

    private void createBiztypeFilter(FilterInfo filter, List<QFilter> qfList) {
        DynamicObjectCollection head_biztype = filter.getDynamicObjectCollection("head_biztype");
        if (head_biztype != null) {
            HashSet idSet = new HashSet(head_biztype.size());
            head_biztype.forEach(obj -> idSet.add(obj.getPkValue()));
            qfList.add(new QFilter("transactiontypeid.transactiontype", "in", idSet));
        }
    }

    private void createProductTypeFilter(FilterInfo filter, List<QFilter> qfList) {
        DynamicObjectCollection head_transactproduct = filter.getDynamicObjectCollection("head_transactproduct");
        if (head_transactproduct != null) {
            HashSet idSet = new HashSet(head_transactproduct.size());
            head_transactproduct.forEach(obj -> idSet.add(obj.getPkValue()));
            qfList.add(new QFilter("transactiontypeid", "in", idSet));
        }
    }

    private void createOrderFilter(FilterInfo filter, List<QFilter> qfList) {
        String head_orderto;
        String head_orderfrom = filter.getString("head_orderfrom");
        if (StringUtils.isNotEmpty((CharSequence)head_orderfrom)) {
            qfList.add(new QFilter("orderentryid.headbillno", ">=", (Object)head_orderfrom));
        }
        if (StringUtils.isNotEmpty((CharSequence)(head_orderto = filter.getString("head_orderto")))) {
            qfList.add(new QFilter("orderentryid.headbillno", "<=", (Object)head_orderto));
        }
    }

    private void createStartTimeFilter(FilterInfo filter, List<QFilter> qfList) {
        Date beginDate = filter.getDate("begintime");
        Date endDate = filter.getDate("endtime");
        Calendar cal = Calendar.getInstance();
        if (beginDate != null) {
            cal.setTime(beginDate);
            cal.set(10, 0);
            cal.set(11, 0);
            cal.set(12, 0);
            cal.set(13, 0);
            cal.set(14, 0);
            qfList.add(new QFilter("orderentryid.planbegintime", ">=", (Object)cal.getTime()));
        }
        if (endDate != null) {
            cal.setTime(endDate);
            cal.set(10, 0);
            cal.set(11, 0);
            cal.set(12, 0);
            cal.set(13, 0);
            cal.set(14, 0);
            cal.add(5, 1);
            qfList.add(new QFilter("orderentryid.planbegintime", "<", (Object)cal.getTime()));
        }
    }

    private void createFinishTimeFilter(FilterInfo filter, List<QFilter> qfList) {
        if (filter.getDate("finishbegin") != null && filter.getDate("finishend") != null) {
            Date beginDate = filter.getDate("finishbegin");
            Date endDate = filter.getDate("finishend");
            Calendar cal = Calendar.getInstance();
            cal.setTime(beginDate);
            cal.set(10, 0);
            cal.set(11, 0);
            cal.set(12, 0);
            cal.set(13, 0);
            cal.set(14, 0);
            qfList.add(new QFilter("orderentryid.planendtime", ">=", (Object)cal.getTime()));
            cal.setTime(endDate);
            cal.set(10, 0);
            cal.set(11, 0);
            cal.set(12, 0);
            cal.set(13, 0);
            cal.set(14, 0);
            cal.add(5, 1);
            qfList.add(new QFilter("orderentryid.planendtime", "<", (Object)cal.getTime()));
        }
    }

    private void createPorductDeptFilter(FilterInfo filter, List<QFilter> qfList) {
        DynamicObject head_producedept = filter.getDynamicObject("head_producedept");
        if (head_producedept != null) {
            qfList.add(new QFilter("orderentryid.producedept", "=", head_producedept.getPkValue()));
        }
    }

    private void createMaterialFilter(FilterInfo filter, List<QFilter> qfList) {
        DynamicObject head_productto;
        DynamicObjectCollection head_productfrom = filter.getDynamicObjectCollection("head_productfrom");
        if (head_productfrom != null) {
            if (head_productfrom.size() == 1) {
                qfList.add(new QFilter("orderentryid.material", ">=", ((DynamicObject)head_productfrom.get(0)).getPkValue()));
            } else {
                HashSet idSet = new HashSet(head_productfrom.size());
                head_productfrom.forEach(obj -> idSet.add(obj.getPkValue()));
                qfList.add(new QFilter("orderentryid.material", "in", idSet));
            }
        }
        if ((head_productto = filter.getDynamicObject("head_productto")) != null) {
            qfList.add(new QFilter("orderentryid.material", "<=", head_productto.getPkValue()));
        }
    }

    private void createBillStatusFilter(FilterInfo filter, List<QFilter> qfList) {
        String head_billstatus = filter.getString("head_billstatus");
        qfList.add(new QFilter("billstatus", "in", (Object)head_billstatus.substring(1, head_billstatus.length() - 1).split(",")));
    }

    private void createTaskStatusFilter(FilterInfo filter, List<QFilter> qfList) {
        String head_taskstatus = filter.getString("head_taskstatus");
        qfList.add(new QFilter("orderentryid.taskstatus", "in", (Object)head_taskstatus.substring(1, head_taskstatus.length() - 1).split(",")));
    }

    private void createPlanStatusFilter(FilterInfo filter, List<QFilter> qfList) {
        String head_planstatus = filter.getString("head_planstatus");
        qfList.add(new QFilter("orderentryid.planstatus", "in", (Object)head_planstatus.substring(1, head_planstatus.length() - 1).split(",")));
    }

    private void createBizStatusFilter(FilterInfo filter, List<QFilter> qfList) {
        String head_bizstatus = filter.getString("head_bizstatus");
        qfList.add(new QFilter("orderentryid.bizstatus", "in", (Object)head_bizstatus.substring(1, head_bizstatus.length() - 1).split(",")));
    }

    private void createPickStatusFilter(FilterInfo filter, List<QFilter> qfList) {
        String head_pickstatus = filter.getString("head_pickstatus");
        qfList.add(new QFilter("orderentryid.pickstatus", "in", (Object)head_pickstatus.substring(1, head_pickstatus.length() - 1).split(",")));
    }

    private void createProjectFilter(FilterInfo filter, List<QFilter> qfList) {
        DynamicObjectCollection projects = filter.getDynamicObjectCollection("head_bdproject");
        if (projects != null) {
            List ids = projects.stream().map(DataEntityBase::getPkValue).collect(Collectors.toList());
            qfList.add(new QFilter("bdproject", "in", ids));
        }
    }

    private void createTrackNumberFilter(FilterInfo filter, List<QFilter> qfList) {
        DynamicObjectCollection trackNumber = filter.getDynamicObjectCollection("head_tracknumber");
        if (trackNumber != null) {
            List ids = trackNumber.stream().map(DataEntityBase::getPkValue).collect(Collectors.toList());
            qfList.add(new QFilter("tracknumber", "in", ids));
        }
    }
}

