/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.mpdm.report.tpl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.GroupbyDataSet;
import kd.bos.algo.JoinDataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.AbstractReportListDataPlugin;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportColumn;
import kd.bos.entity.report.ReportColumnGroup;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;

public class OrderExecuteDetailRptQuery
extends AbstractReportListDataPlugin {
    protected static String[] arr = new String[]{"billname", "billno", "e_customer", "e_address", "e_receiveaddress", "cast(seq as STRING) seq", "e_deliverydate", "e_saleremark"};

    public DataSet query(ReportQueryParam arg0, Object arg1) throws Throwable {
        List<QFilter> qfList = this.appendFilter();
        String selectFields = this.getSelectFields();
        String orderBillType = this.getQueryParam().getCustomParam().get("order").toString();
        DataSet queryDataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)orderBillType, (String)selectFields, (QFilter[])qfList.toArray(new QFilter[0]), null);
        StringBuilder sql = this.getErrorDateData(queryDataSet);
        DataSet dataSet = this.appendInWarehouseStatusFilter(queryDataSet.select(sql.toString()));
        HashSet<String> planBillNoSet = new HashSet<String>(16);
        HashSet<String> saleBillNoSet = new HashSet<String>(16);
        HashSet<Long> orderEntrySet = new HashSet<Long>(16);
        DataSet billNoDataSet = this.getOtherBillNo(dataSet.copy(), planBillNoSet, saleBillNoSet, orderEntrySet);
        DataSet resourceDataSet = this.getSourceBillNo(planBillNoSet, saleBillNoSet, billNoDataSet);
        DataSet saleDataSet = this.getSaleOrderData(saleBillNoSet, resourceDataSet);
        DataSet orderDataSet = dataSet.leftJoin(saleDataSet).on("entryid", "e_entryid").select(dataSet.getRowMeta().getFieldNames(), saleDataSet.getRowMeta().getFieldNames()).finish();
        DataSet inBillDataSet = this.getInBillData(orderBillType, orderEntrySet);
        DataSet returnDataSet = this.calQty(orderDataSet, inBillDataSet);
        if (this.getQueryParam().getSortInfo() != null) {
            returnDataSet = returnDataSet.orderBy(new String[]{this.getQueryParam().getSortInfo()});
        }
        return returnDataSet;
    }

    protected DataSet calQty(DataSet saleDataSet, DataSet inBillDataSet) {
        DataSet auxquainwaqty = inBillDataSet.copy().select("manuentryid,qualitystatus,qtyunit2nd e_auxquainwaqty").where("qualitystatus = 'A'");
        DataSet auxunquainwaqty = inBillDataSet.copy().select("manuentryid,qualitystatus,qtyunit2nd e_auxunquainwaqty").where("qualitystatus = 'B'");
        DataSet auxscrinwaqty = inBillDataSet.select("manuentryid,qualitystatus,qtyunit2nd e_auxscrinwaqty").where("qualitystatus = 'D'");
        saleDataSet = saleDataSet.leftJoin(auxquainwaqty).on("entryid", "manuentryid").select(saleDataSet.getRowMeta().getFieldNames(), new String[]{"e_auxquainwaqty"}).finish();
        saleDataSet = saleDataSet.leftJoin(auxunquainwaqty).on("entryid", "manuentryid").select(saleDataSet.getRowMeta().getFieldNames(), new String[]{"e_auxunquainwaqty"}).finish();
        saleDataSet = saleDataSet.leftJoin(auxscrinwaqty).on("entryid", "manuentryid").select(saleDataSet.getRowMeta().getFieldNames(), new String[]{"e_auxscrinwaqty"}).finish();
        String fields = Arrays.toString(saleDataSet.getRowMeta().getFields());
        saleDataSet = saleDataSet.select(fields.substring(1, fields.length() - 1) + ",(e_auxquainwaqty+e_auxunquainwaqty+e_auxscrinwaqty) e_auxtotalqty,(e_orderqty - e_totalqty) e_untotalqty,(e_auxptyqty - e_auxquainwaqty-e_auxunquainwaqty-e_auxscrinwaqty) e_auxuntotalqty");
        return saleDataSet;
    }

    protected DataSet getInBillData(String orderBillType, Set<Long> orderEntrySet) {
        String inBillType;
        QFilter qFilter = new QFilter("billentry.manuentryid", "in", orderEntrySet);
        qFilter.and(new QFilter("billentry.qualitystatus", "in", (Object)new String[]{"A", "B", "D"}));
        qFilter.and(new QFilter("billentry.producttype", "=", (Object)"C"));
        String string = inBillType = "pom_mftorder".equals(orderBillType) ? "im_mdc_mftmanuinbill" : "im_mdc_omcmplinbill";
        if ("im_mdc_mftmanuinbill".equals(inBillType)) {
            qFilter.and(new QFilter("productiondomain", "=", (Object)"A"));
        }
        DataSet inBillDataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)inBillType, (String)"billentry.manuentryid manuentryid,billentry.qualitystatus qualitystatus,billentry.qtyunit2nd qtyunit2nd", (QFilter[])new QFilter[]{qFilter}, null);
        GroupbyDataSet groupBy = inBillDataSet.groupBy(new String[]{"manuentryid", "qualitystatus"});
        inBillDataSet = groupBy.sum("qtyunit2nd").finish();
        return inBillDataSet;
    }

    private DataSet getSaleOrderData(Set<String> saleBillNoSet, DataSet resourceDataSet) {
        DataSet saleDataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"sm_salorder", (String)this.getSaleOrderFields(), (QFilter[])new QFilter[]{new QFilter("billno", "in", saleBillNoSet)}, null);
        JoinDataSet joinDataSet = resourceDataSet.leftJoin(saleDataSet.select(this.getSaleArray())).on("e_sourcebilltype", "billname").on("e_sourcebillnumber", "billno").on("e_sourceentryseq", "seq");
        resourceDataSet = joinDataSet.select(resourceDataSet.getRowMeta().getFieldNames(), saleDataSet.getRowMeta().getFieldNames()).finish();
        return resourceDataSet;
    }

    private DataSet getSourceBillNo(Set<String> planBillNoSet, Set<String> saleBillNoSet, DataSet billNoDataSet) {
        StringBuilder sql = new StringBuilder();
        DataSet planDataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"mrp_planorder", (String)"billno,demandbill,demandseq", (QFilter[])new QFilter[]{new QFilter("billno", "in", planBillNoSet)}, null);
        DataSet copy = planDataSet.copy();
        for (Row row : copy) {
            saleBillNoSet.add(row.getString("demandbill"));
        }
        DataSet finish = billNoDataSet.leftJoin(planDataSet).on("e_sourcebillnumber", "billno").select(new String[]{"e_entryid", "e_sourcebilltype", "e_sourcebillnumber", "e_sourceentryseq", "demandbill", "demandseq"}).finish();
        sql.append("e_entryid,");
        sql.append("(case when e_sourcebilltype = 'mrp_planorder' then 'sm_salorder' else e_sourcebilltype end) e_sourcebilltype,");
        sql.append("(case when e_sourcebilltype = 'mrp_planorder' then demandbill else e_sourcebillnumber end ) e_sourcebillnumber,");
        sql.append("(case when e_sourcebilltype = 'mrp_planorder' then (case when demandseq = 0 then '' else cast(demandseq as STRING) end) else e_sourceentryseq end ) e_sourceentryseq,");
        sql.append("(case when e_sourcebilltype = 'mrp_planorder' then e_sourcebillnumber else '' end ) e_planorder");
        DataSet select = finish.select(sql.toString());
        return select;
    }

    private DataSet getOtherBillNo(DataSet dataSet, Set<String> planBillNoSet, Set<String> saleBillNoSet, Set<Long> orderEntrySet) {
        DataSet billNoDataSet = dataSet.select("entryid e_entryid,sourcebilltype e_sourcebilltype,sourcebillnumber e_sourcebillnumber,sourceentryseq e_sourceentryseq");
        DataSet copy = billNoDataSet.copy();
        for (Row row : copy) {
            orderEntrySet.add(row.getLong("e_entryid"));
            String billType = row.getString("e_sourcebilltype");
            if ("mrp_planorder".equals(billType)) {
                planBillNoSet.add(row.getString("e_sourcebillnumber"));
                continue;
            }
            if (!"sm_salorder".equals(billType)) continue;
            saleBillNoSet.add(row.getString("e_sourcebillnumber"));
        }
        return billNoDataSet;
    }

    protected String[] getSaleArray() {
        return arr;
    }

    protected String getSaleOrderFields() {
        StringBuilder sql = new StringBuilder();
        sql.append("'sm_salorder' billname,");
        sql.append("billno billno,");
        sql.append("customer e_customer,");
        sql.append("address e_address,");
        sql.append("receiveaddress e_receiveaddress,");
        sql.append("billentry.seq seq,");
        sql.append("billentry.deliverydate e_deliverydate,");
        sql.append("billentry.remark e_saleremark");
        return sql.toString();
    }

    private StringBuilder getErrorDateData(DataSet queryDataSet) {
        String fields = Arrays.toString(queryDataSet.getRowMeta().getFields());
        StringBuilder sql = new StringBuilder();
        sql.append(fields.substring(1, fields.length() - 1));
        sql.append(",DATEDIF(TO_DATE(TO_CHAR(e_planstarttime,'yyyy-MM-dd'),'yyyy-MM-dd')");
        sql.append(",TO_DATE(TO_CHAR(case when e_startworktime is null then cast(now() as Timestamp)");
        sql.append(" else e_startworktime end,'yyyy-MM-dd'),'yyyy-MM-dd'),D) e_starterrortime");
        sql.append(",DATEDIF(TO_DATE(TO_CHAR(e_planfinishtime,'yyyy-MM-dd'),'yyyy-MM-dd')");
        sql.append(",TO_DATE(TO_CHAR(case when e_finishtime is null then cast(now() as Timestamp)");
        sql.append(" else e_finishtime end,'yyyy-MM-dd'),'yyyy-MM-dd'),D) e_finisherrortime");
        sql.append(",(case when e_totalqty >= e_orderqty then 'C' when");
        sql.append(" e_totalqty > 0 and e_totalqty < e_orderqty then 'B' else 'A' end)  inwarehousestatus");
        return sql;
    }

    protected String getSelectFields() {
        StringBuilder sql = new StringBuilder();
        String orderBillType = this.getQueryParam().getCustomParam().get("order").toString();
        if ("om_mftorder".equals(orderBillType)) {
            sql.append("treeentryentity.supplier e_supplier,");
        }
        sql.append("org e_org,");
        sql.append("treeentryentity.producedept e_producedept,");
        sql.append("treeentryentity.materielmasterid e_material,");
        sql.append("treeentryentity.unit e_unit,");
        sql.append("treeentryentity.baseunit e_baseunit,");
        sql.append("treeentryentity.auxptyunit e_auxptyunit,");
        sql.append("treeentryentity.auxproperty e_auxproperty,");
        sql.append("billno e_order,");
        sql.append("treeentryentity.seq e_orderrow,");
        sql.append("treeentryentity.qty e_qty,");
        if ("om_mftorder".equals(orderBillType)) {
            sql.append("treeentryentity.purauditqty e_purauditqty,");
        }
        sql.append("treeentryentity.reportqty e_reportqty,");
        sql.append("treeentryentity.qty - treeentryentity.reportqty e_unreportqty,");
        sql.append("treeentryentity.reportqty/treeentryentity.qty*100 e_finishrate,");
        sql.append("treeentryentity.pickstatus e_pickstatus,");
        sql.append("treeentryentity.baseqty e_orderqty,");
        sql.append("treeentryentity.auxptyqty e_auxptyqty,");
        sql.append("treeentryentity.quainwaqty e_quainwaqty,");
        sql.append("treeentryentity.unquainwaqty e_unquainwaqty,");
        sql.append("treeentryentity.scrinwaqty e_scrinwaqty,");
        sql.append("treeentryentity.quainwaqty + treeentryentity.unquainwaqty + treeentryentity.scrinwaqty e_totalqty,");
        sql.append("(treeentryentity.quainwaqty + treeentryentity.unquainwaqty + treeentryentity.scrinwaqty)/treeentryentity.baseqty*100 e_conversionrate,");
        sql.append("treeentryentity.planbegintime e_planstarttime,");
        sql.append("treeentryentity.startworktime e_startworktime,");
        sql.append("treeentryentity.planendtime e_planfinishtime,");
        sql.append("treeentryentity.endworktime e_finishtime,");
        sql.append("transactiontype.transactiontype e_biztype,");
        sql.append("transactiontype e_transactproduct,");
        sql.append("billstatus e_billstatus,");
        sql.append("treeentryentity.bizstatus e_bizstatus,");
        sql.append("treeentryentity.planstatus e_planstatus,");
        sql.append("treeentryentity.taskstatus e_taskstatus,");
        sql.append("creator e_creator,");
        sql.append("createtime e_createtime,");
        sql.append("modifier e_modifier,");
        sql.append("modifytime e_modifytime,");
        sql.append("auditor e_auditor,");
        sql.append("auditdate e_auditdate,");
        sql.append("remark e_orderremark,");
        sql.append("treeentryentity.sourcebilltype sourcebilltype,");
        sql.append("treeentryentity.sourcebillnumber sourcebillnumber,");
        sql.append("treeentryentity.sourceentryseq sourceentryseq,");
        sql.append("treeentryentity.id entryid,");
        sql.append("treeentryentity.bdproject e_bdproject,");
        sql.append("treeentryentity.tracknumber e_tracknumber");
        return sql.toString();
    }

    protected List<QFilter> appendFilter() {
        FilterInfo filter = this.getQueryParam().getFilter();
        ArrayList<QFilter> qfList = new ArrayList<QFilter>();
        qfList.add(new QFilter("treeentryentity.producttype", "=", (Object)"C"));
        this.appendOrgFilter(filter, qfList);
        this.appendBiztypeFilter(filter, qfList);
        this.appendProductTypeFilter(filter, qfList);
        this.appendSupplierFilter(filter, qfList);
        this.appendOrderFilter(filter, qfList);
        this.appendStartTimeFilter(filter, qfList);
        this.appendFinishTimeFilter(filter, qfList);
        this.appendPorductDeptFilter(filter, qfList);
        this.appendMaterialFilter(filter, qfList);
        this.appendTaskStatusFilter(filter, qfList);
        this.appendPlanStatusFilter(filter, qfList);
        this.appendBizStatusFilter(filter, qfList);
        this.appendBillStatusFilter(filter, qfList);
        this.appendPickStatusFilter(filter, qfList);
        this.appendProjectFilter(filter, qfList);
        this.appendTrackNumberFilter(filter, qfList);
        return qfList;
    }

    private void appendOrgFilter(FilterInfo filter, List<QFilter> qfList) {
        qfList.add(new QFilter("org", "=", filter.getDynamicObject("org").getPkValue()));
    }

    private void appendBiztypeFilter(FilterInfo filter, List<QFilter> qfList) {
        if (filter.getDynamicObjectCollection("biztype") != null) {
            HashSet idSet = new HashSet(filter.getDynamicObjectCollection("biztype").size());
            filter.getDynamicObjectCollection("biztype").forEach(obj -> idSet.add(obj.getPkValue()));
            qfList.add(new QFilter("transactiontype.transactiontype", "in", idSet));
        }
    }

    private void appendProductTypeFilter(FilterInfo filter, List<QFilter> qfList) {
        if (filter.getDynamicObjectCollection("transactproduct") != null) {
            HashSet idSet = new HashSet(filter.getDynamicObjectCollection("transactproduct").size());
            filter.getDynamicObjectCollection("transactproduct").forEach(obj -> idSet.add(obj.getPkValue()));
            qfList.add(new QFilter("transactiontype", "in", idSet));
        }
    }

    private void appendSupplierFilter(FilterInfo filter, List<QFilter> qfList) {
        if (filter.getDynamicObjectCollection("supplier") != null) {
            HashSet idSet = new HashSet(filter.getDynamicObjectCollection("supplier").size());
            filter.getDynamicObjectCollection("supplier").forEach(obj -> idSet.add(obj.getPkValue()));
            qfList.add(new QFilter("treeentryentity.supplier", "in", idSet));
        }
    }

    private void appendOrderFilter(FilterInfo filter, List<QFilter> qfList) {
        if (filter.getString("order") != null && !"".equals(filter.getString("order"))) {
            qfList.add(new QFilter("billno", ">=", (Object)filter.getString("order")));
        }
        if (filter.getString("orderto") != null && !"".equals(filter.getString("orderto"))) {
            qfList.add(new QFilter("billno", "<=", (Object)filter.getString("orderto")));
        }
    }

    private void appendStartTimeFilter(FilterInfo filter, List<QFilter> qfList) {
        Date beginDate = filter.getDate("begintime");
        Date endDate = filter.getDate("endtime");
        Calendar cal = Calendar.getInstance();
        cal.setTime(beginDate);
        cal.set(10, 0);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        qfList.add(new QFilter("treeentryentity.planbegintime", ">=", (Object)cal.getTime()));
        cal.setTime(endDate);
        cal.set(10, 0);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        cal.add(5, 1);
        qfList.add(new QFilter("treeentryentity.planbegintime", "<", (Object)cal.getTime()));
    }

    private void appendFinishTimeFilter(FilterInfo filter, List<QFilter> qfList) {
        if (filter.getDate("finishbegin") != null && filter.getDate("finishend") != null) {
            Date beginDate = filter.getDate("finishbegin");
            Date endDate = filter.getDate("finishend");
            Calendar cal = Calendar.getInstance();
            cal.setTime(beginDate);
            cal.set(10, 0);
            cal.set(11, 0);
            cal.set(12, 0);
            cal.set(13, 0);
            cal.set(14, 0);
            qfList.add(new QFilter("treeentryentity.planendtime", ">=", (Object)cal.getTime()));
            cal.setTime(endDate);
            cal.set(10, 0);
            cal.set(11, 0);
            cal.set(12, 0);
            cal.set(13, 0);
            cal.set(14, 0);
            cal.add(5, 1);
            qfList.add(new QFilter("treeentryentity.planendtime", "<", (Object)cal.getTime()));
        }
    }

    private void appendPorductDeptFilter(FilterInfo filter, List<QFilter> qfList) {
        if (filter.getDynamicObject("producedept") != null) {
            qfList.add(new QFilter("treeentryentity.producedept", "=", filter.getDynamicObject("producedept").getPkValue()));
        }
    }

    private void appendMaterialFilter(FilterInfo filter, List<QFilter> qfList) {
        if (filter.getDynamicObjectCollection("material") != null) {
            if (filter.getDynamicObjectCollection("material").size() == 1) {
                qfList.add(new QFilter("treeentryentity.material", ">=", ((DynamicObject)filter.getDynamicObjectCollection("material").get(0)).getPkValue()));
            } else {
                HashSet idSet = new HashSet(filter.getDynamicObjectCollection("material").size());
                filter.getDynamicObjectCollection("material").forEach(obj -> idSet.add(obj.getPkValue()));
                qfList.add(new QFilter("treeentryentity.material", "in", idSet));
            }
        }
        if (filter.getDynamicObject("materialto") != null) {
            qfList.add(new QFilter("treeentryentity.material", "<=", filter.getDynamicObject("materialto").getPkValue()));
        }
    }

    private void appendTaskStatusFilter(FilterInfo filter, List<QFilter> qfList) {
        qfList.add(new QFilter("treeentryentity.taskstatus", "in", (Object)filter.getString("taskstatus").substring(1, filter.getString("taskstatus").length() - 1).split(",")));
    }

    private void appendPlanStatusFilter(FilterInfo filter, List<QFilter> qfList) {
        qfList.add(new QFilter("treeentryentity.planstatus", "in", (Object)filter.getString("planstatus").substring(1, filter.getString("planstatus").length() - 1).split(",")));
    }

    private void appendBizStatusFilter(FilterInfo filter, List<QFilter> qfList) {
        qfList.add(new QFilter("treeentryentity.bizstatus", "in", (Object)filter.getString("bizstatus").substring(1, filter.getString("bizstatus").length() - 1).split(",")));
    }

    private void appendBillStatusFilter(FilterInfo filter, List<QFilter> qfList) {
        qfList.add(new QFilter("billstatus", "in", (Object)filter.getString("billstatus").substring(1, filter.getString("billstatus").length() - 1).split(",")));
        qfList.add(new QFilter("treeentryentity.baseqty", "!=", (Object)0));
    }

    private void appendPickStatusFilter(FilterInfo filter, List<QFilter> qfList) {
        qfList.add(new QFilter("treeentryentity.pickstatus", "in", (Object)filter.getString("pickstatus").substring(1, filter.getString("pickstatus").length() - 1).split(",")));
    }

    private DataSet appendInWarehouseStatusFilter(DataSet queryDataSet) {
        FilterInfo filter = this.getQueryParam().getFilter();
        String[] split = filter.getString("inwarehousestatus").substring(1, filter.getString("inwarehousestatus").length() - 1).split(",");
        StringBuilder sql = new StringBuilder();
        for (String s : split) {
            if (sql.length() == 0) {
                sql.append('\'');
                sql.append(s);
                sql.append('\'');
                continue;
            }
            sql.append(",'");
            sql.append(s);
            sql.append('\'');
        }
        sql.insert(0, "inwarehousestatus in (");
        sql.append(')');
        DataSet where = queryDataSet.where(sql.toString());
        return where;
    }

    private void appendProjectFilter(FilterInfo filter, List<QFilter> qfList) {
        DynamicObjectCollection bdProject = filter.getDynamicObjectCollection("bdproject");
        if (bdProject != null) {
            List ids = bdProject.stream().map(DataEntityBase::getPkValue).collect(Collectors.toList());
            qfList.add(new QFilter("treeentryentity.bdproject", "in", ids));
        }
    }

    private void appendTrackNumberFilter(FilterInfo filter, List<QFilter> qfList) {
        DynamicObjectCollection trackNumber = filter.getDynamicObjectCollection("tracknumber");
        if (trackNumber != null) {
            List ids = trackNumber.stream().map(DataEntityBase::getPkValue).collect(Collectors.toList());
            qfList.add(new QFilter("treeentryentity.tracknumber", "in", ids));
        }
    }

    public List<AbstractReportColumn> getColumns(List<AbstractReportColumn> columns) throws Throwable {
        List columns2 = super.getColumns(columns);
        if (!"om_mftorder".equals(this.getQueryParam().getCustomParam().get("order"))) {
            Iterator iterator = columns2.iterator();
            while (iterator.hasNext()) {
                AbstractReportColumn next = (AbstractReportColumn)iterator.next();
                if (next instanceof ReportColumnGroup) continue;
                ReportColumn co = (ReportColumn)next;
                if ("e_supplier".contains(co.getFieldKey()) || "e_suppliername".contains(co.getFieldKey())) {
                    iterator.remove();
                    continue;
                }
                if ("e_purauditqty".contains(co.getFieldKey())) {
                    iterator.remove();
                    continue;
                }
                if ("e_order".equals(co.getFieldKey())) {
                    next.setCaption(new LocaleString(ResManager.loadKDString((String)"\u751f\u4ea7\u5de5\u5355\u7f16\u53f7", (String)"OrderExecuteDetailRptQuery_0", (String)"bd-mpdm-report", (Object[])new Object[0])));
                    continue;
                }
                if (!"e_orderrow".equals(co.getFieldKey())) continue;
                next.setCaption(new LocaleString(ResManager.loadKDString((String)"\u751f\u4ea7\u5de5\u5355\u884c\u53f7", (String)"OrderExecuteDetailRptQuery_1", (String)"bd-mpdm-report", (Object[])new Object[0])));
            }
        }
        return columns2;
    }
}

