/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.mpdm.report.tpl;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataSetBuilder;
import kd.bos.algo.DataType;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.RowMetaFactory;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.report.AbstractReportListDataPlugin;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;

public class ProductionInSotreDetailRptQuery
extends AbstractReportListDataPlugin {
    public static final String algoKey = ProductionInSotreDetailRptQuery.class.getName();
    public static final String[] otherFields = new String[]{"entryid", "requirebillno", "requirebillseq"};
    public static final DataType[] otherTypes = new DataType[]{DataType.LongType, DataType.StringType, DataType.StringType};

    public DataSet query(ReportQueryParam reportQueryParam, Object o) throws Throwable {
        DataSet manuInBillDataSet = this.queryManuInBillDataSet();
        HashSet<Long> entryIds = new HashSet<Long>(16);
        manuInBillDataSet.copy().forEach(row -> entryIds.add(row.getLong("manuentryid")));
        DataSet otherDataSet = this.createOtherDataSet(entryIds);
        DataSet resultDataSet = manuInBillDataSet.leftJoin(otherDataSet).on("manuentryid", "entryid").select(manuInBillDataSet.getRowMeta().getFieldNames(), otherDataSet.getRowMeta().getFieldNames()).finish();
        String sort = reportQueryParam.getSortInfo();
        if (StringUtils.isNotEmpty((CharSequence)sort)) {
            resultDataSet = resultDataSet.orderBy(new String[]{sort});
        }
        return resultDataSet;
    }

    protected DataSet createOtherDataSet(Set<Long> entryIds) {
        DataSet mftOrderDataSet = this.queryMftOrder(entryIds);
        HashSet<String> planOrderNo = new HashSet<String>(16);
        HashSet<String> saleOrderNo = new HashSet<String>(16);
        mftOrderDataSet.copy().forEach(row -> {
            String sourceBillType = row.getString("treeentryentity.sourcebilltype");
            String sourceBillNumber = row.getString("treeentryentity.sourcebillnumber");
            if (StringUtils.equals((CharSequence)"mrp_planorder", (CharSequence)sourceBillType) && StringUtils.isNotBlank((CharSequence)sourceBillNumber)) {
                planOrderNo.add(sourceBillNumber);
            } else if (StringUtils.equals((CharSequence)"sm_salorder", (CharSequence)sourceBillType) && StringUtils.isNotBlank((CharSequence)sourceBillNumber)) {
                saleOrderNo.add(sourceBillNumber);
            }
        });
        DataSet planOrderDataSet = this.queryPlanOrder(planOrderNo);
        planOrderDataSet.copy().forEach(row -> {
            String demandbill = row.getString("demandbill");
            if (StringUtils.isNotBlank((CharSequence)demandbill)) {
                saleOrderNo.add(demandbill);
            }
        });
        DataSet resultDataSet = mftOrderDataSet.leftJoin(planOrderDataSet).on("treeentryentity.sourcebillnumber", "planorder").select(mftOrderDataSet.getRowMeta().getFieldNames(), planOrderDataSet.getRowMeta().getFieldNames()).finish();
        RowMeta rowMeta = RowMetaFactory.createRowMeta((String[])otherFields, (DataType[])otherTypes);
        DataSetBuilder dataSetBuilder = Algo.create((String)algoKey).createDataSetBuilder(rowMeta);
        resultDataSet.forEach(row -> dataSetBuilder.append(this.createNewRow((Row)row)));
        DataSet newDataSet = dataSetBuilder.build();
        DataSet saleOrderDataSet = this.querySaleOrder(saleOrderNo);
        newDataSet = newDataSet.leftJoin(saleOrderDataSet).on("requirebillno", "saleorder").select(newDataSet.getRowMeta().getFieldNames(), new String[]{"customer"}).finish();
        return newDataSet;
    }

    protected Object[] createNewRow(Row row) {
        long entryId = row.getLong("treeentryentity.id");
        String sourceBillType = row.getString("treeentryentity.sourcebilltype");
        String sourceBillNumber = row.getString("treeentryentity.sourcebillnumber");
        String sourceEntrySeq = row.getString("treeentryentity.sourceentryseq");
        Object[] values = new Object[]{entryId, sourceBillNumber, sourceEntrySeq};
        if (StringUtils.equals((CharSequence)"mrp_planorder", (CharSequence)sourceBillType)) {
            values[1] = row.getString("demandbill");
            values[2] = row.getString("demandseq");
        }
        return values;
    }

    protected DataSet queryPlanOrder(Set<String> planOrderNo) {
        String properties = "billno AS planorder,demandbill,demandseq";
        QFilter qFilter = new QFilter("billno", "in", planOrderNo);
        return QueryServiceHelper.queryDataSet((String)(algoKey + "_queryPlanOrder"), (String)"mrp_planorder", (String)properties, (QFilter[])new QFilter[]{qFilter}, null);
    }

    protected DataSet querySaleOrder(Set<String> saleOrderNo) {
        String properties = "billno AS saleorder,customer";
        QFilter qFilter = new QFilter("billno", "in", saleOrderNo);
        return QueryServiceHelper.queryDataSet((String)(algoKey + "_querySaleOrder"), (String)"sm_salorder", (String)properties, (QFilter[])new QFilter[]{qFilter}, null);
    }

    protected DataSet queryMftOrder(Set<Long> entryIds) {
        String properties = "treeentryentity.id,treeentryentity.sourcebilltype,treeentryentity.sourcebillnumber,treeentryentity.sourceentryseq";
        QFilter qFilter = new QFilter("treeentryentity.id", "in", entryIds);
        return QueryServiceHelper.queryDataSet((String)(algoKey + "_queryMftOrder"), (String)"pom_mftorder", (String)properties, (QFilter[])new QFilter[]{qFilter}, null);
    }

    protected DataSet queryManuInBillDataSet() {
        List<QFilter> qFilters = this.createHeadFilters();
        qFilters.add(new QFilter("billstatus", "=", (Object)"C"));
        qFilters.add(new QFilter("productiondomain", "=", (Object)"A"));
        String properties = this.getSelectFields();
        QFilter[] filters = qFilters.toArray(new QFilter[0]);
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)(algoKey + "_queryManuInBillDataSet"), (String)"im_mdc_mftmanuinbill", (String)properties, (QFilter[])filters, null);
        return dataSet;
    }

    protected String getSelectFields() {
        String properties = "billno AS inbill,creator AS creator,createtime AS createtime,modifier AS modifier,modifytime AS modifytime,auditor AS auditor,auditdate AS audittime,invscheme AS transaction,org AS storeorg,productionorg AS productionorg,biztime AS bizdate,billstatus AS billstatus,settlecurrency AS currency,billentry.seq AS inbillseq,billentry.material.masterid AS material,billentry.producttype AS producttype,billentry.qualitystatus AS qualitystatus,billentry.qty AS qty,billentry.unit AS unit,billentry.baseunit AS baseunit,billentry.baseqty AS baseqty,billentry.unit2nd AS assistantunit,billentry.qtyunit2nd AS assistantqty,billentry.price AS price,billentry.amount AS amount,billentry.manubill AS mftorder,billentry.manuentry AS mftotderseq,billentry.manuentryid AS manuentryid,billentry.warehouse AS warehouse,billentry.location AS location,billentry.entrycomment AS remark,billentry.project AS bdproject,billentry.tracknumber AS tracknumber";
        return properties;
    }

    protected List<QFilter> createHeadFilters() {
        DynamicObjectCollection trackNumber;
        DynamicObjectCollection projects;
        String head_orderto;
        String head_orderfrom;
        DynamicObject head_materialTo;
        DynamicObjectCollection head_materialFromCollection;
        Date endTime;
        DynamicObject head_storeorg;
        FilterInfo filterInfo = this.getQueryParam().getFilter();
        ArrayList<QFilter> qFilterList = new ArrayList<QFilter>(16);
        DynamicObject head_org = filterInfo.getDynamicObject("head_org");
        if (head_org != null) {
            qFilterList.add(new QFilter("productionorg", "=", head_org.getPkValue()));
        }
        if ((head_storeorg = filterInfo.getDynamicObject("head_storeorg")) != null) {
            qFilterList.add(new QFilter("org", "=", head_storeorg.getPkValue()));
        }
        Calendar cal = Calendar.getInstance();
        Date beginTime = filterInfo.getDate("begintime");
        if (beginTime != null) {
            cal.setTime(beginTime);
            cal.set(10, 0);
            cal.set(11, 0);
            cal.set(12, 0);
            cal.set(13, 0);
            cal.set(14, 0);
            qFilterList.add(new QFilter("biztime", ">=", (Object)cal.getTime()));
        }
        if ((endTime = filterInfo.getDate("endtime")) != null) {
            cal.setTime(endTime);
            cal.set(10, 0);
            cal.set(11, 0);
            cal.set(12, 0);
            cal.set(13, 0);
            cal.set(14, 0);
            qFilterList.add(new QFilter("biztime", "<=", (Object)cal.getTime()));
        }
        if ((head_materialFromCollection = filterInfo.getDynamicObjectCollection("head_materialfrom")) != null) {
            if (head_materialFromCollection.size() == 1) {
                qFilterList.add(new QFilter("billentry.material.masterid", ">=", ((DynamicObject)head_materialFromCollection.get(0)).get("masterid.id")));
            } else {
                ArrayList idList = new ArrayList(16);
                head_materialFromCollection.forEach(dynamicObject -> idList.add(dynamicObject.getLong("masterid.id")));
                qFilterList.add(new QFilter("billentry.material.masterid", "in", idList));
            }
        }
        if ((head_materialTo = filterInfo.getDynamicObject("head_materialto")) != null) {
            qFilterList.add(new QFilter("billentry.material.masterid", "<=", head_materialTo.get("masterid.id")));
        }
        if (StringUtils.isNotEmpty((CharSequence)(head_orderfrom = filterInfo.getString("head_orderfrom")))) {
            qFilterList.add(new QFilter("billentry.manubill", ">=", (Object)head_orderfrom));
        }
        if (StringUtils.isNotEmpty((CharSequence)(head_orderto = filterInfo.getString("head_orderto")))) {
            qFilterList.add(new QFilter("billentry.manubill", "<=", (Object)head_orderto));
        }
        if ((projects = filterInfo.getDynamicObjectCollection("head_bdproject")) != null) {
            List ids = projects.stream().map(DataEntityBase::getPkValue).collect(Collectors.toList());
            qFilterList.add(new QFilter("billentry.project", "in", ids));
        }
        if ((trackNumber = filterInfo.getDynamicObjectCollection("head_tracknumber")) != null) {
            List ids = trackNumber.stream().map(DataEntityBase::getPkValue).collect(Collectors.toList());
            qFilterList.add(new QFilter("billentry.tracknumber", "in", ids));
        }
        return qFilterList;
    }
}

