/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.mpdm.common.gantt.ganttmodel;

import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import kd.bd.mpdm.common.gantt.util.GanttBigObjectCache;

public final class GanttCustomSingleton {
    private GanttCustomSingleton() {
    }

    public static GanttCustomSingleton getSingleInstance() {
        return SingletonClassInstance.instance;
    }

    public void registerTimeScaleCommand(String billFormId, String value) {
        Map<String, String> timeScaleMap = this.getTimeScaleMap();
        timeScaleMap.put(billFormId, value);
        GanttBigObjectCache.put((String)"GanttCustomTimeScaleSingleton", (String)"registerTimeScaleCommand", timeScaleMap);
    }

    public String getTimeScaleCommand(String billFormId) {
        Map<String, String> timeScaleMap = this.getTimeScaleMap();
        String className = timeScaleMap.get(billFormId);
        return className;
    }

    private Map<String, String> getTimeScaleMap() {
        Map timeScaleMap = (Map)GanttBigObjectCache.get((String)"GanttCustomTimeScaleSingleton", (String)"registerTimeScaleCommand");
        if (Objects.nonNull(timeScaleMap)) {
            return timeScaleMap;
        }
        return new ConcurrentHashMap<String, String>(16);
    }

    public void registerTimeLineWayCommand(String billFormId, String value) {
        Map<String, String> timeScaleMap = this.getTimeLineWayMap();
        timeScaleMap.put(billFormId, value);
        GanttBigObjectCache.put((String)"GanttCustomTimeScaleSingleton", (String)"registerTimeLineWayCommand", timeScaleMap);
    }

    public String getTimeLineWayCommand(String billFormId) {
        Map<String, String> timeScaleMap = this.getTimeLineWayMap();
        String className = timeScaleMap.get(billFormId);
        return className;
    }

    private Map<String, String> getTimeLineWayMap() {
        Map timeScaleMap = (Map)GanttBigObjectCache.get((String)"GanttCustomTimeScaleSingleton", (String)"registerTimeLineWayCommand");
        if (Objects.nonNull(timeScaleMap)) {
            return timeScaleMap;
        }
        return new ConcurrentHashMap<String, String>(16);
    }

    private static class SingletonClassInstance {
        private static final GanttCustomSingleton instance = new GanttCustomSingleton();

        private SingletonClassInstance() {
        }
    }
}

