/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.mpdm.common.gantt.ganttmodel;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import kd.bd.mpdm.common.gantt.util.GanttBigObjectCache;

public class GanttDecoratorSingleton {
    private GanttDecoratorSingleton() {
    }

    public static GanttDecoratorSingleton getSingleInstance() {
        return SingletonClassInstance.instance;
    }

    public void registerDecoratorClass(String key, String value) {
        Map<String, List<String>> decoratorMap = this.getDecoratorMap();
        List valueList = decoratorMap.computeIfAbsent(key, val -> new ArrayList(8));
        if (!valueList.contains(value)) {
            valueList.add(value);
            GanttBigObjectCache.put((String)"GanttDecoratorSingleton", (String)"registerDecortaorClass", decoratorMap);
        }
    }

    public List<String> getDecoratorClass(String key) {
        Map<String, List<String>> decoratorMap = this.getDecoratorMap();
        return decoratorMap.get(key);
    }

    private Map<String, List<String>> getDecoratorMap() {
        Map decoratorMap = (Map)GanttBigObjectCache.get((String)"GanttDecoratorSingleton", (String)"registerDecortaorClass");
        if (Objects.nonNull(decoratorMap)) {
            return decoratorMap;
        }
        return new ConcurrentHashMap<String, List<String>>(16);
    }

    private static class SingletonClassInstance {
        private static final GanttDecoratorSingleton instance = new GanttDecoratorSingleton();

        private SingletonClassInstance() {
        }
    }
}

