/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.mpdm.common.gantt.ganttmodel;

import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import kd.bd.mpdm.common.gantt.util.GanttBigObjectCache;
import kd.bos.dataentity.utils.StringUtils;

public final class GanttEventSingleton {
    private GanttEventSingleton() {
    }

    public static GanttEventSingleton getSingleInstance() {
        return SingletonClassInstance.instance;
    }

    public void registerEventCommand(String key, String value) {
        Map<String, String> registerEventMap = this.getRegisterEventMap();
        registerEventMap.put(key, value);
        GanttBigObjectCache.put((String)"GanttEventSingleton", (String)"registerEventCommand", registerEventMap);
    }

    private Map<String, String> getRegisterEventMap() {
        Map registerEventMap = (Map)GanttBigObjectCache.get((String)"GanttEventSingleton", (String)"registerEventCommand");
        if (Objects.nonNull(registerEventMap)) {
            return registerEventMap;
        }
        return new ConcurrentHashMap<String, String>(16);
    }

    public void registerEventCommand(String key, String billFormId, String value) {
        this.registerEventCommand(key.concat("_").concat(billFormId), value);
    }

    public String getEventCommand(String key) {
        Map<String, String> registerEventMap = this.getRegisterEventMap();
        return registerEventMap.get(key);
    }

    public String getEventCommand(String key, String billFormId) {
        Map<String, String> registerEventMap = this.getRegisterEventMap();
        String className = registerEventMap.get(key);
        if (StringUtils.isBlank((CharSequence)className)) {
            className = registerEventMap.get(key.concat("_").concat(billFormId));
        }
        return className;
    }

    private static class SingletonClassInstance {
        private static final GanttEventSingleton instance = new GanttEventSingleton();

        private SingletonClassInstance() {
        }
    }
}

