/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.mpdm.common.gantt.ganttmodel;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import kd.bd.mpdm.common.gantt.ganttmodel.GanttEnumModel;
import kd.bd.mpdm.common.gantt.util.GanttBigObjectCache;
import kd.bos.orm.util.CollectionUtils;

public class GanttMenusSingleton {
    private GanttMenusSingleton() {
    }

    public static GanttMenusSingleton getSingleInstance() {
        return SingletonClassInstance.instance;
    }

    public void registerMenums(String key, GanttEnumModel value) {
        Map<String, List<GanttEnumModel>> menusMap = this.getMenusMap();
        List valueList = menusMap.getOrDefault(key, new ArrayList(8));
        if (!valueList.contains(value)) {
            valueList.add(value);
            List collect = valueList.stream().sorted((x1, x2) -> x1.getIndex() - x2.getIndex()).collect(Collectors.toList());
            menusMap.put(key, collect);
            GanttBigObjectCache.put((String)"GanttMenusSingleton", (String)"registerMenuList", menusMap);
        }
    }

    public void removeMenums(String cbnumber, String entityNameAndBillFormId) {
        Map<String, List<GanttEnumModel>> menusMap = this.getMenusMap();
        List<GanttEnumModel> valueList = menusMap.get(entityNameAndBillFormId);
        if (!CollectionUtils.isEmpty(valueList)) {
            List collect = valueList.stream().filter(x -> !x.getCbNumber().equals(cbnumber)).collect(Collectors.toList());
            menusMap.put(entityNameAndBillFormId, collect);
            GanttBigObjectCache.put((String)"GanttMenusSingleton", (String)"registerMenuList", menusMap);
        }
    }

    public List<GanttEnumModel> getMenus(String key) {
        Map<String, List<GanttEnumModel>> menusMap = this.getMenusMap();
        return menusMap.get(key);
    }

    public Map<String, List<GanttEnumModel>> getMenusMap() {
        Map meausMap = (Map)GanttBigObjectCache.get((String)"GanttMenusSingleton", (String)"registerMenuList");
        if (Objects.nonNull(meausMap)) {
            return meausMap;
        }
        return new ConcurrentHashMap<String, List<GanttEnumModel>>(16);
    }

    private static class SingletonClassInstance {
        private static final GanttMenusSingleton instance = new GanttMenusSingleton();

        private SingletonClassInstance() {
        }
    }
}

