/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.mpdm.common.gantt.ganttmodel;

import java.util.Objects;
import java.util.concurrent.CopyOnWriteArraySet;
import kd.bd.mpdm.common.gantt.util.GanttBigObjectCache;

public final class GanttResourceEditSingleton {
    private GanttResourceEditSingleton() {
    }

    public static GanttResourceEditSingleton getSingleInstance() {
        return SingletonClassInstance.instance;
    }

    public void registerEditAble(String key, String billFormId) {
        CopyOnWriteArraySet<String> editSet = this.getEditAbleSet();
        editSet.add(key.concat("_").concat(billFormId));
        GanttBigObjectCache.put((String)"GanttResourceEditSingleton", (String)"editAbleSet", editSet);
    }

    public boolean getEditAble(String key, String billFormId) {
        CopyOnWriteArraySet<String> editSet = this.getEditAbleSet();
        return editSet.contains(key.concat("_").concat(billFormId));
    }

    public CopyOnWriteArraySet<String> getEditAbleSet() {
        CopyOnWriteArraySet editSet = (CopyOnWriteArraySet)GanttBigObjectCache.get((String)"GanttResourceEditSingleton", (String)"editAbleSet");
        if (Objects.nonNull(editSet)) {
            return editSet;
        }
        return new CopyOnWriteArraySet<String>();
    }

    private static class SingletonClassInstance {
        private static final GanttResourceEditSingleton instance = new GanttResourceEditSingleton();

        private SingletonClassInstance() {
        }
    }
}

