/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.mpdm.common.gantt.ganttmodel;

import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import kd.bd.mpdm.common.gantt.util.GanttBigObjectCache;

public final class GanttTaskMoveSingleton {
    private GanttTaskMoveSingleton() {
    }

    public static GanttTaskMoveSingleton getSingleInstance() {
        return SingletonClassInstance.instance;
    }

    public void registerAdjustCommand(String key, String billFormId, String value) {
        Map<String, String> adjustMap = this.getAdjustMap();
        adjustMap.put(key.concat("_").concat(billFormId), value);
        GanttBigObjectCache.put((String)"GanttTaskMoveSingleton", (String)"registerAdjustCommand", adjustMap);
    }

    public String getAdjustCommand(String key, String billFormId) {
        Map<String, String> adjustMap = this.getAdjustMap();
        String className = adjustMap.get(key.concat("_").concat(billFormId));
        return className;
    }

    public void registerDragCommand(String key, String billFormId, String value) {
        Map<String, String> dragMap = this.getDragMap();
        dragMap.put(key.concat("_").concat(billFormId), value);
        GanttBigObjectCache.put((String)"GanttTaskMoveSingleton", (String)"registerDragCommand", dragMap);
    }

    public String getDragCommand(String key, String billFormId) {
        Map<String, String> dragMap = this.getDragMap();
        String className = dragMap.get(key.concat("_").concat(billFormId));
        return className;
    }

    private Map<String, String> getAdjustMap() {
        Map adjustMap = (Map)GanttBigObjectCache.get((String)"GanttTaskMoveSingleton", (String)"registerAdjustCommand");
        if (Objects.nonNull(adjustMap)) {
            return adjustMap;
        }
        return new ConcurrentHashMap<String, String>(16);
    }

    private Map<String, String> getDragMap() {
        Map dragMap = (Map)GanttBigObjectCache.get((String)"GanttTaskMoveSingleton", (String)"registerDragCommand");
        if (Objects.nonNull(dragMap)) {
            return dragMap;
        }
        return new ConcurrentHashMap<String, String>(16);
    }

    private static class SingletonClassInstance {
        private static final GanttTaskMoveSingleton instance = new GanttTaskMoveSingleton();

        private SingletonClassInstance() {
        }
    }
}

